/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.core.internal.collections.OSet;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.library.Library;
import com.ibm.rave.library.internal.nativeImpl.PropertyNativeUtils;
import com.ibm.rave.library.property.PropertyOption;
import com.ibm.rave.library.property.PropertyStringType;
import com.ibm.rave.library.property.PropertyType;
import java.util.List;

public final class PropertyUtil {
    private static final OSet<String> propertyTypes = new OSet();
    static final PropertyUtil INSTANCE = new PropertyUtil();

    private PropertyUtil() {
        propertyTypes.add((Object)"string");
        propertyTypes.add((Object)"boolean");
        propertyTypes.add((Object)"numeric");
        propertyTypes.add((Object)"enum");
        propertyTypes.add((Object)"font");
        propertyTypes.add((Object)"color");
        propertyTypes.add((Object)"array");
        propertyTypes.add((Object)"palette");
        propertyTypes.add((Object)"length");
        propertyTypes.add((Object)"padding");
        propertyTypes.add((Object)"dasharray");
        propertyTypes.add((Object)"object");
        propertyTypes.add((Object)"jsonobject");
        propertyTypes.add((Object)"geojson");
        propertyTypes.add((Object)"shadow");
    }

    boolean validateNumeric(Object obj, boolean decimal) {
        if (!this.validateBasicType(obj, 11)) {
            return false;
        }
        Double num = ObjectConverter.toDouble((Object)obj);
        if (Double.isNaN(num)) {
            Library.logError(6, "Property Validator");
            return false;
        }
        if (!decimal) {
            return this.validateIsInteger(num);
        }
        return true;
    }

    boolean validateObjectExistInList(List<?> list, Object value) {
        if (list.indexOf(value) == -1) {
            Library.logError(7, "Property Validator");
            return false;
        }
        return true;
    }

    boolean validateNumericProperties(List<PropertyOption<Number>> _options, Number value, boolean decimal) {
        if (_options.size() == 0) {
            return true;
        }
        for (int i = 0; i < _options.size(); ++i) {
            PropertyOption<Number> listVal = _options.get(i);
            if (!(decimal ? listVal.value().doubleValue() == value.doubleValue() : listVal.value().intValue() == value.intValue())) continue;
            return true;
        }
        Library.logError(7, "Property Validator");
        return false;
    }

    boolean validateMinMaxPropertyValue(Number min, Number max, boolean decimal, Number value) {
        if (value != null) {
            if (!decimal && !this.validateIsInteger(value)) {
                return false;
            }
            if (min != null && min.doubleValue() > value.doubleValue()) {
                Library.logError(8, "Property Validator");
                return false;
            }
            if (max != null && max.doubleValue() < value.doubleValue()) {
                Library.logError(9, "Property Validator");
                return false;
            }
        }
        return true;
    }

    boolean validateMinMaxProperties(Object minObj, Object maxObj, boolean decimal, boolean allowNegatives) {
        Double min = null;
        Double max = null;
        if (minObj != null) {
            if (!this.validateNumeric(minObj, decimal)) {
                return false;
            }
            min = ObjectConverter.toDouble((Object)minObj);
            if (!allowNegatives && min < 0.0) {
                Library.logError(10, "Property Validator");
                return false;
            }
        }
        if (maxObj != null) {
            if (!this.validateNumeric(maxObj, decimal)) {
                return false;
            }
            max = ObjectConverter.toDouble((Object)maxObj);
            if (!allowNegatives && max < 0.0) {
                Library.logError(11, "Property Validator");
                return false;
            }
            if (min != null && min > max) {
                Library.logError(12, "Property Validator");
                return false;
            }
        }
        return true;
    }

    boolean validateSimpleOptions(JSONArray optionsArray, PropertyType property) {
        int len = optionsArray.size();
        if (len == 0) {
            Library.logError(13, "Property Validator");
            return false;
        }
        OSet optionsSet = new OSet();
        for (int i = 0; i < len; ++i) {
            Object obj = optionsArray.get(i);
            if (optionsSet.contains(obj)) {
                Library.logError(14, "Property Validator");
                return false;
            }
            optionsSet.add(obj);
            if (property.validateValue(obj)) continue;
            return false;
        }
        return true;
    }

    boolean validateStringOptions(JSONArray optionsArray, PropertyStringType property) {
        int len = optionsArray.size();
        if (len == 0) {
            Library.logError(13, "Property Validator");
            return false;
        }
        OSet optionsSet = new OSet();
        for (int i = 0; i < len; ++i) {
            Object value = ((JSONObject)optionsArray.get(i)).get((Object)"value");
            if (optionsSet.contains(value)) {
                Library.logError(14, "Property Validator");
                return false;
            }
            optionsSet.add(value);
            if (property.validateValue(value)) continue;
            return false;
        }
        return true;
    }

    boolean validateBasicType(Object obj, int typeId) {
        switch (typeId) {
            case 10: {
                if (!PropertyNativeUtils.isString(obj)) {
                    Library.logError(15, "Property Validator");
                    return false;
                }
                return true;
            }
            case 11: {
                if (!PropertyNativeUtils.isNumber(obj)) {
                    Library.logError(16, "Property Validator");
                    return false;
                }
                return true;
            }
            case 12: {
                if (!PropertyNativeUtils.isBoolean(obj)) {
                    Library.logError(17, "Property Validator");
                    return false;
                }
                return true;
            }
            case 20: {
                if (!PropertyNativeUtils.isJSONArray(obj)) {
                    Library.logError(18, "Property Validator");
                    return false;
                }
                return true;
            }
            case 21: {
                if (!PropertyNativeUtils.isJSONObject(obj)) {
                    Library.logError(19, "Property Validator");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    boolean validateIsInteger(Number num) {
        if ((double)ObjectConverter.toInt((Object)num.doubleValue()) != num.doubleValue()) {
            Library.logError(20, "Property Validator");
            return false;
        }
        return true;
    }

    boolean validatePropertySimpleId(String simpleId) {
        if (simpleId == null) {
            Library.logError(21, "PropertySet.populate");
            return false;
        }
        if (simpleId.indexOf(".") != -1) {
            Library.logError(22, "PropertySet.populate");
            return false;
        }
        return true;
    }

    boolean validType(String type) {
        if (!propertyTypes.contains((Object)type)) {
            Library.logError(23, "PropertySet.populate");
            return false;
        }
        return true;
    }

    JSONObject propertyEntry(JSONObject propertyJSON, String propertyId) {
        Object propertyEntry = propertyJSON.get((Object)propertyId);
        if (propertyEntry == null) {
            Library.logError(24, "PropertySet.populate");
            return null;
        }
        if (!PropertyNativeUtils.isJSONObject(propertyEntry)) {
            Library.logError(25, "PropertySet.populate");
            return null;
        }
        return (JSONObject)propertyEntry;
    }

    String type(JSONObject propertyJSON) {
        Object type = propertyJSON.get((Object)"type");
        if (type == null) {
            Library.logError(26, "PropertySet.populate");
            return null;
        }
        if (!PropertyNativeUtils.isString(type)) {
            Library.logError(27, "PropertySet.populate");
            return null;
        }
        String typeStr = ObjectConverter.toString((Object)type);
        if (!this.validType(typeStr)) {
            return null;
        }
        return typeStr;
    }
}

