/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.library.service;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.core.internal.collections.OMap;

public class LibraryError {
    private final int errorCode;
    private final String errorMessage;
    private final String errorLocation;
    private String bundlename;
    private static OMap<Integer, String> errorMap = LibraryError.populateErrorMap();

    private LibraryError(int code, String location, String bundleName) {
        this.errorCode = code;
        this.errorMessage = (String)errorMap.get((Object)code);
        this.errorLocation = location;
        this.bundlename = bundleName;
    }

    public static LibraryError create(int code) {
        return new LibraryError(code, null, null);
    }

    public static LibraryError create(int code, String location) {
        return new LibraryError(code, location, null);
    }

    public static LibraryError create(int code, String location, String bundleName) {
        return new LibraryError(code, location, bundleName);
    }

    private static OMap<Integer, String> populateErrorMap() {
        OMap errorMap = new OMap();
        errorMap.put((Object)300, (Object)"No metadata about the bundle could be found in the json file.");
        errorMap.put((Object)301, (Object)"The specified info does not exist");
        errorMap.put((Object)302, (Object)"Preview format is not supported. It is either svg or img");
        errorMap.put((Object)201, (Object)"Unable to load bundle");
        errorMap.put((Object)206, (Object)"Manifest not available for this bundle");
        errorMap.put((Object)207, (Object)"Bower not available for this bundle");
        errorMap.put((Object)204, (Object)"Requested configuration ID not available for this bundle");
        errorMap.put((Object)4, (Object)"PropertyNativeUtils parse");
        errorMap.put((Object)5, (Object)"Palettes must have a unique id with at least 1 character. PaletteSet add");
        errorMap.put((Object)205, (Object)"Configuration file load error ");
        errorMap.put((Object)101, (Object)"Data model Error");
        errorMap.put((Object)203, (Object)"NLS catalog file load error ");
        errorMap.put((Object)1, (Object)"A property error has occurred.");
        errorMap.put((Object)104, (Object)"No datamodels defined");
        errorMap.put((Object)105, (Object)"Data model not found");
        errorMap.put((Object)106, (Object)"Data set not found");
        errorMap.put((Object)107, (Object)"Data slot not found");
        errorMap.put((Object)108, (Object)"Accessor is not of a type allowed for the data slot");
        errorMap.put((Object)409, (Object)"Mismatched data type");
        errorMap.put((Object)109, (Object)"No data has been assigned to a required data set");
        errorMap.put((Object)110, (Object)"No accessor has been assigned to a required data slot");
        errorMap.put((Object)401, (Object)"Missing ImportData or required ImportData property (visJSONData, index, dataSetId), or JSON parse error. Please check input data.");
        errorMap.put((Object)402, (Object)"ImportData index out of range");
        errorMap.put((Object)403, (Object)"selected table is null or has no fields");
        errorMap.put((Object)404, (Object)"ImportData dataSetId is not valid");
        errorMap.put((Object)405, (Object)"map has an invalid data slot ID");
        errorMap.put((Object)406, (Object)"ImportData dataSetId is not of the correct type (tabular or hierarchical)");
        errorMap.put((Object)407, (Object)"ImportData levels uses an ID which is not a field ID");
        errorMap.put((Object)6, (Object)"The numeric value given is NaN");
        errorMap.put((Object)7, (Object)"The value given does not exist in the specified list");
        errorMap.put((Object)8, (Object)"The value given is less than the minimum specified");
        errorMap.put((Object)9, (Object)"The value given is greater than the maximum specified");
        errorMap.put((Object)10, (Object)"value of minimum is negative");
        errorMap.put((Object)11, (Object)"value of maximum is negative");
        errorMap.put((Object)12, (Object)"The minmum value is greater than the maximum value");
        errorMap.put((Object)13, (Object)"Options array is empty.");
        errorMap.put((Object)14, (Object)"Option array for string property are not unique.");
        errorMap.put((Object)15, (Object)"The property must be string.");
        errorMap.put((Object)16, (Object)"The property must be numeric.");
        errorMap.put((Object)17, (Object)"The property must be boolean.");
        errorMap.put((Object)18, (Object)"The property must be an array.");
        errorMap.put((Object)19, (Object)"The property must be an object.");
        errorMap.put((Object)20, (Object)"The value must be an integer.");
        errorMap.put((Object)21, (Object)"Property simple id is null");
        errorMap.put((Object)22, (Object)"Property simple id is invalid");
        errorMap.put((Object)23, (Object)"Property entry type is invalid");
        errorMap.put((Object)24, (Object)"Property entry is null");
        errorMap.put((Object)25, (Object)"Property entry type is not an object");
        errorMap.put((Object)26, (Object)"Property entry type is not a string");
        errorMap.put((Object)27, (Object)"Property entry has no type");
        errorMap.put((Object)28, (Object)"Property entry has no properties");
        errorMap.put((Object)29, (Object)"Property entry has unknown type");
        errorMap.put((Object)30, (Object)"Found duplicate property entries with the same id but of different types");
        errorMap.put((Object)31, (Object)"value being set is not a JSON object");
        errorMap.put((Object)32, (Object)"value object has an unknown property");
        errorMap.put((Object)33, (Object)"Both the true and false label must be provided");
        errorMap.put((Object)34, (Object)"Value is not part of enum.");
        errorMap.put((Object)35, (Object)"Can't change value of unmodifiable property");
        errorMap.put((Object)36, (Object)"A property in value object does not exist.");
        errorMap.put((Object)37, (Object)"String does not match regular expression");
        errorMap.put((Object)38, (Object)"Can not set value for unknown type");
        errorMap.put((Object)39, (Object)"A required property has no default value");
        errorMap.put((Object)40, (Object)"Can't set a required property with no default to null");
        errorMap.put((Object)41, (Object)"Missing enum options array");
        errorMap.put((Object)42, (Object)"Invalid Enum. Entry: missing enum/enumLabel");
        errorMap.put((Object)43, (Object)"Duplicate enum value");
        errorMap.put((Object)408, (Object)"Stacking isn't allowed");
        return errorMap;
    }

    public int code() {
        return this.errorCode;
    }

    public String message() {
        return this.errorMessage;
    }

    public void setBundlename(String bundleName) {
        this.bundlename = bundleName;
    }

    public String getBundlename() {
        return this.bundlename;
    }

    public String location() {
        return this.errorLocation;
    }

    @FunctionClass(value="error")
    public static interface ReportError {
        public void error(LibraryError var1);
    }
}

