/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.developer.schemas.rds.bibus;

import com.cognos.developer.schemas.rds.bibus.RDS;
import com.cognos.developer.schemas.rds.bibus.RDSService;
import com.cognos.developer.schemas.rds.bibus.RDSServiceStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class RDSLocator
extends Service
implements RDS {
    private String RDS_address = "http://localhost:9300/p2pd/servlet/dispatch";
    private String RDSWSDDServiceName = "RDS";
    private HashSet ports = null;

    public RDSLocator() {
    }

    public RDSLocator(EngineConfiguration engineConfiguration) {
        super(engineConfiguration);
    }

    public RDSLocator(String string, QName qName) throws ServiceException {
        super(string, qName);
    }

    @Override
    public String getRDSAddress() {
        return this.RDS_address;
    }

    public String getRDSWSDDServiceName() {
        return this.RDSWSDDServiceName;
    }

    public void setRDSWSDDServiceName(String string) {
        this.RDSWSDDServiceName = string;
    }

    @Override
    public RDSService getRDS() throws ServiceException {
        URL uRL;
        try {
            uRL = new URL(this.RDS_address);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceException((Throwable)malformedURLException);
        }
        return this.getRDS(uRL);
    }

    @Override
    public RDSService getRDS(URL uRL) throws ServiceException {
        try {
            RDSServiceStub rDSServiceStub = new RDSServiceStub(uRL, this);
            rDSServiceStub.setPortName(this.getRDSWSDDServiceName());
            return rDSServiceStub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setRDSEndpointAddress(String string) {
        this.RDS_address = string;
    }

    public Remote getPort(Class clazz) throws ServiceException {
        try {
            if (RDSService.class.isAssignableFrom(clazz)) {
                RDSServiceStub rDSServiceStub = new RDSServiceStub(new URL(this.RDS_address), this);
                rDSServiceStub.setPortName(this.getRDSWSDDServiceName());
                return rDSServiceStub;
            }
        }
        catch (Throwable throwable) {
            throw new ServiceException(throwable);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (clazz == null ? "null" : clazz.getName()));
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (qName == null) {
            return this.getPort(clazz);
        }
        String string = qName.getLocalPart();
        if ("RDS".equals(string)) {
            return this.getRDS();
        }
        Remote remote = this.getPort(clazz);
        ((Stub)remote).setPortName(qName);
        return remote;
    }

    public QName getServiceName() {
        return new QName("http://developer.cognos.com/schemas/bibus/3/", "RDS");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://developer.cognos.com/schemas/bibus/3/", "RDS"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String string, String string2) throws ServiceException {
        if (!"RDS".equals(string)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + string);
        }
        this.setRDSEndpointAddress(string2);
    }

    public void setEndpointAddress(QName qName, String string) throws ServiceException {
        this.setEndpointAddress(qName.getLocalPart(), string);
    }
}

