/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge.relmd;

import com.cognos.xqe.data.providers.secbridge.relmd.IImpersonator;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractImpersonator
implements IImpersonator {
    private final ExecutorService mExecutorService;
    private final int mErrorLocale;

    AbstractImpersonator(ExecutorService executorService, int errorLocale) {
        if (null == executorService) {
            throw new IllegalArgumentException("executorService was null.");
        }
        this.mExecutorService = executorService;
        this.mErrorLocale = errorLocale;
    }

    final int getErrorLocale() {
        return this.mErrorLocale;
    }

    final <T> T runTask(Callable<T> task) throws Throwable {
        Future<T> future = this.mExecutorService.submit(task);
        try {
            return future.get();
        }
        catch (ExecutionException ex) {
            if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
                Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
                logger.log(Level.WARNING, ex.getMessage());
                RelmdLoggerFactory.flush(logger);
            }
            throw ex.getCause();
        }
    }
}

