/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge.relmd;

import com.cognos.xqe.data.providers.secbridge.relmd.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.relmd.NativeException;
import com.cognos.xqe.data.providers.secbridge.relmd.WinImpersonate;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.dataSource._tools.EncryptedObject;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ImpersonationTask<T>
implements Callable<T> {
    private final Callable<T> task;
    private final String domainName;
    private final String userName;
    private final EncryptedObject<String> encryptedPassword;
    private final int errorLocale;

    public ImpersonationTask(Callable<T> theTask, String theDomainName, String theUserName, EncryptedObject<String> theEncryptedPassword, int theErrorLocale) {
        this.task = theTask;
        this.domainName = theDomainName;
        this.userName = theUserName;
        this.encryptedPassword = theEncryptedPassword;
        this.errorLocale = theErrorLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T result = null;
        long token = 0L;
        try {
            token = WinImpersonate.beginImpersonation(this.errorLocale, this.domainName, this.userName, this.encryptedPassword.decrypt());
        }
        catch (NativeException ex) {
            if (ex.getErrorStatus().getCategory() == ErrorStatus.Category.LOGON_FAILURE) {
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.NATIVE_LOGON_FAILURE, ex);
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.CAM_COULD_NOT_REVERT, ex);
        }
        boolean success = false;
        try {
            result = this.task.call();
            success = true;
        }
        finally {
            try {
                WinImpersonate.revertImpersonation(this.errorLocale, token);
            }
            catch (NativeException ex) {
                if (success) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.CAM_COULD_NOT_REVERT, ex);
                }
                this.logException(this, "Error occurs when reverting Impersonation: " + ex.getMessage(), Level.WARNING);
            }
        }
        return result;
    }

    private void logException(Object obj, String s, Level level) {
        String loggingClassName = obj.getClass().getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            Logger logger = RelmdLoggerFactory.get(loggingClassName);
            logger.log(level, s);
            RelmdLoggerFactory.flush(logger);
        }
    }
}

