/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.xqe.data.providers.secbridge.relmd.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.relmd.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.relmd.LocaleConverter;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.dataSource.ApiTokenSignon;
import com.ibm.cognos.internal.relmd.dataSource.Commands;
import com.ibm.cognos.internal.relmd.dataSource.IDataSourceConnectionCommandBlock;
import com.ibm.cognos.internal.relmd.dataSource.JCAMImpersonator;
import com.ibm.cognos.internal.relmd.dataSource.OIDCCredentialsSignon;
import com.ibm.cognos.internal.relmd.dataSource.RelmdConnectionFactory;
import com.ibm.cognos.internal.relmd.dataSource.ValueDecryption;
import com.ibm.cognos.internal.relmd.dataSource._tools.CredentialsDecrypt;
import com.ibm.cognos.internal.relmd.dataSource._tools.DataSourceConnectionStringParser;
import com.ibm.cognos.internal.relmd.dataSource._tools.ProxyCredentialsDecrypt;
import com.ibm.cognos.internal.relmd.metadata.RelationalMetadataElem;
import com.ibm.cognos.internal.relmd.metadata._schema.CatalogElem;
import com.ibm.cognos.internal.relmd.metadata._schema.DatabaseElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ReferenceableSetElem;
import com.ibm.cognos.internal.relmd.metadata._tools.columnConversion.SqlColumnConversion;
import com.ibm.cognos.internal.relmd.metadata._tools.xml.CompositeModelObjectHandler;
import com.ibm.cognos.internal.relmd.metadata._tools.xml.MergeUtil;
import com.ibm.cognos.internal.relmd.metadata._tools.xml.ModelBuilder;
import com.ibm.cognos.internal.relmd.metadata._tools.xml.ModelObjectContentHandler;
import com.ibm.cognos.internal.relmd.metadata._tools.xml.ModelWriter;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseFunction;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseObjectPath;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseRequest;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowsedObjectsContentHandler;
import com.ibm.cognos.internal.relmd.metadata.browse.SynonymColumnsBrowseFunction;
import com.ibm.cognos.internal.relmd.metadata.import_.ImportRequest;
import com.ibm.cognos.internal.relmd.metadata.import_.ImportResult;
import com.ibm.cognos.internal.relmd.metadata.import_.ImportSource;
import com.ibm.cognos.internal.relmd.metadata.import_.ImportSourceFilter;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ColumnsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.DatabaseImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ForeignKeysImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.FunctionRoutineArgumentsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.FunctionsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ImportFunctionChain;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.IndexesImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ProcedureRoutineArgumentsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ProceduresImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.RoutineArgumentsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.RoutinesImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.SqlObjectColumnsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.SqlObjectImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.SynonymsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.TableParametersImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.TablesImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.UniqueKeysImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ViewsImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions._chains.MetadataImportFunctionChain;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.ImportResultContentHandler;
import com.ibm.cognos.internal.relmd.metadata.selections.AllSelectionsElem;
import com.ibm.cognos.internal.relmd.metadata.selections.ObjectSelectionsDomFactory;
import com.ibm.cognos.internal.relmd.metadata.selections.SelectedObjectElem;
import com.ibm.cognos.internal.relmd.metadata.selections.SelectionsElem;
import com.ibm.cognos.internal.relmd.session.QueriedSession;
import com.ibm.cognos.internal.relmd.session.query.functions.CurrentCatalogSetupElem;
import com.ibm.cognos.internal.relmd.session.query.functions.DefaultCatalogSchemaQueryElem;
import com.ibm.cognos.internal.relmd.session.query.functions.DefaultSchemaImportElem;
import com.ibm.cognos.internal.relmd.session.query.functions.SqlServerAccessibleCatalogsQuery;
import com.ibm.cognos.internal.relmd.vendor.connection.DataSourceElem;
import com.ibm.cognos.internal.relmd.vendor.rules.VendorRulesBuilder;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlContentHandler;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlReader;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosInvalidLogonException;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.StoredProcedure;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.UserDefinedFunction;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.TableView;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.DefaultSchema;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.elements.SynonymTarget;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainer;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ExternalSchemaReference;
import com.ibm.cognos.relmd.metadata._schema.properties.ParentCatalogSchema;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.SchemaLevelObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlObject;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlObjectPath;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.MetadataSqlColumnConversionToolkit;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import com.ibm.cognos.relmd.metadata._tools.xml.ImportResultsMetadataBuilder;
import com.ibm.cognos.relmd.metadata._tools.xml.MergeSource;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataLoader;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataSourceSelectionsFilter;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataWriter;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataXmlToolkit;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseToolkit;
import com.ibm.cognos.relmd.metadata.browse._handlers.BrowsedObjectHandler;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.functions.CatalogsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.FunctionsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ProceduresBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SchemasBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SynonymColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SynonymsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.TablesBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ViewsBrowse;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataRequest;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataResult;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.ColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.DatabaseImport;
import com.ibm.cognos.relmd.metadata.import_.functions.DefaultSchemaImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ForeignKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionRoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.IndexesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.ProcedureRoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ProceduresImport;
import com.ibm.cognos.relmd.metadata.import_.functions.RoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.RoutinesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SynonymsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.TableParametersImport;
import com.ibm.cognos.relmd.metadata.import_.functions.TablesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.UniqueKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ViewsImport;
import com.ibm.cognos.relmd.metadata.import_.results.ImportMetadataResultHandler;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectColumnsResults;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectResults;
import com.ibm.cognos.relmd.metadata.import_.rules.ColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SynonymsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.DatabaseObjectIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefExternalSchemaIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefSchemaIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefSynonymTargetIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SqlObjectIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.ColumnParentPath;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaObjectPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaParentPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.MetadataSourceSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSynonymsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.SelectedAllObjects;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ColumnSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ObjectSelectionsContainer;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SelectedObject;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SynonymSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SystemObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.metadata.source.MetadataSourceToolkit;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session._schema.AccessibleCatalogRef;
import com.ibm.cognos.relmd.session._schema.DefaultCatalogSchema;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.session.query.SessionQueryToolkit;
import com.ibm.cognos.relmd.session.query.functions.AccessibleCatalogsQuery;
import com.ibm.cognos.relmd.session.query.functions.CurrentCatalogSetup;
import com.ibm.cognos.relmd.session.query.functions.DefaultCatalogSchemaQuery;
import com.ibm.cognos.relmd.session.query.rules.AccessibleCatalogsQueryRules;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.session.query.rules.CodePageRules;
import com.ibm.cognos.relmd.session.query.rules.CurrentCatalogRetrievalRules;
import com.ibm.cognos.relmd.session.query.rules.CurrentCatalogSetRules;
import com.ibm.cognos.relmd.session.query.rules.DefaultCatalogSchemaQueryRules;
import com.ibm.cognos.relmd.vendor.DatabaseAccessRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.DatabaseAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.VendorAccessRule;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.access.functions.sql.VendorAccessSqlToolkit;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.CaseSensitivity;
import com.ibm.cognos.relmd.vendor.access.rules.CatalogRetrieval;
import com.ibm.cognos.relmd.vendor.access.rules.CatalogSet;
import com.ibm.cognos.relmd.vendor.access.rules.CatalogSetupRules;
import com.ibm.cognos.relmd.vendor.access.rules.sql.CatalogGrainSql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsCondition;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.vendor.access.rules.sql.Sql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragment;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragmentConcatenationRules;
import com.ibm.cognos.relmd.vendor.access.rules.sql.WhereClauseInsertionRule;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnectionProxySignonParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnectionStringParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnnectionSignonParameters;
import com.ibm.cognos.relmd.vendor.connection.ExtendedParameterLookup;
import com.ibm.cognos.relmd.vendor.connection.VendorConnectionToolkit;
import com.ibm.cognos.relmd.xmlapi.Handler;
import com.ibm.cognos.relmd.xmlapi.XmlApiToolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class RelmdToolkits
implements Relmd,
MetadataToolkit,
MetadataImportToolkit,
MetadataXmlToolkit,
MetadataBrowseToolkit,
MetadataSqlColumnConversionToolkit,
MetadataObjectSelectionsToolkit,
MetadataObjectPathsToolkit,
XmlApiToolkit,
MetadataSourceToolkit,
VendorToolkit,
VendorAccessToolkit,
VendorConnectionToolkit,
SessionToolkit,
SessionQueryToolkit,
SessionAccessToolkit,
VendorAccessSqlToolkit {
    private static final String CONFIGURATION_RELMD = "src/main/resources/etc/configuration/relmd/";
    private static final String INTEGRATED_SECURITY = "integratedSecurity=true";
    private static Map<String, String> m_fmToCCLDataTypeMap = new HashMap<String, String>();
    private static final String DRIVER_BLACKLISTED = "Driver (%s) version %s blacklisted as specified by %s.";
    private static final String COMMAND_BLOCK_FAILED = "SQL Command block (%s) failed with SQL state %s, error code %d, and error text %s";
    private static final String COMMAND_BLOCK_STARTED = "SQL Command block (%s) started";
    private static final String TRUE = "TRUE";
    private static final String BACKSLASH = "\\";
    private static final String ATCHAR = "@";
    private static final String OIDC_NAMESPACE = "oidc.namespace";
    private static final String OIDC_ATOKEN = "oidc.atoken";
    private static final String OIDC_IDTOKEN = "oidc.idtoken";

    @Override
    public DatabaseImport databaseImport() {
        return new DatabaseImportElem();
    }

    @Override
    public ColumnsImport columnsImport() {
        return new ColumnsImportElem();
    }

    @Override
    public TableParametersImport tableParametersImport() {
        return new TableParametersImportElem();
    }

    @Override
    public SynonymsImport synonymsImport() {
        return new SynonymsImportElem();
    }

    @Override
    public RoutinesImport routinesImport() {
        return new RoutinesImportElem();
    }

    @Override
    public UniqueKeysImport uniqueKeysImport() {
        return new UniqueKeysImportElem();
    }

    @Override
    public ForeignKeysImport foreignKeysImport() {
        return new ForeignKeysImportElem();
    }

    @Override
    public IndexesImport indexesImport() {
        return new IndexesImportElem();
    }

    @Override
    public RoutineArgumentsImport routineArgumentsImport() {
        return new RoutineArgumentsImportElem();
    }

    @Override
    public ProcedureRoutineArgumentsImport procedureRoutineArgumentsImport() {
        return new ProcedureRoutineArgumentsImportElem();
    }

    @Override
    public FunctionRoutineArgumentsImport functionRoutineArgumentsImport() {
        return new FunctionRoutineArgumentsImportElem();
    }

    @Override
    @Deprecated
    public DefaultSchemaImport defaultSchemaImport() {
        return new DefaultSchemaImportElem();
    }

    @Override
    public void readImportResult(InputStream importResultStream, ImportMetadataResultHandler importResultHandler) throws SAXException, IOException, ParserConfigurationException {
        CompositeModelObjectHandler compositeImportResultHandler = new CompositeModelObjectHandler(importResultHandler);
        ImportResultContentHandler importResultContentHandler = new ImportResultContentHandler(compositeImportResultHandler);
        XmlReader reader = new XmlReader(importResultContentHandler);
        reader.read(importResultStream);
    }

    @Override
    public MetadataSource dataSource(String dataSourceName, String dataSourceConnectionName, String dataSourceSignonName, String encryptedCredentialsXml) {
        return new DataSourceElem(dataSourceName, dataSourceConnectionName, dataSourceSignonName, encryptedCredentialsXml);
    }

    @Override
    @Deprecated
    public MetadataSource newDataSource(String dataSourceName, String dataSourceConnectionName, String dataSourceSignonName, String encryptedCredentialsXml) {
        return this.dataSource(dataSourceName, dataSourceConnectionName, dataSourceSignonName, encryptedCredentialsXml);
    }

    private Connection connectIntegratedSecurity(ConnectionParameters cmDataSource, String jdbcConnectionString, Properties connectionProps) throws Exception {
        String userId = cmDataSource.userName();
        String password = cmDataSource.password();
        String cryptoHandle = cmDataSource.getCryptoHandle();
        final String driverClass = cmDataSource.driverClass();
        boolean isSingleSignOn = false;
        isSingleSignOn = cryptoHandle != null ? true : userId != null && password != null;
        if (!isSingleSignOn) {
            Driver driver = (Driver)Class.forName(driverClass).newInstance();
            return RelmdConnectionFactory.createAndWrapConnection(driver, jdbcConnectionString, connectionProps, true);
        }
        class ConnectTask
        implements Callable<Object> {
            String connectionString;
            Properties connectionProps;
            Database.EVendorType vendorType;
            Connection connection = null;

            ConnectTask(String theConnectionString, Properties theProperties, Database.EVendorType theVendorType) {
                this.connectionString = theConnectionString;
                this.connectionProps = theProperties;
                this.vendorType = theVendorType;
            }

            @Override
            public Object call() throws Exception {
                Driver driver = (Driver)Class.forName(driverClass).newInstance();
                this.connection = RelmdConnectionFactory.connect(driver, this.vendorType, this.connectionString, this.connectionProps);
                return null;
            }

            public Connection getConnection() {
                return this.connection;
            }
        }
        ConnectTask task = new ConnectTask(jdbcConnectionString, connectionProps, cmDataSource.vendorType());
        int runLocale = Integer.parseInt(LocaleConverter.toLCID(cmDataSource.getContentLocale()));
        try {
            if (cryptoHandle != null) {
                this.invokeWithCAMImpersonation(task, cryptoHandle, runLocale);
            } else {
                String domainName = "";
                String uId = userId;
                int slashPos = uId.indexOf(92);
                if (slashPos > 0) {
                    domainName = uId.substring(0, slashPos);
                    userId = uId.substring(slashPos + 1);
                }
                this.invokeWithWinImpersonation(task, domainName, userId, password, runLocale);
            }
        }
        catch (Exception e) {
            this.logMessage("SSO connection failed: " + e.toString());
            if (task.getConnection() != null) {
                try {
                    task.getConnection().close();
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
                }
                catch (SQLException exception) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                }
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
        }
        this.logMessage("SSO connection succeeded");
        return task.getConnection();
    }

    public <T> T invokeWithCAMImpersonation(Callable<T> task, String camCryptoHandle, int errorLocale) throws RelmdException {
        this.logMessage("invokeWithCAMImpersonation: " + camCryptoHandle);
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(camCryptoHandle, errorLocale);
        try {
            return camImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            this.logException(this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage(), Level.WARNING);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR, e);
        }
        catch (Throwable e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.GENERAL_ERROR, e.getLocalizedMessage());
        }
    }

    public <T> T invokeWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) throws RelmdException {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domainName, userName, password, errorLocale);
        try {
            return winImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            this.logException(this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage(), Level.WARNING);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR, e);
        }
        catch (Throwable e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.GENERAL_ERROR, e.getLocalizedMessage());
        }
    }

    private void logException(Object obj, String s, Level level) {
        String loggingClassName = obj.getClass().getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            Logger logger = RelmdLoggerFactory.get(loggingClassName);
            logger.log(level, s);
            RelmdLoggerFactory.flush(logger);
        }
    }

    private void logMessage(String s) {
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(s);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
    }

    @Override
    public Connection connection(ConnectionParameters cmDataSource) throws ClassNotFoundException, SQLException, SAXException, IOException, ParserConfigurationException {
        Connection connection = null;
        Logger logger = null;
        String methodName = "connect";
        String loggingClassName = RelmdToolkits.class.getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            logger = RelmdLoggerFactory.get(loggingClassName);
        }
        if (cmDataSource.vendorType() != Database.EVendorType.local) {
            String driverClass = cmDataSource.driverClass();
            int tryCount = 0;
            try {
                String password;
                Driver driver = (Driver)Class.forName(driverClass).newInstance();
                String jdbcConnectionString = cmDataSource.jdbcConnectionString();
                if (!jdbcConnectionString.startsWith("sfdc:http")) {
                    RelmdToolkits.checkLoadLocation(driver);
                }
                String ibmcognos_qualifiler_list = null;
                String transformuid = null;
                Properties connectionProps = cmDataSource.getProperties();
                if (connectionProps != null) {
                    Set<String> propertyNames = connectionProps.stringPropertyNames();
                    for (String propertyName : propertyNames) {
                        if (ibmcognos_qualifiler_list == null && propertyName.equalsIgnoreCase("ibmcognos.qualifier_list")) {
                            ibmcognos_qualifiler_list = (String)connectionProps.remove(propertyName);
                            continue;
                        }
                        if (transformuid == null && propertyName.equalsIgnoreCase("@transformuid")) {
                            transformuid = (String)connectionProps.remove(propertyName);
                            continue;
                        }
                        if (ibmcognos_qualifiler_list == null || transformuid == null) continue;
                        break;
                    }
                }
                if (cmDataSource.isKerberos()) {
                    if (isTraceOn) {
                        logger.info(String.format("connection string has ibmcognos.authentication=java_krb5", new Object[0]));
                        RelmdLoggerFactory.flush(logger);
                    }
                    JCAMImpersonator.DelegatedCredential credential = cmDataSource.getDelegatedCredential();
                    if (isTraceOn && credential != null) {
                        logger.info(String.format("Kerberos delegated credential connection started::", new Object[0]));
                        RelmdLoggerFactory.flush(logger);
                    }
                    if (credential == null) {
                        String username = cmDataSource.userName();
                        password = cmDataSource.password();
                        if (isTraceOn) {
                            logger.info(String.format("Non delegated credential started, using username and password[" + username + "][" + password + "]", new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        if (username == null || password == null) {
                            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials);
                        }
                        if (isTraceOn) {
                            logger.info(String.format("@Transformuid is " + transformuid, new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        if (TRUE.equalsIgnoreCase(transformuid)) {
                            String[] parts;
                            if (username != null && username.contains(BACKSLASH)) {
                                parts = username.split("\\\\");
                                if (isTraceOn) {
                                    logger.info(String.format("Removed domain name from domain\\username" + username, new Object[0]));
                                    RelmdLoggerFactory.flush(logger);
                                }
                                username = parts[1];
                            }
                            if (username != null && username.contains(ATCHAR)) {
                                parts = username.split(ATCHAR);
                                if (isTraceOn) {
                                    logger.info(String.format("Removed domain name from username@domain" + username, new Object[0]));
                                    RelmdLoggerFactory.flush(logger);
                                }
                                username = parts[0];
                            }
                        }
                        if (isTraceOn) {
                            logger.info(String.format("Kerberos Non delegated credential connection started::", new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        LoginContext lc = RelmdToolkits.createLoginContext(username, password);
                        lc.login();
                        credential = new JCAMImpersonator.DelegatedCredential(lc.getSubject());
                    }
                    Subject subject = credential.getSubject();
                    if (credential.isConstrained()) {
                        connectionProps.put("JGSSCredential", credential.getCredential());
                    }
                    class ConnectTask
                    implements PrivilegedAction<Exception> {
                        Driver driver;
                        String connectionString;
                        Properties connectionProps;
                        Database.EVendorType vendorType;
                        Exception ex = null;
                        Connection connection = null;

                        ConnectTask(Driver theDriver, String theConnectionString, Properties theProperties, Database.EVendorType theVendorType) {
                            this.driver = theDriver;
                            this.connectionString = theConnectionString;
                            this.connectionProps = theProperties;
                            this.vendorType = theVendorType;
                        }

                        @Override
                        public Exception run() {
                            try {
                                this.connection = RelmdConnectionFactory.connect(this.driver, this.vendorType, this.connectionString, this.connectionProps);
                            }
                            catch (Exception e) {
                                this.ex = e;
                            }
                            return this.ex;
                        }

                        public Exception getException() {
                            return this.ex;
                        }

                        public Connection getConnection() {
                            return this.connection;
                        }
                    }
                    ConnectTask task = new ConnectTask(driver, jdbcConnectionString, connectionProps, cmDataSource.vendorType());
                    Subject.doAs(subject, task);
                    if (task.getException() != null) {
                        throw task.getException();
                    }
                    connection = task.getConnection();
                } else if (cmDataSource.isIntegratedSecurity()) {
                    connection = this.connectIntegratedSecurity(cmDataSource, jdbcConnectionString, connectionProps);
                } else {
                    OIDCCredentialsSignon oidcSignon = cmDataSource.getOIDCCredentialsSignon();
                    if (oidcSignon != null) {
                        connectionProps.setProperty(OIDC_NAMESPACE, oidcSignon.getNamespace());
                        connectionProps.setProperty(OIDC_ATOKEN, oidcSignon.getAccessToken().decrypt());
                        connectionProps.setProperty(OIDC_IDTOKEN, oidcSignon.getIdToken().decrypt());
                    } else {
                        String userName = cmDataSource.userName();
                        password = cmDataSource.password();
                        if (null != userName) {
                            connectionProps.setProperty("user", userName);
                        }
                        if (null != password) {
                            connectionProps.setProperty("password", password);
                        }
                    }
                    String proxyUserName = cmDataSource.proxyUserName();
                    String proxyPassword = cmDataSource.proxyPassword();
                    switch (cmDataSource.vendorType()) {
                        case generic: 
                        case genericSAP: 
                        case genericSiebel: {
                            connection = RelmdConnectionFactory.createAndWrapConnection(driver, jdbcConnectionString, connectionProps, true);
                            break;
                        }
                        case genericSFDC: {
                            if (proxyUserName != null) {
                                connectionProps.setProperty("proxyUserName", proxyUserName);
                                connectionProps.setProperty("proxyPassword", proxyPassword);
                            }
                            connection = RelmdConnectionFactory.createAndWrapConnection(driver, jdbcConnectionString, connectionProps, true);
                            break;
                        }
                        case genericHive: {
                            connection = RelmdConnectionFactory.createAndWrapConnection(driver, jdbcConnectionString, connectionProps, false);
                            String databaseName = jdbcConnectionString.substring(jdbcConnectionString.lastIndexOf(47) + 1);
                            connection.setCatalog(databaseName);
                            break;
                        }
                        default: {
                            connection = RelmdConnectionFactory.connect(driver, jdbcConnectionString, connectionProps);
                        }
                    }
                }
                if (connection instanceof IAdaptorConnection) {
                    if (ibmcognos_qualifiler_list != null) {
                        List<String> qualifierList = Arrays.asList(ibmcognos_qualifiler_list.split("\\s*,\\s*"));
                        ((IAdaptorConnection)connection).setQualifierList(qualifierList);
                    }
                    this.handleBlacklist4Generic(connection, isTraceOn, logger);
                }
                this.handleCommandBlocks(cmDataSource, connection, isTraceOn, logger);
            }
            catch (RuntimeException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                if (tryCount < 10 && "com.ncr.teradata.TeraDriver".equals(driverClass)) {
                    connection = null;
                    ++tryCount;
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidDriverClass, e);
            }
            catch (InstantiationException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidDriverClass, e);
            }
            catch (ClassNotFoundException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcDriverNotFound, e);
            }
            catch (SQLInvalidAuthorizationSpecException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials, e);
            }
            catch (SQLCognosInvalidLogonException e) {
                SQLCognosInvalidLogonException.SubCode subCode;
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                if ((subCode = e.getSubCode()) == SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials, e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
            }
            catch (LoginException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
            }
            catch (SQLException e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
            }
            catch (Exception e) {
                if (isTraceOn) {
                    logger.throwing(loggingClassName, "connect", e);
                }
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.x, e);
            }
        }
        if (isTraceOn) {
            logger.exiting(loggingClassName, loggingClassName);
        }
        return connection;
    }

    public static LoginContext createLoginContext(final String username, final String password) throws Exception {
        LoginContext lc = null;
        try {
            lc = new LoginContext("com.cognos.biserver.security.xqe.jdbc", new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callbacks[i];
                            nc.setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callbacks[i];
                            pc.setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i], "Internal error - unrecognized Callback");
                    }
                }
            });
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        if (lc == null) {
            lc = new LoginContext("com.cognos.biserver.security.xqe.jdbc", null, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callbacks[i];
                            nc.setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callbacks[i];
                            pc.setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i], "Internal error - unrecognized Callback");
                    }
                }
            }, new LocalRelmdConfiguration());
        }
        return lc;
    }

    private void handleCommandBlocks(ConnectionParameters cmDataSource, Connection connection, boolean isTraceOn, Logger logger) {
        if (cmDataSource.commands() != null) {
            EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands = cmDataSource.commands();
            LinkedList clist = new LinkedList();
            if (commands.get((Object)Commands.CMD_OPEN_CONNECTION) != null) {
                clist.addAll(commands.get((Object)Commands.CMD_OPEN_CONNECTION));
            }
            if (commands.get((Object)Commands.CMD_OPEN_SESSION) != null) {
                clist.addAll(commands.get((Object)Commands.CMD_OPEN_SESSION));
            }
            for (IDataSourceConnectionCommandBlock cBlock : clist) {
                if (cBlock.getType() != IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) continue;
                try {
                    if (isTraceOn) {
                        logger.log(Level.INFO, String.format(COMMAND_BLOCK_STARTED, cBlock.getProperty("sql")));
                    }
                    Statement statement = connection.createStatement();
                    statement.execute((String)cBlock.getProperty("sql"));
                    statement.close();
                }
                catch (SQLException e) {
                    if (!isTraceOn) continue;
                    logger.log(Level.WARNING, String.format(COMMAND_BLOCK_FAILED, cBlock.getProperty("sql"), e.getSQLState(), e.getErrorCode(), e.getMessage()));
                }
            }
        }
    }

    private void handleBlacklist4Generic(Connection connection, boolean isTraceOn, Logger logger) throws SQLException {
        Map info = ((IAdaptorConnection)connection).getExtraInformation();
        if (info == null) {
            return;
        }
        if (info.containsKey("blacklistDriver")) {
            String[] blacklistDriverInfo = (String[])info.get("blacklistDriver");
            String driverName = connection.getMetaData().getDriverName();
            if (isTraceOn) {
                logger.log(Level.SEVERE, String.format(DRIVER_BLACKLISTED, driverName, blacklistDriverInfo[0], blacklistDriverInfo[1]));
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcDriverVersionIsNotSupported);
        }
        if (info.containsKey("blacklistServer")) {
            String[] blacklistServerInfo = (String[])info.get("blacklistServer");
            String databaseServerName = connection.getMetaData().getDatabaseProductName();
            if (isTraceOn) {
                logger.log(Level.SEVERE, String.format(DRIVER_BLACKLISTED, databaseServerName, blacklistServerInfo[0], blacklistServerInfo[1]));
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.databaseServerVersionIsNotSupported);
        }
    }

    @Override
    public Map<Database.EVendorType, VendorRules> configuredRules() throws FileNotFoundException {
        ICCLConfiguration instance = CCLConfigurationFactory.getInstance();
        Map<Database.EVendorType, VendorRules> configuredRules = this.configuredRules(instance);
        return configuredRules;
    }

    @Override
    public Map<Database.EVendorType, VendorRules> configuredRules(ICCLConfiguration instance) throws FileNotFoundException {
        Database.EVendorType[] vendorTypesList;
        String resolvedPath = instance.resolveEffectivePath(CONFIGURATION_RELMD);
        HashMap<Database.EVendorType, VendorRules> map = new HashMap<Database.EVendorType, VendorRules>();
        for (Database.EVendorType vendorType : vendorTypesList = Database.EVendorType.values()) {
            try {
                String vendorTypeValue = vendorType.toString();
                if (vendorTypeValue.indexOf("generic") >= 0) {
                    vendorTypeValue = "generic";
                }
                String filePath = resolvedPath + "/" + vendorTypeValue + ".xml";
                File candidateRulesFile = new File(filePath);
                InputStream inStream = null;
                if (candidateRulesFile.exists()) {
                    inStream = new FileInputStream(candidateRulesFile);
                } else {
                    String resourcePath = "/" + vendorTypeValue + ".xml";
                    inStream = this.getClass().getResourceAsStream(resourcePath);
                    if (inStream == null) {
                        throw new FileNotFoundException(resourcePath);
                    }
                }
                VendorRulesBuilder vendorRulesReader = new VendorRulesBuilder(vendorType);
                XmlReader reader = new XmlReader(vendorRulesReader);
                BufferedInputStream inputStream = new BufferedInputStream(inStream, 8192);
                reader.read(inputStream);
                VendorRules vendorRules = vendorRulesReader.getRulesProvider();
                if (null == vendorRules) continue;
                map.put(vendorType, vendorRules);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    @Override
    public VendorRules vendorRules(Database.EVendorType vendorType, Database.ECatalogSupport catalogSupport) throws SAXException, IOException, ParserConfigurationException {
        String vendorTypeValue = vendorType.toString();
        if (vendorTypeValue.indexOf("generic") != -1 || vendorType == Database.EVendorType.local) {
            vendorTypeValue = "generic";
        }
        String filePath = CONFIGURATION_RELMD + vendorTypeValue + ".xml";
        String resolveEffectivePath = CCLConfigurationFactory.getInstance().resolveEffectivePath(filePath);
        File file = new File(resolveEffectivePath);
        InputStream inStream = null;
        if (file.exists()) {
            inStream = new FileInputStream(file);
        } else {
            String resourcePath = "/" + vendorTypeValue + ".xml";
            inStream = this.getClass().getResourceAsStream(resourcePath);
            if (inStream == null) {
                throw new FileNotFoundException(resourcePath);
            }
        }
        VendorRulesBuilder vendorRulesReader = new VendorRulesBuilder(vendorType, catalogSupport);
        XmlReader reader = new XmlReader(vendorRulesReader);
        BufferedInputStream inputStream = new BufferedInputStream(inStream, 8192);
        reader.read(inputStream);
        VendorRules vendorRules = vendorRulesReader.getRulesProvider();
        return vendorRules;
    }

    @Override
    public VendorRules vendorRules(Database.EVendorType vendorType) throws SAXException, IOException, ParserConfigurationException {
        String vendorTypeValue = vendorType.toString();
        if (vendorTypeValue.indexOf("generic") != -1 || vendorType == Database.EVendorType.local) {
            vendorTypeValue = "generic";
        }
        String filePath = CONFIGURATION_RELMD + vendorTypeValue + ".xml";
        String resolveEffectivePath = CCLConfigurationFactory.getInstance().resolveEffectivePath(filePath);
        File file = new File(resolveEffectivePath);
        InputStream inStream = null;
        if (file.exists()) {
            inStream = new FileInputStream(file);
        } else {
            String resourcePath = "/" + vendorTypeValue + ".xml";
            inStream = this.getClass().getResourceAsStream(resourcePath);
            if (inStream == null) {
                throw new FileNotFoundException(resourcePath);
            }
        }
        VendorRulesBuilder vendorRulesReader = new VendorRulesBuilder(vendorType);
        XmlReader reader = new XmlReader(vendorRulesReader);
        BufferedInputStream inputStream = new BufferedInputStream(inStream, 8192);
        reader.read(inputStream);
        VendorRules vendorRules = vendorRulesReader.getRulesProvider();
        return vendorRules;
    }

    @Override
    public void mergeFiltered(InputStream inputModelStream, MergeSource mergee, MetadataSourceSelectionsFilter importSourceFilter, MetadataObjectHandler modelObjectHandler) throws SAXException, IOException, ParserConfigurationException {
        MetadataObjectHandler handler = modelObjectHandler;
        if (mergee != null) {
            handler = new MergeUtil(mergee, modelObjectHandler);
        }
        ModelObjectContentHandler modelReader = new ModelObjectContentHandler(importSourceFilter, XmlContentHandler.EElementRule.accept, handler);
        XmlReader reader = new XmlReader(modelReader);
        reader.read(inputModelStream);
    }

    @Override
    public void delete(InputStream inputModelStream, MetadataSourceSelectionsFilter filter, MetadataObjectHandler handler) throws SAXException, IOException, ParserConfigurationException {
        CompositeModelObjectHandler dispatchingHandler = new CompositeModelObjectHandler(handler);
        ModelObjectContentHandler modelReader = new ModelObjectContentHandler(filter, null, dispatchingHandler);
        XmlReader reader = new XmlReader(modelReader);
        reader.read(inputModelStream);
    }

    @Override
    public TableSelection tableSelection(String objectName) {
        return new SelectedObjectElem("tableSelection", objectName);
    }

    @Override
    public ViewSelection viewSelection(String objectName) {
        return new SelectedObjectElem("viewSelection", objectName);
    }

    @Override
    public SynonymSelection synonymSelection(String objectName) {
        return new SelectedObjectElem("synonymSelection", objectName);
    }

    @Override
    public ProcedureSelection procedureSelection(String objectName) {
        return new SelectedObjectElem("procedureSelection", objectName);
    }

    @Override
    public FunctionSelection functionSelection(String objectName) {
        return new SelectedObjectElem("functionSelection", objectName);
    }

    @Override
    public ColumnSelection columnSelection(String objectName) {
        return new SelectedObjectElem("columnSelection", objectName);
    }

    @Override
    public String cclDataType(String fmDataType) {
        return m_fmToCCLDataTypeMap.get(fmDataType);
    }

    @Override
    public SqlColumn fmColumn(final SqlColumn nativeColumn, SqlColumnConversionRules rules) {
        final String mappedDataType = rules.mapDataType(nativeColumn);
        final Integer mappedSize = rules.mapSize(nativeColumn);
        final Integer mappedPrecision = rules.mapPrecision(nativeColumn);
        final Integer mappedScale = rules.mapScale(nativeColumn);
        final Boolean isNullable = nativeColumn.isNullable();
        SqlColumn fmColumn1 = new SqlColumn(){

            @Override
            public String datatype() {
                return mappedDataType;
            }

            @Override
            public Boolean hasSize() {
                return null != mappedSize;
            }

            @Override
            public Integer size() {
                return mappedSize;
            }

            @Override
            public Boolean hasPrecision() {
                return null != mappedPrecision;
            }

            @Override
            public Integer precision() {
                return mappedPrecision;
            }

            @Override
            public Boolean hasScale() {
                return null != mappedScale;
            }

            @Override
            public Integer scale() {
                return mappedScale;
            }

            @Override
            public Boolean hasIsNullable() {
                return null != isNullable;
            }

            @Override
            public Boolean isNullable() {
                return isNullable;
            }

            @Override
            public Boolean hasDefaultValue() {
                return nativeColumn.hasDefaultValue();
            }

            @Override
            public String defaultValue() {
                return nativeColumn.defaultValue();
            }

            @Override
            public Boolean hasCollationSequence() {
                return nativeColumn.hasCollationSequence();
            }

            @Override
            public String collationSequence() {
                return nativeColumn.collationSequence();
            }

            public String toString() {
                return "datatype: " + mappedDataType + ", size: " + mappedSize + ", precision: " + mappedPrecision + ", scale: " + mappedScale + ", isNullable: " + isNullable;
            }

            @Override
            public SqlColumn.SourceType sourceType() {
                return SqlColumn.SourceType.frameworkManager;
            }
        };
        return fmColumn1;
    }

    @Override
    public ConnectionStringParameters parseConnectionString(String dataSourceConnectionString) {
        return new DataSourceConnectionStringParser(dataSourceConnectionString);
    }

    @Override
    public ConnectionStringParameters parseConnectionString(String dataSourceConnectionString, ConnnectionSignonParameters credentials) {
        return new DataSourceConnectionStringParser(dataSourceConnectionString, null, credentials);
    }

    @Override
    public ConnectionStringParameters parseConnectionString(String dataSourceConnectionString, BiBusHeader biBusHeader, ConnnectionSignonParameters credentials) {
        return new DataSourceConnectionStringParser(dataSourceConnectionString, biBusHeader, credentials);
    }

    @Override
    public ConnnectionSignonParameters decryptCredentials(String encryptedCredentialsXml, ValueDecryption encryptedValueDecrypter) throws UnsupportedEncodingException, DocumentException, CAMCryptoException {
        CredentialsDecrypt credentialsDecrypt = new CredentialsDecrypt(encryptedCredentialsXml, encryptedValueDecrypter);
        return credentialsDecrypt;
    }

    @Override
    public ConnectionProxySignonParameters decryptProxyCredentials(String encryptedCredentialsXml, ValueDecryption encryptedValueDecrypter) throws UnsupportedEncodingException, DocumentException, CAMCryptoException {
        ProxyCredentialsDecrypt credentialsDecrypt = new ProxyCredentialsDecrypt(encryptedCredentialsXml, encryptedValueDecrypter);
        return credentialsDecrypt;
    }

    @Override
    public boolean allSelected(ObjectSelectionsContainer objectSelectionsContainer) {
        boolean bAllSelected = this.allSelected(objectSelectionsContainer.tableSelections());
        bAllSelected = bAllSelected && this.allSelected(objectSelectionsContainer.viewSelections());
        bAllSelected = bAllSelected && this.allSelected(objectSelectionsContainer.procedureSelections());
        bAllSelected = bAllSelected && this.allSelected(objectSelectionsContainer.functionSelections());
        bAllSelected = bAllSelected && this.allSelected(objectSelectionsContainer.synonymSelections());
        return bAllSelected;
    }

    @Override
    public <T extends SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects>> boolean allSelected(T selectionChoice) {
        boolean equals = false;
        if (null != selectionChoice) {
            SelectionChoice.EChoice choice = selectionChoice.choice();
            equals = SelectionChoice.EChoice.all.equals((Object)choice);
        }
        return equals;
    }

    @Override
    public <T extends SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects>> boolean anySelected(T selectionChoice) {
        boolean equals = false;
        if (null != selectionChoice) {
            SelectionChoice.EChoice choice = selectionChoice.choice();
            equals = SelectionChoice.EChoice.all.equals((Object)choice) || 0 < selectionChoice.selectedObjects().size();
        }
        return equals;
    }

    @Override
    public void selectAllChildren(ObjectSelectionsContainer objectSelectionsContainer) {
        this.selectAllTables(objectSelectionsContainer);
        this.selectAllViews(objectSelectionsContainer);
        this.selectAllSynonyms(objectSelectionsContainer);
        this.selectAllProcedures(objectSelectionsContainer);
        this.selectAllFunctions(objectSelectionsContainer);
    }

    @Override
    public void selectAllTables(ObjectSelectionsContainer objectSelectionsContainer) {
        SelectionChoice<TableSelection, AllTablesSelection> tableSelections = objectSelectionsContainer.tableSelections();
        AllTablesSelection allTablesSelection = this.allTablesSelection();
        tableSelections.setAll(allTablesSelection);
    }

    @Override
    public void selectAllViews(ObjectSelectionsContainer objectSelectionsContainer) {
        SelectionChoice<ViewSelection, AllViewsSelection> viewSelections = objectSelectionsContainer.viewSelections();
        AllViewsSelection allViewsSelection = this.allViewsSelection();
        viewSelections.setAll(allViewsSelection);
    }

    @Override
    public void selectAllSynonyms(ObjectSelectionsContainer objectSelectionsContainer) {
        SelectionChoice<SynonymSelection, AllSynonymsSelection> synonymSelections = objectSelectionsContainer.synonymSelections();
        AllSynonymsSelection allSynonymsSelection = this.allSynonymsSelection();
        synonymSelections.setAll(allSynonymsSelection);
    }

    @Override
    public void selectAllProcedures(ObjectSelectionsContainer objectSelectionsContainer) {
        SelectionChoice<ProcedureSelection, AllProceduresSelection> procedureSelections = objectSelectionsContainer.procedureSelections();
        AllProceduresSelection allProceduresSelection = this.allProceduresSelection();
        procedureSelections.setAll(allProceduresSelection);
    }

    @Override
    public void selectAllFunctions(ObjectSelectionsContainer objectSelectionsContainer) {
        SelectionChoice<FunctionSelection, AllFunctionsSelection> functionSelections = objectSelectionsContainer.functionSelections();
        AllFunctionsSelection allFunctionsSelection = this.allFunctionsSelection();
        functionSelections.setAll(allFunctionsSelection);
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, String jdbcConnectionString, String driverClass, String userName, String password, ExtendedParameterLookup extendedParameterLookup, String language, Properties properties) {
        return this.connectionParameters(vendorType, rawVendorType, jdbcConnectionString, driverClass, userName, password, extendedParameterLookup, language, null, false, false, null, null, null, null, properties);
    }

    @Override
    public ConnectionParameters connectionParameters(final Database.EVendorType vendorType, final Database.EVendorType rawVendorType, final String jdbcConnectionString, final String driverClass, final String userName, final String password, final ExtendedParameterLookup extendedParameterLookup, final String language, final JCAMImpersonator.DelegatedCredential credential, final boolean isKerberos, final boolean isIntegratedSecurity, final String cryptoHandle, final String contentLocale, final OIDCCredentialsSignon oidcSignon, final ApiTokenSignon apiTokenSignon, final Properties properties) {
        return new ConnectionParameters(){

            @Override
            public Database.EVendorType vendorType() {
                return vendorType;
            }

            @Override
            public Database.EVendorType rawVendorType() {
                return rawVendorType;
            }

            @Override
            public String jdbcConnectionString() {
                return jdbcConnectionString;
            }

            @Override
            public String driverClass() {
                return driverClass;
            }

            @Override
            public String userName() {
                return userName;
            }

            @Override
            public String password() {
                return password;
            }

            @Override
            public String language() {
                return language;
            }

            @Override
            public ExtendedParameterLookup extendedParameterLookup() {
                return extendedParameterLookup;
            }

            @Override
            public void setVendorType(Database.EVendorType vendorType2) {
            }

            @Override
            public void setRawVendorType(Database.EVendorType rawVendorType2) {
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public String proxyUserName() {
                return null;
            }

            @Override
            public String proxyPassword() {
                return null;
            }

            @Override
            public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
                return credential;
            }

            @Override
            public boolean isKerberos() {
                return isKerberos;
            }

            @Override
            public boolean isIntegratedSecurity() {
                return isIntegratedSecurity;
            }

            @Override
            public String getCryptoHandle() {
                return cryptoHandle;
            }

            @Override
            public String getContentLocale() {
                return contentLocale;
            }

            @Override
            public Properties getProperties() {
                return properties;
            }

            @Override
            public EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands() {
                return null;
            }

            @Override
            public OIDCCredentialsSignon getOIDCCredentialsSignon() {
                return oidcSignon;
            }

            @Override
            public ApiTokenSignon getApiTokenSignon() {
                return apiTokenSignon;
            }
        };
    }

    @Override
    public ConnectionParameters connectionParameters(final Database.EVendorType vendorType, final Database.EVendorType rawVendorType, final Database.ECatalogSupport catalogSupport, final String jdbcConnectionString, final String driverClass, final String userName, final String password, final ExtendedParameterLookup extendedParameterLookup, final String language, final Properties properties) {
        return new ConnectionParameters(){

            @Override
            public Database.EVendorType vendorType() {
                return vendorType;
            }

            @Override
            public Database.EVendorType rawVendorType() {
                return rawVendorType;
            }

            @Override
            public String jdbcConnectionString() {
                return jdbcConnectionString;
            }

            @Override
            public String driverClass() {
                return driverClass;
            }

            @Override
            public String userName() {
                return userName;
            }

            @Override
            public String password() {
                return password;
            }

            @Override
            public String language() {
                return language;
            }

            @Override
            public ExtendedParameterLookup extendedParameterLookup() {
                return extendedParameterLookup;
            }

            @Override
            public void setVendorType(Database.EVendorType vendorType2) {
            }

            @Override
            public void setRawVendorType(Database.EVendorType rawVendorType2) {
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return catalogSupport;
            }

            @Override
            public String proxyUserName() {
                return null;
            }

            @Override
            public String proxyPassword() {
                return null;
            }

            @Override
            public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
                return null;
            }

            @Override
            public boolean isKerberos() {
                return false;
            }

            @Override
            public boolean isIntegratedSecurity() {
                return false;
            }

            @Override
            public String getCryptoHandle() {
                return null;
            }

            @Override
            public String getContentLocale() {
                return null;
            }

            @Override
            public Properties getProperties() {
                return properties;
            }

            @Override
            public EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands() {
                return null;
            }

            @Override
            public OIDCCredentialsSignon getOIDCCredentialsSignon() {
                return null;
            }

            @Override
            public ApiTokenSignon getApiTokenSignon() {
                return null;
            }
        };
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, String jdbcConnectionString, String driverClass, String userName, String password, Properties properties) {
        ExtendedParameterLookup extendedParameterLookup = new ExtendedParameterLookup(){

            @Override
            public Object parameter(String parameterName) {
                return null;
            }
        };
        ConnectionParameters connectionParameters = this.connectionParameters(vendorType, rawVendorType, jdbcConnectionString, driverClass, userName, password, extendedParameterLookup, "en", null, false, false, null, null, null, null, properties);
        return connectionParameters;
    }

    @Override
    @Deprecated
    public VendorAccessConnection vendorConnectionAccess(final Connection connection, DatabaseAccessHandler databaseRequestInfoHandler) {
        final VendorAccessHandler vendorAccessHandler = this.vendorAccessHandler(databaseRequestInfoHandler);
        VendorAccessConnection vendorAccessConnection = new VendorAccessConnection(){

            @Override
            public Connection jdbcConnection() {
                return connection;
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return vendorAccessHandler;
            }

            @Override
            public DatabaseAccessHandler databaseAccessEventHandler() {
                return null;
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return null;
            }

            @Override
            public DatabaseAccessRules databaseAccessRules() {
                return null;
            }

            @Override
            public Session session() {
                return null;
            }
        };
        return vendorAccessConnection;
    }

    @Override
    public VendorAccessConnection vendorConnectionAccess(final Connection connection, DatabaseAccessHandler databaseAccessHandler, final DatabaseAccessRules databaseAccessRules) {
        final SessionQueryRules sessionQueryRules = this.sessionQueryRules(databaseAccessRules);
        final VendorAccessHandler vendorAccessHandler = this.vendorAccessHandler(databaseAccessHandler);
        VendorAccessConnection vendorAccessConnection = new VendorAccessConnection(){

            @Override
            public DatabaseAccessHandler databaseAccessEventHandler() {
                return null;
            }

            @Override
            public Connection jdbcConnection() {
                return connection;
            }

            @Override
            public DatabaseAccessRules databaseAccessRules() {
                return databaseAccessRules;
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return sessionQueryRules;
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return vendorAccessHandler;
            }

            @Override
            public Session session() {
                return null;
            }
        };
        return vendorAccessConnection;
    }

    @Override
    public SessionQueryRules sessionQueryRules(DatabaseAccessRules databaseAccessRules) {
        SessionQueryRules sessionQueryRules = null;
        if (null != databaseAccessRules) {
            CaseSensitivity caseSensitivity = databaseAccessRules.caseSensitivity();
            CatalogSetupRules catalogSetupRules = databaseAccessRules.catalogSetupRules();
            final CatalogGranularityRules catalogGranularityRules = this.catalogGranularityRules(catalogSetupRules);
            String stringValue = caseSensitivity.storage().toString();
            final CaseSensitivityRules.EStorage storageValue = CaseSensitivityRules.EStorage.valueOf(stringValue);
            final CaseSensitivityRules caseSensitivityRules = new CaseSensitivityRules(){

                @Override
                public CaseSensitivityRules.EStorage storage() {
                    return storageValue;
                }

                @Override
                public CaseSensitivityRules.EConversionType conversionType() {
                    return CaseSensitivityRules.EConversionType.sql;
                }
            };
            sessionQueryRules = new SessionQueryRules(){

                @Override
                public CaseSensitivityRules caseSensitivityRules() {
                    return caseSensitivityRules;
                }

                @Override
                public CatalogGranularityRules catalogGranularityRules() {
                    return catalogGranularityRules;
                }

                @Override
                public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
                    return null;
                }

                @Override
                public Boolean hasCatalogGranularityRules() {
                    return null != this.catalogGranularityRules();
                }

                @Override
                public Boolean hasDefaultSchemaQueryRules() {
                    return null;
                }

                @Override
                public Database.ECatalogSupport catalogSupport() {
                    return Database.ECatalogSupport.catalogsNotSupported;
                }

                @Override
                public CodePageRules codePageRules() {
                    return null;
                }
            };
        } else {
            sessionQueryRules = this.sessionQueryRules(CaseSensitivityRules.EStorage.none);
        }
        return sessionQueryRules;
    }

    @Override
    public SchemaObjectPath schemaObjectPath(final SchemaPath schemaPath, final String objectName) {
        return new SchemaObjectPath(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SchemaPath schemaPath() {
                return schemaPath;
            }
        };
    }

    @Override
    public SchemaPath schemaPath(Database.ECatalogSupport catalogSupport, String parentCatalogName, String parentSchemaName) {
        return new BrowseObjectPath(catalogSupport, parentCatalogName, parentSchemaName, null);
    }

    @Override
    public SchemaPath schemaPath(String parentSchemaName) {
        return new BrowseObjectPath(null, null, parentSchemaName, null);
    }

    @Override
    public MetadataSqlColumnConversionToolkit sqlColumnConversionToolkit() {
        return this;
    }

    @Override
    public MetadataXmlToolkit xmlToolkit() {
        return this;
    }

    @Override
    @Deprecated
    public DefaultSchema defaultSchema(final String catalogName, final String schemaName) {
        return new DefaultSchema(){

            @Override
            public String getCatalog() {
                return catalogName != null && 0 < catalogName.length() ? catalogName : null;
            }

            @Override
            public String getSchema() {
                return schemaName != null && 0 < schemaName.length() ? schemaName : null;
            }

            @Override
            public boolean hasCatalog() {
                return null != this.getCatalog();
            }

            @Override
            public boolean hasSchema() {
                return null != this.getSchema();
            }
        };
    }

    @Override
    public Metadata metadata() {
        return new RelationalMetadataElem();
    }

    @Override
    public CatalogSelection catalogSelection(String catalogName) {
        return new SelectedObjectElem("catalogSelection", catalogName);
    }

    @Override
    @Deprecated
    public CatalogSelection catalogSelection(String catalogName, DefaultSchema defaultSchema) {
        String defaultCatalog;
        SelectedObjectElem catalogSelection = new SelectedObjectElem("catalogSelection", catalogName);
        String objectName = catalogSelection.objectName();
        if (0 == objectName.length() && null != (defaultCatalog = defaultSchema.getCatalog())) {
            XmlAttribute objectNameAttribute = catalogSelection.getAttribute("name");
            objectNameAttribute.setValue(defaultCatalog);
        }
        return catalogSelection;
    }

    @Override
    @Deprecated
    public SchemaSelection schemaSelection(String schemaName, DefaultSchema defaultSchema) {
        String defaultSchemaName;
        SelectedObjectElem schemaSelection = new SelectedObjectElem("schemaSelection", schemaName);
        String objectName = schemaSelection.objectName();
        if ((null == objectName || 0 == objectName.length()) && null != (defaultSchemaName = defaultSchema.getSchema())) {
            XmlAttribute objectNameAttribute = schemaSelection.getAttribute("name");
            objectNameAttribute.setValue(defaultSchemaName);
        }
        return schemaSelection;
    }

    @Override
    public SchemaSelection schemaSelection(String schemaName) {
        return new SelectedObjectElem("schemaSelection", schemaName);
    }

    @Override
    public AllCatalogsSelection allCatalogsSelection(boolean includeSystemObjects) {
        return this.allObjectsSelectionSystemLevel("allCatalogsSelection", includeSystemObjects);
    }

    @Override
    public AllSchemasSelection allSchemasSelection(boolean includeSystemObjects) {
        return this.allObjectsSelectionSystemLevel("allSchemasSelection", includeSystemObjects);
    }

    private AllSelectionsElem allObjectsSelectionSystemLevel(String tagName, boolean includeSystemObjects) {
        AllSelectionsElem allSelectionsElem = new AllSelectionsElem(tagName, new RelmdAttributeGroup());
        if (includeSystemObjects) {
            allSelectionsElem.addAttribute("includeSystemObjects", "true");
        }
        return allSelectionsElem;
    }

    @Override
    public AllFunctionsSelection allFunctionsSelection() {
        return new AllSelectionsElem("allFunctionsSelection", new RelmdAttributeGroup());
    }

    @Override
    public AllProceduresSelection allProceduresSelection() {
        return new AllSelectionsElem("allProceduresSelection", new RelmdAttributeGroup());
    }

    @Override
    public AllSynonymsSelection allSynonymsSelection() {
        return new AllSelectionsElem("allSynonymsSelection", new RelmdAttributeGroup());
    }

    @Override
    public AllTablesSelection allTablesSelection() {
        return new AllSelectionsElem("allTablesSelection", new RelmdAttributeGroup());
    }

    @Override
    public AllViewsSelection allViewsSelection() {
        return new AllSelectionsElem("allViewsSelection", new RelmdAttributeGroup());
    }

    @Override
    public SystemObjectSelections systemObjectSelections() {
        return new SelectionsElem("systemObjectsSelections", new RelmdAttributeGroup());
    }

    @Override
    public MetadataObjectHandler chainedMetadataObjectHandler(MetadataObjectHandler ... modelObjectHandlers) {
        return new CompositeModelObjectHandler(modelObjectHandlers);
    }

    @Override
    public MetadataSourceSelectionsFilter importSourceFilter(MetadataSourceSelections ... importSources) {
        return new ImportSourceFilter(importSources);
    }

    @Override
    public MergeSource mergeSource() {
        return new ModelBuilder();
    }

    public MetadataLoader metadataBuilder() {
        return new ModelBuilder();
    }

    @Override
    public MetadataWriter metadataWriter(OutputStream outstream) throws IOException {
        return new ModelWriter("relmdApi.xsd", outstream);
    }

    @Override
    public void readModel(InputStream modelStream, MetadataObjectHandler modelObjectHandler) throws SAXException, IOException, ParserConfigurationException {
        this.mergeFiltered(modelStream, null, null, modelObjectHandler);
    }

    @Override
    public void filter(InputStream inputStream, MetadataSourceSelectionsFilter importSourceFilter, MetadataObjectHandler modelObjectHandler) throws SAXException, IOException, ParserConfigurationException {
        this.mergeFiltered(inputStream, null, importSourceFilter, modelObjectHandler);
    }

    @Override
    public void merge(InputStream inputModelStream, MergeSource mergeModelFilter, MetadataObjectHandler modelObjectHandler) throws SAXException, IOException, ParserConfigurationException {
        this.mergeFiltered(inputModelStream, mergeModelFilter, null, modelObjectHandler);
    }

    @Override
    public MetadataSourceSelections metadataSourceSelections(MetadataSource dataSource, MetadataObjectSelections objectSelections) {
        return new ImportSource(dataSource, objectSelections);
    }

    @Override
    public ImportMetadataResultHandler compositeImportMetadataResultHandler(ImportMetadataResultHandler ... importResultHandlers) {
        return new CompositeModelObjectHandler(importResultHandlers);
    }

    @Override
    public MetadataImportFunctionChain databaseImportChain() {
        return new ImportFunctionChain();
    }

    public MetadataImportFunctionChain columnsImportChain() {
        ImportFunctionChain importFunctionChain = new ImportFunctionChain();
        importFunctionChain.addTablesImport(this.tablesImport());
        importFunctionChain.addViewsImport(this.viewsImport());
        importFunctionChain.addColumnsImport(this.columnsImport());
        importFunctionChain.addUniqueKeysImport(this.uniqueKeysImport());
        importFunctionChain.addForeignKeysImport(this.foreignKeysImport());
        importFunctionChain.addIndexesImport(this.indexesImport());
        importFunctionChain.addSynonymsImport(this.synonymsImport());
        return importFunctionChain;
    }

    public MetadataImportFunctionChain routinesImportChain() {
        ImportFunctionChain importFunctionChain = new ImportFunctionChain();
        importFunctionChain.addRoutinesImport(this.routinesImport());
        importFunctionChain.addRoutineArgumentsImport(this.routineArgumentsImport());
        return importFunctionChain;
    }

    @Override
    public ImportMetadataRequest importMetadataRequest(MetadataImportFunctionChain importFunctionChain, MetadataSource dataSource, MetadataObjectSelections objectSelections) {
        return new ImportRequest(importFunctionChain, dataSource, objectSelections);
    }

    @Override
    public ImportMetadataResult importMetadataResult(Metadata metadata, ImportSummary summary) {
        return new ImportResult(metadata, summary);
    }

    @Override
    public ImportResultsMetadataBuilder importMetadataResultBuilder(MetadataSource dataSource, Database.EVendorType vendorType) {
        RelationalMetadataElem relationalMetadata = new RelationalMetadataElem();
        DatabaseElem database = new DatabaseElem(dataSource.dataSourceName(), vendorType);
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.handleMetadata(relationalMetadata);
        modelBuilder.handleDatabase(database);
        return modelBuilder;
    }

    @Override
    public CatalogsBrowse catalogsBrowse(BrowseQueryType.EQueryType queryType) {
        return new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.catalogsBrowse, null, null, null, queryType);
    }

    @Override
    public ColumnsBrowse columnsBrowse(ColumnParentPath columnParentPath) {
        String parentCatalogName = columnParentPath.parentCatalogName();
        String parentSchemaName = columnParentPath.parentSchemaName();
        String parentObjectName = columnParentPath.parentObjectName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.columnsBrowse, parentCatalogName, parentSchemaName, parentObjectName, BrowseQueryType.EQueryType.regular);
        return m_browseFunction;
    }

    @Override
    public FunctionsBrowse functionsBrowse(SchemaPath schemaPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaPath.parentCatalogName();
        String parentSchemaName = schemaPath.parentSchemaName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.functionsBrowse, parentCatalogName, parentSchemaName, null, queryType);
        return m_browseFunction;
    }

    @Override
    public ProceduresBrowse proceduresBrowse(SchemaPath schemaPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaPath.parentCatalogName();
        String parentSchemaName = schemaPath.parentSchemaName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.proceduresBrowse, parentCatalogName, parentSchemaName, null, queryType);
        return m_browseFunction;
    }

    @Override
    public SchemasBrowse schemasBrowse(SchemaParentPath schemaParentPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaParentPath.parentCatalogName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.schemasBrowse, parentCatalogName, null, null, queryType);
        return m_browseFunction;
    }

    @Override
    public SynonymsBrowse synonymsBrowse(SchemaPath schemaPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaPath.parentCatalogName();
        String parentSchemaName = schemaPath.parentSchemaName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.synonymsBrowse, parentCatalogName, parentSchemaName, null, queryType);
        return m_browseFunction;
    }

    @Override
    public SynonymColumnsBrowse synonymColumnsBrowse(ColumnParentPath columnParentPath) {
        String parentCatalogName = columnParentPath.parentCatalogName();
        String parentSchemaName = columnParentPath.parentSchemaName();
        String parentObjectName = columnParentPath.parentObjectName();
        SynonymColumnsBrowseFunction m_browseFunction = new SynonymColumnsBrowseFunction(parentCatalogName, parentSchemaName, parentObjectName);
        return m_browseFunction;
    }

    @Override
    public TablesBrowse tablesBrowse(SchemaPath schemaPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaPath.parentCatalogName();
        String parentSchemaName = schemaPath.parentSchemaName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.tablesBrowse, parentCatalogName, parentSchemaName, null, queryType);
        return m_browseFunction;
    }

    @Override
    public ViewsBrowse viewsBrowse(SchemaPath schemaPath, BrowseQueryType.EQueryType queryType) {
        String parentCatalogName = schemaPath.parentCatalogName();
        String parentSchemaName = schemaPath.parentSchemaName();
        BrowseFunction m_browseFunction = new BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType.viewsBrowse, parentCatalogName, parentSchemaName, null, queryType);
        return m_browseFunction;
    }

    @Override
    public BrowseMetadataRequest browseMetadataRequest(Element requestElem) {
        DataSourceElem dataSource = null;
        BrowseFunction browseFunction = null;
        Iterator elementIter = requestElem.elementIterator();
        while (elementIter.hasNext()) {
            Element element = (Element)elementIter.next();
            String tagName = element.getName();
            if ("metadataSource".equals(tagName)) {
                dataSource = new DataSourceElem(element);
                continue;
            }
            browseFunction = new BrowseFunction(element);
        }
        return this.browseMetadataRequest(browseFunction, dataSource);
    }

    @Override
    public BrowseMetadataRequest browseMetadataRequest(BrowseMetadataFunction browseFunction, MetadataSource dataSource) {
        return new BrowseRequest(browseFunction, dataSource);
    }

    @Override
    public void readBrowseMetadataResult(InputStream modelStream, BrowsedObjectHandler browsedObjectHandler) throws SAXException, IOException, ParserConfigurationException {
        BrowsedObjectsContentHandler browseResultContentHandler = new BrowsedObjectsContentHandler(browsedObjectHandler);
        XmlReader reader = new XmlReader(browseResultContentHandler);
        reader.read(modelStream);
        browsedObjectHandler.done();
    }

    @Override
    public ColumnParentPath columnParentPath(String schemaName, String tableViewName) {
        return new BrowseObjectPath(null, null, schemaName, tableViewName);
    }

    @Override
    public ColumnParentPath columnParentPath(String catalogName, String schemaName, String tableViewName) {
        return new BrowseObjectPath(null, catalogName, schemaName, tableViewName);
    }

    @Override
    public SchemaPath schemaParentPath() {
        return new BrowseObjectPath(null, null, null);
    }

    @Override
    public SchemaPath schemaParentPath(String catalogName) {
        return new BrowseObjectPath(null, catalogName, null, null);
    }

    @Override
    public ImportMetadataRequest importMetadataRequest(Element requestElem) {
        Element dataSourceElem = requestElem.element("metadataSource");
        DataSourceElem dataSource = new DataSourceElem(dataSourceElem);
        ObjectSelectionsDomFactory databaseObjectSelections = null;
        ImportFunctionChain extractionFunctionChain = new ImportFunctionChain();
        Iterator requestElementChildrenIter = requestElem.elementIterator();
        while (requestElementChildrenIter.hasNext()) {
            Element currentChildElem = (Element)requestElementChildrenIter.next();
            String tagName = currentChildElem.getName();
            if ("metadataObjectSelections".equals(tagName)) {
                databaseObjectSelections = new ObjectSelectionsDomFactory(currentChildElem);
                continue;
            }
            if ("metadataSource".equals(tagName)) {
                dataSource = new DataSourceElem(currentChildElem);
                continue;
            }
            ImportMetadataFunction.EImportFunctionType extractionFunctionType = ImportMetadataFunction.EImportFunctionType.valueOf(tagName);
            MetadataImportToolkit extractionApi = this.importToolkit();
            switch (extractionFunctionType) {
                case importTables: {
                    TablesImport tablesImport = extractionApi.tablesImport();
                    extractionFunctionChain.addTablesImport(tablesImport);
                    break;
                }
                case importViews: {
                    ViewsImport viewsImport = extractionApi.viewsImport();
                    extractionFunctionChain.addViewsImport(viewsImport);
                    break;
                }
                case importColumns: {
                    extractionFunctionChain.addColumnsImport(extractionApi.columnsImport());
                    break;
                }
                case importUniqueKeys: {
                    extractionFunctionChain.addUniqueKeysImport(extractionApi.uniqueKeysImport());
                    break;
                }
                case importForeignKeys: {
                    extractionFunctionChain.addForeignKeysImport(extractionApi.foreignKeysImport());
                    break;
                }
                case importSynonyms: {
                    extractionFunctionChain.addSynonymsImport(extractionApi.synonymsImport());
                    break;
                }
                case importIndexes: {
                    extractionFunctionChain.addIndexesImport(extractionApi.indexesImport());
                    break;
                }
                case importRoutines: {
                    extractionFunctionChain.addRoutinesImport(extractionApi.routinesImport());
                    break;
                }
                case importFunctions: {
                    extractionFunctionChain.addFunctionsImport(extractionApi.functionsImport());
                    break;
                }
                case importProcedures: {
                    extractionFunctionChain.addProceduresImport(extractionApi.proceduresImport());
                    break;
                }
                case importRoutineArguments: {
                    extractionFunctionChain.addRoutineArgumentsImport(extractionApi.routineArgumentsImport());
                    break;
                }
            }
        }
        return new ImportRequest(extractionFunctionChain, dataSource, databaseObjectSelections);
    }

    @Override
    public MetadataObjectSelections metadataObjectSelections() {
        return new SelectionsElem("metadataObjectSelections", new RelmdAttributeGroup());
    }

    @Override
    public MetadataSourceToolkit metadataSourceToolkit() {
        return this;
    }

    @Override
    public MetadataBrowseToolkit browseToolkit() {
        return this;
    }

    @Override
    public MetadataImportToolkit importToolkit() {
        return this;
    }

    @Override
    public MetadataObjectPathsToolkit objectPathsToolkit() {
        return this;
    }

    @Override
    public MetadataObjectSelectionsToolkit objectSelectionsToolkit() {
        return this;
    }

    @Override
    public MetadataSourceToolkit sourceToolkit() {
        return this;
    }

    @Override
    public MetadataLoader metadataLoader() {
        return new ModelBuilder();
    }

    @Override
    public MetadataToolkit metadataToolkit() {
        return this;
    }

    @Override
    public XmlApiToolkit xmlApiToolkit() {
        return this;
    }

    @Override
    public VendorToolkit vendorToolkit() {
        return this;
    }

    @Override
    public SessionQueryRules caseSensitivitySessionQueryRules(final CaseSensitivityRules.EStorage eStorage) {
        final CaseSensitivityRules caseSensitivity = new CaseSensitivityRules(){

            @Override
            public CaseSensitivityRules.EStorage storage() {
                return eStorage;
            }

            @Override
            public CaseSensitivityRules.EConversionType conversionType() {
                return CaseSensitivityRules.EConversionType.sql;
            }
        };
        SessionQueryRules databaseAccessRules = new SessionQueryRules(){

            @Override
            public CaseSensitivityRules caseSensitivityRules() {
                return caseSensitivity;
            }

            @Override
            public CatalogGranularityRules catalogGranularityRules() {
                return null;
            }

            @Override
            public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
                return null;
            }

            @Override
            public Boolean hasCatalogGranularityRules() {
                return null;
            }

            @Override
            public Boolean hasDefaultSchemaQueryRules() {
                return null;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public CodePageRules codePageRules() {
                return null;
            }
        };
        return databaseAccessRules;
    }

    @Override
    public DatabaseAccessRules caseSensitivityDatabaseAccessRules(final CaseSensitivity.EStorage eStorage) {
        DatabaseAccessRules databaseAccessRules = new DatabaseAccessRules(){

            @Override
            public CaseSensitivity caseSensitivity() {
                CaseSensitivity caseSensitivity = new CaseSensitivity(){

                    @Override
                    public CaseSensitivity.EStorage storage() {
                        return eStorage;
                    }
                };
                return caseSensitivity;
            }

            @Override
            public CatalogSetupRules catalogSetupRules() {
                return new CatalogSetupRules(){

                    @Override
                    public CatalogRetrieval catalogRetrieval() {
                        return null;
                    }

                    @Override
                    public CatalogSet catalogSet() {
                        return null;
                    }
                };
            }
        };
        return databaseAccessRules;
    }

    @Override
    public SessionToolkit sessionToolkit() {
        return this;
    }

    @Override
    public DefaultCatalogSchema defaultCatalogSchema(final String defaultCatalogRef, final String defaultSchemaRef) {
        DefaultCatalogSchema defaultCatalogSchema = new DefaultCatalogSchema(){

            @Override
            public String parentSchemaName() {
                return defaultSchemaRef;
            }

            @Override
            public boolean hasParentCatalog() {
                return null != defaultCatalogRef;
            }

            @Override
            public String parentCatalogName() {
                return defaultCatalogRef;
            }
        };
        return defaultCatalogSchema;
    }

    public Session session() {
        Session session = new Session(){

            @Override
            public ReferenceableSet<AccessibleCatalogRef> accessibleCatalogsSet() {
                return null;
            }

            @Override
            public DefaultCatalogSchema defaultCatalogSchema() {
                return null;
            }

            @Override
            public XmlElement asXml() {
                return new RelmdElement("session");
            }
        };
        return session;
    }

    @Override
    public VendorAccessConnection vendorAccessConnection(final Connection connection, final VendorAccessHandler vendorAccessHandler, final SessionQueryRules sessionQueryRules) {
        VendorAccessConnection vendorAccessConnection = new VendorAccessConnection(){

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return vendorAccessHandler;
            }

            @Override
            public DatabaseAccessHandler databaseAccessEventHandler() {
                VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
                DatabaseAccessHandler databaseAccessEventHandler = vendorToolkit.databaseAccessEventHandler(vendorAccessHandler);
                return databaseAccessEventHandler;
            }

            @Override
            public Connection jdbcConnection() {
                return connection;
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return sessionQueryRules;
            }

            @Override
            public DatabaseAccessRules databaseAccessRules() {
                return null;
            }

            @Override
            public Session session() {
                return null;
            }
        };
        return vendorAccessConnection;
    }

    @Override
    public SessionQueryToolkit sessionQueryToolkit() {
        RelmdToolkits relmdToolkits = new RelmdToolkits();
        return relmdToolkits;
    }

    @Override
    public AccessibleCatalogsQuery accessibleCatalogsQuery(CurrentCatalogSetup currentCatalogSetup, VendorAccessResults vendorAccess, Handler<AccessibleCatalogRef> accessibleCatalogRefHandler) {
        AccessibleCatalogsQueryRules accessibleCatalogsQueryRules;
        SqlServerAccessibleCatalogsQuery accessibleCatalogsQuery = null;
        CatalogGranularityRules catalogGranularityRules = currentCatalogSetup.catalogGranularityRules();
        if (null != catalogGranularityRules && null != (accessibleCatalogsQueryRules = catalogGranularityRules.accessibleCatalogsQueryRules())) {
            VendorAccessHandler vendorAccessHandler = vendorAccess.vendorAccessHandler();
            accessibleCatalogsQuery = new SqlServerAccessibleCatalogsQuery(accessibleCatalogsQueryRules, accessibleCatalogRefHandler, vendorAccessHandler, currentCatalogSetup);
        }
        return accessibleCatalogsQuery;
    }

    public SqlObjectQueryPath objectSearchPath(DatabaseAccessRules databaseAccessRules, final String catalog, final String schema, final String objectName) {
        SqlObjectQueryPath sqlObjectQueryPath = new SqlObjectQueryPath(){

            @Override
            public boolean catalogMissing() {
                return null == catalog;
            }

            @Override
            public boolean schemaMissing() {
                return null == schema;
            }

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SchemaPath schemaPath() {
                return new SchemaPath(){

                    @Override
                    public String parentSchemaName() {
                        return null;
                    }

                    @Override
                    public boolean hasParentCatalog() {
                        return false;
                    }

                    @Override
                    public String parentCatalogName() {
                        return null;
                    }
                };
            }

            @Override
            public String getTagName() {
                return null;
            }

            @Override
            public void add(XmlAttribute attribute) {
            }

            @Override
            public Collection<? extends XmlAttribute> attributes() {
                return null;
            }

            @Override
            public XmlAttribute getAttribute(String name) {
                return null;
            }

            @Override
            public Collection<? extends XmlElement> childElements() {
                return null;
            }
        };
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath(SessionQueryRules sessionQueryRules, SchemaPath schemaPath, String objectName) {
        String parentSchemaName = schemaPath.parentSchemaName();
        String parentCatalogName = schemaPath.parentCatalogName();
        SqlObjectQueryPath sqlObjectQueryPath = this.sqlObjectQueryPath(sessionQueryRules, parentCatalogName, parentSchemaName, objectName);
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath(SessionQueryRules sessionQueryRules, String catalogName, String schemaName, String objectName) {
        Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
        SqlObjectQueryPath sqlObjectQueryPath = this.sqlObjectQueryPath(catalogSupport, catalogName, schemaName, objectName);
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath(final Database.ECatalogSupport catalogSupport, final String parentCatalogName, final String parentSchemaName, String objectName) {
        SchemaPath schemaPathNew = new SchemaPath(){

            @Override
            public boolean hasParentCatalog() {
                boolean hasParentCatalog = Database.ECatalogSupport.catalogsSupported.equals((Object)catalogSupport) || parentCatalogName != null && !parentCatalogName.isEmpty();
                return hasParentCatalog;
            }

            @Override
            public String parentCatalogName() {
                return parentCatalogName;
            }

            @Override
            public String parentSchemaName() {
                return parentSchemaName;
            }
        };
        SqlObjectQueryPath sqlObjectQueryPath = this.sqlObjectQueryPath(schemaPathNew, objectName);
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath(final SchemaPath schemaPath, final String objectName) {
        final RelmdAttributeGroup attributes = new RelmdAttributeGroup();
        final boolean hasParentCatalog = schemaPath.hasParentCatalog();
        Relmd relmd = RelmdGateway.relmd();
        XmlApiToolkit xmlApiToolkit = relmd.xmlApiToolkit();
        final String parentCatalogName = schemaPath.parentCatalogName();
        if (hasParentCatalog) {
            XmlAttribute parentCatalogNameAttribute = xmlApiToolkit.attribute("parentCatalogName", parentCatalogName);
            attributes.add(parentCatalogNameAttribute);
        }
        final String parentSchemaName = schemaPath.parentSchemaName();
        XmlAttribute parentSchemaNameAttribute = xmlApiToolkit.attribute("parentSchemaName", parentSchemaName);
        attributes.add(parentSchemaNameAttribute);
        XmlAttribute sqlObjectNameAttribute = xmlApiToolkit.attribute("sqlObjectName", objectName);
        attributes.add(sqlObjectNameAttribute);
        SqlObjectQueryPath sqlObjectQueryPath = new SqlObjectQueryPath(){

            @Override
            public boolean catalogMissing() {
                return !hasParentCatalog || null == parentCatalogName || 0 == parentCatalogName.length();
            }

            @Override
            public boolean schemaMissing() {
                return null == parentSchemaName || 0 == parentSchemaName.length();
            }

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SchemaPath schemaPath() {
                return schemaPath;
            }

            @Override
            public String getTagName() {
                return "sqlObjectQueryPath";
            }

            @Override
            public void add(XmlAttribute attribute) {
            }

            @Override
            public Collection<? extends XmlAttribute> attributes() {
                return attributes.attributes();
            }

            @Override
            public XmlAttribute getAttribute(String name) {
                return attributes.getAttribute(name);
            }

            @Override
            public Collection<? extends XmlElement> childElements() {
                return null;
            }
        };
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectColumnsImport sqlObjectColumnsImport(SessionAccess sessionAccess, SqlObjectQueryPath objectSearchPath, SqlObjectColumnsImportRules sqlObjectColumnsImportRules, SqlObjectColumnsResults sqlObjectResults) {
        SqlObjectImportRules sqlObjectImportRules = sqlObjectColumnsImportRules.sqlObjectImportRules();
        SqlObjectImport sqlObjectImport = this.sqlObjectImport(sessionAccess, objectSearchPath, sqlObjectImportRules, sqlObjectResults);
        ColumnsImportRules columnsImportRules = sqlObjectColumnsImportRules.columnsImportRules();
        Handler<Column> columnHandler = sqlObjectResults.columnHandler();
        SqlObjectColumnsImportElem sqlObjectColumnsImportElem = new SqlObjectColumnsImportElem(sqlObjectImport, columnsImportRules, columnHandler);
        return sqlObjectColumnsImportElem;
    }

    @Override
    public SqlObjectImport sqlObjectImport(SessionAccess sessionAccess, SqlObjectQueryPath objectSearchPath, SqlObjectImportRules sqlObjectImportRules, SqlObjectResults sqlObjectResults) {
        SqlObjectImportElem sqlObjectImportElem = new SqlObjectImportElem(sessionAccess, sqlObjectImportRules, objectSearchPath, sqlObjectResults);
        return sqlObjectImportElem;
    }

    @Override
    @Deprecated
    public DatabaseAccessHandler databaseAccessEventHandler(final VendorAccessHandler vendorAccessHandler) {
        VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        final VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        DatabaseAccessHandler databaseAccessHandler = new DatabaseAccessHandler(){

            @Override
            public void executionError(String errorMsg) {
                Handler<ExecutionError> executionErrorHandler = vendorAccessHandler.executionErrorHandler();
                ExecutionError executionError = vendorAccessToolkit.executionError(errorMsg);
                executionErrorHandler.handle(executionError);
            }

            @Override
            public void jdbcApiPrepare(String jdbcMethodName, String[] params) {
                Handler<BeginJava> beginJavaHandler = vendorAccessHandler.beginJavaHandler();
                BeginJava beginJava = vendorAccessToolkit.beginJava(jdbcMethodName, params);
                beginJavaHandler.handle(beginJava);
            }

            @Override
            public void resultSetProcessingError(int recordIndex, String errorMsg) {
                Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = vendorAccessHandler.resultSetProcessingErrorHandler();
                ResultSetProcessingError resultSetProcessingError = vendorAccessToolkit.resultSetProcessingError(recordIndex, errorMsg);
                resultSetProcessingErrorHandler.handle(resultSetProcessingError);
            }

            @Override
            public void sqlPrepare(String sqlText) {
                Handler<BeginSql> beginSqlHandler = vendorAccessHandler.beginSqlHandler();
                BeginSql beginSql = vendorAccessToolkit.beginSql(sqlText);
                beginSqlHandler.handle(beginSql);
            }
        };
        return databaseAccessHandler;
    }

    @Override
    @Deprecated
    public VendorAccessHandler vendorAccessHandler(final DatabaseAccessHandler databaseAccessHandler) {
        VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        Handler<BeginSql> beginSqlHandler = new Handler<BeginSql>(){

            @Override
            public void handle(BeginSql obj) {
                String sqlText = obj.sqlText();
                databaseAccessHandler.sqlPrepare(sqlText);
            }
        };
        Handler<BeginJava> beginJavaHandler = new Handler<BeginJava>(){

            @Override
            public void handle(BeginJava obj) {
                String[] parameters = obj.parameters();
                String methodName = obj.methodName();
                databaseAccessHandler.jdbcApiPrepare(methodName, parameters);
            }
        };
        Handler<ExecutionInformation> executionInformationHandler = new Handler<ExecutionInformation>(){

            @Override
            public void handle(ExecutionInformation obj) {
                String message = obj.message();
                databaseAccessHandler.sqlPrepare(message);
            }
        };
        Handler<ExecutionError> executionErrorHandler = new Handler<ExecutionError>(){

            @Override
            public void handle(ExecutionError obj) {
                String errorMsg = obj.message();
                databaseAccessHandler.executionError(errorMsg);
            }
        };
        Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler = new Handler<ResultSetProcessingInformation>(){

            @Override
            public void handle(ResultSetProcessingInformation obj) {
                String message = obj.message();
                databaseAccessHandler.sqlPrepare(message);
            }
        };
        Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = new Handler<ResultSetProcessingError>(){

            @Override
            public void handle(ResultSetProcessingError obj) {
                int recordIndex = obj.rowNumber();
                String errorMsg = obj.message();
                databaseAccessHandler.resultSetProcessingError(recordIndex, errorMsg);
            }
        };
        VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        VendorAccessHandler vendorAccessHandler = vendorAccessToolkit.vendorAccessHandler(beginSqlHandler, beginJavaHandler, executionInformationHandler, executionErrorHandler, resultSetProcessingInformationHandler, resultSetProcessingErrorHandler);
        return vendorAccessHandler;
    }

    @Override
    public CatalogGranularityRules catalogGranularityRules(CatalogSetupRules catalogSetupRules) {
        CatalogGranularityRules catalogGranularityRules = null;
        if (null != catalogSetupRules) {
            CatalogRetrieval catalogRetrieval = catalogSetupRules.catalogRetrieval();
            final Sql catalogRetrievalSql = catalogRetrieval.sql();
            CatalogSet catalogSet = catalogSetupRules.catalogSet();
            final CatalogGrainSql catalogSetSql = catalogSet.catalogGrainSql();
            catalogGranularityRules = new CatalogGranularityRules(){

                @Override
                public CurrentCatalogRetrievalRules catalogRetrievalRules() {
                    CurrentCatalogRetrievalRules currentCatalogRetrievalRules = new CurrentCatalogRetrievalRules(){

                        @Override
                        public Sql sql() {
                            return catalogRetrievalSql;
                        }
                    };
                    return currentCatalogRetrievalRules;
                }

                @Override
                public CurrentCatalogSetRules catalogSetRules() {
                    CurrentCatalogSetRules currentCatalogSetRules = new CurrentCatalogSetRules(){

                        @Override
                        public CatalogGrainSql catalogGrainSql() {
                            return catalogSetSql;
                        }
                    };
                    return currentCatalogSetRules;
                }

                @Override
                public AccessibleCatalogsQueryRules accessibleCatalogsQueryRules() {
                    return null;
                }
            };
        }
        return catalogGranularityRules;
    }

    @Override
    public Session session(final DefaultCatalogSchema defaultCatalogSchema, final ReferenceableSet<AccessibleCatalogRef> accessibleCatalogsSet) {
        Session queriedSession = new Session(){

            @Override
            public ReferenceableSet<AccessibleCatalogRef> accessibleCatalogsSet() {
                return accessibleCatalogsSet;
            }

            @Override
            public DefaultCatalogSchema defaultCatalogSchema() {
                return defaultCatalogSchema;
            }

            @Override
            public XmlElement asXml() {
                return new RelmdElement("session");
            }
        };
        return queriedSession;
    }

    @Override
    public DefaultCatalogSchemaQuery defaultCatalogSchemaQuery(String userName, DefaultCatalogSchemaQueryRules defaultSchemaQueryRules, VendorAccessResults vendorAccess, Handler<DefaultCatalogSchema> defaultCatalogSchemaHandler) {
        VendorAccessHandler vendorAccessHandler = vendorAccess.vendorAccessHandler();
        DefaultCatalogSchemaQueryElem defaultCatalogSchemaQueryElem = new DefaultCatalogSchemaQueryElem(userName, defaultCatalogSchemaHandler, defaultSchemaQueryRules, vendorAccessHandler);
        return defaultCatalogSchemaQueryElem;
    }

    @Override
    public Catalog catalog(String catalogName) {
        CatalogElem catalog = new CatalogElem(catalogName, null);
        return catalog;
    }

    @Override
    public Schema schema(final String schemaName) {
        final ReferenceableSetElem tablesSet = new ReferenceableSetElem();
        final ReferenceableSetElem viewsSet = new ReferenceableSetElem();
        final ReferenceableSetElem synonymsSet = new ReferenceableSetElem();
        final ReferenceableSetElem proceduresSet = new ReferenceableSetElem();
        final ReferenceableSetElem functionsSet = new ReferenceableSetElem();
        return new Schema(){

            @Override
            public ReferenceableSet<StoredProcedure> storedProcedureSet() {
                return proceduresSet;
            }

            @Override
            public ReferenceableSet<Synonym> synonymsSet() {
                return synonymsSet;
            }

            @Override
            public ReferenceableSet<Table> tablesSet() {
                return tablesSet;
            }

            @Override
            public ReferenceableSet<UserDefinedFunction> userDefinedFunctionSet() {
                return functionsSet;
            }

            @Override
            public ReferenceableSet<View> viewsSet() {
                return viewsSet;
            }

            @Override
            public String objectName() {
                return schemaName;
            }

            @Override
            public XmlElement asXml() {
                return new RelmdElement("schema");
            }
        };
    }

    @Override
    public BeginSql beginSql(final String sqlText) {
        BeginSql beginSql = new BeginSql(){

            @Override
            public String sqlText() {
                return sqlText;
            }
        };
        return beginSql;
    }

    @Override
    public ExecutionError executionError(final String message) {
        ExecutionError executionError = new ExecutionError(){

            @Override
            public String message() {
                return message;
            }
        };
        return executionError;
    }

    @Override
    public BeginJava beginJava(final String methodName, final String[] params) {
        BeginJava beginJava = new BeginJava(){

            @Override
            public String methodName() {
                return methodName;
            }

            @Override
            public String[] parameters() {
                return params;
            }
        };
        return beginJava;
    }

    @Override
    public ExecutionInformation executionInformation(final String message) {
        ExecutionInformation executionInformation = new ExecutionInformation(){

            @Override
            public String message() {
                return message;
            }
        };
        return executionInformation;
    }

    @Override
    public ResultSetProcessingError resultSetProcessingError(final int rowNum, final String message) {
        ResultSetProcessingError resultSetProcessingError = new ResultSetProcessingError(){

            @Override
            public String message() {
                return message;
            }

            @Override
            public int rowNumber() {
                return rowNum;
            }
        };
        return resultSetProcessingError;
    }

    @Override
    public ResultSetProcessingInformation resultSetProcessingInformation(final int rowNum, final String message) {
        ResultSetProcessingInformation resultSetProcessingInformation = new ResultSetProcessingInformation(){

            @Override
            public String message() {
                return message;
            }

            @Override
            public int rowNumber() {
                return rowNum;
            }
        };
        return resultSetProcessingInformation;
    }

    @Override
    public VendorAccessHandler vendorAccessHandler(final Handler<BeginSql> beginSqlHandler, final Handler<BeginJava> beginJavaHandler, final Handler<ExecutionInformation> executionInformationHandler, final Handler<ExecutionError> executionErrorHandler, final Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler, final Handler<ResultSetProcessingError> resultSetProcessingErrorHandler) {
        VendorAccessHandler vendorAccessHandler = new VendorAccessHandler(){

            @Override
            public Handler<BeginJava> beginJavaHandler() {
                return beginJavaHandler;
            }

            @Override
            public Handler<BeginSql> beginSqlHandler() {
                return beginSqlHandler;
            }

            @Override
            public Handler<ExecutionError> executionErrorHandler() {
                return executionErrorHandler;
            }

            @Override
            public Handler<ExecutionInformation> executionInformationHandler() {
                return executionInformationHandler;
            }

            @Override
            public Handler<ResultSetProcessingError> resultSetProcessingErrorHandler() {
                return resultSetProcessingErrorHandler;
            }

            @Override
            public Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler() {
                return resultSetProcessingInformationHandler;
            }
        };
        return vendorAccessHandler;
    }

    @Override
    public SessionAccess sessionAccess(ConnectionParameters connectionParameters, final Session session, final SessionQueryRules sessionQueryRules, final VendorAccessResults vendorAccess) {
        final String userName = null == connectionParameters ? null : connectionParameters.userName();
        final String driverClass = null == connectionParameters ? null : connectionParameters.driverClass();
        final String jdbcConnectionString = null == connectionParameters ? null : connectionParameters.jdbcConnectionString();
        final Database.EVendorType vendorType = null == connectionParameters ? null : connectionParameters.vendorType();
        final Database.EVendorType rawVendorType = null == connectionParameters ? null : connectionParameters.rawVendorType();
        final String language = null == connectionParameters ? null : connectionParameters.language();
        final String password = null == connectionParameters ? null : connectionParameters.password();
        final String proxyPassword = null == connectionParameters ? null : connectionParameters.proxyPassword();
        final String proxyUserName = null == connectionParameters ? null : connectionParameters.proxyUserName();
        final ExtendedParameterLookup extendedParameterLookup = null == connectionParameters ? null : new ExtendedParameterLookup(){

            @Override
            public Object parameter(String parameterName) {
                return null;
            }
        };
        final JCAMImpersonator.DelegatedCredential credential = null == connectionParameters ? null : connectionParameters.getDelegatedCredential();
        final boolean isKerberos = null == connectionParameters ? false : connectionParameters.isKerberos();
        final boolean isIntegratedSecurity = null == connectionParameters ? false : connectionParameters.isIntegratedSecurity();
        final String cryptoHandle = null == connectionParameters ? null : connectionParameters.getCryptoHandle();
        final String contentLocale = null == connectionParameters ? null : connectionParameters.getContentLocale();
        final Properties properties = null == connectionParameters ? new Properties() : connectionParameters.getProperties();
        final OIDCCredentialsSignon oidcSignon = null != connectionParameters ? connectionParameters.getOIDCCredentialsSignon() : null;
        final ApiTokenSignon apiTokenSignon = null != connectionParameters ? connectionParameters.getApiTokenSignon() : null;
        SessionAccess sessionAccess = new SessionAccess(){
            private LinkedHashMap<String, XmlAttribute> m_attributes = new LinkedHashMap();

            @Override
            public String driverClass() {
                return driverClass;
            }

            @Override
            public String jdbcConnectionString() {
                return jdbcConnectionString;
            }

            @Override
            public Database.EVendorType vendorType() {
                return vendorType;
            }

            @Override
            public Database.EVendorType rawVendorType() {
                return rawVendorType;
            }

            @Override
            public String password() {
                return password;
            }

            @Override
            public String userName() {
                return userName;
            }

            @Override
            public Session session() {
                return session;
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return sessionQueryRules;
            }

            @Override
            public VendorAccessResults vendorAccessResults() {
                return vendorAccess;
            }

            @Override
            public String language() {
                return language;
            }

            @Override
            public ExtendedParameterLookup extendedParameterLookup() {
                return extendedParameterLookup;
            }

            @Override
            public String getTagName() {
                return "sessionAccess";
            }

            @Override
            public void add(XmlAttribute attribute) {
                this.m_attributes.put(attribute.getName(), attribute);
            }

            @Override
            public Collection<? extends XmlAttribute> attributes() {
                return this.m_attributes.values();
            }

            @Override
            public XmlAttribute getAttribute(String name) {
                return this.m_attributes.get(name);
            }

            @Override
            public Collection<? extends XmlElement> childElements() {
                return new ArrayList();
            }

            @Override
            public void setVendorType(Database.EVendorType vendorType2) {
            }

            @Override
            public void setRawVendorType(Database.EVendorType rawVendorType2) {
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public String proxyUserName() {
                return proxyUserName;
            }

            @Override
            public String proxyPassword() {
                return proxyPassword;
            }

            @Override
            public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
                return credential;
            }

            @Override
            public boolean isKerberos() {
                return isKerberos;
            }

            @Override
            public boolean isIntegratedSecurity() {
                return isIntegratedSecurity;
            }

            @Override
            public String getCryptoHandle() {
                return cryptoHandle;
            }

            @Override
            public String getContentLocale() {
                return contentLocale;
            }

            @Override
            public Properties getProperties() {
                return properties;
            }

            @Override
            public EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands() {
                return null;
            }

            @Override
            public OIDCCredentialsSignon getOIDCCredentialsSignon() {
                return oidcSignon;
            }

            @Override
            public ApiTokenSignon getApiTokenSignon() {
                return apiTokenSignon;
            }
        };
        XmlApiToolkit xmlApiToolkit = RelmdGateway.relmd().xmlApiToolkit();
        if (null != vendorType) {
            XmlAttribute vendorTypeAttribute = xmlApiToolkit.attribute("vendorType", vendorType.toString());
            sessionAccess.add(vendorTypeAttribute);
        }
        XmlAttribute jdbcConnectionStringAttribute = xmlApiToolkit.attribute("jdbcConnectionString", jdbcConnectionString);
        sessionAccess.add(jdbcConnectionStringAttribute);
        XmlAttribute userNameAttribute = xmlApiToolkit.attribute("userName", userName);
        sessionAccess.add(userNameAttribute);
        XmlAttribute driverClassAttribute = xmlApiToolkit.attribute("driverClass", driverClass);
        sessionAccess.add(driverClassAttribute);
        return sessionAccess;
    }

    @Override
    public VendorAccessResults vendorAccessResults(final VendorAccessHandler vendorAccessHandler) {
        VendorAccessResults vendorAccess = new VendorAccessResults(){

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return vendorAccessHandler;
            }
        };
        return vendorAccess;
    }

    @Override
    public Session queriedSession(String userName, Connection connection, SessionQueryRules sessionQueryRules, VendorAccessResults vendorAccess) {
        QueriedSession queriedSession = new QueriedSession(connection, sessionQueryRules, vendorAccess, userName);
        return queriedSession;
    }

    @Override
    public SessionAccessToolkit sessionAccessToolkit() {
        RelmdToolkits relmdToolkits = new RelmdToolkits();
        return relmdToolkits;
    }

    @Override
    public VendorAccessToolkit vendorAccessToolkit() {
        RelmdToolkits relmdToolkits = new RelmdToolkits();
        return relmdToolkits;
    }

    @Override
    public VendorConnectionToolkit vendorConnectionToolkit() {
        RelmdToolkits relmdToolkits = new RelmdToolkits();
        return relmdToolkits;
    }

    @Override
    public Connection connectToDatabase(ConnectionParameters connectionParameters) throws ClassNotFoundException, SQLException, SAXException, IOException, ParserConfigurationException {
        VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        VendorConnectionToolkit vendorConnectionToolkit = vendorToolkit.vendorConnectionToolkit();
        Connection connection = vendorConnectionToolkit.connection(connectionParameters);
        return connection;
    }

    @Override
    public VendorAccessSqlToolkit vendorAccessSqlToolkit() {
        return this;
    }

    @Override
    public Sql sql(final String sqlText) {
        Sql sql = new Sql(){

            @Override
            public String value() {
                return sqlText;
            }
        };
        return sql;
    }

    @Override
    public ObjectSelectionsInclusion objectSelectionInclusion(final String sqlFragment, final WhereClauseInsertionRule.EInsertLocation insertLocation, final WhereClauseInsertionRule.EInsertPrefix insertPrefix, String catalogExpression, String schemaExpression, String objectExpression, String columnExpression) {
        final ArrayList<ObjectSelectionsCondition> objectSelectionConditionList = new ArrayList<ObjectSelectionsCondition>();
        ObjectSelectionsCondition objectSelectionsCondition = this.objectSelectionsCondition(catalogExpression, schemaExpression, objectExpression, columnExpression);
        objectSelectionConditionList.add(objectSelectionsCondition);
        ObjectSelectionsInclusion objectSelectionsInclusion = new ObjectSelectionsInclusion(){

            @Override
            public Collection<ObjectSelectionsCondition> objectSelectionConditionCollection() {
                return objectSelectionConditionList;
            }

            @Override
            public WhereClauseInsertionRule.EInsertLocation getInsertLocation() {
                return insertLocation;
            }

            @Override
            public WhereClauseInsertionRule.EInsertPrefix getInsertPrefix() {
                return insertPrefix;
            }

            @Override
            public String getSqlFragment() {
                return sqlFragment;
            }
        };
        return objectSelectionsInclusion;
    }

    @Override
    public SessionQueryRules sessionQueryRules(final CaseSensitivityRules.EStorage storage) {
        final CaseSensitivityRules caseSensitivityRules = new CaseSensitivityRules(){

            @Override
            public CaseSensitivityRules.EStorage storage() {
                return storage;
            }

            @Override
            public CaseSensitivityRules.EConversionType conversionType() {
                return CaseSensitivityRules.EConversionType.sql;
            }
        };
        SessionQueryRules sessionQueryRules = new SessionQueryRules(){

            @Override
            public CaseSensitivityRules caseSensitivityRules() {
                return caseSensitivityRules;
            }

            @Override
            public CatalogGranularityRules catalogGranularityRules() {
                return null;
            }

            @Override
            public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
                return null;
            }

            @Override
            public Boolean hasCatalogGranularityRules() {
                return false;
            }

            @Override
            public Boolean hasDefaultSchemaQueryRules() {
                return false;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public CodePageRules codePageRules() {
                return null;
            }
        };
        return sessionQueryRules;
    }

    @Override
    public SqlFragment sqlFragment(final String conditionText) {
        SqlFragment sqlFragment = new SqlFragment(){

            @Override
            public String value() {
                return conditionText;
            }
        };
        return sqlFragment;
    }

    @Override
    public ObjectSelectionsCondition objectSelectionsCondition(final String catalogExpression, final String schemaExpression, final String objectExpression, final String columnExpression) {
        ObjectSelectionsCondition objectSelectionsCondition = new ObjectSelectionsCondition(){

            @Override
            public String catalogExpression() {
                return catalogExpression;
            }

            @Override
            public String objectExpression() {
                return objectExpression;
            }

            @Override
            public String schemaExpression() {
                return schemaExpression;
            }

            @Override
            public String columnExpression() {
                return columnExpression;
            }

            @Override
            public String getTagName() {
                return null;
            }

            @Override
            public void add(XmlAttribute attribute) {
            }

            @Override
            public Collection<? extends XmlAttribute> attributes() {
                return null;
            }

            @Override
            public XmlAttribute getAttribute(String name) {
                return null;
            }

            @Override
            public Collection<? extends XmlElement> childElements() {
                return null;
            }
        };
        return objectSelectionsCondition;
    }

    @Override
    public ParentCatalogSchema parentCatalogSchema(final String catalog, final String schema) {
        ParentCatalogSchema parentCatalogSchema = new ParentCatalogSchema(){
            final boolean hasParentCatalogRef;
            final String catalogName;
            {
                this.hasParentCatalogRef = null != catalog && 0 < catalog.length();
                this.catalogName = this.hasParentCatalogRef ? catalog : null;
            }

            @Override
            public Boolean hasParentCatalogRef() {
                return this.hasParentCatalogRef;
            }

            @Override
            public String parentCatalogRef() {
                return this.catalogName;
            }

            @Override
            public String parentSchemaRef() {
                return schema;
            }

            @Override
            public String parentSchemaName() {
                return schema;
            }

            @Override
            public boolean hasParentCatalog() {
                return this.hasParentCatalogRef;
            }

            @Override
            public String parentCatalogName() {
                return this.catalogName;
            }
        };
        return parentCatalogSchema;
    }

    @Override
    public ColumnContainerObjectRef columnContainerObjectRef(SchemaLevelObjectRef obj) {
        final String objectName = obj.objectName();
        ColumnContainerObjectRef columnContainerObjectRef = new ColumnContainerObjectRef(){

            @Override
            public String objectName() {
                return objectName;
            }
        };
        return columnContainerObjectRef;
    }

    @Override
    public SchemaPath schemaPath(AccessibleCatalogRef obj) {
        final String catalogName = obj.objectName();
        final String defaultSchemaRef = obj.defaultSchemaRef();
        SchemaPath schemaPath = new SchemaPath(){

            @Override
            public String parentSchemaName() {
                return defaultSchemaRef;
            }

            @Override
            public boolean hasParentCatalog() {
                return true;
            }

            @Override
            public String parentCatalogName() {
                return catalogName;
            }
        };
        return schemaPath;
    }

    @Override
    public void addSchemaObject(SchemaSelection schemaSelection, String objectName) {
        RelmdToolkits objectSelectionsToolkit = this;
        TableSelection tableSelection = objectSelectionsToolkit.tableSelection(objectName);
        ViewSelection viewSelection = objectSelectionsToolkit.viewSelection(objectName);
        ProcedureSelection procedureSelection = objectSelectionsToolkit.procedureSelection(objectName);
        FunctionSelection functionSelection = objectSelectionsToolkit.functionSelection(objectName);
        SynonymSelection synonymSelection = objectSelectionsToolkit.synonymSelection(objectName);
        schemaSelection.tableSelections().selectedObjects().add(tableSelection);
        schemaSelection.viewSelections().selectedObjects().add(viewSelection);
        schemaSelection.synonymSelections().selectedObjects().add(synonymSelection);
        schemaSelection.procedureSelections().selectedObjects().add(procedureSelection);
        schemaSelection.functionSelections().selectedObjects().add(functionSelection);
    }

    @Override
    public Referenceable referenceable(final String objectName) {
        Referenceable referenceable = new Referenceable(){
            private String m_objectName;
            {
                this.m_objectName = objectName;
            }

            @Override
            public String objectName() {
                return this.m_objectName;
            }
        };
        return referenceable;
    }

    @Override
    public SqlFragment listDelimiter(Locale locale) {
        return VendorAccessSqlToolkit.SQLFRAGMENT_COMMA_DELIMITER;
    }

    @Override
    public SqlFragment sqlFragmentLeadingSpace(String sqlText) {
        final String value = null != sqlText && 0 < sqlText.length() ? " " + sqlText : "";
        SqlFragment sqlFragment = new SqlFragment(){

            @Override
            public String value() {
                return value;
            }
        };
        return sqlFragment;
    }

    @Override
    public SqlFragment sqlFragmentSurroundingSpaces(String sqlText) {
        final String value = null != sqlText && 0 < sqlText.length() ? " " + sqlText + " " : "";
        SqlFragment sqlFragment = new SqlFragment(){

            @Override
            public String value() {
                return value;
            }
        };
        return sqlFragment;
    }

    @Override
    public CatalogSelection catalogSelection(AccessibleCatalogRef obj) {
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataObjectSelectionsToolkit objectSelectionsToolkit = metadataToolkit.objectSelectionsToolkit();
        String catalogName = obj.objectName();
        CatalogSelection catalogSelection = objectSelectionsToolkit.catalogSelection(catalogName);
        String defaultSchemaRef = obj.defaultSchemaRef();
        SchemaSelection schemaSelection = objectSelectionsToolkit.schemaSelection(defaultSchemaRef);
        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = catalogSelection.schemaSelections();
        ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
        selectedSchemas.add(schemaSelection);
        return catalogSelection;
    }

    @Override
    public SqlFragmentConcatenationRules sqlFragmentConcatenationRules(final SqlFragment listDelimiter, final SqlFragment leading, final SqlFragment trailing) {
        SqlFragmentConcatenationRules sqlFragmentConcatenationRules = new SqlFragmentConcatenationRules(){

            @Override
            public SqlFragment delimiter() {
                return listDelimiter;
            }

            @Override
            public SqlFragment leading() {
                return leading;
            }

            @Override
            public SqlFragment trailing() {
                return trailing;
            }
        };
        return sqlFragmentConcatenationRules;
    }

    @Override
    public SqlFragmentConcatenationRules sqlFragmentConcatenationRulesDelimitedOnly(SqlFragment listDelimiter) {
        SqlFragmentConcatenationRules sqlFragmentConcatenationRules = this.sqlFragmentConcatenationRules(listDelimiter, null, null);
        return sqlFragmentConcatenationRules;
    }

    @Override
    public SqlFragmentConcatenationRules sqlFragmentConcatenationRulesSurroundingOnly(SqlFragment leading, SqlFragment trailing) {
        SqlFragmentConcatenationRules sqlFragmentConcatenationRules = this.sqlFragmentConcatenationRules(null, leading, trailing);
        return sqlFragmentConcatenationRules;
    }

    @Override
    public SessionAccess sessionAccess(final VendorAccessConnection relmdConnection) {
        Relmd relmd = RelmdGateway.relmd();
        VendorToolkit vendorToolkit = relmd.vendorToolkit();
        SessionQueryRules sessionQueryRules = relmdConnection.sessionQueryRules();
        if (null == sessionQueryRules) {
            DatabaseAccessRules databaseAccessRules = relmdConnection.databaseAccessRules();
            sessionQueryRules = vendorToolkit.sessionQueryRules(databaseAccessRules);
        }
        VendorAccessResults vendorAccessResults = new VendorAccessResults(){
            private VendorAccessHandler m_vendorAccessHandler;
            {
                this.m_vendorAccessHandler = relmdConnection.vendorAccessHandler();
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return this.m_vendorAccessHandler;
            }
        };
        Session session = this.session();
        SessionAccess sessionAccess = this.sessionAccess(null, session, sessionQueryRules, vendorAccessResults);
        return sessionAccess;
    }

    @Override
    public Handler<SchemaPath> contextHandler(final ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        Handler<SchemaPath> handler = new Handler<SchemaPath>(){
            private String m_prevCatalog = null;
            private String m_prevSchema = null;
            boolean catalogEquals = false;

            @Override
            public void handle(SchemaPath obj) {
                if (null != parentCatalogSchemaHandler) {
                    if (obj.hasParentCatalog()) {
                        String parentCatalogName = obj.parentCatalogName();
                        this.catalogEquals = parentCatalogName.equals(this.m_prevCatalog);
                        if (!this.catalogEquals) {
                            parentCatalogSchemaHandler.handleParentCatalogReference(parentCatalogName);
                            this.m_prevCatalog = parentCatalogName;
                        }
                    }
                    String parentSchemaName = obj.parentSchemaName();
                    if (!this.catalogEquals || !this.m_prevSchema.equals(parentSchemaName)) {
                        parentCatalogSchemaHandler.handleParentSchemaReference(parentSchemaName);
                    }
                    this.m_prevSchema = parentSchemaName;
                }
            }
        };
        return handler;
    }

    @Override
    public TableView tableView(final Table table) {
        TableView tableView = new TableView(){

            @Override
            public TableView.EChoice choice() {
                return TableView.EChoice.table;
            }

            @Override
            public Table table() {
                return table;
            }

            @Override
            public View view() {
                return null;
            }
        };
        return tableView;
    }

    @Override
    public TableView tableView(final View view) {
        TableView tableView = new TableView(){

            @Override
            public TableView.EChoice choice() {
                return TableView.EChoice.view;
            }

            @Override
            public Table table() {
                return null;
            }

            @Override
            public View view() {
                return view;
            }
        };
        return tableView;
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice(final MetadataObjectSelections objectSelections) {
        MetadataImportSelectionsChoice objectSelectionsChoice = new MetadataImportSelectionsChoice(){
            private MetadataImportSelectionsChoice.EChoice m_choice = MetadataImportSelectionsChoice.EChoice.metadataObjectSelections;
            private MetadataObjectSelections m_objectSelections = objectSelections;

            @Override
            public MetadataImportSelectionsChoice.EChoice choice() {
                return this.m_choice;
            }

            @Override
            public MetadataObjectSelections metadataObjectSelections() {
                return this.m_objectSelections;
            }

            @Override
            public SqlObjectQueryPath sqlObjectQueryPath() {
                return null;
            }
        };
        return objectSelectionsChoice;
    }

    @Override
    public ColumnsImport columnsImport(SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, ColumnsImportRules importRules, Handler<Catalog> catalogHandler, Handler<Schema> schemaHandler, Handler<ColumnContainerObjectRef> columnContainerObjectRefHandler, Handler<Column> columnHandler) {
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataObjectPathsToolkit objectPathsToolkit = metadataToolkit.objectPathsToolkit();
        Handler<SchemaPath> schemaPathHandler = objectPathsToolkit.schemaPathHandler(catalogHandler, schemaHandler);
        ColumnsImportElem importFunction = new ColumnsImportElem(sessionAccess, metadataImportSelectionsChoice, importRules, columnHandler, columnContainerObjectRefHandler, schemaPathHandler);
        return importFunction;
    }

    @Override
    public ImportFunction<Synonym, SchemaPath> synonymsImport(SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, SynonymsImportRules importRules, Handler<Catalog> catalogHandler, Handler<Schema> schemaHandler, Handler<Synonym> synonymHandler) {
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataObjectPathsToolkit objectPathsToolkit = metadataToolkit.objectPathsToolkit();
        Handler<SchemaPath> schemaPathHandler = objectPathsToolkit.schemaPathHandler(catalogHandler, schemaHandler);
        SynonymsImportElem importFunction = new SynonymsImportElem(sessionAccess, metadataImportSelectionsChoice, importRules, schemaPathHandler, synonymHandler);
        return importFunction;
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice(final SqlObjectQueryPath sqlObjectQueryPath) {
        MetadataImportSelectionsChoice metadataImportSelectionsChoice = new MetadataImportSelectionsChoice(){

            @Override
            public MetadataImportSelectionsChoice.EChoice choice() {
                return MetadataImportSelectionsChoice.EChoice.sqlObjectQueryPath;
            }

            @Override
            public MetadataObjectSelections metadataObjectSelections() {
                return null;
            }

            @Override
            public SqlObjectQueryPath sqlObjectQueryPath() {
                return sqlObjectQueryPath;
            }
        };
        return metadataImportSelectionsChoice;
    }

    @Override
    public ColumnContainerObjectRef columnContainerObjectRef(TableView obj) {
        ColumnContainer columnContainerObjectRef = null;
        TableView.EChoice choice = obj.choice();
        switch (choice) {
            case table: {
                columnContainerObjectRef = obj.table();
                break;
            }
            case view: {
                columnContainerObjectRef = obj.view();
            }
        }
        return columnContainerObjectRef;
    }

    @Override
    public ColumnContainerObjectRef columnContainerObjectRef(SchemaObjectPath obj) {
        final String objectName = obj.objectName();
        ColumnContainerObjectRef columnContainerObjectRef = new ColumnContainerObjectRef(){

            @Override
            public String objectName() {
                return objectName;
            }
        };
        return columnContainerObjectRef;
    }

    public SqlObjectPath sqlObjectPath(final SchemaPath catalogSchema, final String objectName) {
        SqlObjectPath sqlObjectPath = new SqlObjectPath(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SchemaPath schemaPath() {
                return catalogSchema;
            }
        };
        return sqlObjectPath;
    }

    @Override
    public Handler<SchemaPath> schemaPathHandler(final Handler<Catalog> catalogHandler, final Handler<Schema> schemaHandler) {
        Relmd relmd = RelmdGateway.relmd();
        final MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        Handler<SchemaPath> handler = new Handler<SchemaPath>(){
            private String m_prevCatalog = null;

            @Override
            public void handle(SchemaPath obj) {
                boolean catalogEquals;
                String parentCatalogName = obj.parentCatalogName();
                boolean bl = catalogEquals = this.m_prevCatalog != null && (parentCatalogName == null || this.m_prevCatalog.equals(parentCatalogName));
                if (!catalogEquals && null != parentCatalogName) {
                    Catalog catalog = metadataToolkit.catalog(parentCatalogName);
                    catalogHandler.handle(catalog);
                }
                this.m_prevCatalog = parentCatalogName;
                String schemaName = obj.parentSchemaName();
                Schema schema = metadataToolkit.schema(schemaName);
                schemaHandler.handle(schema);
            }
        };
        return handler;
    }

    @Override
    public Handler<TableView> tableViewHandler(final Handler<Table> tableHandler, final Handler<View> viewHandler) {
        Handler<TableView> handler = new Handler<TableView>(){

            @Override
            public void handle(TableView obj) {
                TableView.EChoice choice = obj.choice();
                switch (choice) {
                    case table: {
                        Table table = obj.table();
                        tableHandler.handle(table);
                        break;
                    }
                    case view: {
                        View view = obj.view();
                        viewHandler.handle(view);
                    }
                }
            }
        };
        return handler;
    }

    public SqlObjectPath sqlObjectPath(Database.ECatalogSupport eCatalogSupport, Catalog parentCatalog, Schema parentSchema, Referenceable objectRef) {
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataObjectPathsToolkit objectPathsToolkit = metadataToolkit.metadataObjectPathsToolkit();
        SchemaPath schemaPath = objectPathsToolkit.schemaPath(eCatalogSupport, parentCatalog, parentSchema);
        SqlObjectPath sqlObjectPath = objectPathsToolkit.sqlObjectPath(schemaPath, objectRef);
        return sqlObjectPath;
    }

    @Override
    public CurrentCatalogSetup currentCatalogSetup(CatalogGranularityRules catalogGranularityRules, String catalog, VendorAccessHandler vendorAccessHandler) {
        CurrentCatalogSetupElem currentCatalogSetupElem = new CurrentCatalogSetupElem(catalogGranularityRules, catalog, vendorAccessHandler);
        return currentCatalogSetupElem;
    }

    @Override
    public boolean match(SchemaPath schemaPath1, SchemaPath schemaPath2) {
        boolean match = true;
        String parentCatalogName = schemaPath1.parentCatalogName();
        String parentSchemaName = schemaPath1.parentSchemaName();
        if (schemaPath1.hasParentCatalog()) {
            match = null == parentCatalogName || 0 == parentCatalogName.length() ? null == schemaPath2.parentCatalogName() || 0 == schemaPath2.parentCatalogName().length() : parentCatalogName.equals(schemaPath2.parentCatalogName());
        }
        if (match) {
            match = null == parentSchemaName || 0 == parentSchemaName.length() ? null == schemaPath2.parentSchemaName() || 0 == schemaPath2.parentSchemaName().length() : parentSchemaName.equals(schemaPath2.parentSchemaName());
        }
        return match;
    }

    @Override
    public MetadataBrowseToolkit metadataBrowseToolkit() {
        return this;
    }

    @Override
    public MetadataImportToolkit metadataImportToolkit() {
        return this;
    }

    @Override
    public MetadataObjectPathsToolkit metadataObjectPathsToolkit() {
        return this;
    }

    @Override
    public MetadataObjectSelectionsToolkit metadataObjectSelectionsToolkit() {
        return this;
    }

    @Override
    public MetadataSqlColumnConversionToolkit metadataSqlColumnConversionToolkit() {
        return this;
    }

    @Override
    public MetadataXmlToolkit metadataXmlToolkit() {
        return this;
    }

    @Override
    public SchemaPath schemaPath(String catalogName, String schemaName) {
        Database.ECatalogSupport catalogSupport = null == catalogName || 0 == catalogName.length() ? Database.ECatalogSupport.catalogsNotSupported : Database.ECatalogSupport.catalogsSupported;
        SchemaPath schemaPath = this.schemaPath(catalogSupport, catalogName, schemaName);
        return schemaPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath(VendorRules vendorRules, String catalog, String schema, String objectName) {
        SessionQueryRules sessionQueryRules = vendorRules.sessionQueryRules();
        Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
        SqlObjectQueryPath sqlObjectQueryPath = this.sqlObjectQueryPath(catalogSupport, catalog, schema, objectName);
        return sqlObjectQueryPath;
    }

    @Override
    public VendorAccess vendorAccess(final VendorAccessHandler vendorAccessHandler) {
        VendorAccess vendorAccess = new VendorAccess(){

            @Override
            public VendorAccessRule.EGranularity getGranularity() {
                return null;
            }

            @Override
            public VendorAccessResultSet run(Connection connection, SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
                return null;
            }

            @Override
            public VendorAccessResultSet run(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
                return null;
            }

            @Override
            public VendorAccessResultSet runCatalogLevel(VendorAccessConnection relmdConnection, String parentCatalogName) {
                return null;
            }

            @Override
            public VendorAccessResultSet runDatabaseLevel(VendorAccessConnection relmdConnection) {
                return null;
            }

            @Override
            public VendorAccessResultSet runObjectLevel(VendorAccessConnection relmdConnection, String parentCatalogName, String parentSchemaName, String parentObjectName) {
                return null;
            }

            @Override
            public VendorAccessResultSet runSchemaLevel(VendorAccessConnection relmdConnection, String parentCatalogName, String parentSchemaName) {
                return null;
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return vendorAccessHandler;
            }

            @Override
            public VendorAccessResultSet runGeneric(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
                return null;
            }
        };
        return vendorAccess;
    }

    @Override
    public SchemaPath schemaPath(Database.ECatalogSupport catalogSupport, Referenceable parentCatalogRef, Referenceable parentSchemaRef) {
        String catalog = null == parentCatalogRef ? null : parentCatalogRef.objectName();
        String schema = null == parentSchemaRef ? null : parentSchemaRef.objectName();
        SchemaPath schemaPath = this.schemaPath(catalogSupport, catalog, schema);
        return schemaPath;
    }

    @Override
    public SqlObjectPath sqlObjectPath(final SchemaPath catalogSchema, Referenceable objectRef) {
        final String objectName = null == objectRef ? null : objectRef.objectName();
        SqlObjectPath sqlObjectPath = new SqlObjectPath(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SchemaPath schemaPath() {
                return catalogSchema;
            }
        };
        return sqlObjectPath;
    }

    @Override
    public SessionAccess sessionAccess(Connection connection, ConnectionParameters connectionParameters, SessionQueryRules sessionQueryRules, VendorAccessResults vendorAccessResults) {
        String userName = connectionParameters.userName();
        QueriedSession queriedSession = new QueriedSession(connection, sessionQueryRules, vendorAccessResults, userName);
        return this.sessionAccess(connectionParameters, queriedSession, sessionQueryRules, vendorAccessResults);
    }

    @Override
    public Map<String, String> dataSourceConnectionPropertyMap(String dataSourceConnectionString) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return linkedHashMap;
    }

    @Override
    public SqlFragment sqlFragment(Referenceable ref) {
        String objectName;
        SqlFragment fragment = null;
        if (null != ref && null != (objectName = ref.objectName()) && 0 < objectName.length()) {
            fragment = this.sqlFragment(objectName);
        }
        return fragment;
    }

    @Override
    public TablesImport tablesImport() {
        return new TablesImportElem();
    }

    @Override
    public ViewsImport viewsImport() {
        return new ViewsImportElem();
    }

    @Override
    public FunctionsImport functionsImport() {
        return new FunctionsImportElem();
    }

    @Override
    public ProceduresImport proceduresImport() {
        return new ProceduresImportElem();
    }

    public Table table(final String tableName) {
        final ReferenceableSetElem columns = new ReferenceableSetElem();
        final ReferenceableSetElem tableParameters = new ReferenceableSetElem();
        final ArrayList indexes = new ArrayList();
        final ReferenceableSetElem uniqueKeys = new ReferenceableSetElem();
        final ArrayList foreignKeys = new ArrayList();
        final ArrayList aliases = new ArrayList();
        Table table = new Table(){

            @Override
            public String objectName() {
                return tableName;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public ReferenceableSet<Column> columnsSet() {
                return columns;
            }

            @Override
            public ReferenceableSet<TableParameter> tableParametersSet() {
                return tableParameters;
            }

            @Override
            public Collection<ForeignKey> foreignKeysCollection() {
                return foreignKeys;
            }

            @Override
            public Collection<Index> indexesCollection() {
                return indexes;
            }

            @Override
            public ReferenceableSet<UniqueKey> uniqueKeysSet() {
                return uniqueKeys;
            }

            @Override
            public Collection<String> aliasCollection() {
                return aliases;
            }

            @Override
            public Collection<String> getAliasCollection() {
                return aliases;
            }

            @Override
            public XmlElement asXml() {
                RelmdElement relmdElement = new RelmdElement("table");
                return relmdElement;
            }
        };
        return table;
    }

    @Override
    public View view(final String viewName) {
        final ReferenceableSetElem columns = new ReferenceableSetElem();
        final ReferenceableSetElem tableParameters = new ReferenceableSetElem();
        final ArrayList aliases = new ArrayList();
        View view = new View(){

            @Override
            public String objectName() {
                return viewName;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public ReferenceableSet<Column> columnsSet() {
                return columns;
            }

            @Override
            public ReferenceableSet<TableParameter> tableParametersSet() {
                return tableParameters;
            }

            @Override
            public Collection<String> aliasCollection() {
                return aliases;
            }

            @Override
            public Collection<String> getAliasCollection() {
                return aliases;
            }

            @Override
            public XmlElement asXml() {
                RelmdElement relmdElement = new RelmdElement("table");
                return relmdElement;
            }
        };
        return view;
    }

    public ExternalSchemaReference externalSchemaReference(String synonymTargetExternalHost, SchemaPath schemaPath) {
        final boolean hasParentCatalog = schemaPath.hasParentCatalog();
        final String externalServerRef = synonymTargetExternalHost;
        final String parentCatalogName = hasParentCatalog ? schemaPath.parentCatalogName() : null;
        final String parentSchemaName = schemaPath.parentSchemaName();
        ExternalSchemaReference externalSchemaReference = new ExternalSchemaReference(){

            @Override
            public String externalCatalogRef() {
                return parentCatalogName;
            }

            @Override
            public String externalSchemaRef() {
                return parentSchemaName;
            }

            @Override
            public String externalServerRef() {
                return externalServerRef;
            }

            @Override
            public Boolean hasExternalCatalogRef() {
                return hasParentCatalog;
            }

            @Override
            public Boolean hasExternalSchemaRef() {
                return null != parentSchemaName && 0 < parentSchemaName.length();
            }

            @Override
            public Boolean hasExternalServerRef() {
                return null != externalServerRef && 0 < externalServerRef.length();
            }
        };
        return externalSchemaReference;
    }

    @Override
    public SqlObject sqlObject(Referenceable objectRef, final SqlObject.EType type) {
        final String objectName = objectRef.objectName();
        SqlObject sqlObject = new SqlObject(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public SqlObject.EType sqlObjectType() {
                return type;
            }
        };
        return sqlObject;
    }

    @Override
    public Synonym synonym(Referenceable refName, final SynonymTarget synonymTarget) {
        final String objectName = refName.objectName();
        final RelmdElement relmdElement = new RelmdElement("synonym");
        final ArrayList aliasCollection = new ArrayList();
        Synonym synonym = new Synonym(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public Boolean hasTargetType() {
                return synonymTarget.hasTargetType();
            }

            @Override
            public String targetRef() {
                return synonymTarget.targetRef();
            }

            @Override
            public SqlObject.EType targetType() {
                return synonymTarget.targetType();
            }

            @Override
            public String externalServerRef() {
                return synonymTarget.externalServerRef();
            }

            @Override
            public String externalCatalogRef() {
                return synonymTarget.externalCatalogRef();
            }

            @Override
            public String externalSchemaRef() {
                return synonymTarget.externalSchemaRef();
            }

            @Override
            public Boolean hasExternalCatalogRef() {
                return synonymTarget.hasExternalCatalogRef();
            }

            @Override
            public Boolean hasExternalSchemaRef() {
                return synonymTarget.hasExternalSchemaRef();
            }

            @Override
            public Boolean hasExternalServerRef() {
                return synonymTarget.hasExternalServerRef();
            }

            @Override
            public XmlElement asXml() {
                return relmdElement;
            }

            @Override
            public Collection<String> aliasCollection() {
                return aliasCollection;
            }

            @Override
            public Collection<String> getAliasCollection() {
                return null;
            }
        };
        return synonym;
    }

    @Override
    public SynonymTarget synonymTarget(final ExternalSchemaReference externalSchemaReference, final SqlObject targetSqlObject) {
        SynonymTarget synonymTarget = new SynonymTarget(){

            @Override
            public Boolean hasTargetType() {
                return null != targetSqlObject;
            }

            @Override
            public String targetRef() {
                return targetSqlObject.objectName();
            }

            @Override
            public SqlObject.EType targetType() {
                return targetSqlObject.sqlObjectType();
            }

            @Override
            public String externalServerRef() {
                return externalSchemaReference.externalServerRef();
            }

            @Override
            public String externalCatalogRef() {
                return externalSchemaReference.externalCatalogRef();
            }

            @Override
            public String externalSchemaRef() {
                return externalSchemaReference.externalSchemaRef();
            }

            @Override
            public Boolean hasExternalCatalogRef() {
                return externalSchemaReference.hasExternalCatalogRef();
            }

            @Override
            public Boolean hasExternalSchemaRef() {
                return externalSchemaReference.hasExternalSchemaRef();
            }

            @Override
            public Boolean hasExternalServerRef() {
                return externalSchemaReference.hasExternalServerRef();
            }
        };
        return synonymTarget;
    }

    @Override
    public Table table(Referenceable tableNameRef) {
        final String objectName = tableNameRef.objectName();
        final ReferenceableSetElem columns = new ReferenceableSetElem();
        final ReferenceableSetElem tableParameters = new ReferenceableSetElem();
        final ArrayList indexes = new ArrayList();
        final ReferenceableSetElem uniqueKeys = new ReferenceableSetElem();
        final ArrayList foreignKeys = new ArrayList();
        final ArrayList aliases = new ArrayList();
        final RelmdElement relmdElement = new RelmdElement("table");
        Table table = new Table(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public ReferenceableSet<Column> columnsSet() {
                return columns;
            }

            @Override
            public ReferenceableSet<TableParameter> tableParametersSet() {
                return tableParameters;
            }

            @Override
            public Collection<ForeignKey> foreignKeysCollection() {
                return foreignKeys;
            }

            @Override
            public Collection<Index> indexesCollection() {
                return indexes;
            }

            @Override
            public ReferenceableSet<UniqueKey> uniqueKeysSet() {
                return uniqueKeys;
            }

            @Override
            public Collection<String> aliasCollection() {
                return aliases;
            }

            @Override
            public Collection<String> getAliasCollection() {
                return aliases;
            }

            @Override
            public XmlElement asXml() {
                return relmdElement;
            }
        };
        return table;
    }

    @Override
    public View view(Referenceable viewNameRef) {
        final String objectName = viewNameRef.objectName();
        final ReferenceableSetElem columns = new ReferenceableSetElem();
        final ReferenceableSetElem tableParameters = new ReferenceableSetElem();
        final ArrayList aliases = new ArrayList();
        final RelmdElement relmdElement = new RelmdElement("view");
        View view = new View(){

            @Override
            public String objectName() {
                return objectName;
            }

            @Override
            public String description() {
                return null;
            }

            @Override
            public ReferenceableSet<Column> columnsSet() {
                return columns;
            }

            @Override
            public ReferenceableSet<TableParameter> tableParametersSet() {
                return tableParameters;
            }

            @Override
            public Collection<String> aliasCollection() {
                return aliases;
            }

            @Override
            public Collection<String> getAliasCollection() {
                return aliases;
            }

            @Override
            public XmlElement asXml() {
                return relmdElement;
            }
        };
        return view;
    }

    public Referenceable referenceable(DatabaseObjectIndexes databaseObjectIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        int nameRecordIndex = databaseObjectIndexes.nameRecordIndex();
        String objectName = resultSetValueRetrieval.stringValue(nameRecordIndex);
        Referenceable referenceable = this.referenceable(objectName);
        return referenceable;
    }

    @Override
    public SchemaPath schemaPath(SchemaChildIndexes schemaIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        int parentCatalogNameRecordIndex = schemaIndexes.parentCatalogNameRecordIndex();
        String parentCatalogName = resultSetValueRetrieval.stringValue(parentCatalogNameRecordIndex);
        int parentSchemaNameRecordIndex = schemaIndexes.parentSchemaNameRecordIndex();
        String parentSchemaName = resultSetValueRetrieval.stringValue(parentSchemaNameRecordIndex);
        Database.ECatalogSupport catalogSupport = schemaIndexes.catalogSupport();
        SchemaPath schemaPath = this.schemaPath(catalogSupport, parentCatalogName, parentSchemaName);
        return schemaPath;
    }

    @Override
    public SchemaPath schemaPath(RefSchemaIndexes schemaIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        int refCatalogNameRecordIndex = schemaIndexes.refCatalogNameRecordIndex();
        String parentCatalogName = resultSetValueRetrieval.stringValue(refCatalogNameRecordIndex);
        int refSchemaNameRecordIndex = schemaIndexes.refSchemaNameRecordIndex();
        String parentSchemaName = resultSetValueRetrieval.stringValue(refSchemaNameRecordIndex);
        Database.ECatalogSupport catalogSupport = schemaIndexes.catalogSupport();
        SchemaPath schemaPath = this.schemaPath(catalogSupport, parentCatalogName, parentSchemaName);
        return schemaPath;
    }

    @Override
    public ExternalSchemaReference externalSchemaReference(RefExternalSchemaIndexes refExternalSchemaIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        int externalHostRefIndex = refExternalSchemaIndexes.externalHostRefIndex();
        String synonymTargetExternalHost = resultSetValueRetrieval.stringValue(externalHostRefIndex);
        SchemaPath schemaPath = this.schemaPath(refExternalSchemaIndexes, resultSetValueRetrieval);
        ExternalSchemaReference externalSchemaReference = this.externalSchemaReference(synonymTargetExternalHost, schemaPath);
        return externalSchemaReference;
    }

    @Override
    public Synonym synonym(DatabaseObjectIndexes databaseObjectIndexes, RefSynonymTargetIndexes refSynonymTargetIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        Referenceable referenceable = this.referenceable(databaseObjectIndexes, resultSetValueRetrieval);
        SynonymTarget target = this.synonymTarget(refSynonymTargetIndexes, resultSetValueRetrieval);
        Synonym synonym = this.synonym(referenceable, target);
        return synonym;
    }

    @Override
    public SynonymTarget synonymTarget(RefSynonymTargetIndexes refSynonymTargetIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        ExternalSchemaReference externalSchemaReference = this.externalSchemaReference(refSynonymTargetIndexes, resultSetValueRetrieval);
        SqlObjectIndexes sqlObjectIndexes = refSynonymTargetIndexes.refTargetObjectIndexes();
        SqlObject targetSqlObject = this.sqlObject(sqlObjectIndexes, resultSetValueRetrieval);
        SynonymTarget synonymTarget = this.synonymTarget(externalSchemaReference, targetSqlObject);
        return synonymTarget;
    }

    @Override
    public SqlObject sqlObject(SqlObjectIndexes sqlObjectIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        return this.sqlObject(sqlObjectIndexes, resultSetValueRetrieval, null);
    }

    @Override
    public SqlObject sqlObject(SqlObjectIndexes sqlObjectIndexes, VendorAccessResultSetValues resultSetValueRetrieval, DatabaseMetaData databaseMetaData) {
        String typeCode;
        Referenceable referenceable = this.referenceable(sqlObjectIndexes, resultSetValueRetrieval);
        int objectTypeIndex = sqlObjectIndexes.sqlObjectTypeIndex();
        String string = typeCode = 0 <= objectTypeIndex ? resultSetValueRetrieval.stringValue(objectTypeIndex) : null;
        if (databaseMetaData != null && databaseMetaData instanceof IAdaptorDBMetadata) {
            typeCode = ((IAdaptorDBMetadata)databaseMetaData).getEffectiveTableType(typeCode);
        }
        SqlObject.EType type = this.sqlObjectType(typeCode);
        SqlObject sqlObject = this.sqlObject(referenceable, type);
        return sqlObject;
    }

    @Override
    public SqlObject.EType sqlObjectType(String typeCode) {
        SqlObject.EType type = null;
        if (null != typeCode) {
            if (typeCode.equals("SYSTEM TABLE")) {
                type = SqlObject.EType.table;
            } else if (typeCode.equals("SYSTEM VIEW")) {
                type = SqlObject.EType.view;
            } else if (typeCode.startsWith("T")) {
                type = SqlObject.EType.table;
            } else if (typeCode.startsWith("V")) {
                type = SqlObject.EType.view;
            } else if (typeCode.startsWith("S") || typeCode.startsWith("A")) {
                type = SqlObject.EType.synonym;
            }
        }
        return type;
    }

    @Override
    public Catalog catalog(Referenceable catalogRef) {
        String objectName = catalogRef.objectName();
        Catalog catalog = this.catalog(objectName);
        return catalog;
    }

    @Override
    public Schema schema(Referenceable schemaRef) {
        String schemaName = schemaRef.objectName();
        Schema schema = this.schema(schemaName);
        return schema;
    }

    @Override
    public ExternalSchemaReference resolvedExternalSchemaReference(ExternalSchemaReference externalSchemaReference, SchemaPath parentSchemaPath) {
        final String externalHostRef = externalSchemaReference.externalServerRef();
        String externalCatalogRef = externalSchemaReference.externalCatalogRef();
        Boolean hasExternalCatalogRef = externalSchemaReference.hasExternalCatalogRef();
        String parentCatalogName = parentSchemaPath.parentCatalogName();
        final String resolvedExternalCatalogRef = hasExternalCatalogRef.booleanValue() ? (!parentCatalogName.equals(externalCatalogRef) ? externalCatalogRef : null) : null;
        String externalSchemaRef = externalSchemaReference.externalSchemaRef();
        Boolean hasExternalSchemaRef = externalSchemaReference.hasExternalSchemaRef();
        String parentSchemaName = parentSchemaPath.parentSchemaName();
        final String resolvedExternalSchemaRef = hasExternalSchemaRef.booleanValue() ? (!parentSchemaName.equals(externalSchemaRef) ? externalSchemaRef : null) : null;
        ExternalSchemaReference resolvedExternalSchemaReference = new ExternalSchemaReference(){

            @Override
            public String externalCatalogRef() {
                return resolvedExternalCatalogRef;
            }

            @Override
            public String externalSchemaRef() {
                return resolvedExternalSchemaRef;
            }

            @Override
            public String externalServerRef() {
                return externalHostRef;
            }

            @Override
            public Boolean hasExternalCatalogRef() {
                return null != resolvedExternalCatalogRef;
            }

            @Override
            public Boolean hasExternalSchemaRef() {
                return null != resolvedExternalSchemaRef;
            }

            @Override
            public Boolean hasExternalServerRef() {
                return null != externalHostRef;
            }
        };
        return resolvedExternalSchemaReference;
    }

    @Override
    public Synonym synonym(SchemaPath schemaPath, DatabaseObjectIndexes databaseObjectIndexes, RefSynonymTargetIndexes refSynonymTargetIndexes, VendorAccessResultSetValues resultSetValueRetrieval) {
        ExternalSchemaReference externalSchemaReference = this.externalSchemaReference(refSynonymTargetIndexes, resultSetValueRetrieval);
        ExternalSchemaReference resolvedExternalSchemaReference = this.resolvedExternalSchemaReference(externalSchemaReference, schemaPath);
        SqlObjectIndexes refTargetObjectIndexes = refSynonymTargetIndexes.refTargetObjectIndexes();
        SqlObject targetSqlObject = this.sqlObject(refTargetObjectIndexes, resultSetValueRetrieval);
        SynonymTarget synonymTarget = this.synonymTarget(resolvedExternalSchemaReference, targetSqlObject);
        Referenceable synonymName = this.referenceable(databaseObjectIndexes, resultSetValueRetrieval);
        Synonym synonym = this.synonym(synonymName, synonymTarget);
        return synonym;
    }

    @Override
    public XmlAttribute attribute(final String name, final String value) {
        XmlAttribute xmlAttribute = new XmlAttribute(){
            private String m_value;
            {
                this.m_value = value;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getValue() {
                return this.m_value;
            }

            @Override
            public void setValue(String newValue) {
                this.m_value = value;
            }

            @Override
            public void write(Writer m_writer, String nsPrefix) throws IOException {
            }
        };
        return xmlAttribute;
    }

    @Override
    public CaseSensitivityRules caseSensitivityRules(CaseSensitivityRules.EStorage storage) {
        CaseSensitivityRules caseSensitivityRules = this.caseSensitivityRules(storage, CaseSensitivityRules.EConversionType.sql);
        return caseSensitivityRules;
    }

    @Override
    public CaseSensitivityRules caseSensitivityRules(final CaseSensitivityRules.EStorage storage, final CaseSensitivityRules.EConversionType conversionConjunction) {
        CaseSensitivityRules caseSensitivityRules = new CaseSensitivityRules(){

            @Override
            public CaseSensitivityRules.EConversionType conversionType() {
                return conversionConjunction;
            }

            @Override
            public CaseSensitivityRules.EStorage storage() {
                return storage;
            }
        };
        return caseSensitivityRules;
    }

    @Override
    public SessionQueryRules sessionQueryRules(final DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules, final CaseSensitivityRules caseSensitivityRules, final Database.ECatalogSupport catalogSupport, final CatalogGranularityRules catalogGranularityRules) {
        SessionQueryRules sessionQueryRules = new SessionQueryRules(){

            @Override
            public CaseSensitivityRules caseSensitivityRules() {
                return caseSensitivityRules;
            }

            @Override
            public CatalogGranularityRules catalogGranularityRules() {
                return catalogGranularityRules;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return catalogSupport;
            }

            @Override
            public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
                return defaultCatalogSchemaQueryRules;
            }

            @Override
            public Boolean hasCatalogGranularityRules() {
                return null != catalogGranularityRules;
            }

            @Override
            public Boolean hasDefaultSchemaQueryRules() {
                return null != defaultCatalogSchemaQueryRules;
            }

            @Override
            public CodePageRules codePageRules() {
                return null;
            }
        };
        return sessionQueryRules;
    }

    @Override
    public MetadataSource dataSource(String dataSourceName) {
        return new DataSourceElem(dataSourceName);
    }

    @Override
    public CodePageRules.ECodePage codePageRules() {
        return null;
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, String jdbcConnectionString, String driverClass, String userName, String password) {
        return this.connectionParameters(vendorType, rawVendorType, jdbcConnectionString, driverClass, userName, password, new Properties());
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, Database.ECatalogSupport catalogSupport, String jdbcConnectionString, String driverClass, String userName, String password, ExtendedParameterLookup lookup, String language) {
        return this.connectionParameters(vendorType, rawVendorType, catalogSupport, jdbcConnectionString, driverClass, userName, password, lookup, language, new Properties());
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, String jdbcConnectionString, String driverClass, String userName, String password, ExtendedParameterLookup lookup, String language, JCAMImpersonator.DelegatedCredential credential, boolean isKerberos, boolean isIntegratedSecurity, String cryptoHandle, String contentLocale, OIDCCredentialsSignon oidcSignon, ApiTokenSignon apiTokenSignon) {
        return this.connectionParameters(vendorType, rawVendorType, jdbcConnectionString, driverClass, userName, password, lookup, language, credential, isKerberos, isIntegratedSecurity, cryptoHandle, contentLocale, oidcSignon, apiTokenSignon, new Properties());
    }

    @Override
    public ConnectionParameters connectionParameters(Database.EVendorType vendorType, Database.EVendorType rawVendorType, String jdbcConnectionString, String driverClass, String userName, String password, ExtendedParameterLookup lookup, String language) {
        return this.connectionParameters(vendorType, rawVendorType, jdbcConnectionString, driverClass, userName, password, lookup, language, new Properties());
    }

    private static void checkLoadLocation(Driver theDriver) {
        String jar;
        Class<?> theClass = theDriver.getClass();
        String className = theClass.getName();
        URL resource = theClass.getResource("/" + className.replace('.', '/') + ".class");
        if (!(resource == null || !(jar = resource.toString()).contains("v5dataserver") && !jar.contains("p2pd/WEB-INF/lib") || className.contains("TWCDriver") || className.contains("AutoRESTDriver") || className.contains("SFDCDriver"))) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidDriverLocation);
        }
    }

    static {
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.unknown.toString(), SqlColumnConversion.CCLDataType.unknown.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.unsupported.toString(), SqlColumnConversion.CCLDataType.unknown.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.character.toString(), SqlColumnConversion.CCLDataType.string.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.characterLength16.toString(), SqlColumnConversion.CCLDataType.string.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.characterLength32.toString(), SqlColumnConversion.CCLDataType.string.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.int16.toString(), SqlColumnConversion.CCLDataType.int16.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.int32.toString(), SqlColumnConversion.CCLDataType.int32.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.int64.toString(), SqlColumnConversion.CCLDataType.int64.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.decimal.toString(), SqlColumnConversion.CCLDataType.decimal.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.float_.toString(), SqlColumnConversion.CCLDataType.float_.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.float32.toString(), SqlColumnConversion.CCLDataType.float_.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.float64.toString(), SqlColumnConversion.CCLDataType.double_.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.binary.toString(), SqlColumnConversion.CCLDataType.binary.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.binaryLength16.toString(), SqlColumnConversion.CCLDataType.varBinary.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.databaseKey.toString(), SqlColumnConversion.CCLDataType.binary.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.blob.toString(), SqlColumnConversion.CCLDataType.blob.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.textBlob.toString(), SqlColumnConversion.CCLDataType.textBlob.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.timeTZ.toString(), SqlColumnConversion.CCLDataType.timeTz.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.timeStampTZ.toString(), SqlColumnConversion.CCLDataType.timeStampTZ.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.intervalYM.toString(), SqlColumnConversion.CCLDataType.ymInterval.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.nChar.toString(), SqlColumnConversion.CCLDataType.nChar.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.nVarChar.toString(), SqlColumnConversion.CCLDataType.nVarChar.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.numeric.toString(), SqlColumnConversion.CCLDataType.numeric.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.date.toString(), SqlColumnConversion.CCLDataType.date2.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.time.toString(), SqlColumnConversion.CCLDataType.time2.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.dateTime.toString(), SqlColumnConversion.CCLDataType.timestamp2.toString());
        m_fmToCCLDataTypeMap.put(FMColumnRule.FMDataType.timeInterval.toString(), SqlColumnConversion.CCLDataType.interval2.toString());
    }

    public static class LocalRelmdConfiguration
    extends Configuration {
        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String arg0) {
            String loginModuleClass = null;
            HashMap<String, String> map = new HashMap<String, String>();
            if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
                loginModuleClass = "com.ibm.security.auth.module.Krb5LoginModule";
                map.put("useDefaultCcache", "false");
            } else {
                loginModuleClass = "com.sun.security.auth.module.Krb5LoginModule";
                map.put("useTicketCache", "false");
            }
            AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map);
            return new AppConfigurationEntry[]{entry};
        }
    }
}

