/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class AxisRequestHeaderBuilder {
    private BiBusHeader m_axisHeader = new BiBusHeader();

    public AxisRequestHeaderBuilder(BIBusEnvelope clientEnvelope) {
        AxisRequestHeaderBuilder.copyCAMToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyCAFToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyCookiesToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copySetCookiesToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyPrefsToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyEnvironmentVarsToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyFormFieldVarsToService(clientEnvelope, this.m_axisHeader);
        AxisRequestHeaderBuilder.copyUserCapabilitiesCache(clientEnvelope, this.m_axisHeader);
    }

    private static boolean hasTextChild(Node aNode) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return false;
        }
        String txt = aNode.getText();
        return txt != null && txt.length() > 0;
    }

    private static void copyUserCapabilitiesCache(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element userCapabilities = clientEnvelope.getUserCapabilitiesCache();
        if (userCapabilities != null) {
            List listCapabilities = userCapabilities.selectNodes("userCapabilities/item");
            if (listCapabilities.size() == 0) {
                return;
            }
            UserCapabilityEnum[] eCapabilities = new UserCapabilityEnum[listCapabilities.size()];
            for (int idx = 0; idx < listCapabilities.size(); ++idx) {
                Node anItem = (Node)listCapabilities.get(idx);
                if (!AxisRequestHeaderBuilder.hasTextChild(anItem)) continue;
                eCapabilities[idx] = UserCapabilityEnum.fromValue((String)((Element)anItem).getTextTrim());
            }
            UserCapabilityCache myCache = new UserCapabilityCache();
            myCache.setUserCapabilities(eCapabilities);
            bibus.setUserCapabilityCache(myCache);
        }
    }

    private static void copyEnvironmentVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element envVars = clientEnvelope.getEnvironmentVars();
        if (envVars != null) {
            EnvironmentVar[] cVars = new EnvironmentVar[envVars.elements("item").size()];
            Iterator itEnvVars = envVars.elementIterator("item");
            int iEnvVarCount = 0;
            while (itEnvVars.hasNext()) {
                EnvironmentVar envVar = new EnvironmentVar();
                Element eEnvVarNode = (Element)itEnvVars.next();
                Element eEnvVarName = eEnvVarNode.element("name");
                Element eEnvVarValue = eEnvVarNode.element("value");
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eEnvVarName)) {
                    envVar.setName(eEnvVarName.getTextTrim());
                }
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eEnvVarValue)) {
                    envVar.setValue(eEnvVarValue.getTextTrim());
                }
                cVars[iEnvVarCount] = envVar;
                ++iEnvVarCount;
            }
            if (bibus.getHdrSession() == null) {
                bibus.setHdrSession(new HdrSession());
            }
            bibus.getHdrSession().setEnvironmentVars(cVars);
        }
    }

    private static void copyFormFieldVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element formFieldVars = clientEnvelope.getFormFieldVars();
        if (formFieldVars != null) {
            FormFieldVar[] cVars = new FormFieldVar[formFieldVars.elements("item").size()];
            Iterator itFormFieldVars = formFieldVars.elementIterator("item");
            int iFormFieldVarCount = 0;
            while (itFormFieldVars.hasNext()) {
                FormFieldVar formFieldVar = new FormFieldVar();
                Element eFormFieldVarNode = (Element)itFormFieldVars.next();
                Element eFormFieldVarName = eFormFieldVarNode.element("name");
                Element eFormFieldVarValue = eFormFieldVarNode.element("value");
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eFormFieldVarName)) {
                    formFieldVar.setName(eFormFieldVarName.getTextTrim());
                }
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eFormFieldVarValue)) {
                    formFieldVar.setValue(eFormFieldVarValue.getTextTrim());
                }
                formFieldVar.setFormat(FormatEnum.not_encrypted);
                cVars[iFormFieldVarCount] = formFieldVar;
                ++iFormFieldVarCount;
            }
            if (bibus.getHdrSession() == null) {
                bibus.setHdrSession(new HdrSession());
            }
            bibus.getHdrSession().setFormFieldVars(cVars);
        }
    }

    private static void copyPrefsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element eUserPrefs = clientEnvelope.getUserPreferenceVars();
        UserPreferenceVar[] uPrefs = new UserPreferenceVar[eUserPrefs.elements("item").size()];
        Iterator it = eUserPrefs.elementIterator("item");
        int iCount = 0;
        while (it.hasNext()) {
            UserPreferenceVar uVar = new UserPreferenceVar();
            Element eNode = (Element)it.next();
            Element eName = eNode.element("name");
            Element eValue = eNode.element("value");
            if (AxisRequestHeaderBuilder.hasTextChild((Node)eName)) {
                uVar.setName(eName.getText());
            }
            if (AxisRequestHeaderBuilder.hasTextChild((Node)eValue)) {
                uVar.setValue(eValue.getText());
            }
            uPrefs[iCount] = uVar;
            ++iCount;
        }
        bibus.setUserPreferenceVars(uPrefs);
    }

    private static void copySetCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element eCookieVars = clientEnvelope.getSetCookieVars();
        if (eCookieVars != null) {
            SetCookieVar[] cVars = new SetCookieVar[eCookieVars.elements("item").size()];
            Iterator itCookies = eCookieVars.elementIterator("item");
            int iCookieCount = 0;
            while (itCookies.hasNext()) {
                SetCookieVar cCookie = new SetCookieVar();
                Element eCookieNode = (Element)itCookies.next();
                Element eCookieName = eCookieNode.element("name");
                Element eCookieValue = eCookieNode.element("value");
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eCookieName)) {
                    cCookie.setName(eCookieName.getTextTrim());
                }
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eCookieValue)) {
                    cCookie.setValue(eCookieValue.getTextTrim());
                }
                cVars[iCookieCount] = cCookie;
                ++iCookieCount;
            }
            if (bibus.getHdrSession() == null) {
                bibus.setHdrSession(new HdrSession());
            }
            bibus.getHdrSession().setSetCookieVars(cVars);
        }
    }

    private static void copyCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element eCookieVars = clientEnvelope.getCookieVars();
        if (eCookieVars != null) {
            CookieVar[] cVars = new CookieVar[eCookieVars.elements("item").size()];
            Iterator itCookies = eCookieVars.elementIterator("item");
            int iCookieCount = 0;
            while (itCookies.hasNext()) {
                CookieVar cCookie = new CookieVar();
                Element eCookieNode = (Element)itCookies.next();
                Element eCookieName = eCookieNode.element("name");
                Element eCookieValue = eCookieNode.element("value");
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eCookieName)) {
                    cCookie.setName(eCookieName.getTextTrim());
                }
                if (AxisRequestHeaderBuilder.hasTextChild((Node)eCookieValue)) {
                    cCookie.setValue(eCookieValue.getTextTrim());
                }
                cVars[iCookieCount] = cCookie;
                ++iCookieCount;
            }
            if (bibus.getHdrSession() == null) {
                bibus.setHdrSession(new HdrSession());
            }
            bibus.getHdrSession().setCookieVars(cVars);
        }
    }

    private static void copyCAFToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        CAF caf = bibus.getCAF();
        if (caf == null) {
            caf = new CAF();
            bibus.setCAF(caf);
        }
        String secureState = clientEnvelope.getCAFSecureState();
        caf.setSecureState(secureState);
    }

    private static void copyCAMToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        CAMPassport cPassport;
        CAM cSecurity = bibus.getCAM();
        if (cSecurity == null) {
            cSecurity = new CAM();
            bibus.setCAM(cSecurity);
        }
        if (null == (cPassport = cSecurity.getCAMPassport())) {
            cPassport = new CAMPassport();
        }
        cPassport.setId(clientEnvelope.getPassportID());
        Element logEnabled = null;
        Element generation = null;
        Element canCallLogon = null;
        Element isAnoymous = null;
        Element cam = clientEnvelope.getCAM();
        Element camPassport = cam.element("CAMPassport");
        if (camPassport != null) {
            logEnabled = camPassport.element("logEnabled");
            generation = camPassport.element("generation");
            canCallLogon = camPassport.element("canCallLogon");
            isAnoymous = camPassport.element("isAnonymous");
        }
        if (logEnabled != null) {
            cPassport.setLogEnabled(Boolean.parseBoolean(logEnabled.getText()));
        }
        if (generation != null) {
            try {
                cPassport.setGeneration(Integer.parseInt(generation.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (canCallLogon != null) {
            cPassport.setCanCallLogon(Boolean.parseBoolean(canCallLogon.getText()));
        }
        if (isAnoymous != null) {
            cPassport.setIsAnonymous(Boolean.parseBoolean(isAnoymous.getText()));
        }
        cSecurity.setCAMPassport(cPassport);
        if (cSecurity.getException() != null) {
            cSecurity.setException(null);
        }
        try {
            Node userSessionID;
            Node CAMCredentialPath;
            Node securityBlob;
            cSecurity.setAction(clientEnvelope.getCAMAction());
            Node authencityToken = clientEnvelope.getCAM().selectSingleNode("./authenticityToken");
            if (AxisRequestHeaderBuilder.hasTextChild(authencityToken)) {
                cSecurity.setAuthenticityToken(authencityToken.getText().getBytes("UTF8"));
            }
            if (AxisRequestHeaderBuilder.hasTextChild(securityBlob = clientEnvelope.getCAM().selectSingleNode("./securityBlob"))) {
                cSecurity.setSecurityBlob(securityBlob.getText().getBytes("UTF8"));
            }
            if (AxisRequestHeaderBuilder.hasTextChild(CAMCredentialPath = clientEnvelope.getCAM().selectSingleNode("./CAMCredentialPath"))) {
                cSecurity.setCAMCredentialPath(CAMCredentialPath.getText());
            }
            if (AxisRequestHeaderBuilder.hasTextChild(userSessionID = clientEnvelope.getCAM().selectSingleNode("./userSessionID"))) {
                cSecurity.setUserSessionID(userSessionID.getText().getBytes("UTF8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public BiBusHeader getAxisHeader() {
        return this.m_axisHeader;
    }
}

