/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_Service;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.client.Stub;

public class RelmdCmServiceLocator
implements ContentManagerService_Service {
    private BiBusHeader m_bibusHeader = null;
    private ContentManagerService_ServiceLocator m_serviceLocator;
    private URL m_dispatcherURL;

    public RelmdCmServiceLocator(String contentLocale, String productLocale, String namespace, String user, String password, ICCLConfiguration configuration) throws MalformedURLException, ServiceException, CCLConfigurationException {
        configuration.init();
        String value = configuration.getValue("internalDispatcher", false);
        this.m_dispatcherURL = new URL(value);
        this.m_bibusHeader = new BiBusHeader();
        CAM cam = new CAM();
        if (!(namespace == null || "".equals(namespace) || user == null || "".equals(user) || password == null || "".equals(password))) {
            cam.setAction("logonAs");
            HdrSession hdrSession = new HdrSession();
            FormFieldVar[] vars = new FormFieldVar[3];
            vars[0] = new FormFieldVar();
            vars[0].setName("CAMNamespace");
            vars[0].setFormat(FormatEnum.not_encrypted);
            vars[0].setValue(namespace);
            vars[1] = new FormFieldVar();
            vars[1].setName("CAMUsername");
            vars[1].setValue(user);
            vars[1].setFormat(FormatEnum.not_encrypted);
            vars[2] = new FormFieldVar();
            vars[2].setName("CAMPassword");
            vars[2].setValue(password);
            vars[2].setFormat(FormatEnum.not_encrypted);
            hdrSession.setFormFieldVars(vars);
            this.m_bibusHeader.setHdrSession(hdrSession);
        } else {
            cam.setAction("logon");
        }
        this.m_bibusHeader.setCAM(cam);
        this.addUserPreferences(this.m_bibusHeader, productLocale, contentLocale);
        this.m_serviceLocator = new ContentManagerService_ServiceLocator();
    }

    public RelmdCmServiceLocator(String contentLocale, String productLocale, BiBusHeader bibusHeader, ICCLConfiguration configuration) throws MalformedURLException, ServiceException, CCLConfigurationException {
        configuration.init();
        this.m_bibusHeader = bibusHeader;
        String value = configuration.getValue("internalDispatcher", false);
        this.m_dispatcherURL = new URL(value);
        this.addUserPreferences(this.m_bibusHeader, productLocale, contentLocale);
        this.m_serviceLocator = new ContentManagerService_ServiceLocator();
    }

    private void addUserPreferences(BiBusHeader header, String productLocale, String contentLocale) {
        UserPreferenceVar[] userPrefs = new UserPreferenceVar[2];
        userPrefs[0] = new UserPreferenceVar();
        userPrefs[0].setName("contentLocale");
        userPrefs[0].setValue(contentLocale);
        userPrefs[1] = new UserPreferenceVar();
        userPrefs[1].setName("productLocale");
        userPrefs[1].setValue(productLocale);
        header.setUserPreferenceVars(userPrefs);
    }

    public ContentManagerService_PortType getcontentManagerService() throws ServiceException {
        return this.getcontentManagerService(this.m_dispatcherURL);
    }

    public ContentManagerService_PortType getcontentManagerService(URL portAddress) throws ServiceException {
        ContentManagerService_PortType port = this.m_serviceLocator.getcontentManagerService(portAddress);
        ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)this.m_bibusHeader);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    public String getcontentManagerServiceAddress() {
        return this.m_serviceLocator.getcontentManagerServiceAddress();
    }

    public Call createCall() throws ServiceException {
        return this.m_serviceLocator.createCall();
    }

    public Call createCall(QName arg0) throws ServiceException {
        return this.m_serviceLocator.createCall(arg0);
    }

    public Call createCall(QName arg0, QName arg1) throws ServiceException {
        return this.m_serviceLocator.createCall(arg0, arg1);
    }

    public Call createCall(QName arg0, String arg1) throws ServiceException {
        return this.m_serviceLocator.createCall(arg0, arg1);
    }

    public Call[] getCalls(QName arg0) throws ServiceException {
        return this.m_serviceLocator.getCalls(arg0);
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.m_serviceLocator.getHandlerRegistry();
    }

    public Remote getPort(Class arg0) throws ServiceException {
        return this.m_serviceLocator.getPort(arg0);
    }

    public Remote getPort(QName arg0, Class arg1) throws ServiceException {
        return this.m_serviceLocator.getPort(arg0, arg1);
    }

    public Iterator getPorts() throws ServiceException {
        return this.m_serviceLocator.getPorts();
    }

    public QName getServiceName() {
        return this.m_serviceLocator.getServiceName();
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.m_serviceLocator.getTypeMappingRegistry();
    }

    public URL getWSDLDocumentLocation() {
        return this.m_serviceLocator.getWSDLDocumentLocation();
    }
}

