/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.internal.relmd.bibus.AsyncResponseHelper;
import com.ibm.cognos.internal.relmd.bibus.AxisRequestHeaderBuilder;
import com.ibm.cognos.internal.relmd.bibus.IMetadataRequest;
import com.ibm.cognos.internal.relmd.bibus.I_ServiceCallback;
import com.ibm.cognos.internal.relmd.bibus.RelmdCmServiceLocator;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.RelmdFault;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLogger;
import com.ibm.cognos.internal.relmd.dataSource.ConnectionParametersQuery;
import com.ibm.cognos.internal.relmd.dataSource.ValueDecryption;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseRules;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataRequest;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.xmlapi.IWriteableAsXml;
import com.ibm.cognos.relmd.xmlapi.XmlApiToolkit;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class RelmdServiceConnection
implements IConnection {
    private RelmdLogger m_logUtil = null;
    private final ICCLConfiguration m_config;
    private final ValueDecryption m_valueDecrypter;
    private final VendorAccessHandler m_vendorAccessHandler;

    public RelmdServiceConnection(ICCLConfiguration config, ValueDecryption valueDecrypter, VendorAccessHandler databaseAccessEventHandler) {
        this.m_config = config;
        this.m_valueDecrypter = valueDecrypter;
        this.m_vendorAccessHandler = databaseAccessEventHandler;
        this.m_logUtil = RelmdLogger.GetLogUtilInstance();
    }

    public boolean invokeRequest(MessageContext mc) {
        boolean bFaultOccurred;
        RelmdFault fault = null;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        RelmdRequestEnvironment re = new RelmdRequestEnvironment(requestEnvelope, this.m_config, this.m_vendorAccessHandler, this.m_valueDecrypter);
        try {
            IWriteableAsXml result = this.executeRequest(re);
            AsyncResponseHelper asyncXmlHelper = new AsyncResponseHelper();
            asyncXmlHelper.writeResponse(mc, AsynchReplyStatusEnum.conversationComplete, result);
        }
        catch (RelmdException e) {
            this.m_logUtil.runtimeError(e, re.getRequestEnvelope());
            fault = new RelmdFault(e);
            fault.addDetail(e.getMessage());
        }
        catch (Throwable th) {
            this.m_logUtil.runtimeError(th, re.getRequestEnvelope());
            String messageCode = th.getMessage();
            if (messageCode == null || messageCode.length() == 0) {
                messageCode = th.toString();
            }
            fault = new Fault(messageCode);
            fault.addDetail(messageCode);
        }
        boolean bl = bFaultOccurred = null != fault;
        if (bFaultOccurred) {
            mc.setFault((Fault)fault);
        }
        return bFaultOccurred;
    }

    public IWriteableAsXml executeRequest(IRequestEnvironment reqEnv) throws DocumentException, RelmdException, Exception, SAXException, IOException, ParserConfigurationException {
        Element commandElem = reqEnv.getCommandElem();
        if (commandElem == null) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.x);
        }
        String commandName = commandElem.getName();
        if (!"importMetadataRequest".equals(commandName) && !"browseMetadataRequest".equals(commandName)) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.commandNotFound, commandName);
        }
        IWriteableAsXml result = this.buildRequest(commandElem, reqEnv).execute();
        return result;
    }

    protected IMetadataRequest buildRequest(Element commandElem, IRequestEnvironment reqEnv) throws Exception, SAXException, IOException, ParserConfigurationException {
        Relmd gateway = RelmdGateway.relmd();
        XmlApiToolkit serviceToolkit = gateway.xmlApiToolkit();
        VendorToolkit vendorToolkit = gateway.vendorToolkit();
        if ("importMetadataRequest".equals(commandElem.getName())) {
            ImportMetadataRequest m_request = serviceToolkit.importMetadataRequest(commandElem);
            MetadataSource dataSource = m_request.metadataSource();
            ConnectionParameters queryConnectionParameters = reqEnv.connectionParameters(dataSource);
            Database.EVendorType vendorType = queryConnectionParameters.vendorType();
            VendorRules vendorRules = vendorToolkit.vendorRules(vendorType);
            MetadataImportRules metadataImportRules = vendorRules.metadataImportRules();
            return new RelmdImportRequest(m_request, reqEnv, metadataImportRules);
        }
        BrowseMetadataRequest m_request = serviceToolkit.browseMetadataRequest(commandElem);
        MetadataSource dataSource = m_request.metadataSource();
        ConnectionParameters queryConnectionParameters = reqEnv.connectionParameters(dataSource);
        Database.EVendorType vendorType = queryConnectionParameters.vendorType();
        VendorRules vendorRules = vendorToolkit.vendorRules(vendorType);
        MetadataBrowseRules metadataBrowseRules = vendorRules.metadataBrowseRules();
        return new RelmdBrowseRequest(m_request, reqEnv, metadataBrowseRules);
    }

    public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean abandonRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean cancelRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }

    public boolean release() {
        return false;
    }

    public boolean getOutputForRequest(MessageContext mc) {
        return false;
    }

    public boolean releaseRequest(MessageContext mc) {
        return false;
    }

    static class RelmdBrowseRequest
    implements IMetadataRequest {
        I_ServiceCallback callback;
        MetadataBrowseRules rules;
        BrowseMetadataRequest request;

        RelmdBrowseRequest(BrowseMetadataRequest theRequest, I_ServiceCallback theCallback, MetadataBrowseRules theRules) {
            this.callback = theCallback;
            this.rules = theRules;
            this.request = theRequest;
        }

        @Override
        public IWriteableAsXml execute() throws Exception {
            return this.request.run(this.callback, this.rules);
        }
    }

    static class RelmdImportRequest
    implements IMetadataRequest {
        I_ServiceCallback callback;
        MetadataImportRules rules;
        ImportMetadataRequest request;

        RelmdImportRequest(ImportMetadataRequest theRequest, I_ServiceCallback theCallback, MetadataImportRules theRules) {
            this.callback = theCallback;
            this.rules = theRules;
            this.request = theRequest;
        }

        @Override
        public IWriteableAsXml execute() throws Exception {
            return this.request.run(this.callback, this.rules);
        }
    }

    public static class RelmdRequestEnvironment
    implements IRequestEnvironment {
        private BIBusEnvelope requestEnvelope;
        private ContentManagerService_PortType m_port;
        private BiBusHeader m_axisHeader;
        private ICCLConfiguration config;
        private VendorAccessHandler vendorAccessHandler;
        private ValueDecryption valueDecrypter;

        public RelmdRequestEnvironment(BIBusEnvelope m_requestEnvelope, ICCLConfiguration m_config, VendorAccessHandler theVendorAccessHandler, ValueDecryption theValueDecrypter) {
            this.requestEnvelope = m_requestEnvelope;
            this.config = m_config;
            this.vendorAccessHandler = theVendorAccessHandler;
            this.valueDecrypter = theValueDecrypter;
        }

        @Override
        public BiBusHeader getAxisHeader() {
            if (this.m_axisHeader == null) {
                AxisRequestHeaderBuilder axisHeaderBuilder = new AxisRequestHeaderBuilder(this.requestEnvelope);
                this.m_axisHeader = axisHeaderBuilder.getAxisHeader();
            }
            return this.m_axisHeader;
        }

        @Override
        public ContentManagerService_PortType getPort() throws CCLConfigurationException, MalformedURLException, ServiceException {
            if (this.m_port == null) {
                String productLocale = "en";
                String contentLocale = "en";
                RelmdCmServiceLocator relmdCmServiceLocator = new RelmdCmServiceLocator(productLocale, contentLocale, this.getAxisHeader(), this.config);
                this.m_port = relmdCmServiceLocator.getcontentManagerService();
            }
            return this.m_port;
        }

        @Override
        public Element getCommandElem() throws DocumentException {
            Element valueElem;
            Element specificationElem;
            boolean m_isAsync;
            Element requestElementBody = this.requestEnvelope.getBody();
            Element commandElem = null;
            List elements = requestElementBody.elements();
            if (elements.size() > 0) {
                commandElem = (Element)elements.get(0);
            }
            if (commandElem == null) {
                return null;
            }
            String commandElemName = commandElem.getName();
            boolean bl = m_isAsync = commandElemName.equals("runSpecification") || commandElemName.equals("wait") || commandElemName.equals("cancel") || commandElemName.equals("release");
            if (m_isAsync && (specificationElem = commandElem.element("specification")) != null && (valueElem = specificationElem.element("value")) != null) {
                String value = valueElem.getText();
                SAXReader saxReader = new SAXReader();
                StringReader valueReader = new StringReader(value);
                Document requestDoc = saxReader.read((Reader)valueReader);
                commandElem = requestDoc.getRootElement();
            }
            return commandElem;
        }

        @Override
        public BIBusEnvelope getRequestEnvelope() {
            return this.requestEnvelope;
        }

        @Override
        public boolean currentUserHasImportCapability() {
            BaseClass baseClass;
            boolean bRelmdImportCapabilityFound = false;
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
            PropEnum[] props = new PropEnum[]{PropEnum.userCapabilities};
            BaseClass[] res = null;
            try {
                res = this.getPort().query(smo, props, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (1 <= res.length && (baseClass = res[0]) != null && Session.class.equals(baseClass.getClass())) {
                Session session = (Session)baseClass;
                UserCapabilityEnumArrayProp capabilitiesProp = session.getUserCapabilities();
                UserCapabilityEnum[] capabilities = capabilitiesProp.getValue();
                for (int j = 0; !bRelmdImportCapabilityFound && j < capabilities.length; ++j) {
                    UserCapabilityEnum userCapabilityEnum = capabilities[j];
                    if (!UserCapabilityEnum.canImportRelationalMetadata.equals((Object)userCapabilityEnum)) continue;
                    bRelmdImportCapabilityFound = true;
                }
                if (!bRelmdImportCapabilityFound) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.capabilityCheckFailed);
                }
            }
            return bRelmdImportCapabilityFound;
        }

        @Override
        public ConnectionParameters connectionParameters(MetadataSource dataSource) throws Exception {
            return new ConnectionParametersQuery(dataSource, this.getPort(), this.getValueDecryption(), this.getAxisHeader());
        }

        @Override
        public VendorAccessHandler vendorAccessHandler() {
            return this.vendorAccessHandler;
        }

        @Override
        public ValueDecryption getValueDecryption() {
            return this.valueDecrypter;
        }
    }

    public static interface IRequestEnvironment
    extends I_ServiceCallback {
        public BIBusEnvelope getRequestEnvelope();

        @Override
        public boolean currentUserHasImportCapability();

        public BiBusHeader getAxisHeader();

        public ContentManagerService_PortType getPort() throws CCLConfigurationException, MalformedURLException, ServiceException;

        public Element getCommandElem() throws DocumentException;

        public ValueDecryption getValueDecryption();
    }
}

