/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.async.service.AsyncRequestHandler;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.IConnectionFactory;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.cognos.internal.relmd.bibus.RelmdServiceConnection;
import com.ibm.cognos.internal.relmd.dataSource._tools.CAMCryptoProvider;
import com.ibm.cognos.internal.relmd.dataSource._tools.EncryptedValueDecrypter;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.xmlapi.Handler;
import org.dom4j.Element;

public class RelmdServiceConnectionFactory
implements IConnectionFactory {
    private RESTClientFactory m_clientFactory = null;
    private Configuration m_config = null;
    private EncryptedValueDecrypter m_valueDecrypter = null;

    public void configure(Configuration config) {
        this.m_config = config;
    }

    public IConnection getConnection() {
        ICCLConfiguration configuration = this.m_config.getICCLConfiguration();
        Handler<BeginSql> beginSqlHandler = new Handler<BeginSql>(){

            @Override
            public void handle(BeginSql obj) {
            }
        };
        Handler<BeginJava> beginJavaHandler = new Handler<BeginJava>(){

            @Override
            public void handle(BeginJava obj) {
            }
        };
        Handler<ExecutionError> executionErrorHandler = new Handler<ExecutionError>(){

            @Override
            public void handle(ExecutionError obj) {
            }
        };
        Handler<ExecutionInformation> executionInformationHandler = new Handler<ExecutionInformation>(){

            @Override
            public void handle(ExecutionInformation obj) {
            }
        };
        Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = new Handler<ResultSetProcessingError>(){

            @Override
            public void handle(ResultSetProcessingError obj) {
            }
        };
        Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler = new Handler<ResultSetProcessingInformation>(){

            @Override
            public void handle(ResultSetProcessingInformation obj) {
            }
        };
        VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        VendorAccessHandler vendorAccessHandler = vendorAccessToolkit.vendorAccessHandler(beginSqlHandler, beginJavaHandler, executionInformationHandler, executionErrorHandler, resultSetProcessingInformationHandler, resultSetProcessingErrorHandler);
        RelmdServiceConnection relmdServiceConnection = new RelmdServiceConnection(configuration, this.m_valueDecrypter, vendorAccessHandler);
        return relmdServiceConnection;
    }

    public void compose(AsyncRequestHandler handler, PogoEngine engine, Element config) throws PogoException {
        try {
            this.m_valueDecrypter = new EncryptedValueDecrypter();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() {
        try {
            CAMCryptoProvider.initialize();
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e);
        }
        this.m_clientFactory = RESTClientFactory.getInstance();
        this.m_clientFactory.startup();
    }

    public void resume() {
    }

    public void start() {
    }

    public void stop() {
        try {
            CAMCryptoProvider.terminate();
        }
        catch (CAMCryptoException e) {
            return;
        }
        this.m_clientFactory.shutdown();
    }

    public void suspend(boolean arg0) {
    }
}

