/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus.logging;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;

public class RelmdLoggerFactory {
    private static final String LOGFILE_LOCATION = "../logs/relmd";
    private static final String LOGFILE_PATTERN = "/%s_" + new Date().toString().replaceAll("(\\s|:)", "_") + "_%s.log";
    private static final String LOGGERNAME_ROOT = "Relmd";
    public static final String JDBC_INTERFACES_FILTER = "^(java\\.sql\\..+)|(javax\\.sql\\..+)";
    private static String logFileNameFormat;
    private static int id;
    private static Pattern relmdClassFilter;
    private static final String DEFAULT_RELMD_CLASS_FILTER = ".*";
    private static boolean loggingEnabled;
    private static long lastModificationTime;

    private static synchronized void refreshState() {
        long lmt = RelmdConfiguration.getLastModificationTime();
        if (lmt > lastModificationTime) {
            lastModificationTime = lmt;
            if (Boolean.parseBoolean(RelmdConfiguration.getStringProperty("TraceEnabled", "false"))) {
                try {
                    File logDir = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(LOGFILE_LOCATION));
                    if (!logDir.exists() && !logDir.mkdirs()) {
                        throw new Exception();
                    }
                    if (!logDir.isDirectory()) {
                        throw new Exception();
                    }
                    logFileNameFormat = CCLConfigurationFactory.getInstance().resolveEffectivePath(LOGFILE_LOCATION + LOGFILE_PATTERN);
                    relmdClassFilter = Pattern.compile(RelmdConfiguration.getStringProperty("RelmdTraceFilter", DEFAULT_RELMD_CLASS_FILTER));
                    loggingEnabled = true;
                }
                catch (Exception e) {
                    loggingEnabled = false;
                }
            } else {
                loggingEnabled = false;
            }
        }
    }

    private static synchronized int getID() {
        return id++;
    }

    public static Logger get(String className) {
        Logger logger = null;
        RelmdLoggerFactory.refreshState();
        if (loggingEnabled && relmdClassFilter.matcher(className).matches()) {
            String idText = String.valueOf(RelmdLoggerFactory.getID());
            String loggerName = LOGGERNAME_ROOT + idText;
            try {
                logger = Logger.getLogger(loggerName);
                String logFileName = String.format(logFileNameFormat, className, idText);
                StreamHandler handler = new StreamHandler(new FileOutputStream(logFileName), new SimpleFormatter());
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
                logger.setLevel(Level.ALL);
                logger.setUseParentHandlers(true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return logger;
    }

    public static boolean isLoggingEnabled(String className) {
        RelmdLoggerFactory.refreshState();
        return loggingEnabled && relmdClassFilter.matcher(className).matches();
    }

    public static void flush(Logger logger) {
        for (Handler h : logger.getHandlers()) {
            h.flush();
        }
    }

    public static void close(Logger logger) {
        for (Handler h : logger.getHandlers()) {
            h.close();
        }
    }

    public static String connectionLogText(Connection connection) {
        StringBuffer text = new StringBuffer();
        text.append("Connection URL: '");
        try {
            text.append(connection.getMetaData().getURL());
        }
        catch (Exception e) {
            text.append("Could not get URL.");
        }
        text.append("' as '");
        try {
            text.append(connection.getMetaData().getUserName());
        }
        catch (Exception e) {
            text.append("could not get user name");
        }
        text.append("'");
        return text.toString();
    }

    static {
        loggingEnabled = false;
        lastModificationTime = -1L;
    }
}

