/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource;

import com.ibm.cognos.internal.relmd.dataSource.IDataSourceConnectionCommandBlock;
import java.util.Map;

public class DataSourceConnectionCommandBlock
implements IDataSourceConnectionCommandBlock {
    public static final String USERNAME = "userName";
    public static final String PASSWORD = "password";
    public static final String SQL_COMMAND = "sql";
    private static final int NUMBER_31 = 31;
    private IDataSourceConnectionCommandBlock.CommandBlockType commandBlockType;
    private final Map<String, Object> properties;

    public DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType type, Map<String, Object> props) {
        this.commandBlockType = type;
        this.properties = props;
    }

    @Override
    public final IDataSourceConnectionCommandBlock.CommandBlockType getType() {
        return this.commandBlockType;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public boolean compareTo(IDataSourceConnectionCommandBlock commandBlock) {
        if (commandBlock == null) {
            return false;
        }
        if (this.commandBlockType != commandBlock.getType()) {
            return false;
        }
        if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND) {
            if (!this.getProperty(USERNAME).equals(commandBlock.getProperty(USERNAME))) {
                return false;
            }
            String pass1 = (String)this.getProperty(PASSWORD);
            String pass2 = (String)commandBlock.getProperty(PASSWORD);
            if (pass1 == null && pass2 == null) {
                return true;
            }
            if (pass1 != null && pass2 != null) {
                return pass1.equals(pass2);
            }
        } else {
            if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
                return true;
            }
            if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND && this.getProperty(SQL_COMMAND).equals(commandBlock.getProperty(SQL_COMMAND))) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 + this.getType().hashCode();
        if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND || this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND) {
            if ((String)this.getProperty(USERNAME) != null) {
                hash = hash * 31 + ((String)this.getProperty(USERNAME)).hashCode();
            }
            if ((String)this.getProperty(PASSWORD) != null) {
                hash = hash * 31 + ((String)this.getProperty(PASSWORD)).hashCode();
            }
        } else if (this.commandBlockType == IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND) {
            hash = hash * 31 + ((String)this.getProperty(SQL_COMMAND)).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataSourceConnectionCommandBlock) {
            return this.compareTo((IDataSourceConnectionCommandBlock)obj);
        }
        return false;
    }
}

