/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource._tools;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.dataSource.ApiTokenSignon;
import com.ibm.cognos.internal.relmd.dataSource.JCAMImpersonator;
import com.ibm.cognos.internal.relmd.dataSource.OIDCCredentialsSignon;
import com.ibm.cognos.internal.relmd.dataSource.ValueDecryption;
import com.ibm.cognos.internal.relmd.dataSource._tools.EncryptedObject;
import com.ibm.cognos.relmd.vendor.connection.ConnnectionSignonParameters;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CredentialsDecrypt
implements ConnnectionSignonParameters {
    private static final String ACCESSTOKEN = "access_token";
    private static final String IDTOKEN = "id_token";
    private static final String NAMESPACE = "namespace";
    private static final String AUTHKEY = "authKey";
    private static final String SECRETKEY = "secretKey";
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public String m_encryptedCredentialsXml;
    public ValueDecryption m_valueDecrypter;
    private String m_userName;
    private String m_password;
    private OIDCCredentialsSignon mOIDCCredentialsSignon = null;
    private ApiTokenSignon mApiTokenSignon = null;

    public CredentialsDecrypt(String encryptedCredentialsXml, ValueDecryption valueDecrypter) throws DocumentException, UnsupportedEncodingException, CAMCryptoException {
        Element secretKeyElement;
        Element accesTokenElement;
        Element idTokenElement;
        this.m_encryptedCredentialsXml = encryptedCredentialsXml;
        this.m_valueDecrypter = valueDecrypter;
        SAXReader encryptedCredentialsXmlReader = new SAXReader();
        StringReader encryptedStringReader = new StringReader(encryptedCredentialsXml);
        Document domCredential = encryptedCredentialsXmlReader.read((Reader)encryptedStringReader);
        Element credentialsElement = domCredential.getRootElement();
        String encryptedValue = credentialsElement.elementText("encryptedValue");
        if (encryptedValue == null) {
            RelmdException relmdException = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.missingEncryptedSignonCredentials);
            throw relmdException;
        }
        String decryptedValueXml = valueDecrypter.decrypt(encryptedValue);
        SAXReader reader = new SAXReader();
        StringReader decryptedStringReader = new StringReader(decryptedValueXml);
        Document decryptedDom = reader.read((Reader)decryptedStringReader);
        Element decryptedDomElement = decryptedDom.getRootElement();
        this.m_userName = decryptedDomElement.elementText(USERNAME);
        this.m_password = decryptedDomElement.elementText(PASSWORD);
        String namespace = null;
        EncryptedObject<String> accessToken = null;
        EncryptedObject<String> idToken = null;
        Element namespaceElement = decryptedDomElement.element(NAMESPACE);
        if (namespaceElement != null) {
            namespace = namespaceElement.getText();
        }
        if ((idTokenElement = decryptedDomElement.element(IDTOKEN)) != null) {
            idToken = new EncryptedObject<String>(idTokenElement.getText());
        }
        if ((accesTokenElement = decryptedDomElement.element(ACCESSTOKEN)) != null) {
            accessToken = new EncryptedObject<String>(accesTokenElement.getText());
        }
        if (accessToken != null) {
            this.mOIDCCredentialsSignon = new OIDCCredentialsSignon(namespace, idToken, accessToken);
        }
        EncryptedObject<String> authKey = null;
        EncryptedObject<String> secretKey = null;
        Element authKeyElement = decryptedDomElement.element(AUTHKEY);
        if (authKeyElement != null) {
            authKey = new EncryptedObject<String>(authKeyElement.getText());
        }
        if ((secretKeyElement = decryptedDomElement.element(SECRETKEY)) != null) {
            secretKey = new EncryptedObject<String>(secretKeyElement.getText());
        }
        if (authKey != null || secretKey != null) {
            this.mApiTokenSignon = new ApiTokenSignon(authKey, secretKey);
        }
    }

    @Override
    public String password() {
        return this.m_password;
    }

    @Override
    public String userName() {
        return this.m_userName;
    }

    @Override
    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
        return null;
    }

    @Override
    public boolean isKerberos() {
        return false;
    }

    @Override
    public boolean isIntegratedSecurity() {
        return false;
    }

    @Override
    public String getCryptoHandle() {
        return null;
    }

    @Override
    public String getContentLocale() {
        return null;
    }

    @Override
    public OIDCCredentialsSignon getOIDCCredentialsSignon() {
        return this.mOIDCCredentialsSignon;
    }

    @Override
    public ApiTokenSignon getApiTokenSignon() {
        return this.mApiTokenSignon;
    }
}

