/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource._tools;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.xqe.data.providers.secbridge.relmd.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.relmd.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.relmd.LocaleConverter;
import com.ibm.cognos.internal.relmd.RelmdToolkits;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.dataSource.ApiTokenSignon;
import com.ibm.cognos.internal.relmd.dataSource.JCAMImpersonator;
import com.ibm.cognos.internal.relmd.dataSource.OIDCCredentialsSignon;
import com.ibm.cognos.internal.relmd.dataSource.RelmdConnectionFactory;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;
import com.ibm.cognos.jdbc.adaptor.sqlexception.SQLCognosInvalidLogonException;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.vendor.connection.ConnectionStringParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnnectionSignonParameters;
import com.ibm.cognos.relmd.vendor.connection.ExtendedParameterLookup;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class DataSourceConnectionStringParser
implements ConnectionStringParameters {
    private static final String IBMCOGNOS_AUTHENTICATION_JAVA_KRB5 = "ibmcognos.authentication=java_krb5";
    private static final String IBMCOGNOS_MAXROWSRETRIEVED = "ibmcognos.maxrowsretrieved";
    private static final String PARAMETERNAME_URL = "URL=";
    private static final String PARAMETERNAME_DRIVER_NAME = "DRIVER_NAME=";
    private static final String COGNOSINSIGHTS_DRIVER_NAME = "com.ibm.cognos.tm1.jdbc.TM1Driver";
    private static final String INTEGRATED_SECURITY = "integratedSecurity=true";
    private static final String OIDC_NAMESPACE = "oidc.namespace";
    private static final String OIDC_ATOKEN = "oidc.atoken";
    private static final String OIDC_IDTOKEN = "oidc.idtoken";
    private static final String APITOKEN_AUTHKEY = "authKey";
    private static final String APITOKEN_SECRETKEY = "secretKey";
    public static final String IBMCOGNOS_SG_DEST = "IBMCOGNOS_SG_DEST";
    public static final String IBMCOGNOS_PASSPORT = "IBMCOGNOS_PASSPORT";
    private static final String TRUE = "TRUE";
    private static final String BACKSLASH = "\\";
    private static final String ATCHAR = "@";
    private static final String TRANSFORMUID_CLASSIC = "@TRANSFORMUID=TRUE";
    private static final String TRANSFORMUID = "@TRANSFORMUID";
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private Database.ECatalogSupport m_catalogSupport = Database.ECatalogSupport.catalogsNotSupported;
    private String m_jdbcConnectionString;
    private Properties properties = new Properties();
    private String m_driverClass;
    private boolean m_isKerberos;
    private boolean m_isIntegratedSecurity;
    private boolean m_localTransformUid = false;

    public DataSourceConnectionStringParser(String dataSourceConnectionString) {
        this(dataSourceConnectionString, null, null);
    }

    public DataSourceConnectionStringParser(String dataSourceConnectionString, ConnnectionSignonParameters credentials) {
        this(dataSourceConnectionString, null, credentials);
    }

    public DataSourceConnectionStringParser(String dataSourceConnectionString, BiBusHeader biBusHeader, ConnnectionSignonParameters credentials) {
        String[] ibmCognosProperties;
        String[] dataSourceConnectionStringParts = dataSourceConnectionString.split(";");
        int connectionStringIndex = -1;
        for (int stringIndex = 0; stringIndex < dataSourceConnectionStringParts.length; ++stringIndex) {
            if (!dataSourceConnectionStringParts[stringIndex].startsWith(PARAMETERNAME_URL) || stringIndex <= 0) continue;
            connectionStringIndex = stringIndex - 1;
            break;
        }
        if (connectionStringIndex < 0 || connectionStringIndex + 2 >= dataSourceConnectionStringParts.length) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidConnectionString);
        }
        String vendorTypePart = dataSourceConnectionStringParts[connectionStringIndex];
        String currentPart = dataSourceConnectionStringParts[connectionStringIndex + 1];
        if (!currentPart.startsWith(PARAMETERNAME_URL)) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidConnectionString);
        }
        this.m_jdbcConnectionString = currentPart.substring(PARAMETERNAME_URL.length());
        for (String property : ibmCognosProperties = new String[]{"ibmcognos.authentication", IBMCOGNOS_AUTHENTICATION_JAVA_KRB5, "ibmcognos.maxvarcharsize", "ibmcognos.fetchbuffersize", "ibmcognos.qualifier_list", IBMCOGNOS_MAXROWSRETRIEVED}) {
            if (!this.m_jdbcConnectionString.toLowerCase().contains(property)) continue;
            String nonModifiedUrl = this.m_jdbcConnectionString;
            this.m_jdbcConnectionString = this.m_jdbcConnectionString.substring(0, this.m_jdbcConnectionString.toLowerCase().indexOf(property));
            String propertyToParse = nonModifiedUrl.substring(this.m_jdbcConnectionString.length());
            if (propertyToParse.startsWith(IBMCOGNOS_AUTHENTICATION_JAVA_KRB5) || propertyToParse.toLowerCase().startsWith(IBMCOGNOS_MAXROWSRETRIEVED)) continue;
            String[] pParts = propertyToParse.split("=");
            this.properties.setProperty(pParts[0].trim(), pParts[1].trim());
        }
        ArrayList<String> listOfProperties = new ArrayList<String>();
        listOfProperties.addAll(Arrays.asList(ibmCognosProperties));
        for (int remainingPartsIdx = connectionStringIndex + 2; remainingPartsIdx < dataSourceConnectionStringParts.length; ++remainingPartsIdx) {
            currentPart = dataSourceConnectionStringParts[remainingPartsIdx];
            if (currentPart.startsWith(PARAMETERNAME_DRIVER_NAME)) {
                this.m_driverClass = currentPart.substring(PARAMETERNAME_DRIVER_NAME.length());
                continue;
            }
            if (currentPart.startsWith(IBMCOGNOS_AUTHENTICATION_JAVA_KRB5) || currentPart.toLowerCase().startsWith(IBMCOGNOS_MAXROWSRETRIEVED)) continue;
            String[] pParts = currentPart.split("=");
            if (this.m_driverClass == null && !listOfProperties.contains(pParts[0].trim().toLowerCase())) {
                if (this.m_jdbcConnectionString.endsWith(":")) {
                    this.m_jdbcConnectionString = this.m_jdbcConnectionString + currentPart;
                    continue;
                }
                this.m_jdbcConnectionString = this.m_jdbcConnectionString + ";";
                this.m_jdbcConnectionString = this.m_jdbcConnectionString + currentPart;
                continue;
            }
            if ("LOCALSORT".equals(pParts[0]) || "LEVEL".equals(pParts[0])) continue;
            if (TRANSFORMUID.equalsIgnoreCase(pParts[0]) && TRUE.equalsIgnoreCase(pParts[1])) {
                this.m_localTransformUid = true;
            }
            if (pParts.length == 1) {
                this.properties.setProperty(pParts[0].trim(), "");
                continue;
            }
            if (pParts.length != 2) continue;
            this.properties.setProperty(pParts[0].trim(), pParts[1].trim());
        }
        if (this.m_driverClass == null) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidDriverClass);
        }
        if (dataSourceConnectionString.contains(IBMCOGNOS_AUTHENTICATION_JAVA_KRB5)) {
            this.m_isKerberos = true;
        }
        if (dataSourceConnectionString.contains(INTEGRATED_SECURITY)) {
            this.m_isIntegratedSecurity = true;
        }
        this.properties = DataSourceConnectionStringParser.setPassportProperty(dataSourceConnectionString, biBusHeader, this.properties);
        this.m_vendorType = this.vendorType(vendorTypePart, credentials);
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("Internal database type is ");
            if (this.m_vendorType == Database.EVendorType.generic) {
                msgBuilder.append("'jdbc'");
            } else {
                msgBuilder.append("'" + this.m_vendorType.toString() + "'");
            }
            msgBuilder.append(" for connection string ");
            msgBuilder.append(dataSourceConnectionString);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
    }

    public boolean isTransformUid() {
        return this.m_localTransformUid;
    }

    public static Properties setPassportProperty(String dataSourceConnectionString, BiBusHeader biBusHeader, Properties properties) {
        String cPassportId;
        if (dataSourceConnectionString.contains(IBMCOGNOS_SG_DEST) && !properties.contains(IBMCOGNOS_PASSPORT) && (cPassportId = DataSourceConnectionStringParser.getPasportId(biBusHeader)) != null) {
            properties.setProperty(IBMCOGNOS_PASSPORT, cPassportId);
        }
        return properties;
    }

    private static String getPasportId(BiBusHeader biBusHeader) {
        CAMPassport cPassport;
        if (biBusHeader == null) {
            return null;
        }
        CAM cSecurity = biBusHeader.getCAM();
        if (cSecurity != null && null != (cPassport = cSecurity.getCAMPassport())) {
            int version = 1;
            String cPassportId = cPassport.getId();
            boolean logEnabled = cPassport.isLogEnabled();
            int generation = cPassport.getGeneration();
            boolean canCallLogon = cPassport.isCanCallLogon();
            String separator = ";";
            String stringToCookie = String.valueOf(version) + separator + cPassportId + separator + String.valueOf(logEnabled ? 1 : 0) + separator + String.valueOf(generation) + separator + String.valueOf(canCallLogon ? 1 : 0) + separator;
            return CCLWeb64.encode((byte[])stringToCookie.getBytes());
        }
        return null;
    }

    private Database.EVendorType vendorType(String expectedDatabaseType, ConnnectionSignonParameters credentials) throws RelmdException {
        Database.EVendorType vendorType;
        if (this.m_driverClass.equalsIgnoreCase(COGNOSINSIGHTS_DRIVER_NAME)) {
            vendorType = this.vendorType4CognosInsights(expectedDatabaseType);
        } else {
            StringBuilder msgBuilder;
            Logger logger;
            SQLCognosInvalidLogonException.SubCode subCode;
            DatabaseMetaData md;
            RelmdException exception;
            Connection connection;
            if ("LOCAL".equalsIgnoreCase(expectedDatabaseType)) {
                vendorType = Database.EVendorType.local;
            } else if ("JD-OR".equals(expectedDatabaseType)) {
                this.m_rawVendorType = Database.EVendorType.oracle;
                if (this.isGenericType(Database.EVendorType.oracle, true)) {
                    vendorType = Database.EVendorType.generic;
                    this.m_catalogSupport = Database.ECatalogSupport.catalogsNotSupported;
                } else {
                    vendorType = Database.EVendorType.oracle;
                }
            } else if ("JD-SS".equals(expectedDatabaseType)) {
                this.m_rawVendorType = Database.EVendorType.sqlserver;
                if (this.isGenericType(Database.EVendorType.sqlserver, true)) {
                    vendorType = Database.EVendorType.generic;
                    this.m_catalogSupport = Database.ECatalogSupport.catalogsSupported;
                } else {
                    vendorType = Database.EVendorType.sqlserver;
                }
            } else if ("JD-NZ".equals(expectedDatabaseType)) {
                this.m_rawVendorType = Database.EVendorType.netezza;
                vendorType = Database.EVendorType.generic;
            } else if ("JD-TD".equals(expectedDatabaseType)) {
                this.m_rawVendorType = Database.EVendorType.teradata;
                if (this.isGenericType(Database.EVendorType.teradata, true)) {
                    vendorType = Database.EVendorType.generic;
                    this.m_catalogSupport = Database.ECatalogSupport.catalogsNotSupported;
                } else {
                    vendorType = Database.EVendorType.teradata;
                }
            } else if ("JD-HV".equals(expectedDatabaseType)) {
                vendorType = Database.EVendorType.genericHive;
            } else if ("JD-SPSS".equals(expectedDatabaseType)) {
                vendorType = Database.EVendorType.spss;
            } else if ("ERP-SAP".equals(expectedDatabaseType)) {
                vendorType = Database.EVendorType.genericSAP;
            } else if ("ERP-SIEBEL".equals(expectedDatabaseType)) {
                vendorType = Database.EVendorType.genericSiebel;
            } else if ("ERP-SFDC".equals(expectedDatabaseType)) {
                vendorType = Database.EVendorType.genericSFDC;
            } else if ("JD-D2".equals(expectedDatabaseType)) {
                this.m_rawVendorType = Database.EVendorType.db2;
                if (this.isGenericType(Database.EVendorType.db2, true)) {
                    vendorType = Database.EVendorType.generic;
                    this.m_catalogSupport = Database.ECatalogSupport.catalogsNotSupported;
                } else {
                    block60: {
                        vendorType = Database.EVendorType.db2;
                        connection = null;
                        exception = null;
                        try {
                            String productVersion;
                            connection = this.getDB2Connection(credentials);
                            if (connection != null && (productVersion = (md = connection.getMetaData()).getDatabaseProductVersion()) != null && (productVersion.indexOf("DSN") >= 0 || productVersion.indexOf("QSQ") >= 0)) {
                                vendorType = Database.EVendorType.generic;
                            }
                        }
                        catch (SQLCognosInvalidLogonException e) {
                            subCode = e.getSubCode();
                            exception = subCode == SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS ? new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials, e) : new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                        }
                        catch (SQLException e) {
                            exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                        }
                        catch (LoginException e) {
                            exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
                        }
                        catch (Exception e) {
                            exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.x, e);
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                if (exception == null) {
                                    exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                                }
                                if (!RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) break block60;
                                logger = RelmdLoggerFactory.get(this.getClass().getName());
                                msgBuilder = new StringBuilder();
                                msgBuilder.append("Error occurs during connection close.");
                                msgBuilder.append("Error Type: " + (Object)((Object)RelmdException.EErrorType.client));
                                msgBuilder.append(". Error Code: " + (Object)((Object)RelmdException.EErrorCode.jdbcSQLException));
                                msgBuilder.append(e.toString());
                                logger.info(msgBuilder.toString());
                                RelmdLoggerFactory.flush(logger);
                            }
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
            } else {
                vendorType = Database.EVendorType.generic;
            }
            if (null != vendorType && vendorType == Database.EVendorType.generic) {
                block61: {
                    connection = null;
                    exception = null;
                    try {
                        String catalogTerm;
                        connection = this.getGenericConnection(credentials);
                        if (connection != null && (catalogTerm = (md = connection.getMetaData()).getCatalogTerm()) != null && !catalogTerm.isEmpty()) {
                            this.m_catalogSupport = Database.ECatalogSupport.catalogsSupported;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcDriverNotFound, e);
                    }
                    catch (SQLCognosInvalidLogonException e) {
                        subCode = e.getSubCode();
                        exception = subCode == SQLCognosInvalidLogonException.SubCode.INVALID_CREDENTIALS ? new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials, e) : new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                    }
                    catch (SQLException e) {
                        exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                    }
                    catch (LoginException e) {
                        exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
                    }
                    catch (IllegalAccessException e) {
                        this.logException(e);
                    }
                    catch (InstantiationException e) {
                        this.logException(e);
                    }
                    catch (RelmdException e) {
                        this.logException(e);
                        exception = e;
                    }
                    catch (Exception e) {
                        this.logException(e);
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            if (exception == null) {
                                exception = new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                            }
                            if (!RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) break block61;
                            logger = RelmdLoggerFactory.get(this.getClass().getName());
                            msgBuilder = new StringBuilder();
                            msgBuilder.append("Error occurs during connection close.");
                            msgBuilder.append("Error Type: " + (Object)((Object)RelmdException.EErrorType.client));
                            msgBuilder.append(". Error Code: " + (Object)((Object)RelmdException.EErrorCode.jdbcSQLException));
                            msgBuilder.append(e.toString());
                            logger.info(msgBuilder.toString());
                            RelmdLoggerFactory.flush(logger);
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
        if (this.m_rawVendorType == null) {
            this.m_rawVendorType = vendorType;
        }
        return vendorType;
    }

    private void logException(Exception e) {
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            logger.log(Level.WARNING, String.format(e.getMessage(), e.toString()));
            RelmdLoggerFactory.flush(logger);
        }
    }

    boolean isGenericType(Database.EVendorType type, boolean def) {
        if (type == Database.EVendorType.oracle || type == Database.EVendorType.db2 || type == Database.EVendorType.sqlserver || type == Database.EVendorType.teradata) {
            String property = type.toString() + ".generic";
            return RelmdConfiguration.getBooleanProperty(property, def);
        }
        return true;
    }

    private Connection getGenericConnection(ConnnectionSignonParameters credentials) throws Exception {
        Connection connection = null;
        if (credentials == null) {
            return null;
        }
        Logger logger = null;
        String loggingClassName = RelmdToolkits.class.getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            logger = RelmdLoggerFactory.get(loggingClassName);
        }
        if (this.m_isKerberos) {
            if (isTraceOn) {
                logger.info(String.format("connection string has ibmcognos.authentication=java_krb5", new Object[0]));
                RelmdLoggerFactory.flush(logger);
            }
            JCAMImpersonator.DelegatedCredential credential = credentials.getDelegatedCredential();
            if (isTraceOn && credential != null) {
                logger.info(String.format("Kerberos delegated credential connection started::", new Object[0]));
                RelmdLoggerFactory.flush(logger);
            }
            if (credential == null) {
                String username = credentials.userName();
                String password = credentials.password();
                if (isTraceOn) {
                    logger.info(String.format("Non delegated credential started, using username and password[" + username + "][" + password + "]", new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                if (username == null || password == null) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials);
                }
                if (isTraceOn) {
                    logger.info(String.format("@Transformuid is " + this.isTransformUid(), new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                if (this.isTransformUid()) {
                    String[] parts;
                    if (username != null && username.contains(BACKSLASH)) {
                        parts = username.split("\\\\");
                        if (isTraceOn) {
                            logger.info(String.format("Removed domain name from domain\\username" + username, new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        username = parts[1];
                    }
                    if (username != null && username.contains(ATCHAR)) {
                        parts = username.split(ATCHAR);
                        if (isTraceOn) {
                            logger.info(String.format("Removed domain name from username@domain" + username, new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        username = parts[0];
                    }
                }
                if (isTraceOn) {
                    logger.info(String.format("Kerberos Non delegated credential connection started::", new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                credential = new JCAMImpersonator.DelegatedCredential(this.login(username, password));
            }
            connection = this.connectKerberos(credential);
        } else if (this.m_isIntegratedSecurity) {
            connection = this.connectIntegratedSecurity(credentials);
        } else {
            Driver driver = (Driver)Class.forName(this.m_driverClass).newInstance();
            OIDCCredentialsSignon oidcSignon = credentials.getOIDCCredentialsSignon();
            if (oidcSignon != null) {
                this.properties.setProperty(OIDC_NAMESPACE, oidcSignon.getNamespace());
                this.properties.setProperty(OIDC_ATOKEN, oidcSignon.getAccessToken().decrypt());
                this.properties.setProperty(OIDC_IDTOKEN, oidcSignon.getIdToken().decrypt());
            } else if (credentials.getApiTokenSignon() != null) {
                ApiTokenSignon apiTokenSignon = credentials.getApiTokenSignon();
                if (apiTokenSignon.getAuthKey() != null) {
                    this.properties.setProperty(APITOKEN_AUTHKEY, apiTokenSignon.getAuthKey().decrypt());
                }
                if (apiTokenSignon.getSecretKey() != null) {
                    this.properties.setProperty(APITOKEN_SECRETKEY, apiTokenSignon.getSecretKey().decrypt());
                }
            } else {
                String userName = credentials.userName();
                String password = credentials.password();
                if (userName != null) {
                    this.properties.setProperty("user", userName);
                }
                if (password != null) {
                    this.properties.setProperty("password", password);
                }
            }
            connection = RelmdConnectionFactory.createAndWrapConnection(driver, this.m_jdbcConnectionString, this.properties, true);
        }
        return connection;
    }

    private Connection getDB2Connection(ConnnectionSignonParameters credentials) throws Exception {
        Connection connection = null;
        if (credentials == null) {
            return null;
        }
        Logger logger = null;
        String loggingClassName = RelmdToolkits.class.getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            logger = RelmdLoggerFactory.get(loggingClassName);
        }
        if (this.m_isKerberos) {
            if (isTraceOn) {
                logger.info(String.format("connection string has ibmcognos.authentication=java_krb5", new Object[0]));
                RelmdLoggerFactory.flush(logger);
            }
            JCAMImpersonator.DelegatedCredential credential = credentials.getDelegatedCredential();
            if (isTraceOn && credential != null) {
                logger.info(String.format("Kerberos delegated credential connection started::", new Object[0]));
                RelmdLoggerFactory.flush(logger);
            }
            if (credential == null) {
                String username = credentials.userName();
                String password = credentials.password();
                if (isTraceOn) {
                    logger.info(String.format("Non delegated credential started, using username and password[" + username + "][" + password + "]", new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                if (username == null || password == null) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.invalidCredentials);
                }
                if (isTraceOn) {
                    logger.info(String.format("@Transformuid is " + this.isTransformUid(), new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                if (this.isTransformUid()) {
                    String[] parts;
                    if (username != null && username.contains(BACKSLASH)) {
                        parts = username.split("\\\\");
                        if (isTraceOn) {
                            logger.info(String.format("Removed domain name from domain\\username" + username, new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        username = parts[1];
                    }
                    if (username != null && username.contains(ATCHAR)) {
                        parts = username.split(ATCHAR);
                        if (isTraceOn) {
                            logger.info(String.format("Removed domain name from username@domain" + username, new Object[0]));
                            RelmdLoggerFactory.flush(logger);
                        }
                        username = parts[0];
                    }
                }
                if (isTraceOn) {
                    logger.info(String.format("Kerberos Non delegated credential connection started::", new Object[0]));
                    RelmdLoggerFactory.flush(logger);
                }
                credential = new JCAMImpersonator.DelegatedCredential(this.login(username, password));
            }
            connection = this.connectKerberos(credential);
        } else if (this.m_isIntegratedSecurity) {
            connection = this.connectIntegratedSecurity(credentials);
        } else {
            String password;
            String userName;
            try {
                Class.forName(this.m_driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcDriverNotFound, e);
            }
            OIDCCredentialsSignon oidcSignon = credentials.getOIDCCredentialsSignon();
            if (oidcSignon != null) {
                userName = "";
                password = oidcSignon.getAccessToken().decrypt();
            } else {
                userName = credentials.userName();
                password = credentials.password();
            }
            if (userName != null && password != null) {
                connection = DriverManager.getConnection(this.m_jdbcConnectionString, userName, password);
            }
        }
        return connection;
    }

    private Subject login(String username, String password) throws Exception {
        Subject subject = null;
        LoginContext lc = RelmdToolkits.createLoginContext(username, password);
        lc.login();
        subject = lc.getSubject();
        return subject;
    }

    private Connection connectIntegratedSecurity(ConnnectionSignonParameters credentials) throws Exception {
        String userId = credentials.userName();
        String password = credentials.password();
        String cryptoHandle = credentials.getCryptoHandle();
        boolean isSingleSignOn = false;
        isSingleSignOn = cryptoHandle != null ? true : userId != null && password != null;
        if (!isSingleSignOn) {
            Driver driver = (Driver)Class.forName(this.m_driverClass).newInstance();
            return RelmdConnectionFactory.createAndWrapConnection(driver, this.m_jdbcConnectionString, this.properties, true);
        }
        class ConnectTask
        implements Callable<Object> {
            Connection connection = null;

            ConnectTask() {
            }

            @Override
            public Object call() throws Exception {
                Driver driver = (Driver)Class.forName(DataSourceConnectionStringParser.this.m_driverClass).newInstance();
                this.connection = RelmdConnectionFactory.createAndWrapConnection(driver, DataSourceConnectionStringParser.this.m_jdbcConnectionString, DataSourceConnectionStringParser.this.properties, true);
                return null;
            }

            public Connection getConnection() {
                return this.connection;
            }
        }
        ConnectTask task = new ConnectTask();
        int runLocale = Integer.parseInt(LocaleConverter.toLCID(credentials.getContentLocale()));
        try {
            if (cryptoHandle != null) {
                this.invokeWithCAMImpersonation(task, cryptoHandle, runLocale);
            } else {
                String domainName = "";
                String uId = userId;
                int slashPos = uId.indexOf(92);
                if (slashPos > 0) {
                    domainName = uId.substring(0, slashPos);
                    userId = uId.substring(slashPos + 1);
                }
                this.invokeWithWinImpersonation(task, domainName, userId, password, runLocale);
            }
        }
        catch (Exception e) {
            this.logMessage("SSO connection failed: " + e.toString());
            if (task.getConnection() != null) {
                try {
                    task.getConnection().close();
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
                }
                catch (SQLException exception) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                }
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.SSO_CONNECTION_FAILED, e);
        }
        this.logMessage("SSO connection succeeded");
        return task.getConnection();
    }

    public <T> T invokeWithCAMImpersonation(Callable<T> task, String camCryptoHandle, int errorLocale) throws RelmdException {
        this.logMessage("invokeWithCAMImpersonation: " + camCryptoHandle);
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater(camCryptoHandle, errorLocale);
        try {
            return camImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            this.logException(this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage(), Level.WARNING);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR, e);
        }
        catch (Throwable e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.GENERAL_ERROR, e.getLocalizedMessage());
        }
    }

    public <T> T invokeWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) throws RelmdException {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater(domainName, userName, password, errorLocale);
        try {
            return winImpersonater.runPrivilegedTask(task);
        }
        catch (Exception e) {
            this.logException(this, "Error doing invokeWithCAMImpersonation" + e.getLocalizedMessage(), Level.WARNING);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR, e);
        }
        catch (Throwable e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.GENERAL_ERROR, e.getLocalizedMessage());
        }
    }

    private void logException(Object obj, String s, Level level) {
        String loggingClassName = obj.getClass().getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            Logger logger = RelmdLoggerFactory.get(loggingClassName);
            logger.log(level, s);
            RelmdLoggerFactory.flush(logger);
        }
    }

    private void logMessage(String s) {
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append(s);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
    }

    private Connection connectKerberos(JCAMImpersonator.DelegatedCredential credential) throws Exception {
        class ConnectTask
        implements PrivilegedAction<Exception> {
            Exception ex = null;
            Connection connection = null;

            ConnectTask() {
            }

            @Override
            public Exception run() {
                try {
                    Driver driver = (Driver)Class.forName(DataSourceConnectionStringParser.this.m_driverClass).newInstance();
                    this.connection = RelmdConnectionFactory.createAndWrapConnection(driver, DataSourceConnectionStringParser.this.m_jdbcConnectionString, DataSourceConnectionStringParser.this.properties, true);
                }
                catch (Exception e) {
                    this.ex = e;
                }
                return this.ex;
            }

            public Exception getException() {
                return this.ex;
            }

            public Connection getConnection() {
                return this.connection;
            }
        }
        ConnectTask task = new ConnectTask();
        if (credential.isConstrained()) {
            this.properties.put("JGSSCredential", credential.getCredential());
        }
        Subject.doAs(credential.getSubject(), task);
        if (task.getException() != null) {
            throw task.getException();
        }
        return task.getConnection();
    }

    @Override
    public String jdbcConnectionString() {
        return this.m_jdbcConnectionString;
    }

    @Override
    public String driverClass() {
        return this.m_driverClass;
    }

    @Override
    public Database.EVendorType vendorType() {
        return this.m_vendorType;
    }

    @Override
    public Database.EVendorType rawVendorType() {
        return this.m_rawVendorType;
    }

    @Override
    public ExtendedParameterLookup extendedParameterLookup() {
        ExtendedParameterLookup extendedParameterLookup = new ExtendedParameterLookup(){

            @Override
            public Object parameter(String parameterName) {
                return null;
            }
        };
        return extendedParameterLookup;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    private Database.EVendorType vendorType4CognosInsights(String expectedDatabaseType) {
        Database.EVendorType vendorType = "JD-OR".equals(expectedDatabaseType) ? Database.EVendorType.oracle : ("JD-SS".equals(expectedDatabaseType) ? Database.EVendorType.sqlserver : ("JD-NZ".equals(expectedDatabaseType) ? Database.EVendorType.netezza : ("JD-TD".equals(expectedDatabaseType) ? Database.EVendorType.teradata : ("JD-D2".equals(expectedDatabaseType) ? Database.EVendorType.db2 : ("JD-SPSS".equals(expectedDatabaseType) ? Database.EVendorType.spss : ("JD-IF".equals(expectedDatabaseType) ? Database.EVendorType.informix : Database.EVendorType.generic))))));
        return vendorType;
    }

    @Override
    public Database.ECatalogSupport catalogSupport() {
        return this.m_catalogSupport;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

