/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource._tools;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.dataSource._tools.CAMCryptoProvider;
import com.ibm.cognos.internal.relmd.dataSource._tools.IEncryptedObject;

public class EncryptedObject<T>
implements IEncryptedObject<T> {
    private static final String UTF_8 = "UTF-8";
    private byte[] mSecureData = null;

    public EncryptedObject() {
    }

    public EncryptedObject(T value) {
        this.set(value);
    }

    public void set(T value) {
        if (null == value) {
            this.mSecureData = null;
            return;
        }
        this.encryptString((String)value);
    }

    @Override
    public T decrypt() {
        if (null == this.mSecureData) {
            return null;
        }
        return (T)this.decryptString();
    }

    @Override
    public boolean hasValue() {
        return this.mSecureData != null;
    }

    private void encryptString(String value) {
        try {
            byte[] stringData = value.getBytes(UTF_8);
            this.mSecureData = CAMCryptoProvider.encrypt(stringData);
        }
        catch (Exception ex) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.camCryptoError, ex);
        }
    }

    private String decryptString() {
        try {
            byte[] stringData = CAMCryptoProvider.decrypt(this.mSecureData);
            return new String(stringData, UTF_8);
        }
        catch (Exception ex) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.camCryptoError, ex);
        }
    }
}

