/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._schema;

import com.ibm.cognos.internal.relmd.metadata._schema.MetadataElement;
import com.ibm.cognos.internal.relmd.metadata._schema.ModelElement;
import com.ibm.cognos.internal.relmd.metadata._schema.SqlColumnObjectElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata.import_.rules.TableParametersImportRules;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.util.ArrayList;
import java.util.Collection;

public class TableParameterElem
extends ModelElement
implements TableParameter {
    public static final String ELEMENT_NAME = "inputParameter";
    public static final String ATTRIBUTE_name = "name";
    public static final String ATTRIBUTE_datatype = "datatype";
    public static final String ATTRIBUTE_size = "size";
    public static final String ATTRIBUTE_precision = "precision";
    public static final String ATTRIBUTE_scale = "scale";
    public static final String ATTRIBUTE_category = "category";
    public static final String ATTRIBUTE_isMandatory = "isMandatory";
    public static final String ATTRIBUTE_macroDatatype = "macroDatatype";
    public static final String ATTRIBUTE_filterRefColumn = "filterRefColumn";
    public static final String ATTRIBUTE_filterType = "filterType";

    public TableParameterElem(XmlAttributeGroup attributes) {
        super(ELEMENT_NAME, attributes);
    }

    public TableParameterElem(TableParametersImportRules tableParametersRules, VendorAccessResultSetValues resultSetValueRetrieval, Database.EVendorType vendorType) {
        super(ELEMENT_NAME, resultSetValueRetrieval.stringValue(tableParametersRules.descriptionRecordIndex()), resultSetValueRetrieval.stringValue(tableParametersRules.nameRecordIndex()), true);
        int datatypeRecordIndex = tableParametersRules.datatypeIndex();
        int dataType = resultSetValueRetrieval.intValue(datatypeRecordIndex);
        String jdbcSqlType = SqlColumnObjectElem.getJdbcSqlType(dataType);
        this.addAttribute(ATTRIBUTE_datatype, jdbcSqlType);
        String macroDatatype = null;
        switch (dataType) {
            case 4: {
                macroDatatype = "integer";
                break;
            }
            case 3: {
                macroDatatype = "decimal";
                break;
            }
            case 6: 
            case 8: {
                macroDatatype = "double";
                break;
            }
            case 91: {
                macroDatatype = "date";
                break;
            }
            case 92: {
                macroDatatype = "time";
                break;
            }
            case 93: {
                macroDatatype = "timestamp";
                break;
            }
            default: {
                macroDatatype = "string";
            }
        }
        this.addOptionalAttribute(ATTRIBUTE_macroDatatype, macroDatatype);
        this.addOptionalAttribute(ATTRIBUTE_precision, resultSetValueRetrieval.stringValue(tableParametersRules.precisionIndex()));
        this.addOptionalAttribute(ATTRIBUTE_scale, resultSetValueRetrieval.stringValue(tableParametersRules.scaleIndex()));
        String category = resultSetValueRetrieval.stringValue(tableParametersRules.categoryIndex());
        this.addOptionalAttribute(ATTRIBUTE_category, category);
        this.addOptionalAttribute(ATTRIBUTE_isMandatory, resultSetValueRetrieval.stringValue(tableParametersRules.isMandatoryIndex()));
        if (category.equals("V")) {
            this.addOptionalAttribute(ATTRIBUTE_filterRefColumn, resultSetValueRetrieval.stringValue(tableParametersRules.filterColumnIndex()));
            this.addOptionalAttribute(ATTRIBUTE_filterType, resultSetValueRetrieval.stringValue(tableParametersRules.filterTypeIndex()));
        }
    }

    @Override
    public String datatype() {
        return null;
    }

    @Override
    public Boolean hasSize() {
        return null;
    }

    @Override
    public Integer size() {
        return null;
    }

    @Override
    public Boolean hasPrecision() {
        return null;
    }

    @Override
    public Integer precision() {
        return null;
    }

    @Override
    public Boolean hasScale() {
        return null;
    }

    @Override
    public Integer scale() {
        return null;
    }

    @Override
    public String category() {
        return null;
    }

    @Override
    public String isMandatory() {
        return null;
    }

    @Override
    public String macroPromptDataType() {
        return null;
    }

    @Override
    protected Collection<MetadataElement> childMetadataElements() {
        return new ArrayList<MetadataElement>();
    }
}

