/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;

public class OracleSqlColumnConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String mappedType = FMColumnRule.FMDataType.unknown.toString();
        String datatype = nativeColumn.datatype();
        Integer precision = nativeColumn.precision();
        Integer scale = nativeColumn.scale();
        if ("NUMBER".equals(datatype)) {
            mappedType = null == precision ? (null != scale ? FMColumnRule.FMDataType.decimal.toString() : FMColumnRule.FMDataType.float64.toString()) : (null != scale && scale == 127 ? FMColumnRule.FMDataType.float64.toString() : (precision < 5 ? FMColumnRule.FMDataType.int16.toString() : (precision < 10 ? (null != scale && scale > precision ? FMColumnRule.FMDataType.float64.toString() : FMColumnRule.FMDataType.int32.toString()) : (precision <= 18 ? FMColumnRule.FMDataType.int64.toString() : FMColumnRule.FMDataType.decimal.toString()))));
        } else if ("LONG".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("CHARACTER".equals(datatype) || "NCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nChar.toString();
        } else if ("NVARCHAR".equals(datatype) || "NVARCHAR2".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nVarChar.toString();
        } else if ("VARCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("FLOAT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("BINARY_FLOAT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("BINARY_DOUBLE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("CHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.character.toString();
        } else if ("NCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("VARCHAR2".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("RAW".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.binaryLength16.toString();
        } else if ("LONG RAW".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.blob.toString();
        } else if ("BLOB".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.blob.toString();
        } else if ("BFILE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.blob.toString();
        } else if ("CLOB".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("NCLOB".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("ROWID".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.databaseKey.toString();
        } else if (datatype.matches("TIMESTAMP.* WITH TIME ZONE")) {
            mappedType = FMColumnRule.FMDataType.timeStampTZ.toString();
        } else if ("DATE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if (datatype.matches(".*TIMESTAMP.*")) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if (datatype.matches(".*INTERVAL YEAR.*")) {
            mappedType = FMColumnRule.FMDataType.intervalYM.toString();
        } else if (datatype.matches(".*INTERVAL DAY.*")) {
            mappedType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.matches(".*UROWID.*")) {
            mappedType = FMColumnRule.FMDataType.binary.toString();
        }
        return mappedType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer mappedLength = nativeColumn.size();
        Integer precision = nativeColumn.precision();
        String datatype = nativeColumn.datatype();
        if ("DATE".equals(datatype)) {
            mappedLength = 12;
        } else if ("FLOAT".equals(datatype)) {
            mappedLength = 8;
        } else if ("NUMBER".equals(datatype) && null != mappedLength) {
            if (22 == mappedLength) {
                Integer scale = nativeColumn.scale();
                mappedLength = null != scale && 127 == scale ? Integer.valueOf(8) : (null == precision ? Integer.valueOf(null == scale ? 8 : 20) : (precision < 5 ? Integer.valueOf(2) : (precision < 10 ? (null != scale && scale > precision ? Integer.valueOf(8) : Integer.valueOf(4)) : (precision <= 18 ? Integer.valueOf(8) : Integer.valueOf(precision / 2 + 1)))));
            }
        } else if ("CHAR".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("VARCHAR".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("VARCHAR2".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("CLOB".equals(datatype)) {
            mappedLength = 4;
        } else if ("NCLOB".equals(datatype)) {
            mappedLength = 4;
        } else if ("NCHAR".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : mappedLength + 2;
        } else if ("NVARCHAR2".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : mappedLength + 2;
        } else if ("BLOB".equals(datatype)) {
            mappedLength = 4;
        } else if ("BINARY_DOUBLE".equals(datatype)) {
            mappedLength = 8;
        } else if ("BINARY_FLOAT".equals(datatype)) {
            mappedLength = 8;
        } else if ("BFILE".equals(datatype)) {
            mappedLength = 4;
        } else if ("LONG".equals(datatype)) {
            mappedLength = 4;
        } else if ("ROWID".equals(datatype)) {
            mappedLength = 19;
        } else if ("RAW".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : mappedLength + 2;
        } else if ("LONG RAW".equals(datatype)) {
            mappedLength = 4;
        } else if (datatype.matches("TIMESTAMP.* WITH TIME ZONE")) {
            mappedLength = 16;
        } else if (datatype.matches(".*TIMESTAMP.*")) {
            mappedLength = 12;
        } else if (datatype.matches(".*INTERVAL YEAR.*")) {
            mappedLength = 12;
        } else if (datatype.matches(".*INTERVAL DAY.*")) {
            mappedLength = 24;
        } else if (datatype.matches(".*UROWID.*")) {
            mappedLength = 12;
        }
        return mappedLength;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedPrecision = nativeColumn.size();
        String datatype = nativeColumn.datatype();
        if ("DATE".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("NUMBER".equals(datatype)) {
            Integer precision = nativeColumn.precision();
            mappedPrecision = precision == null ? Integer.valueOf(nativeColumn.scale() == null ? 0 : 38) : Integer.valueOf(precision > 18 ? precision : 0);
        } else if ("FLOAT".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("BINARY_FLOAT".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("BINARY_DOUBLE".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("BLOB".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("BFILE".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("CLOB".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("NCLOB".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("NCHAR".equals(datatype)) {
            mappedPrecision = null == mappedPrecision ? 0 : mappedPrecision / 2;
        } else if ("NVARCHAR2".equals(datatype)) {
            mappedPrecision = null == mappedPrecision ? 0 : mappedPrecision / 2;
        } else if ("LONG".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("RAW".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("LONG RAW".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("ROWID".equals(datatype)) {
            mappedPrecision = 0;
        } else if (datatype.matches(".*TIMESTAMP.*")) {
            mappedPrecision = 0;
        } else if (datatype.matches(".*INTERVAL YEAR.*")) {
            mappedPrecision = 48;
        } else if (datatype.matches(".*INTERVAL DAY.*")) {
            mappedPrecision = 15;
        }
        return mappedPrecision == null ? 0 : mappedPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        Integer mappedScale = nativeColumn.scale();
        String datatype = nativeColumn.datatype();
        if ("NUMBER".equals(datatype)) {
            if (null != mappedScale && mappedScale == 127) {
                mappedScale = 0;
            }
        } else if (datatype.matches(".*TIMESTAMP.*")) {
            mappedScale = 0;
        } else if (datatype.matches(".*INTERVAL.*")) {
            mappedScale = 0;
        }
        return mappedScale == null ? 0 : mappedScale;
    }
}

