/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;

public class SqlServerSqlColumnConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String mappedType = FMColumnRule.FMDataType.unknown.toString();
        String datatype = nativeColumn.datatype();
        if ("int".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int32.toString();
        } else if ("smallint".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int16.toString();
        } else if ("tinyint".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int16.toString();
        } else if ("bit".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int16.toString();
        } else if ("float".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("datetime".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if ("smalldatetime".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if ("numeric".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("decimal".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("text".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("ntext".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("bigint".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int64.toString();
        } else if ("money".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("smallmoney".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("image".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.blob.toString();
        } else if ("sql_variant".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("real".equals(datatype)) {
            if (this.sqlColumnMatch(nativeColumn, null, 24, null)) {
                mappedType = FMColumnRule.FMDataType.float32.toString();
            }
        } else if ("char".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.character.toString();
        } else if ("nchar".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nChar.toString();
        } else if ("uniqueidentifier".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("xml".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("timestamp".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.binary.toString();
        } else if ("nvarchar".equals(datatype) || "varchar".equals(datatype)) {
            mappedType = this.sqlColumnMatch(nativeColumn, -1, null, null) ? FMColumnRule.FMDataType.textBlob.toString() : ("nvarchar".equals(datatype) ? FMColumnRule.FMDataType.nVarChar.toString() : FMColumnRule.FMDataType.characterLength16.toString());
        } else if ("varbinary".equals(datatype)) {
            mappedType = this.sqlColumnMatch(nativeColumn, -1, null, null) ? FMColumnRule.FMDataType.blob.toString() : FMColumnRule.FMDataType.binaryLength16.toString();
        } else if ("binary".equals(datatype)) {
            mappedType = this.sqlColumnMatch(nativeColumn, -1, null, null) ? FMColumnRule.FMDataType.blob.toString() : FMColumnRule.FMDataType.binary.toString();
        } else if ("date".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.date.toString();
        } else if ("time".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.time.toString();
        } else if ("datetime2".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if ("datetimeoffset".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.timeStampTZ.toString();
        }
        return mappedType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer mappedSize = null;
        Integer precision = nativeColumn.precision();
        Integer length = nativeColumn.size();
        Integer scale = nativeColumn.scale();
        String datatype = nativeColumn.datatype();
        if ("char".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : (length + 1) * 2;
        } else if ("nchar".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : (length + 1) * 2;
        } else if ("varchar".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : (length + 1) * 2;
        } else if ("nvarchar".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : (length + 1) * 2;
        } else if ("numeric".equals(datatype)) {
            mappedSize = null == precision ? null : Integer.valueOf(precision / 2 + 1);
        } else if ("smallint".equals(datatype)) {
            mappedSize = 2;
        } else if ("tinyint".equals(datatype)) {
            mappedSize = 2;
        } else if ("int".equals(datatype)) {
            mappedSize = 4;
        } else if ("bigint".equals(datatype)) {
            mappedSize = 8;
        } else if ("float".equals(datatype)) {
            mappedSize = 8;
        } else if ("decimal".equals(datatype) && null != precision) {
            mappedSize = precision / 2 + 1;
        } else if ("real".equals(datatype)) {
            mappedSize = 4;
        } else if ("smallmoney".equals(datatype) && null != precision && null != scale) {
            if (precision == 10 && scale == 4) {
                mappedSize = 6;
            }
        } else if ("money".equals(datatype) && null != precision && null != scale) {
            if (precision == 19 && scale == 4) {
                mappedSize = 10;
            }
        } else if ("datetime".equals(datatype)) {
            mappedSize = 12;
        } else if ("date".equals(datatype)) {
            mappedSize = 4;
        } else if ("time".equals(datatype)) {
            mappedSize = 8;
        } else if ("datetime2".equals(datatype)) {
            mappedSize = 12;
        } else if ("datetimeoffset".equals(datatype)) {
            mappedSize = 16;
        } else if ("smalldatetime".equals(datatype)) {
            mappedSize = 12;
        } else if ("text".equals(datatype)) {
            mappedSize = 4;
        } else if ("ntext".equals(datatype)) {
            mappedSize = 4;
        } else if ("bit".equals(datatype)) {
            mappedSize = 2;
        } else if ("binary".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : length;
        } else if ("timestamp".equals(datatype)) {
            mappedSize = 8;
        } else if ("varbinary".equals(datatype)) {
            mappedSize = null == length || -1 == length ? 4 : nativeColumn.size() + 2;
        } else if ("sql_variant".equals(datatype)) {
            mappedSize = 514;
        } else if ("image".equals(datatype)) {
            mappedSize = 4;
        } else if ("xml".equals(datatype)) {
            mappedSize = 4;
        } else if ("uniqueidentifier".equals(datatype)) {
            mappedSize = 78;
        }
        return mappedSize;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedPrecision = nativeColumn.size();
        String datatype = nativeColumn.datatype();
        if ("numeric".equals(datatype) || "decimal".equals(datatype) || "money".equals(datatype) || "smallmoney".equals(datatype)) {
            mappedPrecision = nativeColumn.precision();
        } else if ("char".equals(datatype) || "nchar".equals(datatype) || "varchar".equals(datatype) || "nvarchar".equals(datatype)) {
            if (null != mappedPrecision && -1 == mappedPrecision) {
                mappedPrecision = 0;
            }
        } else if ("uniqueidentifier".equals(datatype)) {
            mappedPrecision = 38;
        } else if ("binary".equals(datatype) || "varbinary".equals(datatype) || "text".equals(datatype) || "ntext".equals(datatype) || "real".equals(datatype) || "image".equals(datatype) || "xml".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("sql_variant".equals(datatype)) {
            mappedPrecision = 256;
        } else if ("date".equals(datatype) || "time".equals(datatype) || "datetime2".equals(datatype) || "datetimeoffset".equals(datatype)) {
            return null;
        }
        return mappedPrecision == null ? 0 : mappedPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        Integer mappedScale = 0;
        String datatype = nativeColumn.datatype();
        if ("numeric".equals(datatype)) {
            mappedScale = nativeColumn.scale();
        } else if ("decimal".equals(datatype)) {
            mappedScale = nativeColumn.scale();
        } else if ("money".equals(datatype)) {
            mappedScale = 4;
        } else if ("smallmoney".equals(datatype)) {
            mappedScale = 4;
        } else if ("date".equals(datatype) || "time".equals(datatype) || "datetime2".equals(datatype) || "datetimeoffset".equals(datatype)) {
            return null;
        }
        return mappedScale;
    }

    private boolean sqlColumnMatch(SqlColumn column, Integer length, Integer precision, Integer scale) {
        boolean lengthMatch = this.numericPropMatch(length, column.size());
        boolean precisionMatch = this.numericPropMatch(precision, column.precision());
        boolean scaleMatch = this.numericPropMatch(scale, column.scale());
        return lengthMatch && precisionMatch && scaleMatch;
    }

    private boolean numericPropMatch(Integer expectedValue, Integer actualValue) {
        return actualValue == null ? expectedValue == null || expectedValue == -1 : expectedValue == actualValue;
    }
}

