/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.xml;

import com.ibm.cognos.internal.relmd.metadata.RelationalMetadataElem;
import com.ibm.cognos.internal.relmd.metadata._schema.CatalogElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ColumnElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ColumnRefElement;
import com.ibm.cognos.internal.relmd.metadata._schema.DatabaseElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ForeignKeyElem;
import com.ibm.cognos.internal.relmd.metadata._schema.IndexElem;
import com.ibm.cognos.internal.relmd.metadata._schema.IndexedColumnRefElem;
import com.ibm.cognos.internal.relmd.metadata._schema.RoutineArgumentElem;
import com.ibm.cognos.internal.relmd.metadata._schema.RoutineArgumentNestingAdapterElem;
import com.ibm.cognos.internal.relmd.metadata._schema.RoutineElem;
import com.ibm.cognos.internal.relmd.metadata._schema.RoutineSignatureElem;
import com.ibm.cognos.internal.relmd.metadata._schema.SchemaElem;
import com.ibm.cognos.internal.relmd.metadata._schema.SynonymElem;
import com.ibm.cognos.internal.relmd.metadata._schema.TableElem;
import com.ibm.cognos.internal.relmd.metadata._schema.TableParameterElem;
import com.ibm.cognos.internal.relmd.metadata._schema.UniqueKeyElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ViewElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlContentHandler;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.Argument;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.elements.NestedArgument;
import com.ibm.cognos.relmd.metadata._schema.elements.Signature;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainer;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.RoutineArgumentBase;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataSourceSelectionsFilter;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.MetadataSourceSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelectionsContainer;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import java.util.Collection;
import java.util.Stack;

public class ModelObjectContentHandler
implements XmlContentHandler {
    private UniqueKeyElem m_uniqueKey;
    private ForeignKeyElem m_foreignKey;
    private IndexElem m_index;
    private RoutineSignatureElem m_routineSignature;
    private Stack<RoutineArgumentBase> m_routineArgumentStack = new Stack();
    private Table m_table;
    private ColumnContainer m_tabular;
    private View m_view;
    private MetadataObjectSelections m_objectSelectionsFilter = null;
    private Database m_database;
    private SchemaSelectionsContainer m_currentSchemaContainerSelection;
    private SchemaSelection m_currentSchemaSelection;
    private final MetadataObjectHandler m_modelObjectHandler;
    private MetadataSourceSelections m_currentImportSource;
    private boolean m_currentSchemaSelectionHandled = false;
    private MetadataSourceSelectionsFilter m_filter = null;
    private final XmlContentHandler.EElementRule m_elementRule;
    private Catalog m_currentCatalog;
    private SchemaElem m_currentSchema;
    private RoutineElem m_routine;

    public ModelObjectContentHandler(MetadataSourceSelectionsFilter filter, XmlContentHandler.EElementRule elementRule, MetadataObjectHandler modelObjectHandler) {
        this.m_elementRule = elementRule;
        this.m_modelObjectHandler = modelObjectHandler;
        this.m_currentImportSource = null;
        this.m_filter = filter;
    }

    @Override
    public XmlContentHandler.EElementRule elementBegin(String tagName, XmlAttributeGroup attributeGroup) {
        XmlContentHandler.EElementRule status = XmlContentHandler.EElementRule.accept;
        if (XmlContentHandler.EElementRule.accept.equals((Object)status)) {
            if ("relationalMetadata".equals(tagName)) {
                RelationalMetadataElem m_model = new RelationalMetadataElem(attributeGroup);
                this.m_modelObjectHandler.handleMetadata(m_model);
            } else if ("database".equals(tagName)) {
                this.m_database = new DatabaseElem(attributeGroup);
                if (this.m_filter == null) {
                    this.m_modelObjectHandler.handleDatabase(this.m_database);
                } else {
                    this.m_objectSelectionsFilter = null;
                    this.m_currentSchemaContainerSelection = null;
                    this.m_currentSchemaSelection = null;
                    this.m_currentImportSource = this.m_filter.findImportSource(this.m_database);
                    if (this.m_currentImportSource != null) {
                        this.m_objectSelectionsFilter = this.m_currentImportSource.metadataSelections();
                        this.m_currentSchemaContainerSelection = this.m_objectSelectionsFilter;
                    }
                }
            } else if ("catalog".equals(tagName)) {
                this.m_currentCatalog = new CatalogElem(attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_modelObjectHandler.handleCatalog(this.m_currentCatalog);
                } else {
                    this.m_currentSchemaContainerSelection = null;
                    this.m_currentSchemaSelection = null;
                    ReferenceableSet<CatalogSelection> selectedCatalogCollection = this.m_objectSelectionsFilter.catalogSelections().selectedObjects();
                    if (selectedCatalogCollection.size() > 0) {
                        this.m_currentSchemaContainerSelection = selectedCatalogCollection.find(this.m_currentCatalog);
                    }
                }
            } else if ("schema".equals(tagName)) {
                this.m_currentSchema = new SchemaElem(attributeGroup);
                if (this.m_currentSchemaContainerSelection == null) {
                    this.m_modelObjectHandler.handleSchema(this.m_currentSchema);
                } else {
                    this.m_currentSchemaSelectionHandled = false;
                    ReferenceableSet<SchemaSelection> schemaSelections = this.m_currentSchemaContainerSelection.schemaSelections().selectedObjects();
                    this.m_currentSchemaSelection = schemaSelections.find(this.m_currentSchema);
                }
            } else if ("table".equals(tagName)) {
                TableElem table = new TableElem(tagName, attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_table = table;
                    this.m_tabular = this.m_table;
                } else {
                    status = this.checkObjectSelectionsFilter(table);
                    if (!XmlContentHandler.EElementRule.reject.equals((Object)status)) {
                        this.issueHandleSchema();
                        this.m_table = table;
                        this.m_tabular = this.m_table;
                    }
                }
            } else if ("view".equals(tagName)) {
                ViewElem view = new ViewElem(tagName, attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_view = view;
                    this.m_tabular = this.m_view;
                } else {
                    status = this.checkObjectSelectionsFilter(view);
                    if (!XmlContentHandler.EElementRule.reject.equals((Object)status)) {
                        this.issueHandleSchema();
                        this.m_view = view;
                        this.m_tabular = this.m_view;
                    }
                }
            } else if ("synonym".equals(tagName)) {
                SynonymElem synonym = new SynonymElem(attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_modelObjectHandler.handleSynonym(synonym);
                } else {
                    status = this.checkObjectSelectionsFilter(synonym);
                    if (!XmlContentHandler.EElementRule.reject.equals((Object)status)) {
                        this.issueHandleSchema();
                        this.m_modelObjectHandler.handleSynonym(synonym);
                    }
                }
            } else if ("storedProcedure".equals(tagName)) {
                RoutineElem routine = new RoutineElem(tagName, attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_routine = routine;
                } else {
                    status = this.checkObjectSelectionsFilter(routine);
                    if (!XmlContentHandler.EElementRule.reject.equals((Object)status)) {
                        this.issueHandleSchema();
                        this.m_routine = routine;
                    }
                }
            } else if ("userDefinedFunction".equals(tagName)) {
                RoutineElem routine = new RoutineElem(tagName, attributeGroup);
                if (this.m_objectSelectionsFilter == null) {
                    this.m_routine = routine;
                } else {
                    status = this.checkObjectSelectionsFilter(routine);
                    if (!XmlContentHandler.EElementRule.reject.equals((Object)status)) {
                        this.issueHandleSchema();
                        this.m_routine = routine;
                    }
                }
            } else if ("column".equals(tagName)) {
                ColumnElem column = new ColumnElem(attributeGroup);
                ReferenceableSet<Column> columns = this.m_tabular.columnsSet();
                columns.add(column);
            } else if ("inputParameter".equals(tagName)) {
                TableParameterElem param = new TableParameterElem(attributeGroup);
                ReferenceableSet<TableParameter> tParameters = this.m_tabular.tableParametersSet();
                tParameters.add(param);
            } else if ("uniqueKey".equals(tagName)) {
                this.m_uniqueKey = new UniqueKeyElem(attributeGroup);
                ReferenceableSet<UniqueKey> uniqueKeys = this.m_table.uniqueKeysSet();
                uniqueKeys.add(this.m_uniqueKey);
            } else if ("uniqueKeyColumnRef".equals(tagName)) {
                ColumnRefElement uniqueKeyColumnRef = new ColumnRefElement(tagName, attributeGroup);
                this.m_uniqueKey.uniqueKeyColumnRefsCollection().add(uniqueKeyColumnRef);
            } else if ("foreignKey".equals(tagName)) {
                this.m_foreignKey = new ForeignKeyElem(attributeGroup);
                Collection<ForeignKey> foreignKeys = this.m_table.foreignKeysCollection();
                foreignKeys.add(this.m_foreignKey);
            } else if ("exportedColumnRef".equals(tagName)) {
                ColumnRefElement exportedColumnRef = new ColumnRefElement(tagName, attributeGroup);
                this.m_foreignKey.exportedColumnRefsCollection().add(exportedColumnRef);
            } else if ("index".equals(tagName)) {
                this.m_index = new IndexElem(attributeGroup);
                Collection<Index> indexes = this.m_table.indexesCollection();
                indexes.add(this.m_index);
            } else if ("indexedColumnRef".equals(tagName)) {
                IndexedColumnRefElem indexedColumnRef = new IndexedColumnRefElem(attributeGroup);
                this.m_index.indexedColumnRefsCollection().add(indexedColumnRef);
            } else if ("signature".equals(tagName)) {
                this.m_routineSignature = new RoutineSignatureElem();
                Collection<Signature> routineSignatureCollection = this.m_routine.routineSignaturesCollection();
                routineSignatureCollection.add(this.m_routineSignature);
            } else if ("argument".equals(tagName)) {
                RoutineArgumentElem routineArgument = new RoutineArgumentElem(attributeGroup);
                Collection<Argument> routineArgumentCollection = this.m_routineSignature.routineArgumentsCollection();
                routineArgumentCollection.add(routineArgument);
                this.m_routineArgumentStack.push(routineArgument);
            } else if ("nestedArgument".equals(tagName)) {
                RoutineArgumentElem routineArgument = new RoutineArgumentElem(attributeGroup);
                RoutineArgumentNestingAdapterElem nestedRoutineArgument = new RoutineArgumentNestingAdapterElem(routineArgument);
                RoutineArgumentBase nestedRoutineArgumentParent = this.m_routineArgumentStack.peek();
                Collection<NestedArgument> nestedRoutineArgumentCollection = nestedRoutineArgumentParent.nestedArgumentsCollection();
                nestedRoutineArgumentCollection.add(nestedRoutineArgument);
                this.m_routineArgumentStack.push(nestedRoutineArgument);
            }
        }
        return status;
    }

    private void issueHandleSchema() {
        if (this.m_currentImportSource != null && !this.m_currentSchemaSelectionHandled) {
            this.m_modelObjectHandler.handleDatabase(this.m_database);
            if (this.m_currentCatalog != null) {
                this.m_modelObjectHandler.handleCatalog(this.m_currentCatalog);
            }
            this.m_modelObjectHandler.handleSchema(this.m_currentSchema);
            this.m_currentSchemaSelectionHandled = true;
        }
    }

    private XmlContentHandler.EElementRule checkObjectSelectionsFilter(Referenceable objectRef) {
        XmlContentHandler.EElementRule tempstatus = XmlContentHandler.EElementRule.accept;
        TableSelection foundObjectSelection = null;
        if (this.m_currentSchemaSelection != null) {
            ReferenceableSet<TableSelection> selectionCollection = this.m_currentSchemaSelection.tableSelections().selectedObjects();
            if (selectionCollection.size() > 0) {
                String objectName = objectRef.objectName();
                foundObjectSelection = selectionCollection.find(objectName);
                if (XmlContentHandler.EElementRule.accept.equals((Object)this.m_elementRule) && null == foundObjectSelection || XmlContentHandler.EElementRule.reject.equals((Object)this.m_elementRule) && null != foundObjectSelection) {
                    tempstatus = XmlContentHandler.EElementRule.reject;
                }
            } else {
                tempstatus = XmlContentHandler.EElementRule.accept.equals((Object)this.m_elementRule) ? XmlContentHandler.EElementRule.reject : XmlContentHandler.EElementRule.accept;
            }
        }
        return tempstatus;
    }

    @Override
    public void elementEnd(String tagName) {
        if ("table".equals(tagName)) {
            this.m_modelObjectHandler.handleTable(this.m_table);
        } else if ("view".equals(tagName)) {
            this.m_modelObjectHandler.handleView(this.m_view);
            this.m_tabular = null;
        } else if ("uniqueKey".equals(tagName)) {
            this.m_uniqueKey = null;
        } else if ("foreignKey".equals(tagName)) {
            this.m_foreignKey = null;
        } else if ("index".equals(tagName)) {
            this.m_index = null;
        } else if ("storedProcedure".equals(tagName)) {
            this.m_modelObjectHandler.handleStoredProcedure(this.m_routine);
            this.m_routine = null;
        } else if ("userDefinedFunction".equals(tagName)) {
            this.m_modelObjectHandler.handleUserDefinedFunction(this.m_routine);
            this.m_routine = null;
        } else if ("signature".equals(tagName)) {
            this.m_routineSignature = null;
        } else if ("argument".equals(tagName) || "nestedArgument".equals(tagName)) {
            this.m_routineArgumentStack.pop();
        } else if ("database".equals(tagName)) {
            this.m_database = null;
        } else if ("relationalMetadata".equals(tagName)) {
            this.m_modelObjectHandler.done();
        }
    }

    @Override
    public void elementText(String text) {
    }
}

