/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.browse;

import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseObject;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.jdbc.adaptor.util.LoggingProxyBuilder;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseRules;
import com.ibm.cognos.relmd.metadata.browse._handlers.BrowsedObjectHandler;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.functions.CatalogsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.FunctionsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ProceduresBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SchemasBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SynonymsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.TablesBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.ViewsBrowse;
import com.ibm.cognos.relmd.metadata.browse.rules.query.BrowseRule;
import com.ibm.cognos.relmd.metadata.browse.rules.query.BrowsedObject;
import com.ibm.cognos.relmd.metadata.browse.rules.systemObjects.SystemObjectsLookup;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.DatabaseAccessRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.DatabaseAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessRule;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class BrowseFunction
extends RelmdElement
implements CatalogsBrowse,
SchemasBrowse,
TablesBrowse,
ViewsBrowse,
ColumnsBrowse,
SynonymsBrowse,
ProceduresBrowse,
FunctionsBrowse {
    private final IBrowseFunctionDelegate delegate;
    private static final String loggingClassName = BrowseFunction.class.getSimpleName();

    public BrowseFunction(Element elem) {
        super(elem);
        this.delegate = RelmdLoggerFactory.isLoggingEnabled(loggingClassName) ? new BrowseFunctionLogger(elem) : new BrowseFunctionImpl(elem);
    }

    public BrowseFunction(BrowseMetadataFunction.EBrowseFunctionType browseFunctionType, String parentCatalogName, String parentSchemaName, String parentObjectName, BrowseQueryType.EQueryType eQueryType) {
        super(browseFunctionType.toString());
        this.delegate = RelmdLoggerFactory.isLoggingEnabled(loggingClassName) ? new BrowseFunctionLogger(browseFunctionType, parentCatalogName, parentSchemaName, parentObjectName, eQueryType) : new BrowseFunctionImpl(browseFunctionType, parentCatalogName, parentSchemaName, parentObjectName, eQueryType);
    }

    @Override
    public void run(VendorAccessConnection connection, MetadataBrowseRules browseRules, BrowsedObjectHandler browseResultHandler) {
        this.delegate.run(connection, browseRules, browseResultHandler);
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.delegate.setVendorType(vendorType);
    }

    @Override
    public BrowseQueryType.EQueryType queryType() {
        return this.delegate.queryType();
    }

    @Override
    public boolean hasParentCatalog() {
        return this.delegate.hasParentCatalog();
    }

    @Override
    public String parentCatalogName() {
        return this.delegate.parentCatalogName();
    }

    @Override
    public String parentSchemaName() {
        return this.delegate.parentSchemaName();
    }

    @Override
    public String parentObjectName() {
        return this.delegate.parentObjectName();
    }

    private class BrowseFunctionImpl
    implements IBrowseFunctionDelegate {
        private final BrowseMetadataFunction.EBrowseFunctionType m_browseFunctionType;
        private Database.EVendorType m_vendorType;
        String[] m_table_tableTypes;

        public BrowseFunctionImpl(Element elem) {
            String tagName = BrowseFunction.this.getTagName();
            this.m_browseFunctionType = BrowseMetadataFunction.EBrowseFunctionType.valueOf(tagName);
        }

        public BrowseFunctionImpl(BrowseMetadataFunction.EBrowseFunctionType browseFunctionType, String parentCatalogName, String parentSchemaName, String parentObjectName, BrowseQueryType.EQueryType eQueryType) {
            this.m_browseFunctionType = browseFunctionType;
            BrowseFunction.this.addOptionalAttribute("parentCatalogName", parentCatalogName);
            BrowseFunction.this.addOptionalAttribute("parentSchemaName", parentSchemaName);
            BrowseFunction.this.addOptionalAttribute("parentObjectName", parentObjectName);
            if (!BrowseQueryType.EQueryType.regular.equals((Object)eQueryType)) {
                BrowseFunction.this.addAttribute("browseQueryType", eQueryType.toString());
            }
        }

        @Override
        public boolean hasParentCatalog() {
            String parentCatalogName = this.parentCatalogName();
            return parentCatalogName != null;
        }

        @Override
        public String parentCatalogName() {
            return BrowseFunction.this.attributeValue("parentCatalogName");
        }

        @Override
        public String parentSchemaName() {
            return BrowseFunction.this.attributeValue("parentSchemaName");
        }

        @Override
        public String parentObjectName() {
            return BrowseFunction.this.attributeValue("parentObjectName");
        }

        @Override
        public BrowseQueryType.EQueryType queryType() {
            String queryTypeValue = BrowseFunction.this.attributeValue("browseQueryType");
            BrowseQueryType.EQueryType queryType = queryTypeValue == null ? BrowseQueryType.EQueryType.regular : BrowseQueryType.EQueryType.valueOf(queryTypeValue);
            return queryType;
        }

        @Override
        public void run(VendorAccessConnection connection, MetadataBrowseRules browseRules, BrowsedObjectHandler browseResultHandler) {
            if (null != this.m_vendorType && this.m_vendorType == Database.EVendorType.local) {
                return;
            }
            if (null != this.m_vendorType && this.m_vendorType == Database.EVendorType.generic) {
                this.genericBrowse(connection, browseRules, browseResultHandler);
            } else {
                SystemObjectsLookup systemObjectsLookup;
                VendorAccess dbAccess;
                BrowseRule browseRule = this.getBrowseRule(browseRules);
                if (browseRule != null && (dbAccess = this.getDatabaseAccessFunction(browseRule, systemObjectsLookup = browseRules.systemObjectsLookup())) != null) {
                    VendorAccessResultSet resultSet = this.runQuery(connection, dbAccess);
                    VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                    while (resultSetIterator.next()) {
                        VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                        String name = resultSetValueRetrieval.stringValue(1);
                        String description = resultSetValueRetrieval.stringValue(2);
                        BrowseObject browseObject = new BrowseObject(name, description);
                        browseResultHandler.handleBrowsedObject(browseObject);
                    }
                }
                browseResultHandler.done();
            }
        }

        private VendorAccess getDatabaseAccessFunction(BrowseRule browseRule, SystemObjectsLookup systemObjectsLookup) {
            VendorAccess dbAccess = null;
            BrowseQueryType.EQueryType queryType = this.queryType();
            switch (queryType) {
                case systemObjects: {
                    String parentCatalogName = this.parentCatalogName();
                    String parentSchemaName = this.parentSchemaName();
                    if (BrowseMetadataFunction.EBrowseFunctionType.columnsBrowse.equals((Object)this.m_browseFunctionType) || systemObjectsLookup.isSystemCatalog(parentCatalogName) || systemObjectsLookup.isSystemSchema(parentSchemaName)) {
                        dbAccess = browseRule.allObjectsQuery();
                        break;
                    }
                    dbAccess = browseRule.systemObjectsQuery();
                    break;
                }
                default: {
                    dbAccess = browseRule.userObjectsQuery();
                }
            }
            return dbAccess;
        }

        private VendorAccessResultSet runQuery(VendorAccessConnection relmdConnection, VendorAccess dbAccess) {
            VendorAccessResultSet resultSet = null;
            VendorAccessRule.EGranularity granularity = dbAccess.getGranularity();
            switch (granularity) {
                case sql: {
                    resultSet = dbAccess.runDatabaseLevel(relmdConnection);
                    break;
                }
                case catalogGrainSql: {
                    resultSet = dbAccess.runCatalogLevel(relmdConnection, this.parentCatalogName());
                    break;
                }
                case schemaGrainSql: {
                    resultSet = dbAccess.runSchemaLevel(relmdConnection, this.parentCatalogName(), this.parentSchemaName());
                    break;
                }
                case objectGrainSql: {
                    resultSet = dbAccess.runObjectLevel(relmdConnection, this.parentCatalogName(), this.parentSchemaName(), this.parentObjectName());
                }
            }
            return resultSet;
        }

        private BrowseRule getBrowseRule(MetadataBrowseRules browseRules) {
            BrowseRule browseRule = null;
            switch (this.m_browseFunctionType) {
                case catalogsBrowse: {
                    browseRule = browseRules.catalogsBrowseRules();
                    break;
                }
                case schemasBrowse: {
                    browseRule = browseRules.schemasBrowseRules();
                    break;
                }
                case tablesBrowse: {
                    browseRule = browseRules.tablesBrowseRules();
                    break;
                }
                case viewsBrowse: {
                    browseRule = browseRules.viewsBrowseRules();
                    break;
                }
                case columnsBrowse: {
                    browseRule = browseRules.columnsBrowseRules();
                    break;
                }
                case synonymsBrowse: {
                    browseRule = browseRules.synonymsBrowseRules();
                    break;
                }
                case synonymColumnsBrowse: {
                    browseRule = browseRules.synonymColumnsBrowseRules();
                    break;
                }
                case proceduresBrowse: {
                    browseRule = browseRules.proceduresBrowseRules();
                    break;
                }
                case functionsBrowse: {
                    browseRule = browseRules.functionsBrowseRules();
                }
            }
            return browseRule;
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
            this.m_vendorType = vendorType;
        }

        @Override
        public Database.EVendorType vendorType() {
            return this.m_vendorType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void genericBrowse(VendorAccessConnection vendorAccessConnection, MetadataBrowseRules browseRules, BrowsedObjectHandler browseResultHandler) {
            VendorAccessHandler vendorAccessHandler = vendorAccessConnection.vendorAccessHandler();
            Connection connection = vendorAccessConnection.jdbcConnection();
            Statement statement = null;
            ResultSet sqlResultSet = null;
            try {
                RelmdResultSet resultSet = null;
                statement = connection.createStatement();
                DatabaseMetaData md = connection.getMetaData();
                TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
                String catalogName = this.parentCatalogName();
                String schemaName = this.parentSchemaName();
                String objectName = this.parentObjectName();
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                String escapedSchemaName = escapeObject.escape(schemaName);
                String escapedObjectName = escapeObject.escape(objectName);
                BrowseQueryType.EQueryType queryType = this.queryType();
                switch (this.m_browseFunctionType) {
                    case catalogsBrowse: {
                        sqlResultSet = md.getCatalogs();
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleCatalogResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case schemasBrowse: {
                        sqlResultSet = catalogName != null && !catalogName.isEmpty() ? md.getSchemas(catalogName, null) : md.getSchemas();
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleSchemaResultSet(resultSet, browseResultHandler, this.parentCatalogName());
                        return;
                    }
                    case tablesBrowse: {
                        sqlResultSet = md.getTables(catalogName, escapedSchemaName, null, this.getTableTableTypes(md));
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleGetTablesResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case viewsBrowse: {
                        String[] view_tableTypes = tableTypeMapper.defaultView_tableTypes;
                        if (queryType.equals((Object)BrowseQueryType.EQueryType.regular)) {
                            if (md instanceof IAdaptorDBMetadata) {
                                view_tableTypes = tableTypeMapper.getListOfView_TableTypes();
                            }
                        } else if (queryType.equals((Object)BrowseQueryType.EQueryType.systemObjects)) {
                            view_tableTypes = tableTypeMapper.defaultSystemView_tableTypes;
                            if (md instanceof IAdaptorDBMetadata) {
                                view_tableTypes = tableTypeMapper.getListOfSystemView_TableTypes();
                            }
                        }
                        sqlResultSet = md.getTables(catalogName, escapedSchemaName, null, view_tableTypes);
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleGetTablesResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case synonymsBrowse: {
                        if (queryType.equals((Object)BrowseQueryType.EQueryType.regular)) {
                            String[] synonym_tableTypes = tableTypeMapper.defaultSynonym_tableTypes;
                            if (md instanceof IAdaptorDBMetadata) {
                                String jdbcURL = null;
                                String JDBC_URL_PREFIX_MICROSOFT_SQLSERVER = "jdbc:sqlserver";
                                String JDBC_URL_PREFIX_ORACLE = "jdbc:oracle";
                                try {
                                    jdbcURL = md.getURL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                if (jdbcURL != null && (jdbcURL.indexOf(JDBC_URL_PREFIX_MICROSOFT_SQLSERVER) != -1 || jdbcURL.indexOf(JDBC_URL_PREFIX_ORACLE) != -1)) {
                                    sqlResultSet = ((IAdaptorDBMetadata)md).getSynonyms(catalogName, schemaName, null, synonym_tableTypes);
                                    resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                                    this.handleGetTablesResultSet(resultSet, browseResultHandler);
                                    return;
                                }
                                synonym_tableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
                            }
                            if (synonym_tableTypes != null && synonym_tableTypes.length > 0) {
                                sqlResultSet = md.getTables(catalogName, escapedSchemaName, null, synonym_tableTypes);
                            }
                        } else if (queryType.equals((Object)BrowseQueryType.EQueryType.systemObjects)) {
                            String[] systemSynonym_tableTypes = tableTypeMapper.defaultSystemSynonym_tableTypes;
                            if (md instanceof IAdaptorDBMetadata) {
                                systemSynonym_tableTypes = tableTypeMapper.getListOfSystemSynonym_TableTypes();
                            }
                            if (systemSynonym_tableTypes != null && systemSynonym_tableTypes.length > 0) {
                                sqlResultSet = md.getTables(catalogName, escapedSchemaName, null, systemSynonym_tableTypes);
                            }
                        }
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleGetTablesResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case columnsBrowse: {
                        sqlResultSet = md.getColumns(catalogName, escapedSchemaName, escapedObjectName, null);
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleColumnsResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case proceduresBrowse: {
                        if (catalogName != null && catalogName.isEmpty()) {
                            catalogName = null;
                        }
                        sqlResultSet = md.getProcedures(catalogName, escapedSchemaName, null);
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleProceduresResultSet(resultSet, browseResultHandler);
                        return;
                    }
                    case functionsBrowse: {
                        if (md instanceof IAdaptorDBMetadata) {
                            if (catalogName != null && catalogName.isEmpty()) {
                                catalogName = null;
                            }
                            sqlResultSet = ((IAdaptorDBMetadata)md).getFunctions(catalogName, escapedSchemaName, null);
                        }
                        resultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
                        this.handleProceduresResultSet(resultSet, browseResultHandler);
                        return;
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                return;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (sqlResultSet != null) {
                    try {
                        sqlResultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }

        private void handleGetTablesResultSet(VendorAccessResultSet resultSet, BrowsedObjectHandler browseResultHandler) {
            if (resultSet != null) {
                VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    String name = resultSetValueRetrieval.stringValue(3);
                    String description = resultSetValueRetrieval.stringValue(5);
                    BrowseObject browseObject = new BrowseObject(name, description);
                    browseResultHandler.handleBrowsedObject(browseObject);
                }
            }
        }

        private void handleProceduresResultSet(VendorAccessResultSet resultSet, BrowsedObjectHandler browseResultHandler) {
            if (resultSet != null) {
                VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    String name = resultSetValueRetrieval.stringValue(3);
                    String description = resultSetValueRetrieval.stringValue(7);
                    BrowseObject browseObject = new BrowseObject(name, description);
                    browseResultHandler.handleBrowsedObject(browseObject);
                }
            }
        }

        private void handleColumnsResultSet(VendorAccessResultSet resultSet, BrowsedObjectHandler browseResultHandler) {
            if (resultSet != null) {
                VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    String name = resultSetValueRetrieval.stringValue(4);
                    String description = resultSetValueRetrieval.stringValue(12);
                    BrowseObject browseObject = new BrowseObject(name, description);
                    browseResultHandler.handleBrowsedObject(browseObject);
                }
            }
        }

        String[] getTableTableTypes(DatabaseMetaData md) throws SQLException {
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            BrowseQueryType.EQueryType queryType = this.queryType();
            this.m_table_tableTypes = tableTypeMapper.defaultTable_tableTypes;
            if (this.queryType().equals((Object)BrowseQueryType.EQueryType.regular)) {
                this.m_table_tableTypes = tableTypeMapper.defaultTable_tableTypes;
                if (md instanceof IAdaptorDBMetadata) {
                    this.m_table_tableTypes = tableTypeMapper.getListOfTable_TableTypes();
                }
            } else if (queryType.equals((Object)BrowseQueryType.EQueryType.systemObjects)) {
                this.m_table_tableTypes = tableTypeMapper.defaultSystemTable_tableTypes;
                if (md instanceof IAdaptorDBMetadata) {
                    this.m_table_tableTypes = tableTypeMapper.getListOfSystemTable_TableTypes();
                }
            }
            return this.m_table_tableTypes;
        }

        private void handleCatalogResultSet(VendorAccessResultSet resultSet, BrowsedObjectHandler browseResultHandler) {
            if (resultSet != null) {
                VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    String name = resultSetValueRetrieval.stringValue(1);
                    BrowseObject browseObject = new BrowseObject(name, "");
                    browseResultHandler.handleBrowsedObject(browseObject);
                }
            }
        }

        private void handleSchemaResultSet(VendorAccessResultSet resultSet, BrowsedObjectHandler browseResultHandler, String parentCatalogName) {
            if (resultSet != null) {
                VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    String schemaName = resultSetValueRetrieval.stringValue(1);
                    String catalogName = resultSetValueRetrieval.stringValue(2);
                    if ((parentCatalogName == null || !parentCatalogName.equals(catalogName)) && parentCatalogName != null && !catalogName.isEmpty()) continue;
                    BrowseObject browseObject = new BrowseObject(schemaName, "");
                    browseResultHandler.handleBrowsedObject(browseObject);
                }
            }
        }
    }

    private class BrowseFunctionLogger
    implements IBrowseFunctionDelegate {
        private Logger logger = RelmdLoggerFactory.get(BrowseFunction.access$100());
        BrowseFunctionImpl impl;

        public BrowseFunctionLogger(Element elem) {
            Object[] parms = new Object[]{elem};
            this.logger.entering(loggingClassName, loggingClassName, parms);
            try {
                this.impl = new BrowseFunctionImpl(elem);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, loggingClassName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, loggingClassName);
        }

        public BrowseFunctionLogger(BrowseMetadataFunction.EBrowseFunctionType browseFunctionType, String parentCatalogName, String parentSchemaName, String parentObjectName, BrowseQueryType.EQueryType eQueryType) {
            Object[] parms = new Object[]{browseFunctionType, parentCatalogName, parentSchemaName, parentObjectName, eQueryType};
            this.logger.entering(loggingClassName, loggingClassName, parms);
            try {
                this.impl = new BrowseFunctionImpl(browseFunctionType, parentCatalogName, parentSchemaName, parentObjectName, eQueryType);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, loggingClassName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, loggingClassName);
        }

        @Override
        public boolean hasParentCatalog() {
            boolean result;
            String methodName = "hasParentCatalog";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.hasParentCatalog();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public String parentCatalogName() {
            String result;
            String methodName = "parentCatalogName";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.parentCatalogName();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public String parentSchemaName() {
            String result;
            String methodName = "parentSchemaName";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.parentSchemaName();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public String parentObjectName() {
            String result;
            String methodName = "parentObjectName";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.parentObjectName();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public BrowseQueryType.EQueryType queryType() {
            BrowseQueryType.EQueryType result;
            String methodName = "queryType";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.queryType();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, (Object)result);
            return result;
        }

        @Override
        public void run(VendorAccessConnection connection, MetadataBrowseRules browseRules, BrowsedObjectHandler browseResultHandler) {
            Object[] parms = new Object[]{RelmdLoggerFactory.connectionLogText(connection.jdbcConnection()), browseRules, browseResultHandler};
            String methodName = "run";
            this.logger.entering(loggingClassName, methodName, parms);
            BrowsedObjectHandlerLogger loggingResultHandler = new BrowsedObjectHandlerLogger(browseResultHandler);
            try {
                this.impl.run(new VendorAccessConnectionDelegate(connection), browseRules, loggingResultHandler);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, loggingResultHandler.logData.toString());
            RelmdLoggerFactory.flush(this.logger);
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
            Object[] parms = new Object[]{vendorType};
            String methodName = "setVendorType";
            this.logger.entering(loggingClassName, methodName, parms);
            try {
                this.impl.setVendorType(vendorType);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName);
        }

        @Override
        public Database.EVendorType vendorType() {
            Database.EVendorType result;
            String methodName = "queryType";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.vendorType();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, (Object)result);
            return result;
        }

        private class BrowsedObjectHandlerLogger
        implements BrowsedObjectHandler {
            BrowsedObjectHandler impl;
            public StringBuffer logData = new StringBuffer();

            BrowsedObjectHandlerLogger(BrowsedObjectHandler handler) {
                this.impl = handler;
                this.logData.append("<BrowseResult>\n");
            }

            @Override
            public void handleBrowsedObject(BrowsedObject browsedObject) {
                this.logData.append("  " + browsedObject.asXml());
                this.impl.handleBrowsedObject(browsedObject);
            }

            @Override
            public void done() {
                this.logData.append("</BrowseResult>\n");
                this.impl.done();
            }
        }

        private class VendorAccessConnectionDelegate
        implements VendorAccessConnection {
            VendorAccessConnection connectionDelegate;
            Connection JDBCproxy;

            public VendorAccessConnectionDelegate(VendorAccessConnection connection) {
                this.connectionDelegate = connection;
            }

            @Override
            public Connection jdbcConnection() {
                if (this.JDBCproxy == null) {
                    try {
                        this.JDBCproxy = (Connection)LoggingProxyBuilder.getProxy((Logger)BrowseFunctionLogger.this.logger, (Pattern)Pattern.compile("^(java\\.sql\\..+)|(javax\\.sql\\..+)"), (Pattern)Pattern.compile(RelmdConfiguration.getStringProperty("JDBCTraceFilter")), (Object)this.connectionDelegate.jdbcConnection());
                    }
                    catch (Exception e) {
                        this.JDBCproxy = this.connectionDelegate.jdbcConnection();
                    }
                }
                return this.JDBCproxy;
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return this.connectionDelegate.vendorAccessHandler();
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return this.connectionDelegate.sessionQueryRules();
            }

            @Override
            public DatabaseAccessRules databaseAccessRules() {
                return this.connectionDelegate.databaseAccessRules();
            }

            @Override
            public DatabaseAccessHandler databaseAccessEventHandler() {
                return this.connectionDelegate.databaseAccessEventHandler();
            }

            @Override
            public Session session() {
                return this.connectionDelegate.session();
            }
        }
    }

    private static interface IBrowseFunctionDelegate {
        public boolean hasParentCatalog();

        public String parentCatalogName();

        public String parentSchemaName();

        public String parentObjectName();

        public BrowseQueryType.EQueryType queryType();

        public void run(VendorAccessConnection var1, MetadataBrowseRules var2, BrowsedObjectHandler var3);

        public void setVendorType(Database.EVendorType var1);

        public Database.EVendorType vendorType();
    }
}

