/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.browse;

import com.ibm.cognos.internal.relmd.bibus.I_ServiceCallback;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.metadata.browse.BrowseResult;
import com.ibm.cognos.internal.relmd.vendor.connection.DatabaseAccessRequestElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataRequest;
import com.ibm.cognos.relmd.metadata.browse.BrowseMetadataResult;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.VendorConnectionToolkit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class BrowseRequest
extends DatabaseAccessRequestElem
implements BrowseMetadataRequest {
    private final MetadataSource m_dataSource;
    private final BrowseMetadataFunction m_browseFunction;
    private Database.EVendorType m_vendorType;

    public BrowseRequest(BrowseMetadataFunction browseFunction, MetadataSource dataSource) {
        super("browseMetadataRequest", dataSource);
        this.m_dataSource = dataSource;
        this.m_browseFunction = browseFunction;
    }

    @Override
    public BrowseMetadataResult run(I_ServiceCallback serviceCallback, MetadataBrowseRules browseRules) throws Exception {
        BrowseResult browseResult = null;
        boolean currentUserHasImportCapability = serviceCallback.currentUserHasImportCapability();
        if (currentUserHasImportCapability) {
            MetadataSource metadataSource = this.metadataSource();
            ConnectionParameters connectionParameters = serviceCallback.connectionParameters(metadataSource);
            Relmd relmdGateway = RelmdGateway.relmd();
            VendorToolkit vendorToolkit = relmdGateway.vendorToolkit();
            VendorConnectionToolkit vendorConnectionToolkit = vendorToolkit.vendorConnectionToolkit();
            Connection connection = vendorConnectionToolkit.connection(connectionParameters);
            VendorAccessHandler databaseAccessEventHandler = serviceCallback.vendorAccessHandler();
            Database.EVendorType vendorType = connectionParameters.vendorType();
            VendorRules vendorRules = vendorToolkit.vendorRules(vendorType);
            SessionQueryRules sessionQueryRules = vendorRules.sessionQueryRules();
            VendorAccessConnection relmdConnection = vendorToolkit.vendorAccessConnection(connection, databaseAccessEventHandler, sessionQueryRules);
            browseResult = new BrowseResult();
            if (this.m_browseFunction != null) {
                this.m_browseFunction.setVendorType(vendorType);
                this.m_browseFunction.run(relmdConnection, browseRules, browseResult);
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                }
            }
        }
        return browseResult;
    }

    @Override
    public Collection<? extends XmlElement> childElements() {
        ArrayList<XmlElement> childElems = new ArrayList<XmlElement>();
        childElems.add(this.m_dataSource.asXml());
        childElems.add(this.m_browseFunction.asXml());
        return childElems;
    }

    public void cancelRequest() {
    }

    @Override
    public BrowseMetadataFunction metadataBrowseFunction() {
        return this.m_browseFunction;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }
}

