/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.browse;

import com.ibm.cognos.internal.relmd.metadata.import_.rules.SystemObjectFilterElem;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.VendorAccessRuleElem;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.VendorAccessSql;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElementHandler;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.rules.CatalogsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.ColumnsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.FunctionsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.ProceduresBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.SchemasBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.SynonymsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.TablesBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.ViewsBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.rules.systemObjects.SystemObject;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.rules.sql.CatalogGrainSql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectGrainSql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SchemaGrainSql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.Sql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.WhereClauseInsertionRule;
import java.util.Collection;
import java.util.Iterator;

public class BrowseRulesElem
implements CatalogsBrowseRules,
ColumnsBrowseRules,
FunctionsBrowseRules,
ProceduresBrowseRules,
SchemasBrowseRules,
SynonymsBrowseRules,
TablesBrowseRules,
ViewsBrowseRules,
XmlElementHandler {
    private SystemObjectFilterElem m_systemObjectFilter;
    private String m_tagName;
    private VendorAccessRuleElem m_sql;
    private Database.EVendorType m_vendorType;

    public BrowseRulesElem(String tagName) {
        this.m_tagName = tagName;
    }

    @Override
    public String getTagName() {
        return this.m_tagName;
    }

    @Override
    public int nameRecordIndex() {
        return 1;
    }

    @Override
    public int descriptionRecordIndex() {
        return 2;
    }

    @Override
    public Sql getSql() {
        return this.m_sql;
    }

    @Override
    public ObjectGrainSql getObjectGrainSql() {
        return this.m_sql;
    }

    @Override
    public SchemaGrainSql getSchemaGrainSql() {
        return this.m_sql;
    }

    @Override
    public CatalogGrainSql getCatalogGrainSql() {
        return this.m_sql;
    }

    @Override
    public SystemObjectFilterElem getSystemObjectFilter() {
        return this.m_systemObjectFilter;
    }

    @Override
    public void addText(String text) {
        if (this.m_sql != null && this.m_systemObjectFilter == null) {
            this.m_sql.addText(text);
        }
    }

    @Override
    public XmlElementHandler createChild(String elemName, XmlAttributeGroup attributes) {
        XmlElementHandler elem = null;
        if (this.m_sql == null) {
            this.m_sql = new VendorAccessRuleElem(elemName);
            elem = this.m_sql;
        }
        if (elem == null) {
            elem = this.m_sql.createChild(elemName, attributes);
        }
        if (elem == null && this.m_systemObjectFilter == null) {
            this.m_systemObjectFilter = new SystemObjectFilterElem(elemName, attributes);
            elem = this.m_systemObjectFilter;
        }
        if (elem == null) {
            elem = this.m_systemObjectFilter.createChild(elemName, attributes);
        }
        return elem;
    }

    @Override
    public VendorAccess allObjectsQuery() {
        VendorAccessSql vendorAccessSql = new VendorAccessSql(this.m_sql);
        return vendorAccessSql;
    }

    @Override
    public VendorAccess systemObjectsQuery() {
        VendorAccess filteredQuery = this.filteredQuery(BrowseQueryType.EQueryType.systemObjects);
        return filteredQuery;
    }

    @Override
    public VendorAccess userObjectsQuery() {
        VendorAccess filteredQuery = this.filteredQuery(BrowseQueryType.EQueryType.regular);
        return filteredQuery;
    }

    private VendorAccess filteredQuery(BrowseQueryType.EQueryType queryType) {
        SystemObjectFilterElem systemObjectFilter = this.getSystemObjectFilter();
        VendorAccessSql vendorAccessSql = new VendorAccessSql(this.m_sql);
        if (systemObjectFilter != null) {
            WhereClauseInsertionRule.EInsertLocation insertLocation = systemObjectFilter.getInsertLocation();
            WhereClauseInsertionRule.EInsertPrefix insertPrefix = systemObjectFilter.getInsertPrefix();
            Collection<SystemObject> systemObjects = systemObjectFilter.getSystemObjects();
            String objectExpression = systemObjectFilter.getObjectExpression();
            String insertText = this.buildSystemObjectWhereCondition(insertPrefix, systemObjects, objectExpression, queryType);
            String sqlFragment = systemObjectFilter.getSqlFragment();
            vendorAccessSql.insertSql(insertText, sqlFragment, insertLocation);
        }
        return vendorAccessSql;
    }

    private String buildSystemObjectWhereCondition(WhereClauseInsertionRule.EInsertPrefix insertPrefix, Collection<SystemObject> systemObjects, String objectExpression, BrowseQueryType.EQueryType browseQueryType) {
        StringBuilder stringBuilder = new StringBuilder();
        String insertValue = "";
        stringBuilder.append(insertPrefix.toString());
        stringBuilder.append(" (");
        stringBuilder.append(" (");
        stringBuilder.append(objectExpression);
        stringBuilder.append(") ");
        if (!BrowseQueryType.EQueryType.systemObjects.equals((Object)browseQueryType)) {
            stringBuilder.append(" NOT ");
        }
        stringBuilder.append(" IN ");
        stringBuilder.append("(");
        Iterator<SystemObject> systemObjectsIter = systemObjects.iterator();
        boolean bSystemObjectsBegin = true;
        while (systemObjectsIter.hasNext()) {
            if (!bSystemObjectsBegin) {
                stringBuilder.append(", ");
            }
            SystemObject systemObject = systemObjectsIter.next();
            stringBuilder.append(VendorAccessSql.surroundSingleQuotes(systemObject.getName()));
            bSystemObjectsBegin = false;
        }
        stringBuilder.append(")");
        stringBuilder.append(") ");
        insertValue = stringBuilder.toString();
        return insertValue;
    }

    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }
}

