/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.browse;

import com.ibm.cognos.internal.relmd.metadata.browse.BrowseFunction;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseRules;
import com.ibm.cognos.relmd.metadata.browse.MetadataBrowseToolkit;
import com.ibm.cognos.relmd.metadata.browse._handlers.BrowsedObjectHandler;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseMetadataFunction;
import com.ibm.cognos.relmd.metadata.browse.functions.BrowseQueryType;
import com.ibm.cognos.relmd.metadata.browse.functions.ColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.functions.SynonymColumnsBrowse;
import com.ibm.cognos.relmd.metadata.browse.rules.SynonymColumnsBrowseRules;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectImport;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectResults;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectImportRules;
import com.ibm.cognos.relmd.metadata.objectPaths.ColumnParentPath;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session._schema.SqlObjectConflict;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;

public class SynonymColumnsBrowseFunction
extends BrowseFunction
implements SynonymColumnsBrowse,
SqlObjectResults {
    private String m_targetCatalogName;
    private String m_targetSchemaName;
    private String m_targetObjectName;
    private Handler<Schema> m_schemaHandler;
    private Handler<Catalog> m_catalogHandler = new Handler<Catalog>(){

        @Override
        public void handle(Catalog obj) {
            SynonymColumnsBrowseFunction.this.m_targetCatalogName = obj.objectName();
        }
    };
    private Handler<Synonym> m_synonymHandler;
    private Handler<Table> m_tableHandler;
    private Handler<View> m_viewHandler;
    private Database.EVendorType m_vendorType;

    public SynonymColumnsBrowseFunction(String parentCatalogName, String parentSchemaName, String parentObjectName) {
        super(BrowseMetadataFunction.EBrowseFunctionType.synonymColumnsBrowse, parentCatalogName, parentSchemaName, parentObjectName, BrowseQueryType.EQueryType.regular);
        this.m_schemaHandler = new Handler<Schema>(){

            @Override
            public void handle(Schema obj) {
                SynonymColumnsBrowseFunction.this.m_targetSchemaName = obj.objectName();
            }
        };
        this.m_tableHandler = new Handler<Table>(){

            @Override
            public void handle(Table obj) {
                SynonymColumnsBrowseFunction.this.m_targetObjectName = obj.objectName();
            }
        };
        this.m_viewHandler = new Handler<View>(){

            @Override
            public void handle(View obj) {
                SynonymColumnsBrowseFunction.this.m_targetObjectName = obj.objectName();
            }
        };
        this.m_synonymHandler = new Handler<Synonym>(){

            @Override
            public void handle(Synonym obj) {
                String externalSchemaRef;
                String externalCatalogRef = obj.externalCatalogRef();
                if (null != externalCatalogRef) {
                    SynonymColumnsBrowseFunction.this.m_targetCatalogName = externalCatalogRef;
                }
                if (null != (externalSchemaRef = obj.externalSchemaRef())) {
                    SynonymColumnsBrowseFunction.this.m_targetSchemaName = externalSchemaRef;
                }
            }
        };
    }

    @Override
    public void run(VendorAccessConnection relmdConnection, MetadataBrowseRules browseRules, BrowsedObjectHandler browseResultHandler) {
        Relmd relmd = RelmdGateway.relmd();
        SynonymColumnsBrowseRules synonymColumnsBrowseRules = browseRules.synonymColumnsBrowseRules();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataImportToolkit importToolkit = metadataToolkit.metadataImportToolkit();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        SessionAccess sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        SessionQueryRules sessionQueryRules = sessionAccess.sessionQueryRules();
        Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
        MetadataObjectPathsToolkit metadataObjectPathsToolkit = metadataToolkit.metadataObjectPathsToolkit();
        String parentCatalogName = super.parentCatalogName();
        String parentSchemaName = super.parentSchemaName();
        String parentObjectName = super.parentObjectName();
        SqlObjectQueryPath sqlObjectQueryPath = metadataObjectPathsToolkit.sqlObjectQueryPath(catalogSupport, parentCatalogName, parentSchemaName, parentObjectName);
        SqlObjectImportRules sqlObjectImportRules = synonymColumnsBrowseRules.sqlObjectImportRules();
        SqlObjectImport sqlObjectImport = importToolkit.sqlObjectImport(sessionAccess, sqlObjectQueryPath, sqlObjectImportRules, this);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        sqlObjectImport.setVendorType(this.m_vendorType);
        sqlObjectImport.run(jdbcConnection);
        if (null == this.m_targetObjectName) {
            browseResultHandler.done();
        } else {
            ColumnParentPath targetColumnParentPath = metadataObjectPathsToolkit.columnParentPath(this.m_targetCatalogName, this.m_targetSchemaName, this.m_targetObjectName);
            MetadataBrowseToolkit browseToolkit = metadataToolkit.metadataBrowseToolkit();
            ColumnsBrowse columnsBrowse = browseToolkit.columnsBrowse(targetColumnParentPath);
            columnsBrowse.setVendorType(this.m_vendorType);
            columnsBrowse.run(relmdConnection, browseRules, browseResultHandler);
        }
    }

    @Override
    public Handler<Catalog> catalogHandler() {
        return this.m_catalogHandler;
    }

    @Override
    public Handler<Schema> schemaHandler() {
        return this.m_schemaHandler;
    }

    @Override
    public Handler<SqlObjectConflict> sqlObjectConflictHandler() {
        Handler<SqlObjectConflict> handler = new Handler<SqlObjectConflict>(){

            @Override
            public void handle(SqlObjectConflict obj) {
            }
        };
        return handler;
    }

    @Override
    public Handler<Synonym> synonymHandler() {
        return this.m_synonymHandler;
    }

    @Override
    public Handler<Table> tableHandler() {
        return this.m_tableHandler;
    }

    @Override
    public Handler<View> viewHandler() {
        return this.m_viewHandler;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }
}

