/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_;

import com.ibm.cognos.internal.relmd.bibus.I_ServiceCallback;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.metadata.import_.functions._chains.MetadataImportFunctionChain;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;
import com.ibm.cognos.internal.relmd.vendor.connection.DatabaseAccessRequestElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.jdbc.adaptor.util.LoggingProxyBuilder;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._tools.xml.ImportResultsMetadataBuilder;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataRequest;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataResult;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.VendorConnectionToolkit;
import com.ibm.cognos.relmd.xmlapi.Handler;
import com.ibm.cognos.relmd.xmlapi.XmlApiToolkit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ImportRequest
extends DatabaseAccessRequestElem
implements ImportMetadataRequest {
    private final IImportRequestDelegate delegate;
    private static final String loggingClassName = ImportRequest.class.getSimpleName();

    public ImportRequest(MetadataImportFunctionChain extractionFunction, MetadataSource dataSource, MetadataObjectSelections objectSelections) {
        super("importMetadataRequest", dataSource);
        this.delegate = RelmdLoggerFactory.isLoggingEnabled(loggingClassName) ? new ImportRequestLogger(extractionFunction, dataSource, objectSelections) : new ImportRequestImpl(extractionFunction, dataSource, objectSelections);
    }

    @Override
    public ImportMetadataResult run(I_ServiceCallback serviceCallback, MetadataImportRules rules) throws Exception {
        return this.delegate.run(serviceCallback, rules);
    }

    @Override
    public MetadataObjectSelections metadataSelections() {
        return this.delegate.metadataSelections();
    }

    @Override
    public Collection<? extends XmlElement> childElements() {
        return this.delegate.childElements();
    }

    @Override
    public MetadataImportFunctionChain metadataImportFunctionChain() {
        return this.delegate.metadataImportFunctionChain();
    }

    private class ImportRequestImpl
    implements IImportRequestDelegate {
        private final MetadataObjectSelections m_objectSelections;
        private final MetadataImportFunctionChain m_importChain;

        public ImportRequestImpl(MetadataImportFunctionChain extractionFunction, MetadataSource dataSource, MetadataObjectSelections objectSelections) {
            this.m_objectSelections = objectSelections;
            this.m_importChain = extractionFunction;
        }

        @Override
        public ImportMetadataResult run(I_ServiceCallback serviceCallback, MetadataImportRules rules) throws Exception {
            ImportMetadataResult importResult = null;
            if (serviceCallback.currentUserHasImportCapability()) {
                MetadataSource dataSource = ImportRequest.this.metadataSource();
                ConnectionParameters connectionParameters = serviceCallback.connectionParameters(dataSource);
                Relmd relmdGateway = RelmdGateway.relmd();
                VendorToolkit vendorToolkit = relmdGateway.vendorToolkit();
                VendorConnectionToolkit vendorConnectionToolkit = vendorToolkit.vendorConnectionToolkit();
                Connection connection = ImportRequest.this.delegate.decorateConnection(vendorConnectionToolkit.connection(connectionParameters));
                Database.EVendorType vendorType = connectionParameters.vendorType();
                Database.EVendorType rawVendorType = connectionParameters.rawVendorType();
                XmlApiToolkit serviceToolkit = relmdGateway.xmlApiToolkit();
                ImportResultsMetadataBuilder modelBuilder = serviceToolkit.importMetadataResultBuilder(dataSource, vendorType);
                final Handler<BeginSql> beginSqlResultsHandler = new Handler<BeginSql>(){

                    @Override
                    public void handle(BeginSql obj) {
                    }
                };
                final Handler<BeginJava> resultsHandler = new Handler<BeginJava>(){

                    @Override
                    public void handle(BeginJava obj) {
                    }
                };
                final Handler<ExecutionError> executionErrorHandler = new Handler<ExecutionError>(){

                    @Override
                    public void handle(ExecutionError obj) {
                    }
                };
                final Handler<ExecutionInformation> executionInformationHandler = new Handler<ExecutionInformation>(){

                    @Override
                    public void handle(ExecutionInformation obj) {
                    }
                };
                final Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = new Handler<ResultSetProcessingError>(){

                    @Override
                    public void handle(ResultSetProcessingError obj) {
                    }
                };
                final Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler = new Handler<ResultSetProcessingInformation>(){

                    @Override
                    public void handle(ResultSetProcessingInformation obj) {
                    }
                };
                VendorAccessHandler vendorAccessHandler = new VendorAccessHandler(){

                    @Override
                    public Handler<BeginJava> beginJavaHandler() {
                        return resultsHandler;
                    }

                    @Override
                    public Handler<BeginSql> beginSqlHandler() {
                        return beginSqlResultsHandler;
                    }

                    @Override
                    public Handler<ExecutionError> executionErrorHandler() {
                        return executionErrorHandler;
                    }

                    @Override
                    public Handler<ExecutionInformation> executionInformationHandler() {
                        return executionInformationHandler;
                    }

                    @Override
                    public Handler<ResultSetProcessingError> resultSetProcessingErrorHandler() {
                        return resultSetProcessingErrorHandler;
                    }

                    @Override
                    public Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler() {
                        return resultSetProcessingInformationHandler;
                    }
                };
                VendorRules vendorRules = vendorToolkit.vendorRules(vendorType);
                SessionQueryRules sessionQueryRules = vendorRules.sessionQueryRules();
                VendorAccessConnection relmdConnection = vendorToolkit.vendorAccessConnection(connection, vendorAccessHandler, sessionQueryRules);
                this.m_importChain.setVendorType(vendorType);
                this.m_importChain.setRawVendorType(rawVendorType);
                ImportSummary summary = this.m_importChain.run(relmdConnection, this.m_objectSelections, rules, modelBuilder);
                Metadata metadata = modelBuilder.metadata();
                importResult = serviceToolkit.importMetadataResult(metadata, summary);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
                    }
                }
            }
            return importResult;
        }

        @Override
        public MetadataObjectSelections metadataSelections() {
            return this.m_objectSelections;
        }

        @Override
        public Collection<? extends XmlElement> childElements() {
            ArrayList<XmlElement> childElems = new ArrayList<XmlElement>();
            MetadataSource dataSource = ImportRequest.this.metadataSource();
            childElems.add(dataSource.asXml());
            MetadataImportFunctionChain.EChainType chainType = this.m_importChain.getChainType();
            if (!MetadataImportFunctionChain.EChainType.full.equals((Object)chainType)) {
                ArrayList<ImportMetadataFunction> importFunctionCollection = this.m_importChain.getImportFunctionCollection();
                for (ImportMetadataFunction importFunction : importFunctionCollection) {
                    childElems.add(importFunction.asXml());
                }
            }
            childElems.add(this.m_objectSelections.asXml());
            return childElems;
        }

        @Override
        public MetadataImportFunctionChain metadataImportFunctionChain() {
            return this.m_importChain;
        }

        @Override
        public Connection decorateConnection(Connection connection) {
            return connection;
        }
    }

    private class ImportRequestLogger
    implements IImportRequestDelegate {
        private Logger logger = RelmdLoggerFactory.get(ImportRequest.access$000());
        ImportRequestImpl impl;

        public ImportRequestLogger(MetadataImportFunctionChain extractionFunction, MetadataSource dataSource, MetadataObjectSelections objectSelections) {
            Object[] parms = new Object[]{extractionFunction, dataSource, objectSelections};
            this.logger.entering(loggingClassName, loggingClassName, parms);
            try {
                this.impl = new ImportRequestImpl(extractionFunction, dataSource, objectSelections);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, loggingClassName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, loggingClassName);
        }

        @Override
        public ImportMetadataResult run(I_ServiceCallback serviceCallback, MetadataImportRules rules) throws Exception {
            ImportMetadataResult result;
            Object[] parms = new Object[]{serviceCallback, rules};
            String methodName = "run";
            this.logger.entering(loggingClassName, methodName, parms);
            try {
                result = this.impl.run(serviceCallback, rules);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            RelmdLoggerFactory.flush(this.logger);
            return result;
        }

        @Override
        public MetadataObjectSelections metadataSelections() {
            MetadataObjectSelections result;
            String methodName = "metadataSelections";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.metadataSelections();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public Collection<? extends XmlElement> childElements() {
            Collection<? extends XmlElement> result;
            String methodName = "childElements";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.childElements();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public MetadataImportFunctionChain metadataImportFunctionChain() {
            MetadataImportFunctionChain result;
            String methodName = "metadataImportFunctionChain";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.metadataImportFunctionChain();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public Connection decorateConnection(Connection connection) {
            Connection proxy;
            this.logger.finer(RelmdLoggerFactory.connectionLogText(connection));
            try {
                proxy = (Connection)LoggingProxyBuilder.getProxy((Logger)this.logger, (Pattern)Pattern.compile("^(java\\.sql\\..+)|(javax\\.sql\\..+)"), (Pattern)Pattern.compile(RelmdConfiguration.getStringProperty("JDBCTraceFilter")), (Object)connection);
            }
            catch (Exception e) {
                proxy = connection;
            }
            return proxy;
        }
    }

    private static interface IImportRequestDelegate {
        public ImportMetadataResult run(I_ServiceCallback var1, MetadataImportRules var2) throws Exception;

        public MetadataObjectSelections metadataSelections();

        public Collection<? extends XmlElement> childElements();

        public MetadataImportFunctionChain metadataImportFunctionChain();

        public Connection decorateConnection(Connection var1);
    }
}

