/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_;

import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlWriter;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata.import_.ImportMetadataResult;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.SchemaSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.SchemaSummaryElem;
import com.ibm.cognos.relmd.xmlapi.ApiSpecification;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

public class ImportResult
extends RelmdElement
implements ImportMetadataResult,
ApiSpecification {
    private static final long serialVersionUID = 1L;
    private Metadata m_model;
    private ImportSummary m_importSummary;
    public SchemaSummaryElem m_schemaSummaryElem = null;
    public Collection<ImportSummary> m_childImportSummaries = null;
    public Collection<SchemaSummary> m_childSchemaSummaries = null;

    public ImportResult(Metadata relationalMetadata, ImportSummary summary) {
        super("importMetadataResult");
        this.m_model = relationalMetadata;
        this.m_importSummary = summary;
        this.m_childImportSummaries = summary.importSummaryCollection();
        this.m_childSchemaSummaries = summary.schemaSummaryCollection();
        this.m_schemaSummaryElem = summary.schemaSummaryElem();
    }

    @Override
    public Metadata metadata() {
        return this.m_model;
    }

    @Override
    public Collection<? extends XmlElement> childElements() {
        Metadata metadata;
        ImportSummary importSummary;
        ArrayList<XmlElement> childElementsCollection = new ArrayList<XmlElement>();
        if (this.m_schemaSummaryElem != null) {
            childElementsCollection.add(this.m_schemaSummaryElem.asXml());
        }
        if ((importSummary = this.importSummary()) != null) {
            childElementsCollection.add(importSummary.asXml());
        }
        if ((metadata = this.metadata()) != null) {
            childElementsCollection.add(metadata.asXml());
        }
        return childElementsCollection;
    }

    @Override
    public void write(String schemaLocation, OutputStream os) throws IOException {
        XmlWriter writer = new XmlWriter("relmd", "relmdApi.xsd", schemaLocation);
        writer.writeDoc(this, os);
    }

    public final ImportSummary importSummary() {
        return this.m_importSummary;
    }

    public SchemaSummaryElem schemaSummaryElem() {
        return this.m_schemaSummaryElem;
    }

    @Override
    public Collection<ImportSummary> importSummaryCollection() {
        return this.m_childImportSummaries;
    }

    @Override
    public void addChildImportSummary(ImportSummary summary) {
        this.m_childImportSummaries.add(summary);
    }

    @Override
    public Collection<SchemaSummary> schemaSummaryCollection() {
        return this.m_childSchemaSummaries;
    }

    @Override
    public void addChildSchemaSummary(SchemaSummary schemaSummary) {
    }
}

