/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ColumnElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ColumnsImportJdbcFallbackElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableViewHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.ColumnHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.rules.ColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaObjectPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllColumnsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ColumnSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class ColumnsImportElem
extends ExtractionElement
implements VendorAccessResultSetHandler,
I_ChildElementHandler,
ColumnsImport {
    private static final int TABLE_NAME_INDEX = 3;
    private ColumnsImportRules m_columnsRules;
    private Handler<Column> m_columnHandler;
    private ColumnsImportJdbcFallbackElem m_fallback;
    public static final String TAGNAME_columnsImport = "extractColumns";
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction;
    private ImportSummary m_summary;
    private SessionAccess m_sessionAccess;
    private MetadataImportSelectionsChoice m_metadataImportSelectionsChoice;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler;
    private Handler<ColumnContainerObjectRef> m_columnContainerObjectRefHandler;
    private VendorAccessHandler m_vendorAccessHandler = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private String JDBC_URL_PREFIX_TERADATA = "jdbc:teradata";
    private String JDBC_URL_PREFIX_LOTUS_SunAndSon = "jdbc:domsql:";
    private String[] m_listofTableViewTableTypes = null;
    private String[] m_listofTableTableTypes = null;
    private String[] m_listofViewTableTypes = null;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public ColumnsImportElem() {
        this(null, null, null, null, null, null);
    }

    public ColumnsImportElem(SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, ColumnsImportRules importRules, Handler<Column> columnHandler, Handler<ColumnContainerObjectRef> columnContainerObjectRefHandler, Handler<SchemaPath> schemaPathHandler) {
        super(ImportMetadataFunction.EImportFunctionType.importColumns);
        this.m_sessionAccess = sessionAccess;
        this.m_metadataImportSelectionsChoice = metadataImportSelectionsChoice;
        this.m_columnsRules = importRules;
        this.m_columnHandler = columnHandler;
        this.m_columnContainerObjectRefHandler = columnContainerObjectRefHandler;
        this.m_schemaPathHandler = schemaPathHandler;
        this.m_fallback = null;
        this.m_schemaChildLevelExtraction = null;
        this.m_summary = null;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, ColumnsImportRules columnsImportRules, MetadataObjectSelections objectSelections, final ColumnHandler columnHandler, final ParentTableViewHandler parentTableViewHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandlerOld) {
        this.m_schemaChildLevelExtraction = null;
        this.m_columnsRules = columnsImportRules;
        this.m_columnHandler = new Handler<Column>(){

            @Override
            public void handle(Column obj) {
                columnHandler.handleColumn(obj);
            }
        };
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_metadataImportSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_columnContainerObjectRefHandler = new Handler<ColumnContainerObjectRef>(){

            @Override
            public void handle(ColumnContainerObjectRef obj) {
                if (null != parentTableViewHandler) {
                    String name = obj.objectName();
                    parentTableViewHandler.handleParentTableViewReference(name);
                }
            }
        };
        this.m_schemaPathHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandlerOld);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        this.run(jdbcConnection);
        return this.m_summary;
    }

    @Override
    public void run(Connection connection) {
        this.m_schemaChildLevelExtraction = null;
        this.m_summary = new ExtractionSummary("columnsImport");
        VendorAccess extractionQuery = this.m_columnsRules.extractionQuery();
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_columnsRules.objectSelectionsInclusionCollection();
        boolean hasExtractionFailureFallback = this.m_columnsRules.hasExtractionFailureFallback();
        if (hasExtractionFailureFallback) {
            String extractionFailureFallback = this.m_columnsRules.extractionFailureFallback();
            ColumnsImportJdbcFallbackElem fallbackColumnContainerObjectRefHandler = this.m_fallback = new ColumnsImportJdbcFallbackElem(this.m_sessionAccess, connection, this.m_columnsRules, this.m_columnHandler, this.m_columnContainerObjectRefHandler, this.m_schemaPathHandler, extractionFailureFallback);
            this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(fallbackColumnContainerObjectRefHandler);
            ColumnsImportJdbcFallbackElem fallbackResultSetHandler = this.m_fallback;
            ColumnsImportJdbcFallbackElem fallbackChildElementHandler = this.m_fallback;
            Handler<SchemaPath> fallbackParentCatalogSchemaHandler = this.m_fallback.parentCatalogSchemaHandler();
            this.m_summary = this.m_schemaChildLevelExtraction.run(connection, (QueryObjectChildIndexes)this.m_columnsRules, extractionQuery, this.m_sessionAccess, this.m_metadataImportSelectionsChoice, objectSelectionsInclusionCollection, fallbackParentCatalogSchemaHandler, fallbackResultSetHandler, (I_ChildElementHandler)fallbackChildElementHandler, this.m_vendorType);
        } else {
            this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(this.m_columnContainerObjectRefHandler);
            ColumnsImportElem resultSetHandler = this;
            ColumnsImportElem childElementHandler = this;
            MetadataImportSelectionsChoice.EChoice choice = this.m_metadataImportSelectionsChoice.choice();
            if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1 && choice.equals((Object)MetadataImportSelectionsChoice.EChoice.metadataObjectSelections)) {
                VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
                this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
                this.m_summary = this.runColumnsImportGeneric(connection, this.m_metadataImportSelectionsChoice, this.m_schemaPathHandler, this.m_columnsRules, resultSetHandler);
            } else {
                this.m_summary = this.m_schemaChildLevelExtraction.run(connection, (QueryObjectChildIndexes)this.m_columnsRules, extractionQuery, this.m_sessionAccess, this.m_metadataImportSelectionsChoice, objectSelectionsInclusionCollection, this.m_schemaPathHandler, resultSetHandler, (I_ChildElementHandler)childElementHandler, this.m_vendorType);
            }
        }
    }

    private ExtractionSummary runColumnsImportGeneric(Connection connection, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        MetadataObjectSelections metadataObjectSelections = metadataImportSelectionsChoice.metadataObjectSelections();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        try {
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            if (md instanceof IAdaptorDBMetadata) {
                this.m_listofTableTableTypes = tableTypeMapper.getListOfTable_TableTypes();
                this.m_listofViewTableTypes = tableTypeMapper.getListOfView_TableTypes();
                this.m_listofTableViewTableTypes = tableTypeMapper.getListOfTableAndView_TableTypes();
            } else {
                this.m_listofTableTableTypes = tableTypeMapper.defaultTable_tableTypes;
                this.m_listofViewTableTypes = tableTypeMapper.defaultView_tableTypes;
                this.m_listofTableViewTableTypes = tableTypeMapper.defaultTableAndView_tableTypes;
            }
            if (bAllCatalogsSelected) {
                ResultSet rsSchemas = md.getSchemas();
                if (rsSchemas != null && rsSchemas.next()) {
                    EscapeObjectName escapeObject = new EscapeObjectName(md);
                    do {
                        String schemaName = rsSchemas.getString(1);
                        String catalogName = rsSchemas.getString(2);
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        ResultSet rsTablesAndView = null;
                        rsTablesAndView = md.getTables(catalogName, escapedSchemaName, null, this.m_listofTableViewTableTypes);
                        while (rsTablesAndView != null && rsTablesAndView.next()) {
                            String tableOrViewName = rsTablesAndView.getString(3);
                            if (tableOrViewName == null) continue;
                            summary = this.getColumnsGeneric(connection, catalogName, schemaName, tableOrViewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                    } while (rsSchemas.next());
                } else {
                    summary = this.getColumnsGeneric(connection, null, null, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        this.m_catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler, this.m_catalogName);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler, String catalogName) {
        block32: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            try {
                DatabaseMetaData md = connection.getMetaData();
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                if (bAllSchemaSelected) {
                    String schemaTerm = md.getSchemaTerm();
                    if (schemaTerm == null || schemaTerm.isEmpty()) {
                        summary = this.getColumnsGeneric(connection, catalogName, null, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    } else {
                        ResultSet rsSchemas = null;
                        rsSchemas = catalogName != null && !catalogName.isEmpty() ? md.getSchemas(catalogName, null) : md.getSchemas();
                        ArrayList<Object> schemaNames = new ArrayList<Object>();
                        while (rsSchemas != null && rsSchemas.next()) {
                            String schemaName = rsSchemas.getString(1);
                            schemaNames.add(schemaName);
                        }
                        if (rsSchemas != null) {
                            rsSchemas.close();
                        }
                        for (String string : schemaNames) {
                            String escapedSchemaName = escapeObject.escape(string);
                            ResultSet rsTablesAndViews = md.getTables(catalogName, escapedSchemaName, null, this.m_listofTableViewTableTypes);
                            while (rsTablesAndViews != null && rsTablesAndViews.next()) {
                                String tableOrViewName = rsTablesAndViews.getString(3);
                                if (tableOrViewName == null) continue;
                                summary = this.getColumnsGeneric(connection, catalogName, string, tableOrViewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                    }
                    break block32;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block32;
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    String escapedSchemaName;
                    String viewName;
                    String tableName;
                    this.m_schemaName = selectedSchema.objectName();
                    QualifierList.CatalogSchemaPath cs = this.getQualifiedCatalogSchema();
                    if (null != this.m_catalogName && this.m_catalogName.isEmpty() && null != cs && null != cs.getCatalog()) {
                        this.m_catalogName = cs.getCatalog();
                    }
                    if (null != this.m_schemaName && this.m_schemaName.isEmpty() && null != cs && null != cs.getSchema()) {
                        this.m_schemaName = cs.getSchema();
                    }
                    SelectionChoice<TableSelection, AllTablesSelection> selectionChoice = selectedSchema.tableSelections();
                    SelectionChoice<ViewSelection, AllViewsSelection> viewSelections = selectedSchema.viewSelections();
                    boolean bAllTablesSelected = this.m_objectSelectionsToolkit.allSelected(selectionChoice);
                    boolean bAllViewsSelected = this.m_objectSelectionsToolkit.allSelected(viewSelections);
                    ReferenceableSet<TableSelection> selectedTables = selectionChoice.selectedObjects();
                    ReferenceableSet<ViewSelection> selectedViews = viewSelections.selectedObjects();
                    if (bAllTablesSelected && bAllViewsSelected) {
                        String jdbcURL = null;
                        try {
                            jdbcURL = md.getURL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        if (jdbcURL != null && jdbcURL.indexOf(this.JDBC_URL_PREFIX_TERADATA) != -1) {
                            summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            continue;
                        }
                        String escapedSchemaName2 = escapeObject.escape(this.m_schemaName);
                        ResultSet rsTablesAndViews = md.getTables(this.m_catalogName, escapedSchemaName2, null, this.m_listofTableViewTableTypes);
                        ArrayList<Object> objectNames = new ArrayList<Object>();
                        while (rsTablesAndViews != null && rsTablesAndViews.next()) {
                            String tableOrViewName = rsTablesAndViews.getString(3);
                            objectNames.add(tableOrViewName);
                        }
                        if (rsTablesAndViews != null) {
                            rsTablesAndViews.close();
                        }
                        for (String string : objectNames) {
                            if (string == null) continue;
                            summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, string, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (!bAllTablesSelected && !bAllViewsSelected) {
                        SelectionChoice<ColumnSelection, AllColumnsSelection> columnSelections;
                        if (null != selectedTables) {
                            for (TableSelection selectedTable : selectedTables) {
                                tableName = selectedTable.objectName();
                                columnSelections = selectedTable.columnSelections();
                                if (null != columnSelections && columnSelections.selectedObjects().size() > 0) {
                                    summary = this.selectiveColumnsImport(connection, columnSelections, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                                    continue;
                                }
                                summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, tableName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                        if (null == selectedViews) continue;
                        for (ViewSelection selectedView : selectedViews) {
                            viewName = selectedView.objectName();
                            columnSelections = selectedView.columnSelections();
                            if (null != columnSelections && columnSelections.selectedObjects().size() > 0) {
                                summary = this.selectiveColumnsImport(connection, columnSelections, viewName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                                continue;
                            }
                            summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, viewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (bAllTablesSelected && !bAllViewsSelected) {
                        escapedSchemaName = escapeObject.escape(this.m_schemaName);
                        ResultSet rsTables = md.getTables(this.m_catalogName, escapedSchemaName, null, this.m_listofTableTableTypes);
                        while (rsTables != null && rsTables.next()) {
                            tableName = rsTables.getString(3);
                            summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, tableName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        if (null != selectedViews) {
                            for (ViewSelection selectedView : selectedViews) {
                                String viewName2 = selectedView.objectName();
                                summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, viewName2, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                        if (rsTables == null) continue;
                        rsTables.close();
                        continue;
                    }
                    if (!bAllViewsSelected || bAllTablesSelected) continue;
                    escapedSchemaName = escapeObject.escape(this.m_schemaName);
                    ResultSet rsViews = md.getTables(this.m_catalogName, escapedSchemaName, null, this.m_listofViewTableTypes);
                    while (rsViews != null && rsViews.next()) {
                        viewName = rsViews.getString(3);
                        summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, viewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                    if (null != selectedTables) {
                        for (TableSelection selectedTable : selectedTables) {
                            String tableName2 = selectedTable.objectName();
                            summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, tableName2, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                    }
                    if (rsViews == null) continue;
                    rsViews.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExtractionSummary getColumnsGeneric(Connection connection, String catalogName, String schemaName, String tableViewName, String columnName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        Statement statement = null;
        ResultSet rsColumns = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            statement = connection.createStatement();
            if (catalogName != null && catalogName.isEmpty()) {
                catalogName = null;
            }
            if (schemaName != null && schemaName.isEmpty()) {
                schemaName = null;
            }
            EscapeObjectName escapeObject = new EscapeObjectName(md);
            String escapedSchemaName = escapeObject.escape(schemaName);
            String escapedTableViewName = escapeObject.escape(tableViewName);
            String escapedColumnName = escapeObject.escape(columnName);
            if (escapedSchemaName != null && escapedSchemaName.isEmpty()) {
                escapedSchemaName = null;
            }
            rsColumns = md.getColumns(catalogName, escapedSchemaName, escapedTableViewName, escapedColumnName);
            RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsColumns, this.m_vendorAccessHandler);
            summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
        }
        catch (RuntimeException runtimeException) {
            this.m_schemaChildLevelExtraction.close(rsColumns, statement);
        }
        catch (SQLException sQLException) {
            this.m_schemaChildLevelExtraction.close(rsColumns, statement);
            {
                catch (Throwable throwable) {
                    this.m_schemaChildLevelExtraction.close(rsColumns, statement);
                    throw throwable;
                }
            }
        }
        this.m_schemaChildLevelExtraction.close(rsColumns, statement);
        return summary;
    }

    private ExtractionSummary selectiveColumnsImport(Connection connection, SelectionChoice<ColumnSelection, AllColumnsSelection> columnSelections, String tableOrViewTableName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        ReferenceableSet<ColumnSelection> selectedColumns = columnSelections.selectedObjects();
        if (null != selectedColumns) {
            for (ColumnSelection selectedColumn : selectedColumns) {
                String columnName = selectedColumn.objectName();
                summary = this.getColumnsGeneric(connection, this.m_catalogName, this.m_schemaName, tableOrViewTableName, columnName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
            }
        }
        return summary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections databaseObjectSelections, MetadataElementHandler modelElementHandler) {
        ColumnsImportRules columnsImportRules = metadataImportRules.columnsImportRules();
        return this.run(relmdConnection, columnsImportRules, databaseObjectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        ColumnElem column = new ColumnElem(this.m_columnsRules, resultSetValueRetrieval, this.m_vendorType);
        this.m_columnHandler.handle(column);
    }

    @Override
    public void handleParentObjectChanged() {
    }

    @Override
    public void cancel() {
        this.stop();
    }

    @Override
    public void done() {
        this.m_columnsRules = null;
        this.m_columnHandler = null;
        this.m_fallback = null;
    }

    @Override
    public ImportRules<Column> importRules() {
        return this.m_columnsRules.columnsImportRules();
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice() {
        return this.m_metadataImportSelectionsChoice;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void stop() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public Handler<SchemaObjectPath> contextHandler() {
        Handler<SchemaObjectPath> handler = new Handler<SchemaObjectPath>(){

            @Override
            public void handle(SchemaObjectPath obj) {
                SchemaPath schemaPath = obj.schemaPath();
                ColumnsImportElem.this.m_schemaPathHandler.handle(schemaPath);
                Relmd relmd = RelmdGateway.relmd();
                MetadataToolkit metadataToolkit = relmd.metadataToolkit();
                ColumnContainerObjectRef columnContainerObjectRef = metadataToolkit.columnContainerObjectRef(obj);
                ColumnsImportElem.this.m_columnContainerObjectRefHandler.handle(columnContainerObjectRef);
            }
        };
        return handler;
    }

    @Override
    public Handler<Column> objectHandler() {
        return null;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }
}

