/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;
import com.ibm.cognos.jdbc.adaptor.util.LoggingProxyBuilder;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.ColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.DatabaseImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ForeignKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionRoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.IndexesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ProcedureRoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ProceduresImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SchemaSummaryElem;
import com.ibm.cognos.relmd.metadata.import_.functions.SynonymsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.TableParametersImport;
import com.ibm.cognos.relmd.metadata.import_.functions.TablesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.UniqueKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ViewsImport;
import com.ibm.cognos.relmd.metadata.import_.rules.ColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.ForeignKeysImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.FunctionRoutineArgumentsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.FunctionsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.IndexesImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.ProcedureRoutineArgumentsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.ProceduresImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SynonymsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.TableParametersImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.TablesImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.UniqueKeysImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.ViewsImportRules;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSynonymsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SynonymSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.DatabaseAccessRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.DatabaseAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DatabaseImportElem
extends ExtractionElement
implements DatabaseImport {
    private static final long serialVersionUID = 1L;
    public static final String TAGNAME = "databaseImport";
    protected static final String loggingClassName = DatabaseImportElem.class.getSimpleName();
    IDatabaseImportElemDelegate delegate = RelmdLoggerFactory.isLoggingEnabled(loggingClassName) ? new LoggingDatabaseImportElem() : new DatabaseImportElemImpl();

    public DatabaseImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importDatabase);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler m_modelBuilder) {
        return this.delegate.run(relmdConnection, metadataImportRules, objectSelections, m_modelBuilder);
    }

    public void extractObjects(ExtractionSummary summary, ReferenceableSet<SchemaSelection> selectedSchemas, CatalogSelection catalogSelection) {
        this.delegate.extractObjects(summary, selectedSchemas, catalogSelection);
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.delegate.setVendorType(vendorType);
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.delegate.setRawVendorType(rawVendorType);
    }

    @Override
    public void cancel() {
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return null;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return null;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
    }

    private class DatabaseImportElemImpl
    implements IDatabaseImportElemDelegate {
        private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
        private boolean bImportColumns = true;
        private boolean bImportPrimaryKeys = true;
        private boolean bImportForeignKeys = true;
        private boolean bImportIndexes = true;
        private boolean bImportForeignKeysUsingGenericMethod = false;
        Database.EVendorType m_vendorType;
        Database.EVendorType m_rawVendorType;
        MetadataObjectSelections m_tablesMetadataSelection;
        MetadataObjectSelections m_viewsMetadataSelection;
        MetadataObjectSelections m_synonymsMetadataSelection;
        MetadataObjectSelections m_functionsMetadataSelection;
        MetadataObjectSelections m_proceduresMetadataSelection;

        private DatabaseImportElemImpl() {
        }

        @Override
        public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler m_modelBuilder) {
            Relmd gateway = RelmdGateway.relmd();
            MetadataToolkit metadataToolkit = gateway.metadataToolkit();
            this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
            MetadataImportToolkit metadataImportToolkit = metadataToolkit.metadataImportToolkit();
            MetadataObjectSelectionsToolkit objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
            ExtractionSummary summary = new ExtractionSummary(this.getClass().getName());
            SchemaSummaryElem schemaSummaryElem = summary.schemaSummaryElem();
            summary.start();
            if (this.m_vendorType == Database.EVendorType.local) {
                return summary;
            }
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = objectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                this.selectAll(objectSelections);
            } else {
                Object selectedSchemas;
                ReferenceableSet<CatalogSelection> selectedCatalogs = objectSelections.catalogSelections().selectedObjects();
                if (null == selectedCatalogs) {
                    return summary;
                }
                if (selectedCatalogs.isEmpty() && null != (selectedSchemas = objectSelections.schemaSelections().selectedObjects())) {
                    this.extractObjects(summary, (ReferenceableSet<SchemaSelection>)selectedSchemas, null);
                }
                for (CatalogSelection selectedCatalog : selectedCatalogs) {
                    String selectedCatalogName = selectedCatalog.objectName();
                    CatalogSelection catalogSelection = objectSelectionsToolkit.catalogSelection(selectedCatalogName);
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                    boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
                    if (bAllSchemaSelected) {
                        this.selectAll(objectSelections);
                        continue;
                    }
                    ReferenceableSet<SchemaSelection> selectedSchemas2 = schemaSelections.selectedObjects();
                    this.extractObjects(summary, selectedSchemas2, catalogSelection);
                }
            }
            QualifierList ql = new QualifierList(relmdConnection);
            ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = ql.getQualifierList();
            ColumnsImportRules columnsImportRules = metadataImportRules.columnsImportRules();
            TableParametersImportRules tableParametersImportRules = metadataImportRules.tableParametersImportRules();
            if (this.m_tablesMetadataSelection != null) {
                TablesImport tablesExtraction = metadataImportToolkit.tablesImport();
                TablesImportRules tablesImportRules = metadataImportRules.tablesImportRules();
                tablesExtraction.setVendorType(this.m_vendorType);
                tablesExtraction.setQualifierList(m_qualifierList);
                ImportSummary tablesSummary = tablesExtraction.run(relmdConnection, tablesImportRules, this.m_tablesMetadataSelection, m_modelBuilder, m_modelBuilder);
                long tablesRowsProcessed = tablesSummary.rowsProcessed();
                schemaSummaryElem.tablesCount(tablesRowsProcessed);
                summary.addChildImportSummary(tablesSummary);
                if (this.bImportColumns && tablesRowsProcessed > 0L) {
                    ColumnsImport columnsExtraction = metadataImportToolkit.columnsImport();
                    columnsExtraction.setQualifiedCatalogSchema(tablesExtraction.getQualifiedCatalogSchema());
                    columnsExtraction.setVendorType(this.m_vendorType);
                    ImportSummary columnsSummary = columnsExtraction.run(relmdConnection, columnsImportRules, this.m_tablesMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                    summary.addChildImportSummary(columnsSummary);
                }
                if (this.bImportPrimaryKeys && tablesRowsProcessed > 0L) {
                    UniqueKeysImport uniqueKeysExtraction = metadataImportToolkit.uniqueKeysImport();
                    UniqueKeysImportRules uniqueKeysImportRules = metadataImportRules.uniqueKeysImportRules();
                    uniqueKeysExtraction.setQualifiedCatalogSchema(tablesExtraction.getQualifiedCatalogSchema());
                    uniqueKeysExtraction.setVendorType(this.m_vendorType);
                    ImportSummary uniqueKeysSummary = uniqueKeysExtraction.run(relmdConnection, uniqueKeysImportRules, this.m_tablesMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                    summary.addChildImportSummary(uniqueKeysSummary);
                }
                if (this.bImportIndexes && tablesRowsProcessed > 0L) {
                    IndexesImport indexesExtraction = metadataImportToolkit.indexesImport();
                    IndexesImportRules indexesImportRules = metadataImportRules.indexesImportRules();
                    indexesExtraction.setQualifiedCatalogSchema(tablesExtraction.getQualifiedCatalogSchema());
                    indexesExtraction.setVendorType(this.m_vendorType);
                    summary.addChildImportSummary(indexesExtraction.run(relmdConnection, indexesImportRules, this.m_tablesMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder));
                }
                if (this.bImportForeignKeys && tablesRowsProcessed > 0L) {
                    ForeignKeysImport foreignKeysExtraction = metadataImportToolkit.foreignKeysImport();
                    ForeignKeysImportRules foreignKeysImportRules = metadataImportRules.foreignKeysImportRules();
                    foreignKeysExtraction.setQualifiedCatalogSchema(tablesExtraction.getQualifiedCatalogSchema());
                    if (this.bImportForeignKeysUsingGenericMethod) {
                        foreignKeysExtraction.setVendorType(Database.EVendorType.generic);
                    } else {
                        foreignKeysExtraction.setVendorType(this.m_vendorType);
                    }
                    ImportSummary foreignKeysSummary = foreignKeysExtraction.run(relmdConnection, foreignKeysImportRules, this.m_tablesMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                    summary.addChildImportSummary(foreignKeysSummary);
                }
            }
            if (this.m_viewsMetadataSelection != null) {
                ViewsImport viewsExtraction = metadataImportToolkit.viewsImport();
                ViewsImportRules viewsImportRules = metadataImportRules.viewsImportRules();
                viewsExtraction.setVendorType(this.m_vendorType);
                viewsExtraction.setQualifierList(m_qualifierList);
                ImportSummary viewsSummary = viewsExtraction.run(relmdConnection, viewsImportRules, this.m_viewsMetadataSelection, m_modelBuilder, m_modelBuilder);
                long viewsRowsProcessed = viewsSummary.rowsProcessed();
                schemaSummaryElem.viewsCount(viewsRowsProcessed);
                summary.addChildImportSummary(viewsSummary);
                if (this.bImportColumns && viewsRowsProcessed > 0L) {
                    ColumnsImport viewColumnsExtraction = metadataImportToolkit.columnsImport();
                    viewColumnsExtraction.setQualifiedCatalogSchema(viewsExtraction.getQualifiedCatalogSchema());
                    viewColumnsExtraction.setVendorType(this.m_vendorType);
                    ImportSummary viewColumnsSummary = viewColumnsExtraction.run(relmdConnection, columnsImportRules, this.m_viewsMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                    summary.addChildImportSummary(viewColumnsSummary);
                    TableParametersImport parametersExtraction = metadataImportToolkit.tableParametersImport();
                    viewColumnsExtraction.setQualifiedCatalogSchema(viewsExtraction.getQualifiedCatalogSchema());
                    parametersExtraction.setVendorType(this.m_vendorType);
                    summary.addChildImportSummary(parametersExtraction.run(relmdConnection, tableParametersImportRules, this.m_viewsMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder));
                }
            }
            if (this.m_synonymsMetadataSelection != null) {
                SynonymsImport synonymsExtraction = metadataImportToolkit.synonymsImport();
                SynonymsImportRules synonymsImportRules = metadataImportRules.synonymsImportRules();
                synonymsExtraction.setQualifierList(m_qualifierList);
                synonymsExtraction.setVendorType(this.m_vendorType);
                ImportSummary synonymsSummary = synonymsExtraction.run(relmdConnection, synonymsImportRules, this.m_synonymsMetadataSelection, m_modelBuilder, m_modelBuilder);
                long synonymsRowsProcessed = synonymsSummary.rowsProcessed();
                schemaSummaryElem.synonymsCount(synonymsRowsProcessed);
                summary.addChildImportSummary(synonymsSummary);
            }
            if (this.m_functionsMetadataSelection != null) {
                FunctionsImport functionsExtraction = metadataImportToolkit.functionsImport();
                FunctionsImportRules functionsImportRules = metadataImportRules.functionsImportRules();
                functionsExtraction.setQualifierList(m_qualifierList);
                functionsExtraction.setVendorType(this.m_vendorType);
                functionsExtraction.setRawVendorType(this.m_rawVendorType);
                ImportSummary functionsSummary = functionsExtraction.run(relmdConnection, functionsImportRules, this.m_functionsMetadataSelection, m_modelBuilder, m_modelBuilder);
                long functionsRowsProcessed = functionsSummary.rowsProcessed();
                schemaSummaryElem.functionsCount(functionsRowsProcessed);
                summary.addChildImportSummary(functionsSummary);
                FunctionRoutineArgumentsImport functionParamsExtraction = metadataImportToolkit.functionRoutineArgumentsImport();
                FunctionRoutineArgumentsImportRules functionRoutineArgumentsImportRules = metadataImportRules.functionRoutineArgumentsImportRules();
                functionParamsExtraction.setQualifiedCatalogSchema(functionsExtraction.getQualifiedCatalogSchema());
                functionParamsExtraction.setVendorType(this.m_vendorType);
                ImportSummary functionArgumentsSummary = functionParamsExtraction.run(relmdConnection, functionRoutineArgumentsImportRules, this.m_functionsMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                summary.addChildImportSummary(functionArgumentsSummary);
            }
            if (this.m_proceduresMetadataSelection != null) {
                ProceduresImport proceduresExtraction = metadataImportToolkit.proceduresImport();
                ProceduresImportRules proceduresImportRules = metadataImportRules.proceduresImportRules();
                proceduresExtraction.setQualifierList(m_qualifierList);
                proceduresExtraction.setVendorType(this.m_vendorType);
                proceduresExtraction.setRawVendorType(this.m_rawVendorType);
                ImportSummary proceduresSummary = proceduresExtraction.run(relmdConnection, proceduresImportRules, this.m_proceduresMetadataSelection, m_modelBuilder, m_modelBuilder);
                long proceduresRowsProcessed = proceduresSummary.rowsProcessed();
                schemaSummaryElem.proceduresCount(proceduresRowsProcessed);
                summary.addChildImportSummary(proceduresSummary);
                ProcedureRoutineArgumentsImport procedureParamsExtraction = metadataImportToolkit.procedureRoutineArgumentsImport();
                ProcedureRoutineArgumentsImportRules procedureRoutineArgumentsImportRules = metadataImportRules.procedureRoutineArgumentsImportRules();
                procedureParamsExtraction.setQualifiedCatalogSchema(proceduresExtraction.getQualifiedCatalogSchema());
                procedureParamsExtraction.setVendorType(this.m_vendorType);
                ImportSummary procedureArgumentsSummary = procedureParamsExtraction.run(relmdConnection, procedureRoutineArgumentsImportRules, this.m_proceduresMetadataSelection, m_modelBuilder, m_modelBuilder, m_modelBuilder);
                summary.addChildImportSummary(procedureArgumentsSummary);
            }
            summary.addChildSchemaSummary(schemaSummaryElem);
            summary.stop();
            return summary;
        }

        @Override
        public void extractObjects(ExtractionSummary summary, ReferenceableSet<SchemaSelection> selectedSchemas, CatalogSelection catalogSelection) {
            Relmd gateway = RelmdGateway.relmd();
            MetadataToolkit metadataToolkit = gateway.metadataToolkit();
            this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
            MetadataObjectSelectionsToolkit objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
            Iterator iterator = selectedSchemas.iterator();
            while (iterator.hasNext()) {
                SelectionChoice<ProcedureSelection, AllProceduresSelection> procedureSelections;
                boolean bAnyProcedureSelected;
                SelectionChoice<FunctionSelection, AllFunctionsSelection> functionSelections;
                boolean bAnyFunctionSelected;
                SelectionChoice<SynonymSelection, AllSynonymsSelection> synonymSelections;
                boolean bAnySynonymSelected;
                SelectionChoice<ViewSelection, AllViewsSelection> viewSelections;
                boolean bAnyViewSelected;
                SchemaSelection selectedSchema;
                SchemaSelection schemaSelection = selectedSchema = (SchemaSelection)iterator.next();
                this.bImportColumns = schemaSelection.bImportColumns();
                this.bImportPrimaryKeys = schemaSelection.bImportPrimaryKeys();
                this.bImportForeignKeys = schemaSelection.bImportForeignKeys();
                this.bImportIndexes = schemaSelection.bImportIndexes();
                this.bImportForeignKeysUsingGenericMethod = schemaSelection.bImportForeignKeysUsingGenericMethod();
                SchemaSummaryElem schemaSummaryElem = summary.schemaSummaryElem();
                if (catalogSelection != null) {
                    String catalogName = catalogSelection.objectName();
                    schemaSummaryElem.catalogName(catalogName);
                }
                String schemaName = selectedSchema.objectName();
                schemaSummaryElem.schemaName(schemaName);
                SelectionChoice<TableSelection, AllTablesSelection> tableSelections = schemaSelection.tableSelections();
                boolean bAnyTableSelected = this.m_objectSelectionsToolkit.anySelected(tableSelections);
                if (bAnyTableSelected) {
                    if (this.m_tablesMetadataSelection == null) {
                        this.m_tablesMetadataSelection = objectSelectionsToolkit.metadataObjectSelections();
                    }
                    if (catalogSelection != null) {
                        this.m_tablesMetadataSelection.catalogSelections().selectedObjects().add(catalogSelection);
                        catalogSelection.schemaSelections().selectedObjects().add(schemaSelection);
                    } else {
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = this.m_tablesMetadataSelection.schemaSelections();
                        ReferenceableSet<SchemaSelection> selectedObjects = schemaSelections.selectedObjects();
                        selectedObjects.add(schemaSelection);
                    }
                }
                if (bAnyViewSelected = this.m_objectSelectionsToolkit.anySelected(viewSelections = schemaSelection.viewSelections())) {
                    if (this.m_viewsMetadataSelection == null) {
                        this.m_viewsMetadataSelection = objectSelectionsToolkit.metadataObjectSelections();
                    }
                    if (catalogSelection != null) {
                        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = this.m_viewsMetadataSelection.catalogSelections();
                        catalogSelections.selectedObjects().add(catalogSelection);
                        catalogSelection.schemaSelections().selectedObjects().add(schemaSelection);
                    } else {
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = this.m_viewsMetadataSelection.schemaSelections();
                        schemaSelections.selectedObjects().add(schemaSelection);
                    }
                }
                if (bAnySynonymSelected = this.m_objectSelectionsToolkit.anySelected(synonymSelections = schemaSelection.synonymSelections())) {
                    if (this.m_synonymsMetadataSelection == null) {
                        this.m_synonymsMetadataSelection = objectSelectionsToolkit.metadataObjectSelections();
                    }
                    if (catalogSelection != null) {
                        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = this.m_synonymsMetadataSelection.catalogSelections();
                        catalogSelections.selectedObjects().add(catalogSelection);
                        catalogSelection.schemaSelections().selectedObjects().add(schemaSelection);
                    } else {
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = this.m_synonymsMetadataSelection.schemaSelections();
                        schemaSelections.selectedObjects().add(schemaSelection);
                    }
                }
                if (bAnyFunctionSelected = this.m_objectSelectionsToolkit.anySelected(functionSelections = schemaSelection.functionSelections())) {
                    if (this.m_functionsMetadataSelection == null) {
                        this.m_functionsMetadataSelection = objectSelectionsToolkit.metadataObjectSelections();
                    }
                    if (catalogSelection != null) {
                        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = this.m_functionsMetadataSelection.catalogSelections();
                        catalogSelections.selectedObjects().add(catalogSelection);
                        catalogSelection.schemaSelections().selectedObjects().add(schemaSelection);
                    } else {
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = this.m_functionsMetadataSelection.schemaSelections();
                        schemaSelections.selectedObjects().add(schemaSelection);
                    }
                }
                if (!(bAnyProcedureSelected = this.m_objectSelectionsToolkit.anySelected(procedureSelections = schemaSelection.procedureSelections()))) continue;
                if (this.m_proceduresMetadataSelection == null) {
                    this.m_proceduresMetadataSelection = objectSelectionsToolkit.metadataObjectSelections();
                }
                if (catalogSelection != null) {
                    SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = this.m_proceduresMetadataSelection.catalogSelections();
                    catalogSelections.selectedObjects().add(catalogSelection);
                    catalogSelection.schemaSelections().selectedObjects().add(schemaSelection);
                    continue;
                }
                this.m_proceduresMetadataSelection.schemaSelections().selectedObjects().add(schemaSelection);
            }
        }

        private void selectAll(MetadataObjectSelections objectSelections) {
            this.m_tablesMetadataSelection = objectSelections;
            this.m_viewsMetadataSelection = objectSelections;
            this.m_synonymsMetadataSelection = objectSelections;
            this.m_functionsMetadataSelection = objectSelections;
            this.m_proceduresMetadataSelection = objectSelections;
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
            this.m_vendorType = vendorType;
        }

        @Override
        public void setRawVendorType(Database.EVendorType rawVendorType) {
            this.m_rawVendorType = rawVendorType;
        }
    }

    private class LoggingDatabaseImportElem
    implements IDatabaseImportElemDelegate {
        private Logger logger = RelmdLoggerFactory.get(loggingClassName);
        private DatabaseImportElemImpl impl = new DatabaseImportElemImpl();

        private LoggingDatabaseImportElem() {
        }

        @Override
        public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler m_modelBuilder) {
            Object[] parms = new Object[]{"\nrelmdConnection: " + RelmdLoggerFactory.connectionLogText(relmdConnection.jdbcConnection()), "\nmetadataImportRules: " + metadataImportRules.toString(), "\nobjectSelections: " + objectSelections.toString(), "\nm_modelBuilder: " + m_modelBuilder.toString()};
            String methodName = "run";
            this.logger.entering(loggingClassName, methodName, parms);
            ImportSummary result = this.impl.run(new VendorAccessConnectionDelegate(relmdConnection), metadataImportRules, objectSelections, m_modelBuilder);
            this.logger.exiting(loggingClassName, methodName, result);
            return result;
        }

        @Override
        public void extractObjects(ExtractionSummary summary, ReferenceableSet<SchemaSelection> selectedSchemas, CatalogSelection catalogSelection) {
            Object[] parms = new Object[]{"\nsummary: " + summary.toString(), "\nselectedSchemas: " + selectedSchemas.toString(), "\ncatalogSelection: " + (catalogSelection == null ? "" : catalogSelection.toString())};
            String methodName = "extractObjects";
            this.logger.entering(loggingClassName, methodName, parms);
            this.impl.extractObjects(summary, selectedSchemas, catalogSelection);
            this.logger.exiting(loggingClassName, methodName);
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
            Object[] parms = new Object[]{vendorType.toString()};
            String methodName = "setVendorType";
            this.logger.entering(loggingClassName, methodName, parms);
            this.impl.setVendorType(vendorType);
            this.logger.exiting(loggingClassName, methodName);
        }

        @Override
        public void setRawVendorType(Database.EVendorType rawvendorType) {
            Object[] parms = new Object[]{rawvendorType.toString()};
            String methodName = "setVendorType";
            this.logger.entering(loggingClassName, methodName, parms);
            this.impl.setRawVendorType(rawvendorType);
            this.logger.exiting(loggingClassName, methodName);
        }

        private class VendorAccessConnectionDelegate
        implements VendorAccessConnection {
            VendorAccessConnection delegate;
            Connection JDBCproxy;

            public VendorAccessConnectionDelegate(VendorAccessConnection aConnection) {
                this.delegate = aConnection;
            }

            @Override
            public Connection jdbcConnection() {
                if (this.JDBCproxy == null) {
                    try {
                        this.JDBCproxy = (Connection)LoggingProxyBuilder.getProxy((Logger)LoggingDatabaseImportElem.this.logger, (Pattern)Pattern.compile("^(java\\.sql\\..+)|(javax\\.sql\\..+)"), (Pattern)Pattern.compile(RelmdConfiguration.getStringProperty("JDBCTraceFilter")), (Object)this.delegate.jdbcConnection());
                    }
                    catch (Exception e) {
                        this.JDBCproxy = this.delegate.jdbcConnection();
                    }
                }
                return this.JDBCproxy;
            }

            @Override
            public VendorAccessHandler vendorAccessHandler() {
                return this.delegate.vendorAccessHandler();
            }

            @Override
            public SessionQueryRules sessionQueryRules() {
                return this.delegate.sessionQueryRules();
            }

            @Override
            public DatabaseAccessRules databaseAccessRules() {
                return this.delegate.databaseAccessRules();
            }

            @Override
            public DatabaseAccessHandler databaseAccessEventHandler() {
                return this.delegate.databaseAccessEventHandler();
            }

            @Override
            public Session session() {
                return this.delegate.session();
            }
        }
    }

    protected static interface IDatabaseImportElemDelegate {
        public ImportSummary run(VendorAccessConnection var1, MetadataImportRules var2, MetadataObjectSelections var3, MetadataElementHandler var4);

        public void extractObjects(ExtractionSummary var1, ReferenceableSet<SchemaSelection> var2, CatalogSelection var3);

        public void setVendorType(Database.EVendorType var1);

        public void setRawVendorType(Database.EVendorType var1);
    }
}

