/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.vendor.access.resultset.StopWatch;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.relmd.metadata.import_.functions.Event;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.SchemaSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.SchemaSummaryElem;
import com.ibm.cognos.relmd.vendor.access.VendorAccessTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ExtractionSummary
extends RelmdElement
implements ImportSummary,
SchemaSummary,
VendorAccessTimer {
    public static final String ATTRIBUTE_ROWSPROCESSED = "rowsProcessed";
    public static final String ATTRIBUTE_ELAPSEDTIME = "elapsedTime";
    private static final String ATTRIBUTE_function = "function";
    public static final String ATTR_TABLES_COUNTS = "tablesCount";
    public static final String ATTR_VIEWS_COUNTS = "viewsCount";
    public static final String ATTR_SYNONYMS_COUNTS = "synonymsCount";
    public static final String ATTR_PROCEDURES_COUNTS = "proceduresCount";
    public static final String ATTR_FUNCTIONS_COUNTS = "functionsCount";
    private float totalTime = 0.0f;
    private long totalRowsProcessed = 0L;
    private StopWatch stopWatch;
    public ArrayList<ImportSummary> m_childImportSummaries = new ArrayList();
    public ArrayList<SchemaSummary> m_childSchemaSummaries = new ArrayList();
    private SchemaSummaryElem m_schemaSummaryElem = new SchemaSummaryElem("schemaSummary");
    public long m_tablesCount = 0L;
    public long m_viewsCount = 0L;
    public long m_synonymsCount = 0L;
    public long m_proceduresCount = 0L;
    public long m_functionsCount = 0L;
    public static final String TAGNAME = "importSummary";

    public ExtractionSummary(String functionName) {
        super(TAGNAME);
        this.addAttribute(ATTRIBUTE_function, functionName);
        this.stopWatch = new StopWatch();
    }

    public ExtractionSummary(XmlAttributeGroup attributes) {
        super(TAGNAME, attributes);
    }

    @Override
    public void start() {
        this.stopWatch.start();
    }

    @Override
    public void stop() {
        this.stopWatch.stop();
        this.addAttribute(ATTRIBUTE_ROWSPROCESSED, String.valueOf(this.totalRowsProcessed));
        this.addAttribute(ATTRIBUTE_ELAPSEDTIME, this.stopWatch.getDisplayElapsedTime());
    }

    @Override
    public void incrementRowCount() {
        ++this.totalRowsProcessed;
    }

    @Override
    public void addChildImportSummary(ImportSummary importSummary) {
        if (null != importSummary) {
            this.m_childImportSummaries.add(importSummary);
            this.totalRowsProcessed += importSummary.rowsProcessed();
            this.totalTime += importSummary.elapsedTime();
        }
    }

    @Override
    public Collection<? extends XmlElement> childElements() {
        ArrayList<XmlElement> childXmlElements = new ArrayList<XmlElement>();
        Iterator<ImportSummary> childSummaryIter = this.importSummaryCollection().iterator();
        while (childSummaryIter.hasNext()) {
            childXmlElements.add(childSummaryIter.next().asXml());
        }
        return childXmlElements;
    }

    @Override
    public float elapsedTime() {
        return this.stopWatch.getElapsedTime();
    }

    @Override
    public Collection<Event> eventCollection() {
        return null;
    }

    @Override
    public String functionName() {
        return this.attributeValue(ATTRIBUTE_function);
    }

    @Override
    public long rowsProcessed() {
        return this.totalRowsProcessed;
    }

    @Override
    public Collection<ImportSummary> importSummaryCollection() {
        return this.m_childImportSummaries;
    }

    @Override
    public SchemaSummaryElem schemaSummaryElem() {
        return this.m_schemaSummaryElem;
    }

    @Override
    public void tablesCount(long tablesCount) {
        this.m_tablesCount = tablesCount;
    }

    @Override
    public void viewsCount(long viewsCount) {
        this.m_viewsCount = viewsCount;
    }

    @Override
    public void synonymsCount(long synonymsCount) {
        this.m_synonymsCount = synonymsCount;
    }

    @Override
    public void proceduresCount(long proceduresCount) {
        this.m_proceduresCount = proceduresCount;
    }

    @Override
    public void functionsCount(long functionsCount) {
        this.m_functionsCount = functionsCount;
    }

    public void addChildSchemaSummary(SchemaSummary schemaSummary) {
        this.m_childSchemaSummaries.add(schemaSummary);
    }

    @Override
    public Collection<SchemaSummary> schemaSummaryCollection() {
        return this.m_childSchemaSummaries;
    }

    @Override
    public long getFunctionsCount() {
        return this.m_functionsCount;
    }

    @Override
    public long getProceduresCount() {
        return this.m_proceduresCount;
    }

    @Override
    public long getSynonymsCount() {
        return this.m_synonymsCount;
    }

    @Override
    public long getTablesCount() {
        return this.m_tablesCount;
    }

    @Override
    public long getViewsCount() {
        return this.m_viewsCount;
    }
}

