/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ColumnRefElement;
import com.ibm.cognos.internal.relmd.metadata._schema.ExternalSchemaReferenceElem;
import com.ibm.cognos.internal.relmd.metadata._schema.ForeignKeyElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.ForeignKeyHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ExportedColumnRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ForeignKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.rules.ForeignKeysImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefColumnIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefUniqueKeyIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class ForeignKeysImportElem
extends ExtractionElement
implements ImportMetadataFunction,
VendorAccessResultSetHandler,
I_ChildElementHandler,
ForeignKeysImport {
    private ForeignKeyHandler m_foreignKeyHandler;
    private ForeignKey m_currentForeignKey;
    private ForeignKeysImportRules m_foreignKeysRules;
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler;
    private SessionAccess m_sessionAccess;
    private VendorAccessHandler m_vendorAccessHandler = null;
    private static final int TABLE_NAME_INDEX = 3;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public ForeignKeysImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importForeignKeys);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, ForeignKeysImportRules foreignKeysImportRules, MetadataObjectSelections objectSelections, ForeignKeyHandler foreignKeyHandler, ParentTableHandler parentTableHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_foreignKeyHandler = foreignKeyHandler;
        this.m_foreignKeysRules = foreignKeysImportRules;
        VendorAccess extractionQuery = this.m_foreignKeysRules.extractionQuery();
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_foreignKeysRules.objectSelectionsInclusionCollection();
        this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(parentTableHandler);
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        ImportSummary summary = null;
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        if (null != this.m_vendorType && this.m_vendorType == Database.EVendorType.genericHive) {
            String className = this.getClass().getName();
            summary = new ExtractionSummary(className);
        } else if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
            ForeignKeysImportElem resultSetHandler = this;
            this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
            this.m_schemaPathHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandler);
            summary = this.runForeignKeysImportGeneric(jdbcConnection, objectSelections, this.m_schemaPathHandler, this.m_foreignKeysRules, resultSetHandler);
        } else {
            summary = this.m_schemaChildLevelExtraction.run(relmdConnection.jdbcConnection(), (QueryObjectChildIndexes)this.m_foreignKeysRules, extractionQuery, relmdConnection, objectSelections, objectSelectionsInclusionCollection, this, parentCatalogSchemaHandler, (I_ChildElementHandler)this, this.m_vendorType);
        }
        return summary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        return this.run(relmdConnection, metadataImportRules.foreignKeysImportRules(), objectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        Collection<ExportedColumnRef> exportedForeignKeyRefCollection;
        RefUniqueKeyIndexes importedKeyRules = null;
        RefColumnIndexes exportedColumnsRules = null;
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            importedKeyRules = this.m_foreignKeysRules.importedKeyRulesForGeneric();
            exportedColumnsRules = this.m_foreignKeysRules.exportedColumnsRulesForGeneric();
        } else {
            importedKeyRules = this.m_foreignKeysRules.importedKeyRules();
            exportedColumnsRules = this.m_foreignKeysRules.exportedColumnsRules();
        }
        String description = resultSetValueRetrieval.stringValue(this.m_foreignKeysRules.descriptionRecordIndex());
        String catalog = resultSetValueRetrieval.stringValue(this.m_foreignKeysRules.parentCatalogNameRecordIndex());
        String schema = resultSetValueRetrieval.stringValue(this.m_foreignKeysRules.parentSchemaNameRecordIndex());
        String refQueryObject = resultSetValueRetrieval.stringValue(importedKeyRules.refQueryObjectRecordIndex());
        String exportedColumnRef = resultSetValueRetrieval.stringValue(exportedColumnsRules.refColumnNameRecordIndex());
        String foreignKeyName = resultSetValueRetrieval.stringValue(this.m_foreignKeysRules.foreignKeyNameRecordIndex());
        String importedUniqueKeyRef = resultSetValueRetrieval.stringValue(importedKeyRules.importedUniqueKeyRefIndex());
        if (this.m_currentForeignKey == null || !foreignKeyName.equals(this.m_currentForeignKey.objectName())) {
            if (this.m_currentForeignKey != null) {
                this.m_foreignKeyHandler.handleForeignKey(this.m_currentForeignKey);
            }
            ExternalSchemaReferenceElem externalSchemaReference = new ExternalSchemaReferenceElem(null, catalog, schema, resultSetValueRetrieval, importedKeyRules);
            boolean bExists = false;
            Table table = this.m_foreignKeyHandler.getParentTable();
            if (null != table) {
                Collection<ForeignKey> foreignKeys = table.foreignKeysCollection();
                for (ForeignKey foreignKeyInCollection : foreignKeys) {
                    String foreignKeyNameInCollection = foreignKeyInCollection.objectName();
                    String importedTableInCollection = foreignKeyInCollection.importedTableRef();
                    if (!foreignKeyNameInCollection.equals(foreignKeyName) || !importedTableInCollection.equals(refQueryObject)) continue;
                    this.m_currentForeignKey = foreignKeyInCollection;
                    bExists = true;
                    break;
                }
            }
            if (!bExists) {
                this.m_currentForeignKey = new ForeignKeyElem(description, foreignKeyName, refQueryObject, importedUniqueKeyRef, externalSchemaReference);
            }
        }
        ColumnRefElement columnRef = null;
        columnRef = null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1 ? new ColumnRefElement("exportedColumnRef", exportedColumnRef) : new ColumnRefElement("exportedColumnRef", resultSetValueRetrieval, exportedColumnsRules);
        boolean bColumnRefExist = this.bColumnRefExist(columnRef, exportedForeignKeyRefCollection = this.m_currentForeignKey.exportedColumnRefsCollection());
        if (!bColumnRefExist) {
            exportedForeignKeyRefCollection.add(columnRef);
        }
    }

    private boolean bColumnRefExist(ColumnRefElement columnRef, Collection<ExportedColumnRef> exportedForeignKeyRefCollection) {
        boolean bColumnRefExist = false;
        String columnRefName = columnRef.columnName();
        for (ExportedColumnRef columnRefInCollection : exportedForeignKeyRefCollection) {
            String columnName = columnRefInCollection.columnName();
            if (columnRefName == null || !columnRefName.equals(columnName)) continue;
            bColumnRefExist = true;
        }
        return bColumnRefExist;
    }

    @Override
    public void handleParentObjectChanged() {
        if (this.m_currentForeignKey != null) {
            this.m_foreignKeyHandler.handleForeignKey(this.m_currentForeignKey);
            this.m_currentForeignKey = null;
        }
    }

    @Override
    public void done() {
        this.handleParentObjectChanged();
    }

    @Override
    public void cancel() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private ExtractionSummary runForeignKeysImportGeneric(Connection connection, MetadataObjectSelections metadataObjectSelections, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        try {
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            if (bAllCatalogsSelected) {
                ResultSet rsTables = null;
                rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(null, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(null, null, null, tableTypeMapper.defaultTable_tableTypes);
                ArrayList<Object> tableNames = new ArrayList<Object>();
                while (rsTables != null && rsTables.next()) {
                    String tableName = rsTables.getString(3);
                    tableNames.add(tableName);
                }
                if (rsTables != null) {
                    rsTables.close();
                }
                for (String string : tableNames) {
                    summary = this.getForeignKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        this.m_catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> selectionChoice = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(connection, selectionChoice, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        block14: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            try {
                DatabaseMetaData md = connection.getMetaData();
                TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
                if (bAllSchemaSelected) {
                    ResultSet rsTables = null;
                    rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, null, null, tableTypeMapper.defaultTable_tableTypes);
                    ArrayList<Object> tableNames = new ArrayList<Object>();
                    while (rsTables != null && rsTables.next()) {
                        String tableName = rsTables.getString(3);
                        tableNames.add(tableName);
                    }
                    if (rsTables != null) {
                        rsTables.close();
                    }
                    for (String string : tableNames) {
                        summary = this.getForeignKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                    break block14;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block14;
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                for (SchemaSelection schemaSelection : selectedSchemas) {
                    this.m_schemaName = schemaSelection.objectName();
                    QualifierList.CatalogSchemaPath cs = this.getQualifiedCatalogSchema();
                    if (this.m_catalogName != null && this.m_catalogName.isEmpty() && null != cs && null != cs.getCatalog()) {
                        this.m_catalogName = cs.getCatalog();
                    }
                    if (this.m_schemaName != null && this.m_schemaName.isEmpty() && null != cs && null != cs.getSchema()) {
                        this.m_schemaName = cs.getSchema();
                    }
                    SelectionChoice<TableSelection, AllTablesSelection> tableSelections = schemaSelection.tableSelections();
                    boolean bAllTablesSelected = this.m_objectSelectionsToolkit.allSelected(tableSelections);
                    String escapedSchemaName = escapeObject.escape(this.m_schemaName);
                    if (bAllTablesSelected) {
                        ResultSet rsTables = null;
                        rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.defaultTable_tableTypes);
                        ArrayList<Object> objectNames = new ArrayList<Object>();
                        while (rsTables != null && rsTables.next()) {
                            String tableName = rsTables.getString(3);
                            objectNames.add(tableName);
                        }
                        if (rsTables != null) {
                            rsTables.close();
                        }
                        for (String string : objectNames) {
                            summary = this.getForeignKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    ReferenceableSet<TableSelection> selectedTables = tableSelections.selectedObjects();
                    if (null == selectedTables) continue;
                    for (TableSelection selectedTable : selectedTables) {
                        String string = selectedTable.objectName();
                        summary = this.getForeignKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExtractionSummary getForeignKeysGeneric(Connection connection, String tableName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        Statement statement = null;
        ResultSet rsForeignKeys = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            statement = connection.createStatement();
            if (this.m_catalogName != null && this.m_catalogName.isEmpty()) {
                this.m_catalogName = null;
            }
            if (this.m_schemaName != null && this.m_schemaName.isEmpty()) {
                this.m_schemaName = null;
            }
            rsForeignKeys = md.getImportedKeys(this.m_catalogName, this.m_schemaName, tableName);
            RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsForeignKeys, this.m_vendorAccessHandler);
            summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
            this.m_schemaChildLevelExtraction.close(rsForeignKeys, statement);
        }
        catch (SQLException sQLException) {
            this.m_schemaChildLevelExtraction.close(rsForeignKeys, statement);
            catch (Throwable throwable) {
                this.m_schemaChildLevelExtraction.close(rsForeignKeys, statement);
                throw throwable;
            }
        }
        this.done();
        return summary;
    }
}

