/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata.import_.functions.DatabaseImportElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions._chains.MetadataImportFunctionChain;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.ColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.DatabaseImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ForeignKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.IndexesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ProceduresImport;
import com.ibm.cognos.relmd.metadata.import_.functions.RoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.RoutinesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SynonymsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.TablesImport;
import com.ibm.cognos.relmd.metadata.import_.functions.UniqueKeysImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ViewsImport;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import java.util.ArrayList;

public class ImportFunctionChain
implements MetadataImportFunctionChain {
    private DatabaseImport m_databaseExtraction;
    private TablesImport m_tablesImport;
    private ViewsImport m_viewsImport;
    private ColumnsImport m_columnsImport;
    private UniqueKeysImport m_uniqueKeysImport;
    private ForeignKeysImport m_foreignKeysImport;
    private IndexesImport m_indexesImport;
    private SynonymsImport m_synonymsImport;
    private RoutinesImport m_routinesImport;
    private ProceduresImport m_proceduresImport;
    private FunctionsImport m_functionsImport;
    private RoutineArgumentsImport m_routineArgumentsImport;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;

    @Override
    public MetadataImportFunctionChain.EChainType getChainType() {
        return this.m_databaseExtraction == null ? MetadataImportFunctionChain.EChainType.full : MetadataImportFunctionChain.EChainType.partial;
    }

    public DatabaseImport getDatabaseImport() {
        this.m_databaseExtraction = new DatabaseImportElem();
        return this.m_databaseExtraction;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, MetadataImportRules importRules, MetadataElementHandler objectHandler) {
        MetadataImportFunctionChain.EChainType chainType = this.getChainType();
        ImportSummary extractionSummary = new ExtractionSummary(chainType.toString());
        Relmd relmdGateway = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmdGateway.metadataToolkit();
        MetadataImportToolkit importToolkit = metadataToolkit.metadataImportToolkit();
        if (MetadataImportFunctionChain.EChainType.full.equals((Object)chainType)) {
            extractionSummary = new ExtractionSummary(MetadataImportFunctionChain.EChainType.partial.toString());
            DatabaseImport databaseImport = importToolkit.databaseImport();
            databaseImport.setVendorType(this.m_vendorType);
            databaseImport.setRawVendorType(this.m_rawVendorType);
            extractionSummary = databaseImport.run(relmdConnection, importRules, objectSelections, objectHandler);
        } else {
            extractionSummary = new ExtractionSummary(chainType.toString());
            ArrayList<ImportMetadataFunction> functions = this.getImportFunctionCollection();
            for (ImportMetadataFunction importFunction : functions) {
                importFunction.setVendorType(this.m_vendorType);
                importFunction.setRawVendorType(this.m_rawVendorType);
                importFunction.run(relmdConnection, importRules, objectSelections, objectHandler);
            }
        }
        return extractionSummary;
    }

    @Override
    public ArrayList<ImportMetadataFunction> getImportFunctionCollection() {
        ArrayList<ImportMetadataFunction> functions = new ArrayList<ImportMetadataFunction>();
        if (this.hasTablesImport()) {
            functions.add(this.getTablesImport());
        }
        if (this.hasViewsImport()) {
            functions.add(this.getViewsImport());
        }
        if (this.hasColumnsImport()) {
            functions.add(this.getColumnsImport());
        }
        if (this.hasUniqueKeysImport()) {
            functions.add(this.getUniqueKeysImport());
        }
        if (this.hasForeignKeysImport()) {
            functions.add(this.getForeignKeysImport());
        }
        if (this.hasIndexesImport()) {
            functions.add(this.getIndexesImport());
        }
        if (this.hasSynonymsImport()) {
            functions.add(this.getSynonymsImport());
        }
        if (this.hasRoutinesImport()) {
            functions.add(this.getRoutinesImport());
        }
        if (this.hasFunctionsImport()) {
            functions.add(this.getFunctionsImport());
        }
        if (this.hasProceduresImport()) {
            functions.add(this.getProceduresImport());
        }
        if (this.hasRoutineArgumentsImport()) {
            functions.add(this.getRoutineArgumentsImport());
        }
        return functions;
    }

    @Override
    public boolean hasTablesImport() {
        return null != this.getTablesImport();
    }

    @Override
    public boolean hasViewsImport() {
        return null != this.getViewsImport();
    }

    @Override
    public TablesImport getTablesImport() {
        return this.m_tablesImport;
    }

    @Override
    public ViewsImport getViewsImport() {
        return this.m_viewsImport;
    }

    public void addTablesImport(TablesImport tablesImport) {
        this.m_tablesImport = tablesImport;
    }

    public void addViewsImport(ViewsImport viewsImport) {
        this.m_viewsImport = viewsImport;
    }

    @Override
    public boolean hasColumnsImport() {
        return null != this.getColumnsImport();
    }

    @Override
    public ColumnsImport getColumnsImport() {
        return this.m_columnsImport;
    }

    public void addColumnsImport(ColumnsImport columnsImport) {
        this.m_columnsImport = columnsImport;
    }

    @Override
    public boolean hasUniqueKeysImport() {
        return null != this.getUniqueKeysImport();
    }

    @Override
    public UniqueKeysImport getUniqueKeysImport() {
        return this.m_uniqueKeysImport;
    }

    public void addUniqueKeysImport(UniqueKeysImport uniqueKeysImport) {
        this.m_uniqueKeysImport = uniqueKeysImport;
    }

    @Override
    public boolean hasForeignKeysImport() {
        return null != this.getForeignKeysImport();
    }

    @Override
    public ForeignKeysImport getForeignKeysImport() {
        return this.m_foreignKeysImport;
    }

    public void addForeignKeysImport(ForeignKeysImport foreignKeysImport) {
        this.m_foreignKeysImport = foreignKeysImport;
    }

    @Override
    public boolean hasIndexesImport() {
        return null != this.getIndexesImport();
    }

    @Override
    public IndexesImport getIndexesImport() {
        return this.m_indexesImport;
    }

    public void addIndexesImport(IndexesImport indexesImport) {
        this.m_indexesImport = indexesImport;
    }

    @Override
    public boolean hasSynonymsImport() {
        return null != this.getSynonymsImport();
    }

    @Override
    public SynonymsImport getSynonymsImport() {
        return this.m_synonymsImport;
    }

    public void addSynonymsImport(SynonymsImport synonymsImport) {
        this.m_synonymsImport = synonymsImport;
    }

    @Override
    public boolean hasRoutinesImport() {
        return null != this.getRoutinesImport();
    }

    @Override
    public RoutinesImport getRoutinesImport() {
        return this.m_routinesImport;
    }

    public void addRoutinesImport(RoutinesImport routinesImport) {
        this.m_routinesImport = routinesImport;
    }

    public boolean hasFunctionsImport() {
        return null != this.getFunctionsImport();
    }

    public FunctionsImport getFunctionsImport() {
        return this.m_functionsImport;
    }

    public void addFunctionsImport(FunctionsImport functionsImport) {
        this.m_functionsImport = functionsImport;
    }

    public boolean hasProceduresImport() {
        return null != this.getProceduresImport();
    }

    public ProceduresImport getProceduresImport() {
        return this.m_proceduresImport;
    }

    public void addProceduresImport(ProceduresImport proceduresImport) {
        this.m_proceduresImport = proceduresImport;
    }

    @Override
    public boolean hasRoutineArgumentsImport() {
        return null != this.getRoutineArgumentsImport();
    }

    @Override
    public RoutineArgumentsImport getRoutineArgumentsImport() {
        return this.m_routineArgumentsImport;
    }

    public void addRoutineArgumentsImport(RoutineArgumentsImport routineArgumentsImport) {
        this.m_routineArgumentsImport = routineArgumentsImport;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }
}

