/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ProcedureElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.ProcedureHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.ProceduresImport;
import com.ibm.cognos.relmd.metadata.import_.rules.ProceduresImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ProceduresImportElem
extends ExtractionElement
implements VendorAccessResultSetHandler,
I_ChildElementHandler,
ProceduresImport {
    private ProceduresImportRules m_proceduresImportRules = null;
    private ProcedureHandler m_procedureHandler = null;
    private ProcedureElem m_procedure = null;
    private VendorAccessResultSet m_resultSet = null;
    private SessionAccess m_sessionAccess;
    private SessionAccessToolkit m_sessionAccessToolkit;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private MetadataImportSelectionsChoice m_objectSelectionsChoice;
    private ExtractionSummary m_importSummary;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private boolean m_applyQualifierList = false;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public ProceduresImportElem(SessionAccess sessionAccess) {
        super(ImportMetadataFunction.EImportFunctionType.importProcedures);
        Relmd relmd = RelmdGateway.relmd();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccess;
        this.m_objectSelectionsChoice = null;
        this.m_importSummary = null;
    }

    public ProceduresImportElem() {
        this((SessionAccess)null);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, ProceduresImportRules proceduresImportRules, MetadataObjectSelections objectSelections, ProcedureHandler procedureHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_resultSet = null;
        this.m_procedureHandler = procedureHandler;
        this.m_proceduresImportRules = proceduresImportRules;
        this.m_sessionAccess = this.m_sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_objectSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        VendorAccess m_extractionQuery = this.m_proceduresImportRules.extractionQuery();
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (parentCatalogSchemaHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)this.m_proceduresImportRules, parentCatalogSchemaHandler, (I_ChildElementHandler)this);
        }
        this.m_importSummary = new ExtractionSummary(this.getClass().getName());
        this.m_importSummary.start();
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            Connection jdbcConnection = relmdConnection.jdbcConnection();
            this.runProceduresImportGeneric(jdbcConnection, resultSetSchemaLocator);
        } else {
            this.m_resultSet = m_extractionQuery.run(relmdConnection, objectSelections, this.m_proceduresImportRules.objectSelectionsInclusionCollection());
            VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
            while (resultSetIterator.next()) {
                VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
                this.m_importSummary.incrementRowCount();
                if (resultSetSchemaLocator != null) {
                    resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
                }
                this.handleResultSetRecord(resultSetValueRetrieval);
            }
        }
        this.done();
        this.m_importSummary.proceduresCount(this.m_importSummary.rowsProcessed());
        this.m_importSummary.stop();
        return this.m_importSummary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        ImportSummary summary = this.run(relmdConnection, metadataImportRules.proceduresImportRules(), objectSelections, modelElementHandler, modelElementHandler);
        return summary;
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        int nameRecordIndex = this.m_proceduresImportRules.nameRecordIndex();
        int descriptionRecordIndex = this.m_proceduresImportRules.descriptionRecordIndex();
        String description = resultSetValueRetrieval.stringValue(descriptionRecordIndex);
        String procedureName = resultSetValueRetrieval.stringValue(nameRecordIndex);
        if (this.m_procedure == null || !this.m_procedure.objectName().equals(procedureName)) {
            this.m_procedure = new ProcedureElem("storedProcedure", description, procedureName);
            this.m_procedureHandler.handleStoredProcedure(this.m_procedure);
        }
    }

    public void handleResultSetRecord(String description, String procedureName) {
        if (this.m_procedure == null || !this.m_procedure.objectName().equals(procedureName)) {
            this.m_procedure = new ProcedureElem("storedProcedure", description, procedureName);
            this.m_procedureHandler.handleStoredProcedure(this.m_procedure);
        }
    }

    @Override
    public void handleParentObjectChanged() {
    }

    public ProceduresImportRules proceduresImportRule() {
        return this.m_proceduresImportRules;
    }

    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runProceduresImportGeneric(Connection connection, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        Statement statement = null;
        ResultSet rsProcedures = null;
        try {
            statement = connection.createStatement();
            DatabaseMetaData md = connection.getMetaData();
            MetadataObjectSelections metadataObjectSelections = this.m_objectSelectionsChoice.metadataObjectSelections();
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                rsProcedures = md.getProcedures(null, null, null);
                this.handleResultSet(statement, rsProcedures, resultSetSchemaLocator);
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        String catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, catalogName);
                    }
                }
            }
            this.close(rsProcedures, statement);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
        finally {
            this.close(rsProcedures, statement);
        }
    }

    private void handleResultSet(Statement statement, ResultSet rsProcedures, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        ProcedureInfo procedureInfo;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsProcedures, vendorAccessHandler);
        this.m_resultSet = relmdResultSet;
        ArrayList<ProcedureInfo> procedureInfoList = new ArrayList<ProcedureInfo>();
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            String catalogName = resultSetValueRetrieval.stringValue(this.m_proceduresImportRules.parentCatalogNameRecordIndex());
            String schemaName = resultSetValueRetrieval.stringValue(this.m_proceduresImportRules.parentSchemaNameRecordIndex());
            int descriptionRecordIndex = this.m_proceduresImportRules.descriptionRecordIndex();
            String description = resultSetValueRetrieval.stringValue(descriptionRecordIndex);
            int nameRecordIndex = this.m_proceduresImportRules.nameRecordIndex();
            String procedureName = resultSetValueRetrieval.stringValue(nameRecordIndex);
            ProcedureInfo procedureInfo2 = new ProcedureInfo(catalogName, schemaName, description, procedureName);
            procedureInfoList.add(procedureInfo2);
        }
        ArrayList<QualifierList.CatalogSchemaPath> qualifierList = this.getQualifierList();
        if (null == qualifierList) {
            this.m_applyQualifierList = false;
        }
        if (this.m_applyQualifierList && null != (procedureInfo = this.findProcedureInfoWithQualifierList(procedureInfoList, qualifierList))) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(procedureInfo.getCatalog(), procedureInfo.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(procedureInfo.getDescription(), procedureInfo.getProcedure());
            return;
        }
        for (ProcedureInfo procedureInfo3 : procedureInfoList) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(procedureInfo3.getCatalog(), procedureInfo3.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(procedureInfo3.getDescription(), procedureInfo3.getProcedure());
        }
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private ProcedureInfo findProcedureInfoWithQualifierList(ArrayList<ProcedureInfo> procedureInfoList, ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        if (1 == procedureInfoList.size()) {
            ProcedureInfo procedureInfo = procedureInfoList.get(0);
            QualifierList.CatalogSchemaPath cs = new QualifierList.CatalogSchemaPath(procedureInfo.getCatalog(), procedureInfo.getSchema());
            this.setQualifiedCatalogSchema(cs);
            return procedureInfo;
        }
        if (0 >= procedureInfoList.size()) {
            return null;
        }
        boolean matching = false;
        for (QualifierList.CatalogSchemaPath qualifier : qualifierList) {
            String qualifierCatalogName = qualifier.getCatalog();
            String qualifierSchemaName = qualifier.getSchema();
            for (ProcedureInfo procedureInfo : procedureInfoList) {
                String catalogValue = procedureInfo.getCatalog();
                String schemaValue = procedureInfo.getSchema();
                if (null == qualifierCatalogName && null != qualifierSchemaName) {
                    matching = qualifierSchemaName.equals(schemaValue);
                } else if (null != qualifierCatalogName && null == qualifierSchemaName) {
                    matching = qualifierCatalogName.equals(catalogValue);
                } else if (null == qualifierCatalogName && null == qualifierSchemaName) {
                    matching = false;
                } else {
                    boolean bl = matching = qualifierSchemaName.equals(schemaValue) && qualifierCatalogName.equals(catalogValue);
                }
                if (!matching) continue;
                this.setQualifiedCatalogSchema(qualifier);
                return procedureInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleSchemaSelections(Statement statement, DatabaseMetaData md, ParentSchemaReferenceProcessor resultSetSchemaLocator, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, String catalogName) {
        boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
        ResultSet rsProcedures = null;
        try {
            if (bAllSchemaSelected) {
                rsProcedures = md.getProcedures(catalogName, null, null);
                this.handleResultSet(statement, rsProcedures, resultSetSchemaLocator);
            } else {
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null != selectedSchemas) {
                    EscapeObjectName escapeObject = new EscapeObjectName(md);
                    for (SchemaSelection selectedSchema : selectedSchemas) {
                        String schemaName = selectedSchema.objectName();
                        if (catalogName != null && catalogName.isEmpty()) {
                            catalogName = null;
                        }
                        if (schemaName != null && schemaName.isEmpty()) {
                            schemaName = null;
                        }
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        SelectionChoice<ProcedureSelection, AllProceduresSelection> procedureSelections = selectedSchema.procedureSelections();
                        boolean bAllProcedureSelected = this.m_objectSelectionsToolkit.allSelected(procedureSelections);
                        if (bAllProcedureSelected) {
                            rsProcedures = md.getProcedures(catalogName, escapedSchemaName, null);
                            this.handleResultSet(statement, rsProcedures, resultSetSchemaLocator);
                            continue;
                        }
                        ReferenceableSet<ProcedureSelection> selectedProcedures = procedureSelections.selectedObjects();
                        if (null == selectedProcedures) continue;
                        for (ProcedureSelection selectedProcedure : selectedProcedures) {
                            String procedureName = selectedProcedure.objectName();
                            String escapedProcedureName = escapeObject.escape(procedureName);
                            String resolvedCatalogName = catalogName;
                            String resolvedProcedureName = escapedProcedureName;
                            if (this.m_rawVendorType.equals((Object)Database.EVendorType.oracle)) {
                                if (!escapedProcedureName.contains(".")) {
                                    if (catalogName == null) {
                                        resolvedCatalogName = "";
                                    }
                                } else {
                                    resolvedCatalogName = escapedProcedureName.substring(0, escapedProcedureName.indexOf("."));
                                    resolvedProcedureName = escapedProcedureName.substring(escapedProcedureName.indexOf(".") + 1, escapedProcedureName.length());
                                }
                            }
                            rsProcedures = md.getProcedures(resolvedCatalogName, escapedSchemaName, resolvedProcedureName);
                            this.handleResultSet(statement, rsProcedures, resultSetSchemaLocator);
                        }
                    }
                }
            }
            this.close(rsProcedures, null);
        }
        catch (SQLException sQLException) {
            this.close(rsProcedures, null);
            catch (Throwable throwable) {
                this.close(rsProcedures, null);
                throw throwable;
            }
        }
    }

    private void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class ProcedureInfo
    extends QualifierList.CatalogSchemaPath {
        private String description;
        private String procedure;

        public ProcedureInfo(String catalog, String schema, String desc, String procedure) {
            super(catalog, schema);
            this.description = null;
            this.procedure = null;
            this.description = desc;
            this.procedure = procedure;
        }

        public String getDescription() {
            return this.description;
        }

        public String getProcedure() {
            return this.procedure;
        }
    }
}

