/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SimulatedResultSet
implements VendorAccessResultSet,
VendorAccessResultSetIterator,
VendorAccessResultSetValues {
    private ArrayList<Row> rows = new ArrayList();
    int currentRow = -1;

    public void addRow(String ... data) {
        this.rows.add(new Row(data));
    }

    public void addRow(ResultSet rs, int ... columns) throws SQLException {
        Row row = new Row();
        try {
            for (int col : columns) {
                String s = rs.getString(col);
                if (rs.wasNull()) {
                    s = null;
                }
                row.add(s);
            }
        }
        catch (SQLException e) {
            rs.close();
            throw e;
        }
        this.rows.add(row);
    }

    public void addAll(ResultSet rs, int ... columns) throws SQLException {
        while (rs.next()) {
            this.addRow(rs, columns);
        }
        rs.close();
    }

    public int size() {
        return this.rows.size();
    }

    public void deleteCurrentRow() {
        if (this.currentRow >= 0) {
            this.rows.remove(this.currentRow);
            --this.currentRow;
        }
    }

    public void reset() {
        this.currentRow = -1;
    }

    @Override
    public VendorAccessResultSetIterator iterator() {
        return this;
    }

    @Override
    public VendorAccessResultSetValues values() {
        return this;
    }

    @Override
    public void close() {
        for (Row row : this.rows) {
            row.clear();
        }
        this.rows.clear();
        this.reset();
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        return this.currentRow < this.rows.size();
    }

    @Override
    public String stringValue(int index) {
        return (String)this.rows.get(this.currentRow).get(index - 1);
    }

    @Override
    public Integer intValue(int signatureIndex) {
        return Integer.valueOf(this.stringValue(signatureIndex));
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.rows.size(); ++i) {
            b.append(i);
            b.append(" : ");
            b.append(this.rows.get(i).toString());
            b.append("\n");
        }
        return b.toString();
    }

    private class Row
    extends ArrayList<String> {
        protected Row(String[] data) {
            for (String datum : data) {
                this.add(datum);
            }
        }

        protected Row() {
        }
    }
}

