/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlWriter;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.ColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectColumnsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectImport;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectResults;
import com.ibm.cognos.relmd.metadata.import_.rules.ColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectImportRules;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.session._schema.SqlObjectConflict;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class SqlObjectColumnsImportElem
implements SqlObjectColumnsImport {
    public static final String TAGNAME = "sqlObjectColumnsImport";
    private SqlObjectImport m_sqlObjectImport;
    private SessionAccess m_sessionAccess;
    private Handler<Column> m_columnHandler;
    private ColumnsImportRules m_columnsImportRules;
    private SqlObjectResults m_sqlObjectResults;
    private final ISqlObjectColumnsImportElemDelegate delegate;
    private static final String loggingClassName = SqlObjectColumnsImportElem.class.getSimpleName();

    public SqlObjectColumnsImportElem(SqlObjectImport sqlObjectImport, ColumnsImportRules columnsImportRules, Handler<Column> columnHandler) {
        this.delegate = RelmdLoggerFactory.isLoggingEnabled(loggingClassName) ? new SqlObjectColumnsImportElemLogger(sqlObjectImport, columnsImportRules, columnHandler) : new SqlObjectColumnsImportElemImpl(sqlObjectImport, columnsImportRules, columnHandler);
    }

    @Override
    public void run(Connection jdbcConnection) {
        this.delegate.run(jdbcConnection);
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public XmlElement asXml() {
        return this.delegate.asXml();
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.delegate.setVendorType(vendorType);
    }

    @Override
    public SqlObjectQueryPath getUpdatedSqlObjectQueryPath() {
        return this.delegate.getUpdatedSqlObjectQueryPath();
    }

    @Override
    public SchemaPath getMatchingSchemaPathFromQualifierList() {
        SchemaPath schemaPath = this.m_sqlObjectImport.getMatchingSchemaPathFromQualifierList();
        return schemaPath;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath() {
        SqlObjectQueryPath sqlObjectQueryPath = this.m_sqlObjectImport.sqlObjectQueryPath();
        return sqlObjectQueryPath;
    }

    @Override
    public SqlObjectColumnsImportRules sqlObjectColumnsImportRules() {
        final SqlObjectImportRules sqlObjectImportRules = this.m_sqlObjectImport.sqlObjectImportRules();
        SqlObjectColumnsImportRules sqlObjectColumnsImportRules = new SqlObjectColumnsImportRules(){

            @Override
            public SqlObjectImportRules sqlObjectImportRules() {
                return sqlObjectImportRules;
            }

            @Override
            public ColumnsImportRules columnsImportRules() {
                return SqlObjectColumnsImportElem.this.m_columnsImportRules;
            }
        };
        return sqlObjectColumnsImportRules;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public Handler<Column> columnHandler() {
        return this.m_columnHandler;
    }

    @Override
    public Handler<Synonym> synonymHandler() {
        Handler<Synonym> synonymHandler = this.m_sqlObjectImport.synonymHandler();
        return synonymHandler;
    }

    @Override
    public Handler<SqlObjectConflict> sqlObjectConflictHandler() {
        return this.m_sqlObjectResults.sqlObjectConflictHandler();
    }

    @Override
    public Handler<Catalog> catalogHandler() {
        return this.m_sqlObjectResults.catalogHandler();
    }

    @Override
    public Handler<Schema> schemaHandler() {
        return this.m_sqlObjectResults.schemaHandler();
    }

    @Override
    public Handler<Table> tableHandler() {
        return this.m_sqlObjectResults.tableHandler();
    }

    @Override
    public Handler<View> viewHandler() {
        return this.m_sqlObjectResults.viewHandler();
    }

    public String toString() {
        String string = "";
        ByteArrayOutputStream requestOut = new ByteArrayOutputStream();
        try {
            XmlElement asXml = this.asXml();
            XmlWriter writer = new XmlWriter("relmd", "relmdApi.xsd", "../webcontent/remd");
            writer.writeElem(asXml, requestOut, "relmd");
            requestOut.flush();
            requestOut.close();
            string = requestOut.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private class SqlObjectColumnsImportElemImpl
    implements ISqlObjectColumnsImportElemDelegate,
    ISqlObjectColumnsImportElemDelegate_public {
        private final Relmd m_relmd;
        private final MetadataToolkit m_metadataToolkit;
        private boolean m_bCancelled;
        private Catalog m_parentCatalog;
        private Schema m_parentSchema;
        private SqlObjectQueryPath m_sqlObjectQueryPath;
        private MetadataImportToolkit m_metadataImportToolkit;
        private VendorAccessToolkit m_vendorAccessToolkit;

        public SqlObjectColumnsImportElemImpl(final SqlObjectImport sqlObjectImport, ColumnsImportRules columnsImportRules, Handler<Column> columnHandler) {
            SqlObjectColumnsImportElem.this.m_sqlObjectResults = sqlObjectImport;
            SqlObjectColumnsImportElem.this.m_columnsImportRules = columnsImportRules;
            SqlObjectColumnsImportElem.this.m_columnHandler = columnHandler;
            SqlObjectColumnsImportElem.this.m_sessionAccess = sqlObjectImport.sessionAccess();
            this.m_relmd = RelmdGateway.relmd();
            this.m_metadataToolkit = this.m_relmd.metadataToolkit();
            this.m_bCancelled = false;
            this.m_sqlObjectQueryPath = null;
            this.m_metadataImportToolkit = this.m_metadataToolkit.metadataImportToolkit();
            SessionQueryRules sessionQueryRules = SqlObjectColumnsImportElem.this.m_sessionAccess.sessionQueryRules();
            final Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
            SqlObjectImportRules sqlObjectImportRules = sqlObjectImport.sqlObjectImportRules();
            final MetadataObjectPathsToolkit m_objectPathsToolkit = this.m_metadataToolkit.metadataObjectPathsToolkit();
            SqlObjectResults sqlObjectResults = new SqlObjectResults(){

                @Override
                public Handler<Catalog> catalogHandler() {
                    Handler<Catalog> handler = new Handler<Catalog>(){

                        @Override
                        public void handle(Catalog obj) {
                            Handler<Catalog> catalogHandler = sqlObjectImport.catalogHandler();
                            catalogHandler.handle(obj);
                            SqlObjectColumnsImportElemImpl.this.m_parentCatalog = obj;
                        }
                    };
                    return handler;
                }

                @Override
                public Handler<Schema> schemaHandler() {
                    Handler<Schema> handler = new Handler<Schema>(){

                        @Override
                        public void handle(Schema obj) {
                            Handler<Schema> schemaHandler = SqlObjectColumnsImportElem.this.m_sqlObjectResults.schemaHandler();
                            schemaHandler.handle(obj);
                            SqlObjectColumnsImportElemImpl.this.m_parentSchema = obj;
                        }
                    };
                    return handler;
                }

                @Override
                public Handler<SqlObjectConflict> sqlObjectConflictHandler() {
                    Handler<SqlObjectConflict> sqlObjectConflictHandler = SqlObjectColumnsImportElem.this.m_sqlObjectResults.sqlObjectConflictHandler();
                    return sqlObjectConflictHandler;
                }

                @Override
                public Handler<Synonym> synonymHandler() {
                    Handler<Synonym> handler = new Handler<Synonym>(){

                        @Override
                        public void handle(Synonym obj) {
                            Handler<Synonym> synonymHandler = SqlObjectColumnsImportElem.this.m_sqlObjectResults.synonymHandler();
                            synonymHandler.handle(obj);
                            String externalParentCatalogName = obj.externalCatalogRef();
                            String externalParentSchemaName = obj.externalSchemaRef();
                            String objectName = obj.targetRef();
                            if (externalParentCatalogName != null && !externalParentCatalogName.isEmpty() && !externalParentCatalogName.equals(SqlObjectColumnsImportElemImpl.this.m_parentCatalog.objectName())) {
                                SqlObjectColumnsImportElemImpl.this.m_parentCatalog = SqlObjectColumnsImportElemImpl.this.m_metadataToolkit.catalog(externalParentCatalogName);
                            }
                            if (externalParentSchemaName != null && !externalParentSchemaName.isEmpty() && !externalParentSchemaName.equals(SqlObjectColumnsImportElemImpl.this.m_parentSchema.objectName())) {
                                SqlObjectColumnsImportElemImpl.this.m_parentSchema = SqlObjectColumnsImportElemImpl.this.m_metadataToolkit.schema(externalParentSchemaName);
                            }
                            SqlObjectColumnsImportElemImpl.this.m_sqlObjectQueryPath = m_objectPathsToolkit.sqlObjectQueryPath(catalogSupport, externalParentCatalogName, externalParentSchemaName, objectName);
                        }
                    };
                    return handler;
                }

                @Override
                public Handler<Table> tableHandler() {
                    Handler<Table> handler = new Handler<Table>(){

                        @Override
                        public void handle(Table obj) {
                            Handler<Table> tableHandler = SqlObjectColumnsImportElem.this.m_sqlObjectResults.tableHandler();
                            tableHandler.handle(obj);
                            SchemaPath schemaPath = m_objectPathsToolkit.schemaPath(catalogSupport, SqlObjectColumnsImportElemImpl.this.m_parentCatalog, SqlObjectColumnsImportElemImpl.this.m_parentSchema);
                            String objectName = obj.objectName();
                            SqlObjectColumnsImportElemImpl.this.m_sqlObjectQueryPath = m_objectPathsToolkit.sqlObjectQueryPath(schemaPath, objectName);
                        }
                    };
                    return handler;
                }

                @Override
                public Handler<View> viewHandler() {
                    Handler<View> handler = new Handler<View>(){

                        @Override
                        public void handle(View obj) {
                            Handler<View> viewHandler = SqlObjectColumnsImportElem.this.m_sqlObjectResults.viewHandler();
                            viewHandler.handle(obj);
                            SchemaPath schemaPath = m_objectPathsToolkit.schemaPath(catalogSupport, SqlObjectColumnsImportElemImpl.this.m_parentCatalog, SqlObjectColumnsImportElemImpl.this.m_parentSchema);
                            String objectName = obj.objectName();
                            SqlObjectColumnsImportElemImpl.this.m_sqlObjectQueryPath = m_objectPathsToolkit.sqlObjectQueryPath(schemaPath, objectName);
                        }
                    };
                    return handler;
                }
            };
            SqlObjectQueryPath sqlObjectQueryPath = sqlObjectImport.sqlObjectQueryPath();
            SqlObjectColumnsImportElem.this.m_sqlObjectImport = this.m_metadataImportToolkit.sqlObjectImport(SqlObjectColumnsImportElem.this.m_sessionAccess, sqlObjectQueryPath, sqlObjectImportRules, sqlObjectResults);
            VendorToolkit vendorToolkit = this.m_relmd.vendorToolkit();
            this.m_vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        }

        @Override
        public void run(Connection jdbcConnection) {
            ExtractionSummary summary = new ExtractionSummary(SqlObjectColumnsImportElem.TAGNAME);
            summary.start();
            VendorAccessResults vendorAccessResults = SqlObjectColumnsImportElem.this.m_sessionAccess.vendorAccessResults();
            VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
            Handler<ExecutionInformation> executionInformationHandler = vendorAccessHandler.executionInformationHandler();
            String xmlValue = SqlObjectColumnsImportElem.this.toString();
            ExecutionInformation runBegin = this.m_vendorAccessToolkit.executionInformation(xmlValue);
            executionInformationHandler.handle(runBegin);
            SqlObjectColumnsImportElem.this.m_sqlObjectImport.run(jdbcConnection);
            if (!this.m_bCancelled && null != this.m_sqlObjectQueryPath) {
                MetadataObjectSelectionsToolkit m_objectSelectionsToolkit = this.m_metadataToolkit.metadataObjectSelectionsToolkit();
                MetadataImportSelectionsChoice metadataImportSelectionsChoice = m_objectSelectionsToolkit.metadataImportSelectionsChoice(this.m_sqlObjectQueryPath);
                Handler<ColumnContainerObjectRef> columnContainerObjectRefHandler = new Handler<ColumnContainerObjectRef>(){

                    @Override
                    public void handle(ColumnContainerObjectRef obj) {
                    }
                };
                Handler<Catalog> catalogHandler = new Handler<Catalog>(){

                    @Override
                    public void handle(Catalog obj) {
                    }
                };
                Handler<Schema> schemaHandler = new Handler<Schema>(){

                    @Override
                    public void handle(Schema obj) {
                    }
                };
                MetadataImportToolkit metadataImportToolkit = this.m_metadataToolkit.metadataImportToolkit();
                Database.EVendorType vendorType = SqlObjectColumnsImportElem.this.m_sessionAccess.vendorType();
                ColumnsImport columnsImport = metadataImportToolkit.columnsImport(SqlObjectColumnsImportElem.this.m_sessionAccess, metadataImportSelectionsChoice, SqlObjectColumnsImportElem.this.m_columnsImportRules, catalogHandler, schemaHandler, columnContainerObjectRefHandler, SqlObjectColumnsImportElem.this.m_columnHandler);
                columnsImport.setVendorType(vendorType);
                columnsImport.run(jdbcConnection);
            }
            summary.stop();
            ExecutionInformation runEnd = this.m_vendorAccessToolkit.executionInformation(xmlValue + "done, time: " + summary.elapsedTime());
            executionInformationHandler.handle(runEnd);
        }

        @Override
        public void stop() {
            SqlObjectColumnsImportElem.this.m_sqlObjectImport.stop();
            this.m_bCancelled = true;
        }

        @Override
        public XmlElement asXml() {
            final RelmdAttributeGroup attributeGroup = new RelmdAttributeGroup();
            final ArrayList<XmlElement> childElements = new ArrayList<XmlElement>();
            childElements.add(SqlObjectColumnsImportElem.this.m_sessionAccess);
            SqlObjectQueryPath sqlObjectQueryPath = SqlObjectColumnsImportElem.this.sqlObjectQueryPath();
            childElements.add(sqlObjectQueryPath);
            XmlElement xmlElement = new XmlElement(){

                @Override
                public String getTagName() {
                    return SqlObjectColumnsImportElem.TAGNAME;
                }

                @Override
                public void add(XmlAttribute attribute) {
                    attributeGroup.add(attribute);
                }

                @Override
                public Collection<? extends XmlAttribute> attributes() {
                    return attributeGroup.attributes();
                }

                @Override
                public XmlAttribute getAttribute(String name) {
                    return attributeGroup.getAttribute(name);
                }

                @Override
                public Collection<? extends XmlElement> childElements() {
                    return childElements;
                }
            };
            return xmlElement;
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
        }

        @Override
        public SqlObjectQueryPath getUpdatedSqlObjectQueryPath() {
            return this.m_sqlObjectQueryPath;
        }
    }

    private class SqlObjectColumnsImportElemLogger
    implements ISqlObjectColumnsImportElemDelegate,
    ISqlObjectColumnsImportElemDelegate_public {
        private Logger logger = RelmdLoggerFactory.get(SqlObjectColumnsImportElem.access$000());
        ColumnHandlerDelegate handler;
        SqlObjectColumnsImportElemImpl impl;

        public SqlObjectColumnsImportElemLogger(SqlObjectImport sqlObjectImport, ColumnsImportRules columnsImportRules, Handler<Column> columnHandler) {
            Object[] parms = new Object[]{sqlObjectImport, columnsImportRules, columnHandler};
            this.logger.entering(loggingClassName, loggingClassName, parms);
            this.handler = new ColumnHandlerDelegate(columnHandler);
            try {
                this.impl = new SqlObjectColumnsImportElemImpl(sqlObjectImport, columnsImportRules, this.handler);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, loggingClassName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, loggingClassName);
        }

        @Override
        public void run(Connection jdbcConnection) {
            Object[] parms = new Object[]{RelmdLoggerFactory.connectionLogText(jdbcConnection)};
            String methodName = "run";
            this.logger.entering(loggingClassName, methodName, parms);
            try {
                this.impl.run(jdbcConnection);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, this.handler.xmlText);
            RelmdLoggerFactory.flush(this.logger);
        }

        @Override
        public void stop() {
            String methodName = "stop";
            this.logger.entering(loggingClassName, methodName);
            try {
                this.impl.stop();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName);
        }

        @Override
        public XmlElement asXml() {
            XmlElement result;
            String methodName = "asXml";
            this.logger.entering(loggingClassName, methodName);
            try {
                result = this.impl.asXml();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName, result);
            RelmdLoggerFactory.flush(this.logger);
            return result;
        }

        @Override
        public void setVendorType(Database.EVendorType vendorType) {
            Object[] parms = new Object[]{vendorType};
            String methodName = "vendorType";
            this.logger.entering(loggingClassName, methodName, parms);
            try {
                this.impl.setVendorType(vendorType);
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName);
        }

        @Override
        public SqlObjectQueryPath getUpdatedSqlObjectQueryPath() {
            String methodName = "getUpdatedSqlObjectQueryPath";
            this.logger.entering(loggingClassName, methodName);
            SqlObjectQueryPath sqlObjectQueryPath = null;
            try {
                sqlObjectQueryPath = this.impl.getUpdatedSqlObjectQueryPath();
            }
            catch (RuntimeException e) {
                this.logger.throwing(loggingClassName, methodName, e);
                throw e;
            }
            this.logger.exiting(loggingClassName, methodName);
            RelmdLoggerFactory.flush(this.logger);
            return sqlObjectQueryPath;
        }

        private class ColumnHandlerDelegate
        implements Handler<Column> {
            Handler<Column> handlerDelegate;
            public StringBuffer xmlText = new StringBuffer();

            public ColumnHandlerDelegate(Handler<Column> columnHandler) {
                this.handlerDelegate = columnHandler;
                this.xmlText.append("<Column>");
            }

            @Override
            public void handle(Column obj) {
                this.xmlText.append(obj.asXml());
                this.handlerDelegate.handle(obj);
            }
        }
    }

    public static interface ISqlObjectColumnsImportElemDelegate_public {
        public SqlObjectQueryPath getUpdatedSqlObjectQueryPath();
    }

    private static interface ISqlObjectColumnsImportElemDelegate {
        public void run(Connection var1);

        public void stop();

        public XmlElement asXml();

        public void setVendorType(Database.EVendorType var1);

        public SqlObjectQueryPath getUpdatedSqlObjectQueryPath();
    }
}

