/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ExternalSchemaReferenceElem;
import com.ibm.cognos.internal.relmd.metadata._schema.SynonymElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.SynonymHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ExternalSchemaReference;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.SynonymsImport;
import com.ibm.cognos.relmd.metadata.import_.rules.SynonymsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSynonymsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SynonymSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class SynonymsImportElem
extends ExtractionElement
implements SynonymsImport,
VendorAccessResultSetHandler,
I_ChildElementHandler {
    private SynonymsImportRules m_synonymsImportRules;
    private VendorAccessResultSet m_resultSet;
    private Handler<SchemaPath> m_contextHandler;
    private Handler<Synonym> m_synonymHandler;
    private MetadataImportSelectionsChoice m_metadataImportSelectionsChoice;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private SessionAccess m_sessionAccess;
    private ExtractionSummary m_importSummary;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private boolean m_applyQualifierList = false;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public SynonymsImportElem(SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, SynonymsImportRules synonymsImportRules, Handler<SchemaPath> schemaPathHandler, Handler<Synonym> synonymHandler) {
        super(ImportMetadataFunction.EImportFunctionType.importSynonyms);
        this.m_sessionAccess = sessionAccess;
        this.m_metadataImportSelectionsChoice = metadataImportSelectionsChoice;
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_synonymHandler = synonymHandler;
        this.m_synonymsImportRules = synonymsImportRules;
        this.m_contextHandler = schemaPathHandler;
        this.m_resultSet = null;
        this.m_importSummary = null;
        this.m_applyQualifierList = false;
    }

    public SynonymsImportElem() {
        this(null, null, null, null, null);
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice() {
        return this.m_metadataImportSelectionsChoice;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public Handler<SchemaPath> contextHandler() {
        return this.m_contextHandler;
    }

    @Override
    public Handler<Synonym> objectHandler() {
        return this.m_synonymHandler;
    }

    @Override
    public void run(Connection connection) {
        VendorAccessResultSetValues resultSetValueRetrieval;
        this.m_resultSet = null;
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (this.m_contextHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)this.m_synonymsImportRules, this.m_contextHandler, (I_ChildElementHandler)this);
        }
        VendorAccess extractionQuery = this.m_synonymsImportRules.extractionQuery();
        VendorAccessResultSetIterator resultSetIterator = null;
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_synonymsImportRules.objectSelectionsInclusionCollection();
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            this.runForGeneric(connection, resultSetSchemaLocator);
            return;
        }
        this.m_resultSet = extractionQuery.run(connection, this.m_sessionAccess, this.m_metadataImportSelectionsChoice, objectSelectionsInclusionCollection);
        if (null != this.m_resultSet) {
            resultSetIterator = this.m_resultSet.iterator();
            while (resultSetIterator.next()) {
                resultSetValueRetrieval = this.m_resultSet.values();
                this.m_importSummary.incrementRowCount();
                if (resultSetSchemaLocator != null) {
                    resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
                }
                this.handleResultSetRecord(resultSetValueRetrieval);
            }
        }
        while (null != resultSetIterator && resultSetIterator.next()) {
            resultSetValueRetrieval = this.m_resultSet.values();
            this.m_importSummary.incrementRowCount();
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
            }
            this.handleResultSetRecord(resultSetValueRetrieval);
        }
        this.done();
        long rowsProcessed = this.m_importSummary.rowsProcessed();
        this.m_importSummary.synonymsCount(rowsProcessed);
    }

    @Override
    public void stop() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void handleParentObjectChanged() {
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        int externalHostRefIndex = this.m_synonymsImportRules.externalHostRefIndex();
        String externalHostRef = resultSetValueRetrieval.stringValue(externalHostRefIndex);
        int parentCatalogNameRecordIndex = this.m_synonymsImportRules.parentCatalogNameRecordIndex();
        String m_catalog = resultSetValueRetrieval.stringValue(parentCatalogNameRecordIndex);
        int parentSchemaNameRecordIndex = this.m_synonymsImportRules.parentSchemaNameRecordIndex();
        String m_schema = resultSetValueRetrieval.stringValue(parentSchemaNameRecordIndex);
        ExternalSchemaReferenceElem externalSchemaReference = new ExternalSchemaReferenceElem(externalHostRef, m_catalog, m_schema, resultSetValueRetrieval, this.m_synonymsImportRules);
        SynonymElem synonym = new SynonymElem(this.m_synonymsImportRules, resultSetValueRetrieval, externalSchemaReference);
        this.m_synonymHandler.handle(synonym);
    }

    public void handleResultSetRecord(String objectDescription, String objectName, String targetName, ExternalSchemaReference externalSchemaReference) {
        SynonymElem synonym = new SynonymElem(objectDescription, objectName, targetName, externalSchemaReference);
        this.m_synonymHandler.handle(synonym);
    }

    @Override
    public void done() {
    }

    @Override
    public ImportSummary run(VendorAccessConnection connection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        return this.run(connection, metadataImportRules.synonymsImportRules(), objectSelections, modelElementHandler, modelElementHandler);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, SynonymsImportRules synonymsImportRules, MetadataObjectSelections objectSelections, final SynonymHandler synonymHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_importSummary = new ExtractionSummary(this.getClass().getName());
        this.m_importSummary.start();
        this.m_resultSet = null;
        this.m_synonymHandler = new Handler<Synonym>(){

            @Override
            public void handle(Synonym obj) {
                synonymHandler.handleSynonym(obj);
            }
        };
        this.m_synonymsImportRules = synonymsImportRules;
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        MetadataObjectSelectionsToolkit objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_metadataImportSelectionsChoice = objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_contextHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandler);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        this.run(jdbcConnection);
        this.done();
        this.m_importSummary.stop();
        return this.m_importSummary;
    }

    public SynonymsImportRules synonymsImportRule() {
        return this.m_synonymsImportRules;
    }

    @Override
    public void cancel() {
        this.stop();
    }

    @Override
    public ImportRules<Synonym> importRules() {
        ImportRules<Synonym> importRules = null;
        return importRules;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runForGeneric(Connection connection, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        Statement statement = null;
        ResultSet rsSynonyms = null;
        try {
            statement = connection.createStatement();
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            MetadataObjectSelections metadataObjectSelections = this.m_metadataImportSelectionsChoice.metadataObjectSelections();
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                String[] synonym_tableTypes = tableTypeMapper.defaultSynonym_tableTypes;
                if (md instanceof IAdaptorDBMetadata) {
                    synonym_tableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
                    rsSynonyms = ((IAdaptorDBMetadata)md).getSynonyms(null, null, null, synonym_tableTypes);
                } else {
                    rsSynonyms = md.getTables(null, null, null, tableTypeMapper.defaultSynonym_tableTypes);
                }
                this.handleResultSet(statement, rsSynonyms, resultSetSchemaLocator);
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        String catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, catalogName);
                    }
                }
            }
            this.close(rsSynonyms, statement);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
        finally {
            this.close(rsSynonyms, statement);
        }
    }

    private void handleResultSet(Statement statement, ResultSet rsSynonyms, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        SynonymInfo synonymInfo;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        this.m_resultSet = new RelmdResultSet(statement, rsSynonyms, vendorAccessHandler);
        ArrayList<SynonymInfo> synonymInfoList = new ArrayList<SynonymInfo>();
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            String externalHostRef = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.externalHostRefIndex());
            String catalog = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.parentCatalogNameRecordIndex());
            String schema = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.parentSchemaNameRecordIndex());
            String synonymName = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.nameRecordIndex());
            String description = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.descriptionRecordIndex());
            String externalCatalogRef = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.refCatalogNameRecordIndex());
            String externalSchemaRef = resultSetValueRetrieval.stringValue(this.m_synonymsImportRules.refSchemaNameRecordIndex());
            String refSynonymTargetName = resultSetValueRetrieval.stringValue(7);
            ExternalSchemaReferenceElem externalSchemaReference = new ExternalSchemaReferenceElem(externalHostRef, catalog, schema, externalCatalogRef, externalSchemaRef);
            SynonymInfo synonymInfo2 = new SynonymInfo(catalog, schema, description, synonymName, refSynonymTargetName, externalSchemaReference);
            synonymInfoList.add(synonymInfo2);
        }
        ArrayList<QualifierList.CatalogSchemaPath> qualifierList = this.getQualifierList();
        if (null == qualifierList) {
            this.m_applyQualifierList = false;
        }
        if (this.m_applyQualifierList && null != (synonymInfo = this.findSynonymInfoWithQualifierList(synonymInfoList, qualifierList))) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(synonymInfo.getCatalog(), synonymInfo.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(synonymInfo.getDescription(), synonymInfo.getSynonym(), synonymInfo.getRefSynonymTargetName(), synonymInfo.getExternalSchemaReference());
            return;
        }
        for (SynonymInfo synonymInfo3 : synonymInfoList) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(synonymInfo3.getCatalog(), synonymInfo3.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(synonymInfo3.getDescription(), synonymInfo3.getSynonym(), synonymInfo3.getRefSynonymTargetName(), synonymInfo3.getExternalSchemaReference());
        }
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private SynonymInfo findSynonymInfoWithQualifierList(ArrayList<SynonymInfo> synonymInfoList, ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        if (1 == synonymInfoList.size()) {
            SynonymInfo synonymInfo = synonymInfoList.get(0);
            QualifierList.CatalogSchemaPath cs = new QualifierList.CatalogSchemaPath(synonymInfo.getCatalog(), synonymInfo.getSchema());
            this.setQualifiedCatalogSchema(cs);
            return synonymInfo;
        }
        if (0 >= synonymInfoList.size()) {
            return null;
        }
        boolean matching = false;
        for (QualifierList.CatalogSchemaPath qualifier : qualifierList) {
            String qualifierCatalogName = qualifier.getCatalog();
            String qualifierSchemaName = qualifier.getSchema();
            for (SynonymInfo synonymInfo : synonymInfoList) {
                String catalogValue = synonymInfo.getCatalog();
                String schemaValue = synonymInfo.getSchema();
                if (null == qualifierCatalogName && null != qualifierSchemaName) {
                    matching = qualifierSchemaName.equals(schemaValue);
                } else if (null != qualifierCatalogName && null == qualifierSchemaName) {
                    matching = qualifierCatalogName.equals(catalogValue);
                } else if (null == qualifierCatalogName && null == qualifierSchemaName) {
                    matching = false;
                } else {
                    boolean bl = matching = qualifierSchemaName.equals(schemaValue) && qualifierCatalogName.equals(catalogValue);
                }
                if (!matching) continue;
                this.setQualifiedCatalogSchema(qualifier);
                return synonymInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSchemaSelections(Statement statement, DatabaseMetaData md, ParentSchemaReferenceProcessor resultSetSchemaLocator, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, String catalogName) {
        block22: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            ResultSet rsSynonyms = null;
            try {
                TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
                String[] synonym_tableTypes = tableTypeMapper.defaultSynonym_tableTypes;
                if (bAllSchemaSelected) {
                    if (md instanceof IAdaptorDBMetadata) {
                        synonym_tableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
                        rsSynonyms = ((IAdaptorDBMetadata)md).getSynonyms(catalogName, null, null, synonym_tableTypes);
                    } else {
                        rsSynonyms = md.getTables(catalogName, null, null, tableTypeMapper.defaultSynonym_tableTypes);
                    }
                    this.handleResultSet(statement, rsSynonyms, resultSetSchemaLocator);
                    break block22;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block22;
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    String schemaName = selectedSchema.objectName();
                    if (catalogName != null && catalogName.isEmpty()) {
                        catalogName = null;
                        this.m_applyQualifierList = true;
                    }
                    if (schemaName != null && schemaName.isEmpty()) {
                        schemaName = null;
                        this.m_applyQualifierList = true;
                    }
                    String escapedSchemaName = escapeObject.escape(schemaName);
                    SelectionChoice<SynonymSelection, AllSynonymsSelection> synonymSelections = selectedSchema.synonymSelections();
                    boolean bAllSynonymSelected = this.m_objectSelectionsToolkit.allSelected(synonymSelections);
                    if (bAllSynonymSelected) {
                        if (md instanceof IAdaptorDBMetadata) {
                            synonym_tableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
                            rsSynonyms = ((IAdaptorDBMetadata)md).getSynonyms(catalogName, escapedSchemaName, null, synonym_tableTypes);
                        } else {
                            rsSynonyms = md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.defaultSynonym_tableTypes);
                        }
                        this.handleResultSet(statement, rsSynonyms, resultSetSchemaLocator);
                        continue;
                    }
                    ReferenceableSet<SynonymSelection> selectedSynonyms = synonymSelections.selectedObjects();
                    if (null == selectedSynonyms) continue;
                    for (SynonymSelection selectedSynonym : selectedSynonyms) {
                        String synonymName = selectedSynonym.objectName();
                        if (synonymName != null && synonymName.isEmpty()) {
                            synonymName = null;
                        }
                        String escapedsynonymName = escapeObject.escape(synonymName);
                        if (md instanceof IAdaptorDBMetadata) {
                            String catalogNamePattern = catalogName;
                            String schemaNamePattern = escapedSchemaName;
                            String synonymNamePattern = escapedsynonymName;
                            String jdbcURL = null;
                            String JDBC_URL_PREFIX_INFORMIX = "jdbc:informix";
                            try {
                                jdbcURL = md.getURL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            if (escapedsynonymName != null && !escapedsynonymName.isEmpty() && jdbcURL != null && jdbcURL.indexOf(JDBC_URL_PREFIX_INFORMIX) != -1) {
                                String[] tableTypes;
                                ResultSet rs;
                                synonym_tableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
                                String getIdentifierQuoteString = md.getIdentifierQuoteString();
                                if (getIdentifierQuoteString != null && getIdentifierQuoteString.trim().isEmpty() && (rs = md.getTables(catalogName, escapedSchemaName, escapedsynonymName, tableTypes = new String[]{"SYNONYM"})) != null && rs.next()) {
                                    catalogNamePattern = rs.getString("TABLE_CAT");
                                    schemaNamePattern = rs.getString("TABLE_SCHEM");
                                    synonymNamePattern = rs.getString("TABLE_NAME");
                                }
                            }
                            rsSynonyms = ((IAdaptorDBMetadata)md).getSynonyms(catalogNamePattern, schemaNamePattern, synonymNamePattern, synonym_tableTypes);
                        } else {
                            rsSynonyms = md.getTables(catalogName, escapedSchemaName, escapedsynonymName, tableTypeMapper.defaultSynonym_tableTypes);
                        }
                        this.handleResultSet(statement, rsSynonyms, resultSetSchemaLocator);
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.close(rsSynonyms, null);
            }
        }
    }

    private void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class SynonymInfo
    extends QualifierList.CatalogSchemaPath {
        private String description;
        private String synonym;
        private String refSynonymTargetName;
        private ExternalSchemaReferenceElem externalSchemaReference;

        public SynonymInfo(String catalog, String schema, String desc, String synonym, String targetName, ExternalSchemaReferenceElem externalSchemaReference) {
            super(catalog, schema);
            this.description = null;
            this.synonym = null;
            this.refSynonymTargetName = null;
            this.externalSchemaReference = null;
            this.description = desc;
            this.synonym = synonym;
            this.refSynonymTargetName = targetName;
            this.externalSchemaReference = externalSchemaReference;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSynonym() {
            return this.synonym;
        }

        public String getRefSynonymTargetName() {
            return this.refSynonymTargetName;
        }

        public ExternalSchemaReferenceElem getExternalSchemaReference() {
            return this.externalSchemaReference;
        }
    }
}

