/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.TableParameterElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableViewHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.TableParameterHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.TableParametersImport;
import com.ibm.cognos.relmd.metadata.import_.rules.TableParametersImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaObjectPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TableParametersImportElem
extends ExtractionElement
implements VendorAccessResultSetHandler,
I_ChildElementHandler,
TableParametersImport {
    private static final int TABLE_NAME_INDEX = 3;
    private TableParametersImportRules m_tableParametersRules = null;
    private Handler<TableParameter> m_tableParameterHandler = null;
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction = null;
    private ImportSummary m_summary = null;
    private SessionAccess m_sessionAccess = null;
    private MetadataImportSelectionsChoice m_metadataImportSelectionsChoice = null;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler = null;
    private Handler<ColumnContainerObjectRef> m_columnContainerObjectRefHandler = null;
    private VendorAccessHandler m_vendorAccessHandler = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private String JDBC_URL_PREFIX_TERADATA = "jdbc:teradata";
    private String[] m_listofTableViewTableTypes = null;
    private String[] m_listofTableTableTypes = null;
    private String[] m_listofViewTableTypes = null;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    @Override
    public ImportMetadataFunction.EImportFunctionType importFunctionType() {
        return ImportMetadataFunction.EImportFunctionType.importTableParameters;
    }

    public TableParametersImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importTableParameters);
    }

    @Override
    public ImportSummary run(VendorAccessConnection connection, MetadataImportRules importRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        TableParametersImportRules importRulesT = importRules.tableParametersImportRules();
        return this.run(connection, importRulesT, objectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, TableParametersImportRules tableParametersImportRules, MetadataObjectSelections objectSelections, final TableParameterHandler tableParameterHandler, final ParentTableViewHandler parentTableViewHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandlerOld) {
        this.m_schemaChildLevelExtraction = null;
        this.m_tableParametersRules = tableParametersImportRules;
        this.m_tableParameterHandler = new Handler<TableParameter>(){

            @Override
            public void handle(TableParameter obj) {
                tableParameterHandler.handleTableParameter(obj);
            }
        };
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_metadataImportSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_columnContainerObjectRefHandler = new Handler<ColumnContainerObjectRef>(){

            @Override
            public void handle(ColumnContainerObjectRef obj) {
                if (null != parentTableViewHandler) {
                    String name = obj.objectName();
                    parentTableViewHandler.handleParentTableViewReference(name);
                }
            }
        };
        this.m_schemaPathHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandlerOld);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        this.run(jdbcConnection);
        return this.m_summary;
    }

    @Override
    public void run(Connection connection) {
        this.m_schemaChildLevelExtraction = null;
        this.m_summary = new ExtractionSummary("inputParametersImport");
        this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(this.m_columnContainerObjectRefHandler);
        TableParametersImportElem resultSetHandler = this;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        this.m_summary = this.runTableParametersImportGeneric(connection, this.m_metadataImportSelectionsChoice, this.m_schemaPathHandler, this.m_tableParametersRules, resultSetHandler);
    }

    private ExtractionSummary runTableParametersImportGeneric(Connection connection, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        MetadataObjectSelections metadataObjectSelections = metadataImportSelectionsChoice.metadataObjectSelections();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        try {
            String jdbcURL;
            DatabaseMetaData md = connection.getMetaData();
            try {
                jdbcURL = md.getURL();
            }
            catch (SQLException e) {
                jdbcURL = "";
            }
            if (jdbcURL != null && !jdbcURL.startsWith("jdbc:sap://")) {
                return null;
            }
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            if (!(md instanceof IAdaptorDBMetadata)) {
                throw new RuntimeException("Programming Error - input parameters only supported with Adaptors.");
            }
            this.m_listofTableTableTypes = tableTypeMapper.getListOfTable_TableTypes();
            this.m_listofViewTableTypes = tableTypeMapper.getListOfView_TableTypes();
            this.m_listofTableViewTableTypes = tableTypeMapper.getListOfTableAndView_TableTypes();
            if (bAllCatalogsSelected) {
                ResultSet rsSchemas = md.getSchemas();
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                if (rsSchemas.next()) {
                    do {
                        String schemaName = rsSchemas.getString(1);
                        String catalogName = rsSchemas.getString(2);
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        ResultSet rsTablesAndView = null;
                        rsTablesAndView = md.getTables(catalogName, escapedSchemaName, null, this.m_listofTableViewTableTypes);
                        while (rsTablesAndView.next()) {
                            String tableOrViewName = rsTablesAndView.getString(3);
                            if (tableOrViewName == null) continue;
                            summary = this.getTableParametersGeneric(connection, catalogName, schemaName, tableOrViewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                    } while (rsSchemas.next());
                } else {
                    summary = this.getTableParametersGeneric(connection, null, null, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        this.m_catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler, this.m_catalogName);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler, String catalogName) {
        block30: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            try {
                DatabaseMetaData md = connection.getMetaData();
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                if (bAllSchemaSelected) {
                    String schemaTerm = md.getSchemaTerm();
                    if (schemaTerm == null || schemaTerm.isEmpty()) {
                        summary = this.getTableParametersGeneric(connection, catalogName, null, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    } else {
                        ResultSet rsSchemas = null;
                        rsSchemas = catalogName != null && !catalogName.isEmpty() ? md.getSchemas(catalogName, null) : md.getSchemas();
                        ArrayList<Object> schemaNames = new ArrayList<Object>();
                        while (rsSchemas.next()) {
                            String schemaName = rsSchemas.getString(1);
                            schemaNames.add(schemaName);
                        }
                        if (rsSchemas != null) {
                            rsSchemas.close();
                        }
                        for (String string : schemaNames) {
                            String escapedSchemaName = escapeObject.escape(string);
                            ResultSet rsTablesAndViews = md.getTables(catalogName, escapedSchemaName, null, this.m_listofTableViewTableTypes);
                            while (rsTablesAndViews.next()) {
                                String tableOrViewName = rsTablesAndViews.getString(3);
                                if (tableOrViewName == null) continue;
                                summary = this.getTableParametersGeneric(connection, catalogName, string, tableOrViewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                    }
                    break block30;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block30;
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    this.m_schemaName = selectedSchema.objectName();
                    QualifierList.CatalogSchemaPath cs = this.getQualifiedCatalogSchema();
                    if (null != this.m_catalogName && this.m_catalogName.isEmpty() && null != cs && null != cs.getCatalog()) {
                        this.m_catalogName = cs.getCatalog();
                    }
                    if (null != this.m_schemaName && this.m_schemaName.isEmpty() && null != cs && null != cs.getSchema()) {
                        this.m_schemaName = cs.getSchema();
                    }
                    String string = escapeObject.escape(this.m_schemaName);
                    SelectionChoice<TableSelection, AllTablesSelection> tableSelections = selectedSchema.tableSelections();
                    SelectionChoice<ViewSelection, AllViewsSelection> viewSelections = selectedSchema.viewSelections();
                    boolean bAllTablesSelected = this.m_objectSelectionsToolkit.allSelected(tableSelections);
                    boolean bAllViewsSelected = this.m_objectSelectionsToolkit.allSelected(viewSelections);
                    ReferenceableSet<TableSelection> selectedTables = tableSelections.selectedObjects();
                    ReferenceableSet<ViewSelection> selectedViews = viewSelections.selectedObjects();
                    if (bAllTablesSelected && bAllViewsSelected) {
                        String jdbcURL = null;
                        try {
                            jdbcURL = md.getURL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        if (jdbcURL != null && jdbcURL.indexOf(this.JDBC_URL_PREFIX_TERADATA) != -1) {
                            summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, null, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            continue;
                        }
                        ResultSet rsTablesAndViews = null;
                        rsTablesAndViews = md.getTables(this.m_catalogName, string, null, this.m_listofTableViewTableTypes);
                        ArrayList<Object> objectNames = new ArrayList<Object>();
                        while (rsTablesAndViews.next()) {
                            String tableOrViewName = rsTablesAndViews.getString(3);
                            objectNames.add(tableOrViewName);
                        }
                        if (rsTablesAndViews != null) {
                            rsTablesAndViews.close();
                        }
                        for (String string2 : objectNames) {
                            if (string2 == null) continue;
                            summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, string2, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (!bAllTablesSelected && !bAllViewsSelected) {
                        if (null != selectedTables) {
                            for (TableSelection selectedTable : selectedTables) {
                                String tableName = selectedTable.objectName();
                                summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, tableName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                        if (null == selectedViews) continue;
                        for (ViewSelection selectedView : selectedViews) {
                            String viewName = selectedView.objectName();
                            summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, viewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (bAllTablesSelected && !bAllViewsSelected) {
                        ResultSet rsTables = md.getTables(this.m_catalogName, string, null, this.m_listofTableTableTypes);
                        while (rsTables.next()) {
                            String tableName = rsTables.getString(3);
                            summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, tableName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        if (null != selectedViews) {
                            for (ViewSelection selectedView : selectedViews) {
                                String viewName = selectedView.objectName();
                                summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, viewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                            }
                        }
                        if (rsTables == null) continue;
                        rsTables.close();
                        continue;
                    }
                    if (!bAllViewsSelected || bAllTablesSelected) continue;
                    ResultSet rsViews = null;
                    rsViews = md.getTables(this.m_catalogName, string, null, this.m_listofViewTableTypes);
                    while (rsViews.next()) {
                        String viewName = rsViews.getString(3);
                        summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, viewName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                    if (null != selectedTables) {
                        for (TableSelection selectedTable : selectedTables) {
                            String tableName = selectedTable.objectName();
                            summary = this.getTableParametersGeneric(connection, this.m_catalogName, this.m_schemaName, tableName, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                    }
                    if (rsViews == null) continue;
                    rsViews.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionSummary getTableParametersGeneric(Connection connection, String catalogName, String schemaName, String tableViewName, String parameterName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        Statement statement = null;
        ResultSet rsColumns = null;
        try {
            IAdaptorDBMetadata md = (IAdaptorDBMetadata)connection.getMetaData();
            statement = connection.createStatement();
            if (catalogName != null && catalogName.isEmpty()) {
                catalogName = null;
            }
            if (schemaName != null && schemaName.isEmpty()) {
                schemaName = null;
            }
            EscapeObjectName escapeObject = new EscapeObjectName((DatabaseMetaData)md);
            String escapedSchemaName = escapeObject.escape(schemaName);
            String escapedTableViewName = escapeObject.escape(tableViewName);
            if ("_SYS_BIC".equals(schemaName)) {
                rsColumns = md.getTableParameters(catalogName, escapedSchemaName, escapedTableViewName, parameterName);
                RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsColumns, this.m_vendorAccessHandler);
                summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.m_schemaChildLevelExtraction.close(rsColumns, statement);
        }
        return summary;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    @Override
    public void cancel() {
        this.m_tableParametersRules = null;
        this.m_tableParameterHandler = null;
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice() {
        return this.m_metadataImportSelectionsChoice;
    }

    @Override
    public ImportRules<TableParameter> importRules() {
        return this.m_tableParametersRules.tableParametersImportRules();
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void stop() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public Handler<SchemaObjectPath> contextHandler() {
        Handler<SchemaObjectPath> handler = new Handler<SchemaObjectPath>(){

            @Override
            public void handle(SchemaObjectPath obj) {
                SchemaPath schemaPath = obj.schemaPath();
                TableParametersImportElem.this.m_schemaPathHandler.handle(schemaPath);
                Relmd relmd = RelmdGateway.relmd();
                MetadataToolkit metadataToolkit = relmd.metadataToolkit();
                ColumnContainerObjectRef columnContainerObjectRef = metadataToolkit.columnContainerObjectRef(obj);
                TableParametersImportElem.this.m_columnContainerObjectRefHandler.handle(columnContainerObjectRef);
            }
        };
        return handler;
    }

    @Override
    public Handler<TableParameter> objectHandler() {
        return null;
    }

    @Override
    public void handleParentObjectChanged() {
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        TableParameterElem tableParameter = new TableParameterElem(this.m_tableParametersRules, resultSetValueRetrieval, this.m_vendorType);
        this.m_tableParameterHandler.handle(tableParameter);
    }

    @Override
    public void done() {
    }
}

