/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.metadata._schema.ColumnElem;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.rules.ColumnsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SqlColumnsIndexes;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessRule;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;

public class TeradataGetColumnsFunction
implements VendorAccess,
VendorAccessResultSetHandler {
    public static final int UNSUPPORTED = -1;
    public static final int COLUMNS_PARENT_CAT_NAME_INDEX = 1;
    public static final int COLUMNS_PARENT_SCHEMA_NAME_INDEX = 2;
    public static final int COLUMNS_QUERY_OBJECT_NAME_INDEX = 3;
    public static final int COLUMNS_DATATYPE_INDEX = 5;
    public static final int COLUMNS_SIZE_INDEX = 6;
    public static final int COLUMNS_PRECISION_INDEX = 7;
    public static final int COLUMNS_SCALE_INDEX = 8;
    public static final int COLUMNS_NULLABLE_INDEX = 9;
    public static final int COLUMNS_DEFAULTVALUE_INDEX = 10;
    public static final int COLUMNS_DESCRPTION_INDEX = 11;
    public static final int COLUMNS_COLLATIONSEQUENCE_INDEX = -1;
    private String DOUBLE_QUOTE = "\"";
    private Connection m_connection;
    private ColumnsImportRules m_columnsRules;
    private final Handler<Column> m_columnHandler;
    private VendorAccessHandler m_eventHandler;
    private VendorToolkit m_vendorToolkit;
    private Database.EVendorType m_vendorType;

    public TeradataGetColumnsFunction(Handler<Column> columnHandler) {
        Relmd relmd = RelmdGateway.relmd();
        this.m_vendorToolkit = relmd.vendorToolkit();
        this.m_eventHandler = null;
        this.m_columnHandler = columnHandler;
        this.m_vendorType = null;
        this.m_columnsRules = null;
        this.setTeradataColumnImportRules(this.m_vendorType);
    }

    public void setTeradataColumnImportRules(Database.EVendorType vendorType) {
        this.m_columnsRules = vendorType != null && vendorType.toString().indexOf("generic") != -1 ? new ColumnsImportRules(){

            @Override
            public int parentCatalogNameRecordIndex() {
                return 1;
            }

            @Override
            public int parentSchemaNameRecordIndex() {
                return 2;
            }

            @Override
            public int queryObjectNameRecordIndex() {
                return 3;
            }

            @Override
            public int nameRecordIndex() {
                return 4;
            }

            @Override
            public int descriptionRecordIndex() {
                return -1;
            }

            @Override
            public int datatypeRecordIndex() {
                return 5;
            }

            @Override
            public int sizeRecordIndex() {
                return 7;
            }

            @Override
            public int precisionRecordIndex() {
                return 7;
            }

            @Override
            public int scaleRecordIndex() {
                return -1;
            }

            @Override
            public int nullableFlagRecordIndex() {
                return 18;
            }

            @Override
            public int defaultValueRecordIndex() {
                return 13;
            }

            @Override
            public int collationSequenceRecordIndex() {
                return -1;
            }

            @Override
            public SqlColumnsIndexes.EType sqlColumnType() {
                return SqlColumnsIndexes.EType.jdbcType;
            }

            @Override
            public Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection() {
                return null;
            }

            @Override
            public VendorAccess extractionQuery() {
                return null;
            }

            @Override
            public boolean hasExtractionFailureFallback() {
                return false;
            }

            @Override
            public String extractionFailureFallback() {
                return null;
            }

            @Override
            public ImportRules<Column> columnsImportRules() {
                return null;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public int datatypeRecordNameIndex() {
                return 6;
            }
        } : new ColumnsImportRules(){

            @Override
            public int parentCatalogNameRecordIndex() {
                return 1;
            }

            @Override
            public int parentSchemaNameRecordIndex() {
                return 2;
            }

            @Override
            public int queryObjectNameRecordIndex() {
                return 3;
            }

            @Override
            public int nameRecordIndex() {
                return 4;
            }

            @Override
            public int descriptionRecordIndex() {
                return -1;
            }

            @Override
            public int datatypeRecordIndex() {
                return 5;
            }

            @Override
            public int sizeRecordIndex() {
                return 6;
            }

            @Override
            public int precisionRecordIndex() {
                return 7;
            }

            @Override
            public int scaleRecordIndex() {
                return 8;
            }

            @Override
            public int nullableFlagRecordIndex() {
                return 9;
            }

            @Override
            public int defaultValueRecordIndex() {
                return 10;
            }

            @Override
            public int collationSequenceRecordIndex() {
                return -1;
            }

            @Override
            public SqlColumnsIndexes.EType sqlColumnType() {
                return SqlColumnsIndexes.EType.jdbcType;
            }

            @Override
            public Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection() {
                return null;
            }

            @Override
            public VendorAccess extractionQuery() {
                return null;
            }

            @Override
            public boolean hasExtractionFailureFallback() {
                return false;
            }

            @Override
            public String extractionFailureFallback() {
                return null;
            }

            @Override
            public ImportRules<Column> columnsImportRules() {
                return null;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsNotSupported;
            }

            @Override
            public int datatypeRecordNameIndex() {
                return 5;
            }
        };
    }

    public ColumnsImportRules columnsRules() {
        return this.m_columnsRules;
    }

    @Override
    public VendorAccessRule.EGranularity getGranularity() {
        return VendorAccessRule.EGranularity.objectGrainSql;
    }

    @Override
    public VendorAccessResultSet runDatabaseLevel(VendorAccessConnection connection) {
        return this.runObjectLevel(connection, "*", "%", "%");
    }

    @Override
    public VendorAccessResultSet runCatalogLevel(VendorAccessConnection connection, String parentCatalogName) {
        return this.runObjectLevel(connection, "*", "%", "%");
    }

    @Override
    public VendorAccessResultSet runSchemaLevel(VendorAccessConnection connection, String parentCatalogName, String parentSchemaName) {
        return this.runObjectLevel(connection, "%", "%", "%");
    }

    @Override
    public VendorAccessResultSet runObjectLevel(VendorAccessConnection connection, String parentCatalogName, String parentSchemaName, String parentObjectName) {
        VendorAccessHandler vendorAccessHandler;
        this.m_connection = connection.jdbcConnection();
        this.m_eventHandler = vendorAccessHandler = connection.vendorAccessHandler();
        Statement statement = null;
        ResultSet resultSet = null;
        DatabaseMetaData md = null;
        VendorAccessToolkit vendorAccessToolkit = null;
        try {
            md = this.m_connection.getMetaData();
            vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
            if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1) {
                resultSet = md.getColumns(parentCatalogName, parentSchemaName, parentObjectName, null);
            } else {
                statement = this.m_connection.createStatement();
                String sqlStatement = "HELP COLUMN " + this.DOUBLE_QUOTE + parentSchemaName + this.DOUBLE_QUOTE + "." + this.DOUBLE_QUOTE + parentObjectName + this.DOUBLE_QUOTE + ".*";
                Handler<BeginSql> beginSqlHandler = this.m_eventHandler.beginSqlHandler();
                BeginSql beginSql = vendorAccessToolkit.beginSql(sqlStatement);
                beginSqlHandler.handle(beginSql);
                resultSet = statement.executeQuery(sqlStatement);
            }
        }
        catch (SQLException e) {
            Handler<ExecutionError> executionErrorHandler = this.m_eventHandler.executionErrorHandler();
            String message = "Teradata help column invocation error: " + e.getMessage();
            if (vendorAccessToolkit != null) {
                ExecutionError executionError = vendorAccessToolkit.executionError(message);
                executionErrorHandler.handle(executionError);
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.sqlExecutionError, e);
        }
        VendorAccessResultSet tdViewColumnsResultSet = this.resultSet(md, resultSet, statement, parentCatalogName, parentSchemaName, parentObjectName);
        return tdViewColumnsResultSet;
    }

    private VendorAccessResultSet resultSet(final DatabaseMetaData md, final ResultSet resultSet, final Statement statement, String parentCatalogName, final String parentSchemaName, final String parentObjectName) {
        final VendorAccessToolkit vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
        VendorAccessResultSet relmdResultSet = new VendorAccessResultSet(){
            int currentRow = 0;
            private boolean m_next = true;

            @Override
            public VendorAccessResultSetIterator iterator() {
                VendorAccessResultSetIterator relmdResultSetIterator = new VendorAccessResultSetIterator(){

                    @Override
                    public boolean next() {
                        if (m_next) {
                            try {
                                m_next = resultSet.next();
                                if (m_next) {
                                    ++currentRow;
                                } else {
                                    resultSet.close();
                                    if (statement != null) {
                                        statement.close();
                                    }
                                }
                            }
                            catch (SQLException e) {
                                String message = e.getMessage();
                                Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = TeradataGetColumnsFunction.this.m_eventHandler.resultSetProcessingErrorHandler();
                                ResultSetProcessingError resultSetProcessingError = vendorAccessToolkit.resultSetProcessingError(currentRow, message);
                                resultSetProcessingErrorHandler.handle(resultSetProcessingError);
                            }
                        }
                        return m_next;
                    }
                };
                return relmdResultSetIterator;
            }

            @Override
            public VendorAccessResultSetValues values() {
                String[] record = null;
                if (null != TeradataGetColumnsFunction.this.m_vendorType && TeradataGetColumnsFunction.this.m_vendorType.toString().indexOf("generic") != -1) {
                    String format;
                    String columnName = this.value(resultSet, 4);
                    String dataType = this.value(resultSet, 5);
                    String dataTypeName = this.value(resultSet, 6);
                    if (dataTypeName.length() > 0 && !"0".equals(dataTypeName.trim())) {
                        dataType = dataType + " " + dataTypeName;
                    }
                    if (null != (format = "")) {
                        dataType = dataType + " " + format;
                    }
                    String precision = "10";
                    String size = "";
                    if (dataTypeName.equals(String.valueOf(2)) || dataTypeName.equals(String.valueOf(3)) || dataTypeName.equals(String.valueOf(4)) || dataTypeName.equals(String.valueOf(-5)) || dataTypeName.equals(String.valueOf(-6)) || dataTypeName.equals(String.valueOf(5)) || dataTypeName.equals(String.valueOf(7)) || dataTypeName.equals(String.valueOf(6))) {
                        precision = this.value(resultSet, 7);
                    } else if (dataTypeName.equals(String.valueOf(12)) || dataTypeName.equals(String.valueOf(1)) || dataTypeName.equals(String.valueOf(-1)) || dataTypeName.equals(String.valueOf(-4)) || dataTypeName.equals(String.valueOf(92)) || dataTypeName.equals(String.valueOf(93)) || dataTypeName.equals(String.valueOf(91)) || dataTypeName.equals(String.valueOf(-2)) || dataTypeName.equals(String.valueOf(1111))) {
                        size = this.value(resultSet, 7);
                    }
                    String scale = "";
                    String nullable = this.value(resultSet, 11);
                    String comment = this.value(resultSet, 12);
                    String defaultValue = this.value(resultSet, 13);
                    String isNullable = this.value(resultSet, 18);
                    isNullable = !isNullable.startsWith("YES") ? "0" : "1";
                    record = new String[]{"", parentSchemaName, parentObjectName, columnName, dataType, dataTypeName, precision, "", "", "", nullable, comment, defaultValue, "", "", "", "", isNullable};
                } else {
                    String format;
                    int databaseMajorVersion = 0;
                    int databaseMinorVersion = 0;
                    try {
                        databaseMajorVersion = md.getDatabaseMajorVersion();
                        databaseMinorVersion = md.getDatabaseMinorVersion();
                    }
                    catch (SQLException e) {
                        throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.sqlExecutionError, e);
                    }
                    String columnName = databaseMajorVersion == 14 && databaseMinorVersion >= 10 || databaseMajorVersion > 14 ? this.value(resultSet, 32) : this.value(resultSet, 1);
                    String dataType = this.value(resultSet, 2);
                    String charType = this.value(resultSet, 17);
                    if (charType.length() > 0 && !"0".equals(charType.trim())) {
                        dataType = dataType + " " + charType;
                    }
                    if (null != (format = this.value(resultSet, 4))) {
                        dataType = dataType + " " + format;
                    }
                    String size = dataType.startsWith("D") ? this.value(resultSet, 6) : this.value(resultSet, 5);
                    String precision = "10";
                    String scale = this.value(resultSet, 7);
                    String nullable = this.value(resultSet, 3);
                    nullable = !nullable.startsWith("Y") && !nullable.startsWith("T") ? "0" : "1";
                    String defaultValue = "";
                    String description = "";
                    record = new String[]{"", parentSchemaName, parentObjectName, columnName, dataType, size, precision, scale, nullable, defaultValue, description};
                }
                VendorAccessResultSetValues relmdResultSetValues = this.values(record);
                return relmdResultSetValues;
            }

            private String value(ResultSet resultSet2, int index) {
                String value = "";
                try {
                    value = resultSet2.getString(index);
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = TeradataGetColumnsFunction.this.m_eventHandler.resultSetProcessingErrorHandler();
                    ResultSetProcessingError resultSetProcessingError = vendorAccessToolkit.resultSetProcessingError(this.currentRow, message);
                    resultSetProcessingErrorHandler.handle(resultSetProcessingError);
                }
                return null == value ? "" : value.trim();
            }

            private VendorAccessResultSetValues values(final String[] record) {
                VendorAccessResultSetValues relmdResultSetValues = new VendorAccessResultSetValues(){

                    @Override
                    public Integer intValue(int index) {
                        return index == -1 ? null : Integer.valueOf(this.stringValue(index));
                    }

                    @Override
                    public String stringValue(int index) {
                        return index == -1 ? "" : record[index - 1];
                    }
                };
                return relmdResultSetValues;
            }

            @Override
            public void close() {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = TeradataGetColumnsFunction.this.m_eventHandler.resultSetProcessingErrorHandler();
                    ResultSetProcessingError resultSetProcessingError = vendorAccessToolkit.resultSetProcessingError(this.currentRow, message);
                    resultSetProcessingErrorHandler.handle(resultSetProcessingError);
                }
            }
        };
        return relmdResultSet;
    }

    @Override
    public VendorAccessResultSet run(VendorAccessConnection connection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
        return null;
    }

    public VendorAccessRule.EAccessType getAccessType() {
        return VendorAccessRule.EAccessType.jdbc;
    }

    @Override
    public void done() {
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        ColumnElem column = new ColumnElem(this.m_columnsRules, resultSetValueRetrieval);
        this.m_columnHandler.handle(column);
    }

    @Override
    public VendorAccessResultSet run(Connection connection, SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
        return null;
    }

    @Override
    @Deprecated
    public VendorAccessHandler vendorAccessHandler() {
        return null;
    }

    @Override
    public VendorAccessResultSet runGeneric(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
        return null;
    }

    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }
}

