/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions;

import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ParentCatalogSchema;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;

public class ParentSchemaReferenceProcessor
implements VendorAccessResultSetHandler {
    private String m_currentSchema = null;
    private String m_currentCatalog = null;
    private final Handler<SchemaPath> m_schemaPathHandler;
    private final SchemaChildIndexes m_schemaChildRules;
    private final I_ChildElementHandler m_childElementHandler;
    private MetadataToolkit m_metadataToolkit;

    public ParentSchemaReferenceProcessor(SchemaChildIndexes schemaChildRules, Handler<SchemaPath> schemaPathHandler, I_ChildElementHandler childElementHandler) {
        Relmd relmd = RelmdGateway.relmd();
        this.m_metadataToolkit = relmd.metadataToolkit();
        this.m_schemaChildRules = schemaChildRules;
        this.m_schemaPathHandler = schemaPathHandler;
        this.m_childElementHandler = childElementHandler;
    }

    public ParentSchemaReferenceProcessor(SchemaChildIndexes schemaChildRules, final ParentCatalogSchemaHandler parentCatalogSchemaHandler, I_ChildElementHandler childElementHandler) {
        Relmd relmd = RelmdGateway.relmd();
        this.m_metadataToolkit = relmd.metadataToolkit();
        this.m_schemaChildRules = schemaChildRules;
        this.m_childElementHandler = childElementHandler;
        this.m_schemaPathHandler = new Handler<SchemaPath>(){

            @Override
            public void handle(SchemaPath obj) {
                boolean hasParentCatalog = obj.hasParentCatalog();
                if (hasParentCatalog) {
                    String catalogName = obj.parentCatalogName();
                    parentCatalogSchemaHandler.handleParentCatalogReference(catalogName);
                }
                String schemaName = obj.parentSchemaName();
                parentCatalogSchemaHandler.handleParentSchemaReference(schemaName);
            }
        };
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        String catalog = resultSetValueRetrieval.stringValue(this.m_schemaChildRules.parentCatalogNameRecordIndex());
        String schema = resultSetValueRetrieval.stringValue(this.m_schemaChildRules.parentSchemaNameRecordIndex());
        ParentCatalogSchema parentCatalogSchema = this.m_metadataToolkit.parentCatalogSchema(catalog, schema);
        boolean hasChanged = true;
        boolean bCatalogChanged = catalog != null && catalog.length() > 0 && !this.compareObjectsByName(this.m_currentCatalog, catalog);
        boolean bl = hasChanged = bCatalogChanged || !this.compareObjectsByName(this.m_currentSchema, schema);
        if (hasChanged) {
            this.m_childElementHandler.handleParentObjectChanged();
        }
        if (hasChanged) {
            this.m_schemaPathHandler.handle(parentCatalogSchema);
        }
        if (bCatalogChanged) {
            this.m_currentCatalog = catalog;
        }
        if (hasChanged) {
            this.m_currentSchema = schema;
        }
    }

    public void handleResultSetRecord(String catalogName, String schemaName) {
        ParentCatalogSchema parentCatalogSchema = this.m_metadataToolkit.parentCatalogSchema(catalogName, schemaName);
        boolean hasChanged = true;
        boolean bCatalogChanged = catalogName != null && catalogName.length() > 0 && !this.compareObjectsByName(this.m_currentCatalog, catalogName);
        boolean bl = hasChanged = bCatalogChanged || !this.compareObjectsByName(this.m_currentSchema, schemaName);
        if (hasChanged) {
            this.m_childElementHandler.handleParentObjectChanged();
        }
        if (hasChanged) {
            this.m_schemaPathHandler.handle(parentCatalogSchema);
        }
        if (bCatalogChanged) {
            this.m_currentCatalog = catalogName;
        }
        if (hasChanged) {
            this.m_currentSchema = schemaName;
        }
    }

    private boolean compareObjectsByName(String currentObject, String newObject) {
        boolean result = (currentObject == null || currentObject.length() == 0) && newObject == null;
        result = result || currentObject != null && newObject != null && newObject.equals(currentObject);
        return result;
    }

    @Override
    public void done() {
        this.m_childElementHandler.done();
    }
}

