/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions;

import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import java.util.Collection;

public class SchemaLevelObjectsExtraction {
    private final VendorAccess m_extractionQuery;
    private final VendorAccessConnection m_relmdConnection;
    private final MetadataObjectSelections m_databaseObjectSelections;
    private ParentSchemaReferenceProcessor m_resultSetSchemaLocator;
    private final VendorAccessResultSetHandler m_resultSetHandler;
    private final Collection<ObjectSelectionsInclusion> m_objectSelectionsInclusionRulesCollection;

    public SchemaLevelObjectsExtraction(SchemaChildIndexes tablesRules, VendorAccess extractionQuery, VendorAccessConnection relmdConnection, MetadataObjectSelections databaseObjectSelections, VendorAccessResultSetHandler resultSetHandler, ParentCatalogSchemaHandler schemaHandler, I_ChildElementHandler childElementHandler, Collection<ObjectSelectionsInclusion> objectSelectionsInclusionRulesCollection) {
        this.m_extractionQuery = extractionQuery;
        this.m_databaseObjectSelections = databaseObjectSelections;
        this.m_relmdConnection = relmdConnection;
        this.m_resultSetHandler = resultSetHandler;
        this.m_objectSelectionsInclusionRulesCollection = objectSelectionsInclusionRulesCollection;
        if (schemaHandler != null) {
            this.m_resultSetSchemaLocator = new ParentSchemaReferenceProcessor(tablesRules, schemaHandler, childElementHandler);
        }
    }

    public final ImportSummary run() {
        ExtractionSummary summary = new ExtractionSummary(this.getClass().getName());
        summary.start();
        VendorAccessResultSet resultSetRecord = this.m_extractionQuery.run(this.m_relmdConnection, this.m_databaseObjectSelections, this.m_objectSelectionsInclusionRulesCollection);
        VendorAccessResultSetIterator resultSetIterator = resultSetRecord.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = resultSetRecord.values();
            summary.incrementRowCount();
            if (this.m_resultSetSchemaLocator != null) {
                this.m_resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
            }
            this.m_resultSetHandler.handleResultSetRecord(resultSetValueRetrieval);
        }
        summary.stop();
        return summary;
    }
}

