/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ParentCatalogSchema;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.SelectedAllObjects;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SelectedObject;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;

public class TableGrainQueryExecution {
    private final VendorAccessConnection m_relmdConnection;
    private final VendorAccess m_dbExtraction;

    public TableGrainQueryExecution(VendorAccessConnection relmdConnection, VendorAccess dbExtraction) {
        this.m_relmdConnection = relmdConnection;
        this.m_dbExtraction = dbExtraction;
    }

    private void navigateSchemaSelections(ReferenceableSet<SchemaSelection> schemaSelections, Handler<ColumnContainerObjectRef> parentTableViewHandler, Handler<SchemaPath> catalogSchemaHandler, VendorAccessResultSetHandler resultSetHandler, SelectedObject catalogSelection) {
        String catalogName;
        String string = catalogName = null == catalogSelection ? "" : catalogSelection.objectName();
        if (0 == schemaSelections.size()) {
            this.runQuery(catalogName, "%", "%", resultSetHandler, parentTableViewHandler, catalogSchemaHandler);
        } else {
            for (SchemaSelection schemaSelection : schemaSelections) {
                this.run(parentTableViewHandler, catalogSchemaHandler, resultSetHandler, catalogName, schemaSelection, schemaSelection.tableSelections());
                this.run(parentTableViewHandler, catalogSchemaHandler, resultSetHandler, catalogName, schemaSelection, schemaSelection.viewSelections());
            }
        }
    }

    private void run(Handler<ColumnContainerObjectRef> parentTableViewHandler, Handler<SchemaPath> catalogSchemaHandler, VendorAccessResultSetHandler resultSetHandler, String catalogName, SchemaSelection schemaSelection, SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects> objectSelections) {
        if (SelectionChoice.EChoice.all.equals((Object)objectSelections.choice())) {
            String schemaName = schemaSelection.objectName();
            this.runQuery(catalogName, schemaName, "%", resultSetHandler, parentTableViewHandler, catalogSchemaHandler);
        } else {
            for (SelectedObject selectedObject : objectSelections.selectedObjects()) {
                String schemaName = schemaSelection.objectName();
                String tableName = selectedObject.objectName();
                try {
                    this.runQuery(catalogName, schemaName, tableName, resultSetHandler, parentTableViewHandler, catalogSchemaHandler);
                }
                catch (RelmdException e) {
                    if (e.getErrorCode() == RelmdException.EErrorCode.sqlExecutionError) continue;
                    break;
                }
            }
        }
    }

    private void runQuery(String catalogName, String schemaName, String objectName, VendorAccessResultSetHandler resultSetHandler, Handler<ColumnContainerObjectRef> parentTableViewHandler, Handler<SchemaPath> catalogSchemaHandler) {
        VendorAccessResultSet resultSet = this.m_dbExtraction.runObjectLevel(this.m_relmdConnection, catalogName, schemaName, objectName);
        String prevCatalog = "";
        String prevSchema = "";
        String prevTable = "";
        VendorAccessResultSetIterator iterator = resultSet.iterator();
        while (iterator.next()) {
            boolean bContextChanged = false;
            VendorAccessResultSetValues resultSetValues = resultSet.values();
            String retrievedCatalog = resultSetValues.stringValue(1);
            String retrievedSchema = resultSetValues.stringValue(2);
            Relmd relmd = RelmdGateway.relmd();
            MetadataToolkit metadataToolkit = relmd.metadataToolkit();
            if (!prevCatalog.equals(retrievedCatalog)) {
                bContextChanged = true;
                prevCatalog = retrievedCatalog;
            }
            if (bContextChanged || !prevSchema.equals(retrievedSchema)) {
                bContextChanged = true;
                prevSchema = retrievedSchema;
            }
            if (bContextChanged && null != catalogSchemaHandler) {
                ParentCatalogSchema parentCatalogSchema = metadataToolkit.parentCatalogSchema(retrievedCatalog, retrievedSchema);
                catalogSchemaHandler.handle(parentCatalogSchema);
            }
            if (null != parentTableViewHandler) {
                final String retrievedTable = resultSetValues.stringValue(3);
                if (bContextChanged || !prevTable.equals(retrievedTable)) {
                    ColumnContainerObjectRef columnContainerObjectRef = new ColumnContainerObjectRef(){

                        @Override
                        public String objectName() {
                            return retrievedTable;
                        }
                    };
                    parentTableViewHandler.handle(columnContainerObjectRef);
                    prevTable = retrievedTable;
                }
            }
            VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
            resultSetHandler.handleResultSetRecord(resultSetValueRetrieval);
        }
    }

    public ImportSummary run(MetadataObjectSelections databaseObjectSelections, VendorAccessResultSetHandler resultSetHandler, Handler<ColumnContainerObjectRef> parentTableViewHandler, Handler<SchemaPath> catalogSchemaHandler) {
        ReferenceableSet<CatalogSelection> catalogSelections = databaseObjectSelections.catalogSelections().selectedObjects();
        for (CatalogSelection catalogSelection : catalogSelections) {
            ReferenceableSet<SchemaSelection> schemaSelections = catalogSelection.schemaSelections().selectedObjects();
            this.navigateSchemaSelections(schemaSelections, parentTableViewHandler, catalogSchemaHandler, resultSetHandler, catalogSelection);
        }
        ReferenceableSet<SchemaSelection> databaseSchemaSelections = databaseObjectSelections.schemaSelections().selectedObjects();
        this.navigateSchemaSelections(databaseSchemaSelections, parentTableViewHandler, catalogSchemaHandler, resultSetHandler, null);
        ExtractionSummary extractionSummary = new ExtractionSummary("TableGrainQueryExecution");
        return extractionSummary;
    }

    static enum EChangedState {
        catalog,
        schema,
        object,
        none;

    }
}

