/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.session;

import com.ibm.cognos.internal.relmd.metadata._schema.ReferenceableSetElem;
import com.ibm.cognos.internal.relmd.session.query.functions.CurrentCatalogSetupElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session._schema.AccessibleCatalogRef;
import com.ibm.cognos.relmd.session._schema.DefaultCatalogSchema;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.session.query.SessionQueryToolkit;
import com.ibm.cognos.relmd.session.query.functions.AccessibleCatalogsQuery;
import com.ibm.cognos.relmd.session.query.functions.DefaultCatalogSchemaQuery;
import com.ibm.cognos.relmd.session.query.rules.AccessibleCatalogsQueryRules;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.session.query.rules.DefaultCatalogSchemaQueryRules;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;

public class QueriedSession
implements Session {
    private final String m_dbUserName;
    private ReferenceableSet<AccessibleCatalogRef> m_accessibleCatalogsSet;
    private DefaultCatalogSchema m_defaultCatalogSchema;
    private final SessionQueryRules m_sessionQueryRules;
    private final VendorAccessResults m_vendorAccessResults;
    private final Connection m_connection;
    private SessionQueryToolkit m_sessionQueryToolkit;
    private MetadataToolkit m_metadataToolkit;

    public QueriedSession(Connection connection, SessionQueryRules sessionQueryRules, VendorAccessResults vendorAccessResults, String dbUserName) {
        this.m_connection = connection;
        this.m_sessionQueryRules = sessionQueryRules;
        this.m_vendorAccessResults = vendorAccessResults;
        this.m_dbUserName = dbUserName;
        Relmd relmd = RelmdGateway.relmd();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        this.m_sessionQueryToolkit = sessionToolkit.sessionQueryToolkit();
        this.m_metadataToolkit = relmd.metadataToolkit();
    }

    public String dbUserName() {
        return this.m_dbUserName;
    }

    @Override
    public DefaultCatalogSchema defaultCatalogSchema() {
        if (null == this.m_defaultCatalogSchema) {
            DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules = this.m_sessionQueryRules.defaultCatalogSchemaQueryRules();
            if (null != defaultCatalogSchemaQueryRules) {
                Handler<DefaultCatalogSchema> defaultCatalogSchemaHandler = new Handler<DefaultCatalogSchema>(){

                    @Override
                    public void handle(DefaultCatalogSchema obj) {
                        QueriedSession.this.m_defaultCatalogSchema = obj;
                    }
                };
                DefaultCatalogSchemaQuery defaultCatalogSchemaQuery = this.m_sessionQueryToolkit.defaultCatalogSchemaQuery(this.m_dbUserName, defaultCatalogSchemaQueryRules, this.m_vendorAccessResults, defaultCatalogSchemaHandler);
                defaultCatalogSchemaQuery.run(this.m_connection);
            } else {
                String m_defaultSchemaRef = this.m_dbUserName;
                CaseSensitivityRules caseSensitivityRules = this.m_sessionQueryRules.caseSensitivityRules();
                CaseSensitivityRules.EStorage storage = caseSensitivityRules.storage();
                if (CaseSensitivityRules.EStorage.upper.equals((Object)storage)) {
                    m_defaultSchemaRef = m_defaultSchemaRef.toUpperCase();
                }
                this.m_defaultCatalogSchema = this.m_metadataToolkit.defaultCatalogSchema(null, m_defaultSchemaRef);
            }
        }
        return this.m_defaultCatalogSchema;
    }

    @Override
    public ReferenceableSet<AccessibleCatalogRef> accessibleCatalogsSet() {
        if (null == this.m_accessibleCatalogsSet) {
            AccessibleCatalogsQueryRules accessibleCatalogsQueryRules;
            Relmd relmd = RelmdGateway.relmd();
            SessionToolkit sessionToolkit = relmd.sessionToolkit();
            SessionQueryToolkit queryToolkit = sessionToolkit.sessionQueryToolkit();
            CatalogGranularityRules catalogGranularityRules = this.m_sessionQueryRules.catalogGranularityRules();
            if (null != catalogGranularityRules && null != (accessibleCatalogsQueryRules = catalogGranularityRules.accessibleCatalogsQueryRules())) {
                this.m_accessibleCatalogsSet = new ReferenceableSetElem<AccessibleCatalogRef>();
                Handler<AccessibleCatalogRef> accessibleCatalogsHandler = new Handler<AccessibleCatalogRef>(){

                    @Override
                    public void handle(AccessibleCatalogRef obj) {
                        QueriedSession.this.m_accessibleCatalogsSet.add(obj);
                    }
                };
                VendorAccessHandler vendorAccessHandler = this.m_vendorAccessResults.vendorAccessHandler();
                DefaultCatalogSchema defaultCatalogSchema = this.defaultCatalogSchema();
                if (null != defaultCatalogSchema) {
                    String catalog = defaultCatalogSchema.parentCatalogName();
                    CurrentCatalogSetupElem currentCatalogSetupElem = new CurrentCatalogSetupElem(catalogGranularityRules, catalog, vendorAccessHandler);
                    AccessibleCatalogsQuery accessibleCatalogsQuery = queryToolkit.accessibleCatalogsQuery(currentCatalogSetupElem, this.m_vendorAccessResults, accessibleCatalogsHandler);
                    accessibleCatalogsQuery.run(this.m_connection);
                }
            }
        }
        return this.m_accessibleCatalogsSet;
    }

    @Override
    public XmlElement asXml() {
        return null;
    }

    public void write(String schemaLocation, OutputStream os) throws IOException {
    }
}

