/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.session.query.functions;

import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session._schema.DefaultCatalogSchema;
import com.ibm.cognos.relmd.session.query.functions.DefaultCatalogSchemaQuery;
import com.ibm.cognos.relmd.session.query.rules.DefaultCatalogSchemaQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.DatabaseAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;

public class DefaultCatalogSchemaQueryElem
extends ExtractionElement
implements DefaultCatalogSchemaQuery {
    public static final String TAGNAME = "defaultSchema";
    public static final String ATTRIBUTE_CATALOG = "defaultCatalog";
    public static final String TAGNAME_defaultSchema = "defaultSchema";
    private final DefaultCatalogSchemaQueryRules m_defaultCatalogSchemaQueryRules;
    private final Handler<DefaultCatalogSchema> m_defaultCatalogSchemaHandler;
    private final String m_dbUserName;
    private final VendorAccessHandler m_vendorAccessHandler;

    public DefaultCatalogSchemaQueryElem() {
        super(ImportMetadataFunction.EImportFunctionType.defaultSchema);
        this.m_dbUserName = null;
        this.m_vendorAccessHandler = null;
        this.m_defaultCatalogSchemaQueryRules = null;
        this.m_defaultCatalogSchemaHandler = null;
    }

    public DefaultCatalogSchemaQueryElem(String dbUserName, Handler<DefaultCatalogSchema> defaultCatalogSchemaHandler, DefaultCatalogSchemaQueryRules defaultSchemaQueryRules, VendorAccessHandler vendorAccessHandler) {
        super(ImportMetadataFunction.EImportFunctionType.defaultSchema);
        this.m_dbUserName = dbUserName;
        this.m_defaultCatalogSchemaQueryRules = defaultSchemaQueryRules;
        this.m_defaultCatalogSchemaHandler = defaultCatalogSchemaHandler;
        this.m_vendorAccessHandler = vendorAccessHandler;
    }

    @Override
    public void stop() {
    }

    @Override
    public String dbUserName() {
        return this.m_dbUserName;
    }

    @Override
    public Handler<DefaultCatalogSchema> defaultCatalogSchemaHandler() {
        return this.m_defaultCatalogSchemaHandler;
    }

    @Override
    public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
        return this.m_defaultCatalogSchemaQueryRules;
    }

    @Override
    public void run(Connection connection) {
        SessionToolkit metadataToolkit = RelmdGateway.relmd().sessionToolkit();
        DefaultCatalogSchema defaultSchema = null;
        ExtractionSummary summary = new ExtractionSummary(this.getClass().getName());
        if (null == this.m_defaultCatalogSchemaQueryRules) {
            if (null != this.m_dbUserName) {
                defaultSchema = metadataToolkit.defaultCatalogSchema(null, this.m_dbUserName);
            }
        } else {
            VendorAccess m_extractionQuery = this.m_defaultCatalogSchemaQueryRules.extractionQuery();
            summary.start();
            VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
            VendorAccessHandler vendorAccessHandler = this.m_vendorAccessHandler;
            DatabaseAccessHandler databaseAccessEventHandler = vendorToolkit.databaseAccessEventHandler(vendorAccessHandler);
            VendorAccessConnection vendorAccessConnection = vendorToolkit.vendorConnectionAccess(connection, databaseAccessEventHandler);
            VendorAccessResultSet resultSet = m_extractionQuery.run(vendorAccessConnection, null, this.m_defaultCatalogSchemaQueryRules.objectSelectionsInclusionCollection());
            VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
            if (resultSetIterator.next()) {
                VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                String defaultCatalogName = resultSetValueRetrieval.stringValue(this.m_defaultCatalogSchemaQueryRules.defaultCatalogRecordIndex());
                String defaultSchemaName = resultSetValueRetrieval.stringValue(this.m_defaultCatalogSchemaQueryRules.defaultSchemaRecordIndex());
                defaultSchema = metadataToolkit.defaultCatalogSchema(defaultCatalogName, 0 == defaultSchemaName.length() ? this.m_dbUserName : defaultSchemaName);
                summary.incrementRowCount();
            }
            resultSet.close();
            summary.stop();
        }
        if (null != defaultSchema) {
            this.m_defaultCatalogSchemaHandler.handle(defaultSchema);
        }
    }

    @Override
    public VendorAccessHandler vendorAccessHandler() {
        return this.m_vendorAccessHandler;
    }
}

