/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.session.query.functions;

import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.RelmdSqlExecution;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.session._schema.AccessibleCatalogRef;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.session.query.functions.AccessibleCatalogsQuery;
import com.ibm.cognos.relmd.session.query.functions.CurrentCatalogSetup;
import com.ibm.cognos.relmd.session.query.rules.AccessibleCatalogsQueryRules;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.session.query.rules.CodePageRules;
import com.ibm.cognos.relmd.session.query.rules.DefaultCatalogSchemaQueryRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class SqlServerAccessibleCatalogsQuery
implements AccessibleCatalogsQuery {
    private final AccessibleCatalogsQueryRules m_accessibleCatalogsQueryRules;
    private final CurrentCatalogSetup m_currentCatalogSetup;
    public static final String SQLTEXT_allCatalogsRetrieval = "SELECT A.CATALOG_NAME objectName, '' description FROM INFORMATION_SCHEMA.SCHEMATA A GROUP BY A.CATALOG_NAME ORDER BY objectName ";
    private final Handler<AccessibleCatalogRef> m_accessibleCatalogsRefHandler;
    private final VendorAccessHandler m_vendorAccessHandler;
    private VendorToolkit m_vendorToolkit;
    private LinkedHashSet<String> m_allCatalogs;
    private VendorAccessToolkit m_vendorAccessToolkit;

    public SqlServerAccessibleCatalogsQuery(AccessibleCatalogsQueryRules accessiblCatalogsQueryRules, Handler<AccessibleCatalogRef> accessibleCatalogsRefHandler, VendorAccessHandler vendorAccessHandler, CurrentCatalogSetup currentCatalogSetup) {
        this.m_currentCatalogSetup = currentCatalogSetup;
        this.m_accessibleCatalogsQueryRules = accessiblCatalogsQueryRules;
        this.m_accessibleCatalogsRefHandler = accessibleCatalogsRefHandler;
        this.m_vendorAccessHandler = vendorAccessHandler;
        this.m_vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        this.m_vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
    }

    @Override
    public AccessibleCatalogsQueryRules accessibleCatalogsQueryRules() {
        return this.m_accessibleCatalogsQueryRules;
    }

    @Override
    public Handler<AccessibleCatalogRef> accessibleCatalogRefHandler() {
        return this.m_accessibleCatalogsRefHandler;
    }

    @Override
    public void run(Connection connection) {
        this.m_currentCatalogSetup.run(connection);
        final CatalogGranularityRules catalogGranularityRules = this.m_currentCatalogSetup.catalogGranularityRules();
        final CaseSensitivityRules caseSensitivityRules = new CaseSensitivityRules(){

            @Override
            public CaseSensitivityRules.EStorage storage() {
                return CaseSensitivityRules.EStorage.none;
            }

            @Override
            public CaseSensitivityRules.EConversionType conversionType() {
                return CaseSensitivityRules.EConversionType.sql;
            }
        };
        final CodePageRules codePageRules = new CodePageRules(){

            @Override
            public CodePageRules.ECodePage codePage() {
                return CodePageRules.ECodePage.unicode;
            }
        };
        SessionQueryRules sessionQueryRules = new SessionQueryRules(){

            @Override
            public CaseSensitivityRules caseSensitivityRules() {
                return caseSensitivityRules;
            }

            @Override
            public CatalogGranularityRules catalogGranularityRules() {
                return catalogGranularityRules;
            }

            @Override
            public DefaultCatalogSchemaQueryRules defaultCatalogSchemaQueryRules() {
                return null;
            }

            @Override
            public Boolean hasCatalogGranularityRules() {
                return null != catalogGranularityRules;
            }

            @Override
            public Boolean hasDefaultSchemaQueryRules() {
                return false;
            }

            @Override
            public Database.ECatalogSupport catalogSupport() {
                return Database.ECatalogSupport.catalogsSupported;
            }

            @Override
            public CodePageRules codePageRules() {
                return codePageRules;
            }
        };
        VendorAccessConnection relmdConnection = this.m_vendorToolkit.vendorAccessConnection(connection, this.m_vendorAccessHandler, sessionQueryRules);
        LinkedHashSet<String> catalogNames = this.allCatalogs(relmdConnection);
        this.accessibleCatalogs(catalogNames, relmdConnection);
        this.m_currentCatalogSetup.stop();
    }

    private void accessibleCatalogs(LinkedHashSet<String> catalogNames, VendorAccessConnection relmdConnection) {
        ArrayList<String> accessibleCatalogs = new ArrayList<String>();
        for (final String catalogName : catalogNames) {
            Connection jdbcConnection = relmdConnection.jdbcConnection();
            SessionQueryRules sessionQueryRules = relmdConnection.sessionQueryRules();
            VendorAccessHandler vendorAccessHandler = this.vendorAccessHandlerStub();
            VendorAccessConnection relmdConnection2 = this.m_vendorToolkit.vendorAccessConnection(jdbcConnection, vendorAccessHandler, sessionQueryRules);
            RelmdSqlExecution execution = new RelmdSqlExecution(relmdConnection2);
            String sql = "USE \"" + catalogName + "\" SELECT A.name defaultSchema FROM master.dbo.sysusers A WHERE A.uid = 1";
            VendorAccessResultSet resultSet = execution.run(sql);
            VendorAccessResultSetIterator iterator = resultSet.iterator();
            while (iterator.next()) {
                VendorAccessResultSetValues values = resultSet.values();
                final String defaultSchemaName = values.stringValue(1);
                AccessibleCatalogRef accessibleCatalogRef = new AccessibleCatalogRef(){

                    @Override
                    public String objectName() {
                        return catalogName;
                    }

                    @Override
                    public String defaultSchemaRef() {
                        return defaultSchemaName;
                    }
                };
                this.m_accessibleCatalogsRefHandler.handle(accessibleCatalogRef);
                String objectName = accessibleCatalogRef.objectName();
                accessibleCatalogs.add(objectName);
            }
            resultSet.close();
        }
        ExecutionInformation endEvent = this.m_vendorAccessToolkit.executionInformation("SqlServerAccessibleCatalogsQuery.run(Connection) end: " + accessibleCatalogs.toString());
        VendorAccessHandler vendorAccessHandler = relmdConnection.vendorAccessHandler();
        Handler<ExecutionInformation> executionInformationHandler = vendorAccessHandler.executionInformationHandler();
        executionInformationHandler.handle(endEvent);
    }

    private VendorAccessHandler vendorAccessHandlerStub() {
        VendorAccessHandler vendorAccessHandler = new VendorAccessHandler(){

            @Override
            public Handler<BeginJava> beginJavaHandler() {
                return new Handler<BeginJava>(){

                    @Override
                    public void handle(BeginJava obj) {
                    }
                };
            }

            @Override
            public Handler<BeginSql> beginSqlHandler() {
                return new Handler<BeginSql>(){

                    @Override
                    public void handle(BeginSql obj) {
                    }
                };
            }

            @Override
            public Handler<ExecutionInformation> executionInformationHandler() {
                return new Handler<ExecutionInformation>(){

                    @Override
                    public void handle(ExecutionInformation obj) {
                    }
                };
            }

            @Override
            public Handler<ExecutionError> executionErrorHandler() {
                return new Handler<ExecutionError>(){

                    @Override
                    public void handle(ExecutionError obj) {
                    }
                };
            }

            @Override
            public Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler() {
                return new Handler<ResultSetProcessingInformation>(){

                    @Override
                    public void handle(ResultSetProcessingInformation obj) {
                    }
                };
            }

            @Override
            public Handler<ResultSetProcessingError> resultSetProcessingErrorHandler() {
                return new Handler<ResultSetProcessingError>(){

                    @Override
                    public void handle(ResultSetProcessingError obj) {
                    }
                };
            }
        };
        return vendorAccessHandler;
    }

    private LinkedHashSet<String> allCatalogs(VendorAccessConnection relmdConnection) {
        if (null == this.m_allCatalogs) {
            this.m_allCatalogs = new LinkedHashSet();
            RelmdSqlExecution relmdSqlExecution = new RelmdSqlExecution(relmdConnection);
            VendorAccessResultSet resultSet = relmdSqlExecution.run("select d.name from master.dbo.sysdatabases d order by d.name");
            if (null != resultSet) {
                VendorAccessResultSetIterator iterator = resultSet.iterator();
                while (iterator.next()) {
                    VendorAccessResultSetValues values = resultSet.values();
                    String catalogName = values.stringValue(1);
                    this.m_allCatalogs.add(catalogName);
                }
                resultSet.close();
            }
            VendorAccessHandler vendorAccessHandler = relmdConnection.vendorAccessHandler();
            Handler<ExecutionInformation> executionInformationHandler = vendorAccessHandler.executionInformationHandler();
            ExecutionInformation beginInformation = this.m_vendorAccessToolkit.executionInformation("SqlServerAccessibleCatalogsQuery.run(Connection) begin: " + this.m_allCatalogs.toString());
            executionInformationHandler.handle(beginInformation);
        }
        return this.m_allCatalogs;
    }

    @Override
    public void stop() {
        this.m_currentCatalogSetup.stop();
    }

    @Override
    public XmlElement asXml() {
        RelmdElement relmdElement = new RelmdElement("accessibleCatalogsQueryRules");
        return relmdElement;
    }

    public String toString() {
        XmlElement asXml = this.asXml();
        String string = asXml.toString();
        return string;
    }

    @Override
    public VendorAccessHandler vendorAccessHandler() {
        VendorAccessHandler vendorAccessHandler = this.m_vendorAccessHandler;
        return vendorAccessHandler;
    }
}

