/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.utilities;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class EscapeObjectName {
    private static final String JDBC_ANY_STRING = "%";
    private static final String JDBC_ANY_CHAR = "_";
    private String JDBC_ESCAPE_CHAR = null;
    private String escapedAnyJDBCString = null;
    private String escapedAnyJDBCChar = null;
    private String escapedEscapeChar = null;
    private DatabaseMetaData m_md = null;

    public EscapeObjectName(DatabaseMetaData md) throws SQLException {
        this.m_md = md;
        try {
            this.JDBC_ESCAPE_CHAR = this.m_md.getSearchStringEscape();
        }
        catch (SQLException e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
        }
        if (null != this.JDBC_ESCAPE_CHAR && !this.JDBC_ESCAPE_CHAR.isEmpty()) {
            this.escapedEscapeChar = this.JDBC_ESCAPE_CHAR + this.JDBC_ESCAPE_CHAR;
            this.escapedAnyJDBCString = this.JDBC_ESCAPE_CHAR + JDBC_ANY_STRING;
            this.escapedAnyJDBCChar = this.JDBC_ESCAPE_CHAR + JDBC_ANY_CHAR;
        }
    }

    public String escape(String objectName) {
        String escapedString = objectName;
        if (null != escapedString && !escapedString.isEmpty() && null != this.JDBC_ESCAPE_CHAR && !this.JDBC_ESCAPE_CHAR.isEmpty()) {
            escapedString = escapedString.replace(this.JDBC_ESCAPE_CHAR, this.escapedEscapeChar);
            escapedString = escapedString.replace(JDBC_ANY_STRING, this.escapedAnyJDBCString);
            escapedString = escapedString.replace(JDBC_ANY_CHAR, this.escapedAnyJDBCChar);
        }
        return escapedString;
    }
}

