/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments;

import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments.SqlFragmentConcatenationBase;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CodePageRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access.functions.sql.VendorAccessSqlToolkit;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragment;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragmentConcatenationRules;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;

public class ObjectInclusionConditionExpressionEvaluation
implements SqlFragment,
Handler<SqlFragment> {
    private LinkedHashMap<String, SqlFragment> m_entries;
    private final SqlFragment m_expressionFragmentLhs;
    private final SqlFragment m_listDelimiter;
    private VendorAccessSqlToolkit m_vendorAccessSqlToolkit;
    private final Locale m_locale;
    private final CaseSensitivityRules m_caseSensitivityRules;
    private CodePageRules m_codePageRules = null;
    public static final String NVARCHAR = "N";
    private static final char EXPRESSION_BEGIN_LEFTPAREN = '(';
    private static final char EXPRESSION_END_RIGHTPAREN = ')';

    public ObjectInclusionConditionExpressionEvaluation(SqlFragment expressionFragmentLhs, CaseSensitivityRules caseSensitivityRules, Locale locale) {
        Relmd relmd = RelmdGateway.relmd();
        VendorToolkit vendorToolkit = relmd.vendorToolkit();
        VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        this.m_vendorAccessSqlToolkit = vendorAccessToolkit.vendorAccessSqlToolkit();
        this.m_locale = locale;
        this.m_expressionFragmentLhs = expressionFragmentLhs;
        this.m_listDelimiter = VendorAccessSqlToolkit.SQLFRAGMENT_COMMA_DELIMITER;
        this.m_entries = new LinkedHashMap();
        this.m_caseSensitivityRules = caseSensitivityRules;
    }

    public void setCodePageRules(CodePageRules codePageRules) {
        this.m_codePageRules = codePageRules;
    }

    @Override
    public String value() {
        SqlFragmentConcatenationRules rules;
        int entryCount;
        String value = "";
        int size = entryCount = this.m_entries.size();
        SqlFragment operator = VendorAccessSqlToolkit.SQLFRAGMENT_OPERATOR_EQUALS;
        SqlFragment rhsFragment = null;
        Collection<SqlFragment> values = this.m_entries.values();
        if (1 == size) {
            Iterator<SqlFragment> first = values.iterator();
            rhsFragment = first.next();
        } else if (1 < size) {
            operator = VendorAccessSqlToolkit.SQLFRAGMENT_OPERATOR_IN;
            rules = this.m_vendorAccessSqlToolkit.sqlFragmentConcatenationRules(this.m_listDelimiter, VendorAccessSqlToolkit.SQLFRAGMENT_LEFTPARENTHESIS, VendorAccessSqlToolkit.SQLFRAGMENT_RIGHTPARENTHESIS);
            SqlFragmentConcatenationBase entriesConcatenation = new SqlFragmentConcatenationBase(rules);
            for (SqlFragment entry : values) {
                entriesConcatenation.handle(entry);
            }
            rhsFragment = entriesConcatenation;
        }
        if (null != rhsFragment) {
            rules = this.m_vendorAccessSqlToolkit.sqlFragmentConcatenationRulesDelimitedOnly(operator);
            SqlFragmentConcatenationBase binaryOperationConcatenation = new SqlFragmentConcatenationBase(rules);
            binaryOperationConcatenation.handle(this.m_expressionFragmentLhs);
            binaryOperationConcatenation.handle(rhsFragment);
            value = binaryOperationConcatenation.value();
        }
        return value;
    }

    @Override
    public void handle(SqlFragment sqlFragment) {
        if (null != this.m_expressionFragmentLhs) {
            String objectExpression = null;
            if (null != sqlFragment) {
                objectExpression = sqlFragment.value();
            }
            if (null != objectExpression) {
                String nameDelimited = "";
                String trimmed = objectExpression.trim();
                if (0 < trimmed.length()) {
                    CaseSensitivityRules.EStorage storage;
                    CodePageRules.ECodePage codePage = CodePageRules.ECodePage.nonUnicode;
                    if (this.m_codePageRules != null && (codePage = this.m_codePageRules.codePage()) != null && codePage.equals((Object)CodePageRules.ECodePage.unicode)) {
                        nameDelimited = nameDelimited + NVARCHAR;
                    }
                    this.m_vendorAccessSqlToolkit.sessionQueryRules(CaseSensitivityRules.EStorage.lower);
                    nameDelimited = nameDelimited + "'";
                    nameDelimited = nameDelimited + trimmed;
                    nameDelimited = nameDelimited + "'";
                    SqlFragment nameFragment = this.m_vendorAccessSqlToolkit.sqlFragment(nameDelimited);
                    this.m_entries.put(nameDelimited, nameFragment);
                    if (null != this.m_caseSensitivityRules && !(storage = this.m_caseSensitivityRules.storage()).equals((Object)CaseSensitivityRules.EStorage.none)) {
                        String caseInsensitiveNameDelimited = null;
                        caseInsensitiveNameDelimited = CaseSensitivityRules.EStorage.lower.equals((Object)storage) ? (null != this.m_locale ? nameDelimited.toLowerCase(this.m_locale) : nameDelimited.toLowerCase()) : (null != this.m_locale ? nameDelimited.toUpperCase(this.m_locale) : nameDelimited.toUpperCase());
                        boolean equals = caseInsensitiveNameDelimited.equals(nameDelimited);
                        if (!equals) {
                            SqlFragment caseInsensitiveNameFragment = null;
                            CaseSensitivityRules.EConversionType conversionConjunction = this.m_caseSensitivityRules.conversionType();
                            if (CaseSensitivityRules.EConversionType.java.equals((Object)conversionConjunction)) {
                                nameDelimited = caseInsensitiveNameDelimited;
                                caseInsensitiveNameFragment = this.m_vendorAccessSqlToolkit.sqlFragment(caseInsensitiveNameDelimited);
                            } else {
                                String storageValue = storage.toString();
                                String storageValueSqlFragmentText = storageValue.toUpperCase();
                                nameDelimited = storageValueSqlFragmentText + '(' + nameDelimited + ')';
                                caseInsensitiveNameFragment = this.m_vendorAccessSqlToolkit.sqlFragment(nameDelimited);
                            }
                            this.m_entries.put(nameDelimited, caseInsensitiveNameFragment);
                        }
                    }
                }
            }
        }
    }
}

