/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments;

import com.ibm.cognos.relmd.vendor.access.functions.sql.SqlFragmentConcatenation;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragment;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragmentConcatenationRules;
import java.util.ArrayList;
import java.util.Collection;

public class SqlFragmentConcatenationBase
implements SqlFragmentConcatenation {
    private final SqlFragmentConcatenationRules m_concatenationRules;
    private Collection<SqlFragment> m_sqlFragmentCollection;

    public SqlFragmentConcatenationBase() {
        this(new SqlFragmentConcatenationRules(){

            @Override
            public SqlFragment delimiter() {
                return null;
            }

            @Override
            public SqlFragment leading() {
                return null;
            }

            @Override
            public SqlFragment trailing() {
                return null;
            }
        });
    }

    public SqlFragmentConcatenationBase(SqlFragmentConcatenationRules concatenationRules) {
        this.m_concatenationRules = concatenationRules;
        this.m_sqlFragmentCollection = new ArrayList<SqlFragment>();
    }

    @Override
    public String value() {
        String fragmentsValue = "";
        StringBuilder stringBuilder = new StringBuilder(fragmentsValue);
        SqlFragment m_delimiter = null;
        SqlFragment m_leading = null;
        SqlFragment m_trailing = null;
        if (null != this.m_concatenationRules) {
            m_delimiter = this.m_concatenationRules.delimiter();
            m_leading = this.m_concatenationRules.leading();
            m_trailing = this.m_concatenationRules.trailing();
        }
        for (SqlFragment fragment : this.m_sqlFragmentCollection) {
            String value = fragment.value();
            if (0 == stringBuilder.length()) {
                if (null != m_leading) {
                    String leadingValue = m_leading.value();
                    stringBuilder.append(leadingValue);
                }
            } else if (null != m_delimiter) {
                String delimiterValue = m_delimiter.value();
                stringBuilder.append(delimiterValue);
            }
            stringBuilder.append(value);
        }
        if (null != m_trailing && 0 < stringBuilder.length()) {
            String trailingValue = m_trailing.value();
            stringBuilder.append(trailingValue);
        }
        fragmentsValue = stringBuilder.toString();
        return fragmentsValue;
    }

    @Override
    public void handle(SqlFragment obj) {
        String value;
        if (null != obj && null != (value = obj.value()) && 0 < value.length()) {
            this.m_sqlFragmentCollection.add(obj);
        }
    }

    @Override
    public SqlFragmentConcatenationRules sqlFragmentConcatenationRules() {
        return this.m_concatenationRules;
    }

    @Override
    public Collection<SqlFragment> fragmentCollection() {
        return this.m_sqlFragmentCollection;
    }
}

