/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.xmlapi;

import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttribute;
import com.ibm.cognos.relmd.xmlapi.ApiSpecification;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import org.dom4j.io.OutputFormat;

public class XmlWriter {
    private static final long serialVersionUID = 1L;
    private static final String XMLNS = "xmlns";
    private static final String ATTRIBUTE_XSISCHEMALOCATION = "schemaLocation";
    private static final String XMLSEPARATOR_COLON = ":";
    private static final String INDENT_CHAR = "\t";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String XSI_NSURI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_NSPREFIX = "xsi";
    private final String m_relmdSchemaLocation;
    private final String m_reldNamespacePrefix;

    public XmlWriter(String reldNamespacePrefix, String relmdSchemaFileName, String relmdSchemaFileLocation) {
        this.m_reldNamespacePrefix = reldNamespacePrefix;
        this.m_relmdSchemaLocation = relmdSchemaFileLocation + "/" + relmdSchemaFileName;
    }

    public void writeDoc(ApiSpecification specification, OutputStream outputStream) throws IOException {
        XmlElement element = specification.asXml();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING_UTF8));
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setNewlines(true);
        outputFormat.setIndent(true);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String prefixedElementName = XmlWriter.prefixNodeName(this.m_reldNamespacePrefix, element.getTagName());
        this.writeElemTag(writer, prefixedElementName);
        this.writeAttribute("xmlns:xsi", XSI_NSURI, writer);
        this.writeAttribute("xmlns:" + this.m_reldNamespacePrefix, "http://www.ibm.com/xmlns/prod/cognos/relmd/1/0", writer);
        this.writeAttribute("xsi:schemaLocation", "http://www.ibm.com/xmlns/prod/cognos/relmd/1/0 " + this.m_relmdSchemaLocation, writer);
        this.writeAttributes(element, this.m_reldNamespacePrefix, writer);
        this.writeChildren(prefixedElementName, element.childElements(), writer, this.m_reldNamespacePrefix, 0);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void writeElem(XmlElement element, OutputStream outputStream, String nsPrefix) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, ENCODING_UTF8);
        BufferedWriter writer = new BufferedWriter(outputStreamWriter);
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setNewlines(true);
        outputFormat.setIndent(true);
        String tagName = element.getTagName();
        String nodeName = XmlWriter.prefixNodeName(nsPrefix, tagName);
        this.writeElemTag(writer, nodeName);
        if (null == element.getAttribute("xmlns:" + this.m_reldNamespacePrefix)) {
            this.writeAttribute("xmlns:" + this.m_reldNamespacePrefix, "http://www.ibm.com/xmlns/prod/cognos/relmd/1/0", writer);
        }
        this.writeAttributes(element, nsPrefix, writer);
        this.writeChildren(nodeName, element.childElements(), writer, nsPrefix, 0);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public void writeElem(XmlElement element, Writer m_writer, String nsPrefix) throws IOException {
        String nodeName = XmlWriter.prefixNodeName(nsPrefix, element.getTagName());
        this.writeElemTag(m_writer, nodeName);
        if (null == element.getAttribute("xmlns:" + this.m_reldNamespacePrefix)) {
            this.writeAttribute("xmlns:" + this.m_reldNamespacePrefix, "http://www.ibm.com/xmlns/prod/cognos/relmd/1/0", m_writer);
        }
        this.writeAttributes(element, nsPrefix, m_writer);
        this.writeChildren(nodeName, element.childElements(), m_writer, nsPrefix, 0);
    }

    private void writeElem(XmlElement element, Writer m_writer, String nsPrefix, int indentLevel) throws IOException {
        String nodeName = XmlWriter.prefixNodeName(nsPrefix, element.getTagName());
        this.indent(m_writer, indentLevel);
        this.writeElemTag(m_writer, nodeName);
        this.writeAttributes(element, nsPrefix, m_writer);
        Collection<? extends XmlElement> childElements = element.childElements();
        this.writeChildren(nodeName, childElements, m_writer, nsPrefix, indentLevel);
    }

    private void writeChildren(String parentQName, Collection<? extends XmlElement> collection, Writer m_writer, String nsPrefix, int indentLevel) throws IOException {
        boolean bHasChildren;
        boolean bl = bHasChildren = null != collection && collection.size() > 0;
        if (!bHasChildren) {
            m_writer.write("/>");
            m_writer.write("\n");
        } else {
            m_writer.write(">");
            m_writer.write("\n");
            for (XmlElement xmlElement : collection) {
                this.writeElem(xmlElement, m_writer, nsPrefix, indentLevel + 1);
            }
            this.indent(m_writer, indentLevel);
            m_writer.write("</");
            m_writer.write(parentQName);
            m_writer.write(">\n");
        }
    }

    private void writeElemTag(Writer m_writer, String qName) throws IOException {
        m_writer.write("<");
        m_writer.write(qName);
    }

    private void writeAttributes(XmlElement element, String nsPrefix, Writer m_writer) throws IOException {
        for (XmlAttribute xmlAttribute : element.attributes()) {
            String name = nsPrefix + ':' + xmlAttribute.getName();
            String value = xmlAttribute.getValue();
            this.writeAttribute(name, value, m_writer);
        }
    }

    private void writeAttribute(String name, String value, Writer m_writer) throws IOException {
        m_writer.write(" ");
        if (null != value) {
            m_writer.write(name);
            m_writer.write("=\"");
            String escapeAttributeEntities = RelmdAttribute.escapeAttributeEntities(value);
            m_writer.write(escapeAttributeEntities);
            m_writer.write("\"");
        }
    }

    private void indent(Writer writer, int indentLevel) throws IOException {
        for (int i = 0; i < indentLevel; ++i) {
            writer.write(INDENT_CHAR);
        }
    }

    public static String prefixNodeName(String prefix, String nodeName) {
        return prefix == null ? nodeName : prefix + XMLSEPARATOR_COLON + nodeName;
    }
}

