/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.xmlapi.attributes;

import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import java.io.IOException;
import java.io.Writer;

public class RelmdAttribute
implements XmlAttribute {
    private final String m_name;
    private String m_value;

    public RelmdAttribute(String name, String value) {
        this.m_name = name;
        this.m_value = value;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(String newValue) {
        this.m_value = newValue;
    }

    public static String escapeAttributeEntities(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        char[] block = null;
        int last = 0;
        int size = null == text ? 0 : text.length();
        int i = 0;
        for (i = 0; i < size; ++i) {
            String entity = null;
            switch (text.charAt(i)) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                }
            }
            if (entity == null) continue;
            if (block == null) {
                block = text.toCharArray();
            }
            buffer.append(block, last, i - last);
            buffer.append(entity);
            last = i + 1;
        }
        if (last == 0) {
            return text;
        }
        if (last < size) {
            if (block == null) {
                block = text.toCharArray();
            }
            buffer.append(block, last, i - last);
        }
        String answer = buffer.toString();
        buffer.setLength(0);
        return answer;
    }

    public boolean equals(Object obj) {
        boolean bEquals = false;
        if (obj != null && obj instanceof XmlAttribute) {
            bEquals = this.getName().equals(((XmlAttribute)obj).getName());
        }
        return bEquals;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final String toString() {
        return this.asXml(null);
    }

    @Override
    public void write(Writer m_writer, String nsPrefix) throws IOException {
        String xmlValue = this.asXml(nsPrefix);
        m_writer.write(xmlValue);
    }

    private String asXml(String nsPrefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(nsPrefix == null ? this.getName() : nsPrefix + ":" + this.getName());
        buffer.append("=\"");
        buffer.append(RelmdAttribute.escapeAttributeEntities(this.getValue()));
        buffer.append("\"");
        String newString = new String(buffer);
        return newString;
    }
}

