/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryplugincommon;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HeadersPropertyBuilder {
    public static Map<String, String> buildResponseHeaders(String contentType, String locale, String filename, String contentLength) {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        if (StringUtils.isNotEmpty((String)contentType)) {
            headers.put("Content-Type", contentType);
        }
        if (StringUtils.isNotEmpty((String)locale)) {
            headers.put("Content-Language", locale);
        }
        if (StringUtils.isNotEmpty((String)contentLength)) {
            headers.put("Content-Length", contentLength);
        }
        headers.put("Content-Disposition", HeadersPropertyBuilder.buildDispositionHeader(filename, contentLength));
        return headers;
    }

    private static String buildDispositionHeader(String fileName, String contentLength) {
        StringBuilder sb = new StringBuilder("attachment; ");
        if (StringUtils.isNotEmpty((String)fileName)) {
            sb.append("filename=\"").append(fileName).append("\"; ");
        }
        if (StringUtils.isNotEmpty((String)contentLength)) {
            sb.append("size=").append(contentLength);
        }
        return sb.toString();
    }
}

