/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryplugincommon.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryplugincommon.RepositoryPluginCommonErrors;
import java.io.File;

public class FileAccessUtil {
    public static final int DOES_NOT_EXIST = 0;
    public static final int EXISTS = 1;
    public static final int WRITE = 2;
    public static final int READ = 4;
    public static final int READ_WRITE = 6;

    public static int getFileAccessFlags(File file) {
        int accessFlags = 0;
        if (file.exists()) {
            ++accessFlags;
            if (file.canRead()) {
                accessFlags += 4;
            }
            if (file.canWrite()) {
                accessFlags += 2;
            }
        }
        return accessFlags;
    }

    public static boolean checkFileAccessFlags(File file, int requiredAccessFlags) {
        int fileAccessFlags = FileAccessUtil.getFileAccessFlags(file);
        return FileAccessUtil.checkAccessFlags(requiredAccessFlags, fileAccessFlags);
    }

    protected static boolean checkAccessFlags(int requiredAccessFlags, int fileAccessFlags) {
        return requiredAccessFlags == (requiredAccessFlags & fileAccessFlags);
    }

    public static void checkFileAccessFlagsWithFault(File file, int requiredAccessFlags) throws RepositoryException {
        int fileAccessFlags = 0;
        try {
            fileAccessFlags = FileAccessUtil.getFileAccessFlags(file);
        }
        catch (SecurityException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (FileAccessUtil.checkAccessFlags(requiredAccessFlags, fileAccessFlags)) {
            return;
        }
        if (FileAccessUtil.checkAccessFlags(1, fileAccessFlags)) {
            Message msg;
            switch (requiredAccessFlags) {
                case 4: 
                case 5: {
                    msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.userHasNoReadAccess);
                    break;
                }
                case 2: 
                case 3: {
                    msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.userHasNoWriteAccess);
                    break;
                }
                case 6: 
                case 7: {
                    msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.userHasNoReadWriteAccess);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid access flags");
                }
            }
            throw new RepositoryException(msg);
        }
        throw new RepositoryException(new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.resourceDoesNotExist));
    }
}

