/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.repositoryplugincommon.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryplugincommon.RepositoryPluginCommonErrors;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.logging.Log;

public abstract class FileOutputBase
implements FileOutput {
    protected static final String GZIP_EXTENSION = ".gz";
    protected String filename;
    protected String fileHeader;
    protected OutputStream outputStream;
    private boolean countBytes;
    private CountingOutputStream countingStream = null;
    private static final String SUCCESSFULLY_WRITTEN_TO_FILE_SYSTEM = "wrote file: ";
    private static final String FAILED_TO_CLOSE_STREAM = "failed to close file: ";

    public FileOutputBase(String filename, boolean countBytes) {
        this.filename = filename;
        this.countBytes = countBytes;
    }

    protected abstract Log getLog();

    @Override
    public abstract void write() throws RepositoryException;

    @Override
    public long getBytesWritten() {
        long byteCount = 0L;
        if (this.countingStream != null) {
            byteCount = this.countingStream.getByteCount();
        } else if (this.countBytes) {
            byteCount = new File(this.filename).length();
        }
        return byteCount;
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected OutputStream createFileOutputStream(File file) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        if (file.getName().endsWith(GZIP_EXTENSION)) {
            if (this.countBytes) {
                this.countingStream = new CountingOutputStream((OutputStream)os);
                os = this.countingStream;
            }
            return this.compress(os);
        }
        return os;
    }

    protected OutputStream compress(OutputStream os) throws IOException {
        return new GZIPOutputStream(os);
    }

    protected void logFailedtoCloseStream(File file) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((Object)(FAILED_TO_CLOSE_STREAM + file.getPath()));
        }
    }

    protected void logFileWritten(File f) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)(SUCCESSFULLY_WRITTEN_TO_FILE_SYSTEM + f.getPath()));
        }
    }

    protected boolean canBeOverWritten(File file) {
        return !(file.exists() ^ file.canWrite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(File file, byte[] data) throws RepositoryException {
        try {
            this.outputStream = this.createFileOutputStream(file);
            this.outputStream.write(data);
            this.logFileWritten(file);
        }
        catch (Exception e) {
            this.handleWritingException(e);
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                catch (IOException e) {
                    this.logFailedtoCloseStream(file);
                }
            }
        }
    }

    protected void handleWritingException(Exception e) throws RepositoryException {
        Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToWriteFile).param("fileName", this.filename);
        msg.addDetail(e.getMessage());
        throw new RepositoryException(msg, (Throwable)e);
    }
}

